<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePlansTable extends Migration
{
    public function up()
    {
      Schema::create('plans',function(Blueprint $table){
        $table->increments('id');
        $table->string('name');
        $table->string('identifier',191)->unique();
        $table->float('price')->unsigned()->default(0);
        $table->unsignedSmallInteger('trial_days')->default(0);
        $table->text('features')->nullable()->default(NULL);
        $table->tinyInteger('highlight')->default(0);
        $table->unsignedSmallInteger('porder')->default(1);
        $table->tinyInteger('status')->default(0);
        $table->enum('type',['shopify','all'])->default('all');
        $table->unsignedBigInteger('store_id')->nullable()->default(NULL);
        $table->timestamps();
      });

      $features = array("products_100","inventory_sync","price_sync","order_sync");
      $data = array('name'=>'Trial','identifier'=>'trial','type'=>'all','price'=>0,'trial_days'=>0,'features'=>json_encode($features),'porder'=>1,'status'=>1,'created_at'=>date("Y-m-d H:i:s"));
      DB::table('plans')->insert([$data]);

      $features = array("products_100","inventory_sync","price_sync","order_sync");
      $data = array('name'=>'Starter','identifier'=>'starter','type'=>'all','price'=>24.99,'trial_days'=>2,'features'=>json_encode($features),'porder'=>2,'status'=>1,'created_at'=>date("Y-m-d H:i:s"));
      DB::table('plans')->insert([$data]);

      $features = array("products_100","inventory_sync","price_sync","order_sync");
      $data = array('name'=>'Lite','identifier'=>'lite','type'=>'all','price'=>49.99,'trial_days'=>2,'features'=>json_encode($features),'porder'=>3,'status'=>1,'created_at'=>date("Y-m-d H:i:s"));
      DB::table('plans')->insert([$data]);

    }

    public function down()
    {
      Schema::dropIfExists('plans');
    }
}
