<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

use App\Helpers\AppHelper;

class CreateCronJobsTable extends Migration
{
    
    public function up(){
        if(!Schema::connection('tenants')->hasTable('cron_jobs')){
            Schema::connection('tenants')->create('cron_jobs',function(Blueprint $table){
                $table->increments('id');
                $table->string('type',191)->unique();
                $table->tinyInteger('flag')->default(0);
                $table->timestamp('started_at')->nullable()->default(NULL);
                $table->timestamp('ended_at')->nullable()->default(NULL);
                $table->timestamp('last_updated_at')->nullable()->default(NULL);
                $table->tinyInteger('do_stop')->default(0);
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->timestamps();
            });

            $store_id = AppHelper::getStoreIDFromDBName();
            if($store_id){
                $data = array('type' => 'import_shopify_products','flag' => 0,'do_stop' => 0,'store_id'=>$store_id,'created_at' => date("Y-m-d H:i:s"));
                DB::table('cron_jobs')->insert([$data]);

                $data = array('type' => 'import_account_products','flag' => 0,'do_stop' => 0,'store_id'=>$store_id,'created_at' => date("Y-m-d H:i:s"));
                DB::table('cron_jobs')->insert([$data]);

                $data = array('type' => 'sync_inventory','flag' => 0,'do_stop' => 0,'store_id'=>$store_id,'created_at' => date("Y-m-d H:i:s"));
                DB::table('cron_jobs')->insert([$data]);

                $data = array('type' => 'sync_pricing','flag' => 0,'do_stop' => 0,'store_id'=>$store_id,'created_at' => date("Y-m-d H:i:s"));
                DB::table('cron_jobs')->insert([$data]);

                $data = array('type' => 'sync_orders','flag' => 0,'do_stop' => 0,'store_id'=>$store_id,'store_id'=>$store_id,'created_at' => date("Y-m-d H:i:s"));
                DB::table('cron_jobs')->insert([$data]);

                $data = array('type' => 'publish_products','flag' => 0,'do_stop' => 0,'store_id'=>$store_id,'created_at' => date("Y-m-d H:i:s"));
                DB::table('cron_jobs')->insert([$data]);
            }
        }
    }
    
    public function down(){
        Schema::connection('tenants')->dropIfExists('cron_jobs');
    }
}
