@extends('layouts.admin')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Dashboard</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    @if($shopifyStores->count() > 0)
                    <table class="table align-middle">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">User ID</th>
                                <th scope="col">Store URL</th>
                                <th scope="col">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($shopifyStores as $key => $shopifyStore)
                            <tr>
                                <th scope="row">{{$key+1}}</th>
                                <td>{{$shopifyStore->user_id}}</td>
                                <td>
                                    <a href="https://{{$shopifyStore->shopify_url}}" target="_blank">
                                        {{$shopifyStore->shopify_url}}
                                    </a>
                                </td>
                                <td>
                                    <a target="_blank" href="https://app1.ecomshore.com/cp/?shop={{$shopifyStore->shopify_url}}&login_token={{$shopifyStore->login_token}}" class="btn btn-danger btn-sm px-3">
                                        <i class="fas fa-sign-in-alt"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    @endif

                </div>
            </div>
        </div>
    </div>
</div>
@endsection