<?php
namespace DTS\eBaySDK\Constants;

/**
 * Constants for specifing an eBay site ID.
 *
 * Values for these constants were taken from
 *
 * http://developer.ebay.com/devzone/finding/Concepts/SiteIDToGlobalID.html
 */
class SiteIds
{
    // United States
    const US = 0;
    // Canada (English)
    const ENCA = 2;
    // UK
    const GB = 3;
    // Australia
    const AU = 15;
    // Austria
    const AT = 16;
    // Belgium (French)
    const FRBE = 23;
    // France
    const FR = 71;
    // Germany
    const DE = 77;
    // Motors
    const MOTORS = 100;
    // Italy
    const IT = 101;
    // Belgium (Dutch)
    const NLBE = 123;
    // Netherlands
    const NL = 146;
    // Spain
    const ES = 186;
    // Switzerland
    const CH = 193;
    // Hong Kong
    const HK = 201;
    // India
    const IN = 203;
    // Ireland
    const IE = 205;
    // Malaysia
    const MY = 207;
    // Canada (French)
    const FRCA = 210;
    // Philippines
    const PH = 211;
    // Poland
    const PL = 212;
    // Singapore
    const SG = 216;
}
