<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class EbaySellerProfile extends Model {
	
	protected $table = 'ebay_seller_profiles';
	protected $connection = 'tenants';


	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}

	public function account(){
		return $this->belongsTo('App\AmazonAccount','account_id','id');
	}

  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}
	
	protected $fillable = [
        'seller_profile_id',
		'name',
		'type',
		'account_id',
		'store_id',
		'user_id'
    ];
}
