<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Requests;
use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Artisan;
use Carbon\Carbon;
use PHPShopify;
use Mail;
use Illuminate\Support\Facades\Storage;
use App\User;
use App\ShopifyStore;
use App\StoreCronJob;
use App\CronJob;
use App\Helpers\AppHelper;
use App\Product;
use App\ProductVariant;
use App\Mail\Notification;
use App\Jobs\PublishProduct;
use App\Jobs\SyncAccountInventory;
use App\Jobs\SyncAccountPrice;
use App\Jobs\Newpendinginvenoryupdate;
use App\Helpers\EbayHelper;
use \DTS\eBaySDK\Constants;
use \DTS\eBaySDK\Trading\Services;
use \DTS\eBaySDK\Trading\Types;
use \DTS\eBaySDK\Trading\Enums;
use Illuminate\Support\Facades\Log;

class ProductController extends Controller{

	public $shopifyStore = null;
	
	public function __construct(){
		$this->middleware('shopify.store',['only' => ['redirectEdit']]);
	}

	public function updateWebhookShopifyAmazon(Request $request){
        $response = array();
	    return response()->json($response,200);

	}

	public function updateWebhookShopify(Request $request){
		$response = array();
	    return response()->json($response,200);
	}

	public function deleteWebhookShopify(Request $request){

		$response = array();
	    return response()->json($response,200);

	}

	public function index(Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
		//	$per_page = 20;
			  $per_page_limit = $request->input('limit');

            // if ($per_page_limit !== null && $per_page_limit == 50 || $per_page_limit == 100 ||  $per_page_limit == 200) {
			if ($per_page_limit !== null) {
                // Set $per_page to $per_page_limit
                $per_page = $per_page_limit;
            } else {
                $per_page = 20;
            }


			$sort_by = ($request->input("sort_by")) ? $request->input("sort_by") : "title";
			$sort_order = ($request->input("sort_order")) ? $request->input("sort_order") : "asc";
			$title = trim($request->input("title"));
			$tags = trim($request->input("tags"));
			$status = trim($request->input("status"));
			$sku = trim($request->input("sku"));
			$barcode = trim($request->input("barcode"));

			$conditions = array();
			if($title) $conditions[] = array("title","like","%".$title."%");
			if($tags) $conditions[] = array("shopify_product_data","like","%".$tags."%");
			if($status) $conditions[] = array("status","=",$status);

			$vconditions = array();
			if($barcode) $vconditions[] = array("product_id_val","=",$barcode);
			if($sku) $vconditions[] = array("sku","=",$sku);

			$products = array();
			if($vconditions){
				if($conditions){
					$products = $shopifyStore->products()->with('profile')->with('listing')->with('variantsCount')->whereHas('variants',function($query) use($vconditions){
						$query->where($vconditions);
					})->where($conditions)->orderBy($sort_by,$sort_order)->paginate($per_page);
				}
				else{
					$products = $shopifyStore->products()->with('profile')->with('listing')->with('variantsCount')->whereHas('variants',function($query) use($vconditions){
						$query->where($vconditions);
					})->orderBy($sort_by,$sort_order)->paginate($per_page);
				}
			}
			else{
				if($conditions){
					$products = $shopifyStore->products()->with('variants')->with('profile')->with('listing')->with('variantsCount')->where($conditions)->orderBy($sort_by,$sort_order)->paginate($per_page);
				}
				else{
					$products = $shopifyStore->products()->with('variants')->with('profile')->with('listing')->with('variantsCount')->orderBy($sort_by,$sort_order)->paginate($per_page);
				// 	if($shopifyStore->id  == 149){
				// 	    $prevImpArr =  [6623161876529,4574825513009,4827918860337,7602075009278,7602074845438,4674014412849,6623797608497,7635215155454,7500764020990,4695268917297,7540950368510,6536318484529,4821951447089,6637677969457,6662204129329,6579737657393,4794830225457,7610715832574,6656828538929,7521574977790,6605962805297,6613326725169,6546794020913,7600556048638,6591887278129,7560150089982,6614701998129,6579781402673,7603292274942,4752445374513,7526826508542,4700298215473,6613248376881,4829333356593,4829330047025,6592832012337,6625214136369,6613220786225,6595969613873,6579064995889,6536434614321,6576164274225,6660307877937,6660307845169,7488366018814,6541335625777,4700298444849,6657424130097,6656837124145,6657543077937,7540953481470,7573033353470,6549246181425,7573033582846,6662175555633,4753615618097,7602085232894,6606934016049,6559564496945,6568195948593,4791750983729,7493501747454,6579052183601,6544165371953,6546794086449,6570502586417,6570508550193,6582224683057,6630571999281,6575924674609,4692853358641,7515572338942,7476012810494,6660443144241,6656613449777,4692601897009,7527705542910,6598550978609,6556984737841,7507023593726,4795593982001,4739582918705,6605962739761,4534248210481,6619928821809,4806306037809,6539651088433,6612920500273,7504416211198,7578177077502,6570820829233,6637116031025,6619061977137,7506826887422,7517730603262,7475853918462,6660456611889,6633786834993,7475849298174,6591891210289,7521894596862,6637995032625,4534516711473,6536436842545,6660559831089,4743997947953,6585944768561,4830325407793,7522130264318,6538523902001,6606969045041,7500764381438,6660874076209,7527699906814,6606679244849,6656757465137,6576169025585,6579745194033,4826058948657,6544165339185,6619944190001,4829993009201,6537241329713,4534268428337,7487527321854,7526409011454,7519037686014,6599885881393,6609847255089,4654965391409,6606970290225,6598571491377,6656764870705,6553668681777,7551337169150,7493510234366,7541055324414,6656440205361,6595733979185,7553470857470,6585949978673,7526680789246,6585489522737,7501472825598,7575230415102,7560149532926,6595693969457,7472871932158,6585491849265,6605962870833,7474908201214,6544164028465,4821515403313,6560180011057,4749851033649,6564459479089,7555208675582,7602085396734,4752696410161,6567807352881,6546068308017,7526695928062,7549734289662,7500606341374,6559860686897,6608835870769,4765336109105,6633809051697,7569357996286,7603455426814,7553292239102,6641268162609,4802287271985,7575096525054,6620369387569,7507989725438,7569444241662,6586858307633,4822011576369,4675820814385,4534245523505,4793240059953,4534354477105,6641226219569,6596075946033,7569437032702,6583478255665,6633809870897,4821922480177,7553928855806,7600638853374,4835183657009,7553928495358,4686281244721,6621804724273,6609121345585,6631299350577,7569436770558,6546059264049,4534221406257,4534372499505,4822648848433,4792065130545,6663812808753,6626623946801,6536438120497,4835924410417,4821901574193,4822656909361,4822656942129,4824308744241,7504376824062,7501481574654,6612588265521,4707579134001,7500663587070,4835312074801,4674814672945,6657666449457,4675818422321,7505226072318,6582235398193,4534529065009,7506918277374,4828567568433,6598573391921,4821846032433,7492909629694,6585597689905,7506237882622,7506237751550,7601850843390,7569282269438,7517709828350,6631295811633,6585250480177,6539650203697,6633784934449,7488400949502,6569974825009,6656791642161,6620370862129,6595730407473,6598549438513,6560184959025,6620382887985,6595397124145,4534521430065,7555208806654,6586439991345,6576167780401,6660309418033,7555191800062,7575075062014,7528284881150,7574214934782,4757912518705,7488400785662,6595950149681,6595730702385,4822654943281,4738363654193,4807044890673,4804928634929,4674027749425,4704284114993,4829065412657,7461196464382,4704263340081,4534444556337,6595734569009,7553284767998,6638002896945,7651118547198,4764073754673,4825522241585,4828539322417,6619168178225,6656613384241,6660304732209,6553912311857,4583801290801,6623475531825,7574303408382,4534442164273,4534548889649,7492897145086,4746876059697,4802482929713,7600534323454,7600691151102,7603454443774,7600565911806,4776782364721,7492897014014,4776786460721,7461215011070,6596274421809,7541186527486,6544230318129,4765629612081,4828548300849,4804928929841,4575742984241,4575567970353,4824869306417,6657232994353,6536128331825,4825621364785,4824604180529,4829214179377,7654144737534,7461183258878,4821519663153,4828537290801,6609766416433,4825635946545,4825623298097,4804304863281,7506102452478,4829048111153,4743997784113,4822588489777,7553267761406,4831157157937,7459903242494,4830975066161,7488366215422,4826021953585,4826020347953,6538538549297,4765623582769,4824604114993,4798874255409,4534417752113,6606932803633,4824608014385,4791461773361,4758650159153,4825629818929,4763784904753,7487520243966,4824313069617,4829051617329,6567811776561,7474857181438,4834352562225,4825632931889,7569217356030,4829408362545,4534218915889,6656441057329,4821894332465,4752781803569,6582645489713,6664016527409,6637219348529,4763674247217,6630349111345,6630349176881,4687752757297,6539252170801,6575931686961,6619930296369,6622715052081,4829410656305,4829337190449,6630892142641,6638000406577,4765623517233,4824614699057,4824646385713,6624238600241,6656694255665,4829055156273,6608791207985,7475855720702,4824603623473,6544298803249,6661104402481,7553298465022,4830962319409,7492906483966,4822577872945,6629926142001,6637756252209,4789105033265,6637605781553,6630352355377,6631276838961,4826056327217,6540330762289,4824223121457,6608758538289,6660513234993,6606687076401,4830974607409,6605576798257,7551459098878,4822647275569,6538526720049,6538528292913,6536004862001,6598853787697,4829413015601,6592327417905,6592327483441,4785770790961,4765403971633,4765404069937,6606693171249,6542673772593,6630897483825,6592394887217,6570338287665,6630554763313,6621804527665,7475848151294,6619155103793,6630352322609,4534261645361,4782270709809,6657232633905,4736453804081,6612924727345,6656831488049,7541200879870,6570101899313,7487519883518,6592328597553,6656679575601,6637615972401,4791737974833,6539265114161,6609060855857,4822584098865,6539254890545,6586474922033,6660556947505,4822592225329,6662647578673,6630576881713,7569208803582,6548944715825,4819086966833,7475846807806,6592733970481,6663956529201,6630873858097,6609063116849,7551333859582,6624231751729,6550004039729,6609149198385,7488406290686,7476199260414,7624525873406,6544165175345,6621792862257,7600661922046,6620401926193,4788074872881,6659364192305,6631335133233,4829404495921,6538826973233,4575569838129,6569971646513,6621724442673,7462541918462,7461236015358,6622566711345,6595951853617,4726710927409,6630548930609,6660046061617,7575048421630,6546760368177,6656440238129,7472868884734,6536012333105,6609848664113,4787842777137,6570397237297,7487529058558,4817627643953,6568091844657,6664239874097,6656440926257,6631249084465,6608635199537,6550007873585,6595972890673,7460054892798,6579330416689,7517430644990,6630875594801,4785483350065,7476181958910,6586854670385,7635241730302,7635239731454,4534389440561,6569665462321,6607051522097,6546772492337,6659478683697,6596634279985,7521604894974,4824695963697,6619945697329,6579734151217,7472870850814,4765989011505,7472865050878,6592833191985,4824921112625,7602087100670,6595408756785,6591675662385,6576168763441,4829208739889,4824979275825,6591902056497,6659137044529,4687879536689,6612614610993,7552685670654,6592326107185,7489369899262,6568073625649,6609828806705,6607046606897,6559834406961,6622717739057,4830451892273,6540336889905,4830372888625,6637143556145,6657657864241,4822329131057,7574300393726,6660582015025,6540631867441,6659156017201,4773689655345,7459902095614,6572829114417,6575819653169,7487529124094,4534262431793,7475521945854,7600567517438,4835383083057,6621782048817,6659094741041,4674869002289,6591888064561,4763789393969,4742010241073,6663654506545,7541076328702,7541081866494,7492901732606,7600921673982,4807035453489,6567106773041,4821897216049,4534263382065,6599520256049,6660530733105,7474537496830,6544300900401,4794900643889,4534530211889,6660042031153,7490006778110,7504374726910,4795594014769,6548695547953,6660513005617,6659137372209,6656768507953,6622714101809,4807037616177,7600694132990,6573371588657,6656759103537,6573108002865,6656652804145,6656818053169,6559557419057,4819095388209,7504424173822,4779818483761,6621731422257,6659475505201,4575717064753,6662647611441,4798863769649,6544164061233,6627020439601,6660462084145,4821847670833,6606621802545,6567072366641,7553471054078,4798251892785,7573989490942,4534523953201,6592838107185,7573978448126,6608805003313,6626174271537,4584535359537,4826080739377,4835902980145,4674029158449,6609139859505,6638003781681,4583916503089,6660039082033,6660039180337,6621830185009,7500769263870,7501477019902,6563997253681,6567109394481,6568089649201,6544239329329,6573100695601,6621809868849,6621810098225,6572611993649,6592332824625,4674903506993,6572924633137,6564046438449,4717144506417,4830328586289,6659342499889,6536122630193,6582224748593,6607054471217,4583749451825,6660046094385,6612199702577,6622541643825,6612871610417,4754202492977,4766005329969,6663785775153,6630575996977,7502772306174,6569637740593,6657993310257,4674017329201,6657179844657,6572915785777,6661080514609,7523543711998,6620410642481,6596687724593,4787867648049,4750610137137,7472865444094,4806557335601,7551441404158,6661094998065,6663985201201,6569776414769,6585962790961,6559896567857,6540335808561,7461209211134,6544233332785,4835914776625,6606936277041,6538813964337,4773690605617,6626627977265,7517571940606,4600846221361,7459900915966,6659185115185,7472868524286,6662197248049,6596069261361,6599602208817,6592394952753,6566982516785,6659191078961,6538534486065,4830325243953,6656687374385,7600662020350,6661122654257,7492897210622,6629954584625,6592617480241,6593591672881,7549793304830,4829324378161,6564454105137,4807845052465,6592354779185,6663980908593,4824616304689,6548943142961,6593578270769,6663622131761,4763782742065,6592337412145,4534529949745,6560884916273,6609847353393,6607033073713,6663981858865,6608768663601,6546059362353,6566404489265,6623798100017,6546778259505,4833841119281,6564060823601,6586854637617,6606656733233,6663968194609,6663800684593,6563921297457,7488418021630,7555130360062,6659184721969,6544300638257,6582574743601,4575583830065,6536123744305,4575546376241,6638041268273,4819092045873,6663810678833,6660015358001,6540333711409,4779226759217,6657233682481,4749113655345,4747482660913,6559569117233,4788100169777,6580175208497,6622692704305,6575926771761,6624233291825,6641244602417,6656691568689,7488310313214,7461193974014,4534499311665,6595697213489,7502746452222,4534348775473,6660499111985,6596031545393,4720650944561,6560594722865,6656770113585,6595973185585,4752437706801,6622537351217,6536128462897,6622717706289,7574302982398,6570815455281,7541001355518,6606682062897,6657995636785,6637756350513,4824303992881,6659343286321,6585944539185,4534511829041,4828560031793,6663618789425,6663800651825,6572603637809,7460070260990,6612861616177,4534224158769,4835211968561,6585489686577,6593069285425,4761767608369,7504424141054,6626288992305,7574111158526,6572538560561,4804302340145,6660513890353,4764072476721,7551140561150,7490124644606,7490124611838,7490129199358,4758689513521,6538505617457,7494655901950,4534451241009,4725243609137,4749071712305,7521896988926,4829403807793,4742245089329,6569774710833,7522434515198,6573099483185,6573099417649,7504422895870,7553362428158,6560886194225,4626718851121,4744013348913,6569675063345,6585945292849,7504420602110,7492992762110,7575209607422,6546098192433,7578133364990,6579783008305,6572717408305,6555006107697,4701098639409,7578071466238,4804600823857,6576162996273,6596580180017,6586858242097,4822646128689,6592352845873,6608635330609,6539179884593,6569650815025,6656758743089,7519037423870,6656766967857,6596580212785,6542376566833,4824607359025,6640328900657,6663875461169,6608799236145,4824953389105,6663903117361,7635347669246,4750368440369,6612897202225,6623475662897,4753595957297,6585954369585,6570101866545,4792571822129,6605963100209,6630534512689,7602092310782,7459901571326,4819093258289,6593017937969,6657666220081,7541191934206,6546797461553,6656440631345,6598581190705,4534524084273,6545234952241,7551338021118,7526437978366,6622717116465,7544639750398,6656643170353,6606972813361,6606941290545,6657983283249,6657982595121,4534530080817,4816724131889,7521887617278,6593082916913,6572921126961,4795592966193,4583999209521,4584004386865,4720493690929,6657536163889,4674024144945,7551331008766,6567076233265,6570019192881,4534507634737,7560439103742,6559566102577,4584000061489,7500769231102,4724836007985,6609077960753,4583989870641,4534502621233,4750363295793,6657533083697,4724835516465,7569376870654,4830372921393,4785485185073,4830372102193,6660461953073,6573108559921,6623797641265,7577946456318,6570032988209,7501560807678,4575550701617,6622715805745,7460047519998,7460188717310,6575832399921,7462541164798,7560446476542,6656441712689,7492891541758,6579781369905,6538863476785,6605558513713,6596631560241,4833944567857,6612858011697,7552697827582,6572620152881,7555294429438,4829336338481,6606961410097,4753901256753,4829431529521,6656643924017,6592357498929,6660498030641,4830324981809,6539650433073,4534516449329,6641276977201,6536009121841,6564482809905,6546781143089,6627027320881,6556136636465,6609763532849,4821845999665,4599199105073,4819087163441,4534491742257,7502760902910,6605954285617,4575572951089,4646279020593,6544164454449,6623475269681,6539211046961,7555143336190,4656698130481,7461129683198,7651118678270,7459902324990,6657663828017,7575229858046,4583761346609,7507007373566,6546796183601,6656441122865,6544237101105,7521604927742,4765336469553,4824623448113,7472870392062,4835274424369,4829997989937,4534496493617,6599529005105,6567071055921,7500663783678,6656646709297,6592825655345,4701026779185,7460322279678,6585594511409,6556990603313,6573110427697,4824920293425,6657232240689,4707605282865,7472871473406,6659185475633,7460344234238,7553281294590,6537208430641,6591888261169,7651156132094,6609061183537,4835183788081,6546055200817,7557236424958,7476658077950,6656828571697,6660311089201,7555161260286,6583109582897,4633214615601,4752781148209,4758648815665,6658013003825,4836007903281,6564455350321,7528448688382,6538534518833,6612874854449,6544233070641,4787844579377,7600696033534,7600696131838,6660318691377,6613229862961,6599565213745,4704293748785,6549996208177,6559862226993,6660433215537,7506827116798,6592337346609,7555355443454,4824927633457,6536129642545,6559118393393,6613218754609,6633803907121,7517595107582,7474908168446,6549270921265,4835293036593,6663812939825,7460214440190,7544435867902,6622715084849,4795592409137,7515620606206,6613226881073,7526681018622,6656757268529,6591888523313,6624236503089,4835929817137,6585288654897,6552645533745,7544416010494,6629966315569,6552680267825,4785484300337,6549996240945,6631222771761,4765624303665,6660048420913,6536012890161,6606621999153,6537218195505,6662101598257,4821900722225,4821920809009,6564800757809,6626428747825,7553470923006,7553474953470,4824928944177,4802006614065,7475853656318,6536012955697,6657902510129,6663783514161,6592361889841,7541067219198,6564383817777,7522047656190,6608794746929,6656694779953,6613225865265,6614702522417,6660313317425,4804928995377,6592336822321,6622713249841,7560162181374,6537204334641,6633807249457,7578177372414,7575209869566,6585256214577,7569409114366,6537241231409,7553464926462,4745571663921,6608802611249,7507007275262,6638038384689,6556161015857,4806192791601,7527706001662,7506833441022,7506834718974,7526752911614,4796008366129,6544163864625,6568213577777,6536437760049,6536437792817,6564474847281,6564470456369,4756703248433,6626288762929,6536436645937,6536435892273,6625223901233,6536437006385,6564473045041,6564470423601,6564468359217,6564468129841,6612933345329,7541001486590,7460203659518,7521607090430,6566407700529,6536178761777,6583100276785,6630339969073,6606931263537,6664216018993,6587881127985,4810075045937,6595690070065,6657930854449,6660313350193,7575047504126,4801989869617,6537243721777,6662101729329,7517571678462,6656817102897,7527717208318,7527717535998,7553475051774,6537212067889,6663810809905,6663810875441,4822657794097,6536169816113,7549793501438,6637231145009,6570337599537,6662101663793,6663790657585,4799238570033,6585489719345,6626626175025,4827870986289,4793778012209,7517572432126,6592839090225,6663801372721,7541221589246,6537205317681,6605961494577,6592330104881,6582224158769,4801837269041,6661112168497,6536121090097,6592331120689,7461284479230,7526414909694,6657555726385,7635239403774,6660484595761,7507024118014,6608804970545,6608828792881,6542671773745,4802006712369,6598569066545,6560884949041,6660512514097,6656838959153,6659096150065,7551435145470,7551435342078,6663781187633,4830314201137,7472872423678,7504383705342,6573097287729,6663903510577,4807499677745,6593024426033,6570818666545,6662193315889,7521852522750,6613228257329,6613230288945,6608644931633,6538535764017,7476670234878,6586331201585,6606621868081,6662101073969,6633411215409,6660446945329,6605965852721,7569368088830,6564794007601,6663875657777,7459901636862,6605533675569,4825507954737,6608804020273,6539181359153,7523510616318,6592360775729,4787842121777,7555143696638,6586843267121,7551335170302,7549734748414,4797700505649,6564454170673,6656829653041,6599594770481,6559554928689,7522474262782,6570337468465,7540984905982,6633410854961,6633813278769,6633803776049,6661044666417,6660439244849,7578177274110,6659476062257,6657232207921,6572611764273,7528285405438,6596282286129,6605482557489,6555006140465,6605557039153,7540985463038,4807046529073,7527717732606,4692352237617,6619947171889,7569377132798,6538871636017,6586860601393,6664242233393,6605463453745,4796769468465,6564823859249,6627021586481,6656795246641,6559012257841,7459903045886,6596668719153,7506892554494,6657902805041,7555294593278,6660877418545,4821844754481,6663634780209,7507607519486,6553640828977,6559551914033,6570338353201,4634584023089,4693367881777,7527702298878,4534358540337,4704129122353,4826025590833,4822646915121,7551335956734,6564454236209];
				// 	    Log::info('count is this -> '.count($prevImpArr));
					    
				// 	    $products = $shopifyStore->products()->with('profile')->with('listing')->with('variantsCount')->whereIn('shopify_product_id',$prevImpArr)->orderBy($sort_by,$sort_order)->paginate($per_page);
				// 	}
				}
			}

			return response()->json($products,200);
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function allProducts(Request $request){
	    	Log::channel('fetchshopifyproducts')->info('hiteshmali request  ' . $request);
	    Log::info('enter in allProducts');
	    
		$shopifyStore = AppHelper::getShopifyStore($request);
		
		if($shopifyStore){
		    Log::info('enter in allProducts 1');
			$sort_by = ($request->input("sort_by")) ? $request->input("sort_by") : "title";
			$sort_order = ($request->input("sort_order")) ? $request->input("sort_order") : "asc";

// 			$products = $shopifyStore->products()->with('variants')->where('listing_id',0)->orWhereNull('listing_id')->orderBy($sort_by,$sort_order)->get();
			
			// $products = $shopifyStore->products()->with('variants')->where('listing_id',0)->orWhereNull('listing_id')->where('status', 'unpublished')->orderBy($sort_by,$sort_order)->orWhere('title', 'like', '%' . $sort_by . '%')->get();

			$title = $request->input("title");

            // Title ko space se split karein
            $words = explode(" ", $title);

            // Trim karein aur array ke pehle 3 elements ko lein
            $trimmedTitle = implode(" ", array_slice($words, 0, 3));

            $products = Product::whereRaw("SUBSTRING_INDEX(products.title, ' ', 3) = ?", $trimmedTitle)
            ->with('variants')
            ->where(function ($query) {
                $query->where('listing_id', 0)
                      ->orWhereNull('listing_id')
                      ->orWhere('status', 'unpublished');
            })
            ->orderBy($sort_by,$sort_order)
            ->get();
			
            Log::info('enter in allProducts 3');


			return response()->json($products,200);
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}
	
	

    public function importProducts() {

        $cronJob = CronJob::where('type', 'import_shopify_products')->first();
        if ($cronJob && ($cronJob->flag == 1 || $cronJob->do_stop == 1)) {
            return response()->json(['status' => 'error', 'msg' => "cron already running"], 406);
        } else {
            $cronJob->flag = 1;
            $cronJob->started_at = date("Y-m-d H:i:s");
            $cronJob->ended_at = NULL;
            $cronJob->last_updated_at = date("Y-m-d H:i:s");
            $cronJob->save();
        }
    
        Log::channel('fetchshopifyproducts')->info('process ImportShopifyProducts start');
        // $shopifyStores = ShopifyStore::where('status',"active")->where('id','992')->get();
    
        $shopifyStores = ShopifyStore::where('status', "active")->where('import_products', 1)->orderBy('id', 'desc')->get();
    
        if ($shopifyStores->count() > 0) {
    
            Log::channel('fetchshopifyproducts')->info('Total shopify store found to process ImportShopifyProducts' . $shopifyStores->count());
    
            foreach ($shopifyStores as $shopifyStore) {
                $shopify_store_id = $shopifyStore->id;
                // echo "<br>";
                Log::channel('fetchshopifyproducts')->info('ImportShopifyProducts shopify store id ' . $shopify_store_id);
                $store_database_name = config('config.store_db_prefix') . $shopify_store_id;
                AppHelper::setConnection($store_database_name, $shopifyStore);
                
				// PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version')));
                
				$config = array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version'));
				$shopifyClient = new PHPShopify\ShopifySDK($config);
				

				// print_r($shopifyClient->apiVersion());

				
				

                if (!$shopifyClient) continue;
                try {


					// echo "hi"; die();

                    Log::channel('fetchshopifyproducts')->info('Entered in the try method' . json_encode($shopifyClient, true));
                    //	if(!$shopifyClient)continue;
                    $errors = array();
                    $errorProductsCount = 0;
                    $newProductsCount = 0;
                    $updatedProductsCount = 0;
    
                    $productCount = $shopifyClient->Product();
    
                    $productResource = $shopifyClient->Product();
    
                        Log::channel('fetchshopifyproducts')->info('productResource ' . json_encode($productResource, true));
    
                        $params = array('limit' => '200');
    
                        $products = $productResource->get(['status' => 'active'] + $params);
                
                    $shopifyProductid = array();
                    $mar = 0;
    
                    while ($products) {
    
                        foreach ($products as $shProduct) {
                            Log::channel('fetchshopifyproducts')->info('enter shProduct foreach loop');
                            $mar++;
                            $cronJob2 = CronJob::where('type', 'import_shopify_products')->first();
                            if ($cronJob2 && $cronJob2->do_stop) break;
                            $cronJob->last_updated_at = date("Y-m-d H:i:s");
                            $cronJob->save();
                            try {
                                $sh_product_id = $shProduct["id"];
                                $sh_product_id2 = array();
                                $sh_product_id2[] = $shProduct["id"];
                                //	Log::info('shopify product id '.$sh_product_id);
                                $sh_product_handle = $shProduct["handle"];
                                $sh_product_status = $shProduct["published_at"];
                                $sh_product_sat = $shProduct["status"];
                                //	Log::info('shProduct data  '.json_encode($shProduct,true));
                                Log::channel('fetchshopifyproducts')->info('Entered in the try method' . json_encode($shopifyClient, true));
                                Log::channel('fetchshopifyproducts')->info('shProduct data  ' . json_encode($shProduct, true));
    
                                if ($sh_product_sat !== 'active' && $sh_product_status !== 'active') {
                                    Log::channel('fetchshopifyproducts')->info('The product is not active');
                                    continue;
                                } else {
                                    $shopifyProductid[] = $sh_product_id;
                                    Log::channel('fetchshopifyproducts')->info('entered in else condition ,the product is active');
                                    $product = $shopifyStore->products()->where('shopify_product_id', $sh_product_id)->orWhere('shopify_product_handle', $sh_product_handle)->first();
                                    if (!$product) {
                                        Log::channel('fetchshopifyproducts')->info('enter addProduct function');
                                        $addErrors = $this->addProduct($shProduct, $shopifyStore, $shopifyClient);
                                        if ($addErrors) {
                                            $errors = array_merge($errors, $addErrors);
                                            $errorProductsCount++;
                                            Log::channel('fetchshopifyproducts')->info('error found in adding product to db' . $shopify_store_id . ' and shopify product id ' . $sh_product_id);
                                        } else {
                                            $newProductsCount++;
                                        }
                                    } else {
                                        Log::channel('fetchshopifyproducts')->info('enter updateProduct function');
                                        Log::channel('fetchshopifyproducts')->info('product is already in db updateing products  in the database ' . $shopify_store_id . ' and shopify product id ' . $sh_product_id);
                                        $updateErrors = $this->updateProduct($shProduct, $shopifyStore, $product, $shopifyClient);
                                        if ($updateErrors) {
                                            $errors = array_merge($errors, $updateErrors);
                                            $errorProductsCount++;
                                            Log::channel('fetchshopifyproducts')->info('error found in updating product to db' . $shopify_store_id . ' and shopify product id ' . $sh_product_id);
                                        } else {
                                            $updatedProductsCount++;
    
                                        }
                                    }
                                }
                            }
                            catch(\Exception $e) {
                                report($e);
                                $errors[] = $e->getMessage();
                            }
                        }
    
                        $products = array();
                            $nextPageProducts = $productResource->getNextPageParams();
                            if ($nextPageProducts){
                                $products = $productResource->get($productResource->getNextPageParams());
                            } else{
                                Log::channel('fetchshopifyproducts')->info('enter in else condition because no next pagination found');
                            }
                    }
    
                    if(count($shopifyProductid) >= 0){
                    $notmatchshopify_product_id = $shopifyStore->products()->where('status', '!=', 'deleted')->whereNotIn('shopify_product_id', $shopifyProductid)->pluck('shopify_product_id');
    
                    if (count($notmatchshopify_product_id) > 0) {
    
                        foreach ($notmatchshopify_product_id as $sh_id) {
    
                            try {
                                $productShopifysafdd = $shopifyClient->Product($sh_id)->get();
    
    
                                if ($productShopifysafdd['status'] == 'draft') {
                                    $notinshopify = $shopifyStore->products()->where('shopify_product_id', $sh_id)->get();
    
                                    if ('unpublished' == $notinshopify[0]['status']) {
    
                                        $shopifyStore->variants()->where('shopify_product_id', $sh_id)->delete();
                                        $shopifyStore->products()->where('shopify_product_id', $sh_id)->delete();
                                    }
                                    if ('published' == $notinshopify[0]['status']) {
    
                                        $shopifyStore->products()->where('shopify_product_id', $sh_id)->update(['status' => 'deleted']);
                                    }
                                }
                            }
                            catch(\Exception $e) {
                                $notinshopify = $shopifyStore->products()->where('shopify_product_id', $sh_id)->get();
                                echo $notinshopify[0]['status'];
                                if ('unpublished' == $notinshopify[0]['status']) {
    
                                    $shopifyStore->variants()->where('shopify_product_id', $sh_id)->delete();
                                    $shopifyStore->products()->where('shopify_product_id', $sh_id)->delete();
                                }
                                if ('published' == $notinshopify[0]['status']) {
    
                                    $shopifyStore->products()->where('shopify_product_id', $sh_id)->update(['status' => 'deleted']);
                                }
                            }
                        }
                    }
                    }
                    Log::channel('fetchshopifyproducts')->info('going onto next page ');
                    //	Log::info('ImportShopifyProducts products process is done for store '.$shopify_store_id);
                    $output_data = array();
                    $output_data["new_products"] = $newProductsCount;
                    $output_data["updated_products"] = $updatedProductsCount;
                    $output_data["error_products"] = $errorProductsCount;
                    if ($errors) $output_data["errors"] = $errors;
                    $logData = array();
                    $logData["log_type"] = "import_shopify_products";
                    $logData["input_data"] = NULL;
                    $logData["status"] = ($errors) ? "error" : "success";
                    $logData["remarks"] = "shopify import products processed with " . $errorProductsCount . " products with errors.";
                    $logData["output_data"] = json_encode($output_data, JSON_INVALID_UTF8_IGNORE);
                    $logData["store_id"] = $shopifyStore->id;
                    $logData["user_id"] = $shopifyStore->user_id;
                    $shopifyStore->logs()->create($logData);
                    //	Log::info('ImportShopifyProducts products logs saved for store '.$shopify_store_id);
    
                }
                catch(\Exception $e) {
                    report($e);
                    $errors[] = $e->getMessage();
                    Log::channel('fetchshopifyproducts')->info('ImportShopifyProducts products errors found id store ' . $shopify_store_id);
                }
                if ($errors) file_put_contents("importProductsErrorShopify_" . $shopify_store_id . ".json", json_encode($errors));
                $shopifyStore->import_products = 0;
                $shopifyStore->save();
            }
        }
        $cronJob->flag = 0;
        $cronJob->ended_at = date("Y-m-d H:i:s");
        $cronJob->last_updated_at = date("Y-m-d H:i:s");
        $cronJob->save();
        Log::channel('fetchshopifyproducts')->info('exited in import products method of ImportShopifyProducts');
        return response()->json(['status' => 'success', 'msg' => "done"], 200);
    }
	
    public  function getEbayData($ebay_item_id,$site_id,$access_token,$sku){
       
       Log::info("Entered in getEbayData method");
       
        $ebay_environment = config('ebay.environment');

		$ebayCredentials = array(
			'credentials' => [
				'devId' => config('ebay.' . $ebay_environment . 'devid'),
				'appId' => config('ebay.' . $ebay_environment . 'appid'),
				'certId' => config('ebay.' . $ebay_environment . 'certid'),
			],
			'authToken' => '',
			'oauthUserToken' => '',
			'ruName' => config('ebay.' . $ebay_environment . 'RuName')
		);
		$ebayService = new Services\TradingService([
			'credentials' => $ebayCredentials['credentials'],
			'sandbox' => ($ebay_environment == "sandbox") ? true : false,
			'siteId' => $site_id
		]);

    	$ebConfig = array('production' => 
      array('credentials' => array(
     'devId' =>  config('ebay.' . $ebay_environment . 'devid'),
     'appId' => config('ebay.' . $ebay_environment . 'appid'),
     'certId' =>config('ebay.' . $ebay_environment . 'certid')),
    ));


     $service = new Services\TradingService([
		 'credentials' => $ebConfig['production']['credentials'],
		'sandbox'     => false,
		 'siteId'      => $site_id
		  ]);	

          $ebayItem = [];
          $ebayItemRequest = new Types\GetItemRequestType();
          $ebayItemRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
          $ebayItemRequest->RequesterCredentials->eBayAuthToken = $access_token;
          $ebayItemRequest->ItemID = $ebay_item_id;
          $ebayItemRequest->IncludeItemSpecifics = true;
          $ebayItemResponse = $ebayService->getItem($ebayItemRequest);
          $ebayItemResponse = $ebayItemResponse->toArray();
          if(isset($ebayItemResponse["Item"]) && $ebayItemResponse["Item"]) $ebayItem = $ebayItemResponse["Item"];
       
		
          $ebayqnty = $ebayItem->Quantity;
	//	  if($ebayqnty == 0){
            // $endItemRequest = new Types\EndItemRequestType();
            // $endItemRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
            // $endItemRequest->RequesterCredentials->eBayAuthToken = $access_token;
            // $endItemRequest->ItemID = $ebay_item_id;
            // $endItemRequest->EndingReason = "NotAvailable";
            // $ebayResponse = $ebayService->endItem($endItemRequest);
            // $ebayResponse = ($ebayResponse) ? $ebayResponse->toArray() : array();
                       $inventoryStatus = new Types\InventoryStatusType();
                      if(trim($sku)) $inventoryStatus->SKU = trim($sku);
                                                    $inventoryStatus->ItemID = $ebay_item_id;
                                                    $inventoryStatus->Quantity = 0;
                                                     $inventoryStatusArray = array();
                                                     $inventoryStatusArray[] = $inventoryStatus;
                                                          $ebayRequest = new Types\ReviseInventoryStatusRequestType();
                                                           $ebayRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
                                                            $ebayRequest->RequesterCredentials->eBayAuthToken = $ebay_token;
                                                            $ebayRequest->InventoryStatus = $inventoryStatusArray;
                                                            $ebayResponse = $ebayService->reviseInventoryStatus($ebayRequest);
                                                            $ebayResponse = ($ebayResponse) ? $ebayResponse->toArray() : array();
        
                                                            if(isset($ebayResponse["Ack"]) && $ebayResponse["Ack"] == 'Failure' && $ebayResponse["Errors"]){
                                                                $errors = $ebayResponse["Errors"];
                                                                $shortMsg = strtolower($errors[0]["LongMessage"]);
                                                                if(strpos($shortMsg,'valid number greater than 0') !== false || strpos($shortMsg,'must have a quantity greater than 0') !== false){
                                                                    $endItemRequest = new Types\EndFixedPriceItemRequestType();
                                                                    $endItemRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
                                                                    $endItemRequest->RequesterCredentials->eBayAuthToken = $ebay_token;
                                                                    $endItemRequest->ItemID = $ebay_item_id;
                                                                    $endItemRequest->EndingReason = "NotAvailable";
                                                                    $ebayResponse = $ebayService->endFixedPriceItem($endItemRequest);
                                                                    $ebayResponse = ($ebayResponse) ? $ebayResponse->toArray() : array();
                                                                }
                                                            }
             Log::info("successfully updated Quantity on ebay in getEbayData method");
            return "success";
      //  }
		
	}
	
	public function addProduct($shProduct, $shopifyStore, $shopifyClient = null) {
		Log::channel('fetchshopifyproducts')->info("Webhook: Entered in addProduct method");
		$errors = array();
		$productData = array();
		$sh_product_id = $shProduct["id"];
		$sh_product_handle = $shProduct["handle"];
		$productData["title"] = $shProduct["title"];
		$productData["image"] = (isset($shProduct["image"]) && $shProduct["image"]) ? $shProduct["image"]["src"] : null;
		$productData["shopify_product_id"] = $shProduct["id"];
		$productData["shopify_product_handle"] = $shProduct["handle"];
		$productData["shopify_product_type"] = $shProduct["product_type"];
		$productData["shopify_product_data"] = json_encode($shProduct, JSON_INVALID_UTF8_IGNORE);
		$productData["store_id"] = $shopifyStore->id;
		$productData["user_id"] = $shopifyStore->user_id;
		$hasError = false;
		Log::channel('fetchshopifyproducts')->info(" foreach loop is starting");
		foreach ($shProduct["variants"] as $vkey => $variant) {
			$sku = trim($variant["sku"]);
			Log::channel('fetchshopifyproducts')->info("Here is the shopify_variant_iddd " . $variant["id"]);
			if (!$sku) {
				// $hasError = true; // Setting hasError to true if SKU is missing
				// $errors[] = "SKU missing for variant with Shopify variant id: " . $variant["id"];
				// Set SKU to variant ID
				$shProduct["variants"][$vkey]["sku"] = $variant["id"];
			} else {
				// Check if variant with same SKU exists in database
				$existingVariant = $shopifyStore->variants()->where("sku", $sku)->first();
				if ($existingVariant) {
					$shProduct["variants"][$vkey]["sku"] = $existingVariant["id"];
				}
			}
		}
		if (!$hasError) {
			$product = $shopifyStore->products()->create($productData);
			Log::channel('fetchshopifyproducts')->info("Product created in db in addProduct methoddd " . json_encode($product, true));
			if ($product) {
				foreach ($shProduct["variants"] as $variant) {
					$variantData = array();
					if (isset($shProduct["images"]) && $shProduct["images"]) {
						$image_id = (isset($variant["image_id"])) ? $variant["image_id"] : null;
						if ($image_id) {
							foreach ($shProduct["images"] as $simage) {
								if ($simage["id"] == $image_id) {
									$variantData["image"] = $simage["src"];
									break;
								}
							}
						}
					}
					$variantData["title"] = $variant["title"];
					$variantData["sku"] = $variant["sku"];	
					$variantData["asin"] = isset($variant["sku"]) && trim($variant["sku"]) !== '' ? trim($variant["sku"]) : 'Empty_Sku';
					if (isset($variant["barcode"]) && $variant["barcode"]) {
						$variantData["product_id_val"] = $variant["barcode"];
					} else {
						$variantData["product_id_val"] = "Does not apply";
					}
					$variantData["quantity"] = $variant["inventory_quantity"];
					$variantData["price"] = $variant["price"];
					$variantData["compare_at_price"] = $variant["compare_at_price"];
					$variantData["shopify_variant_id"] = $variant["id"];
					$variantData["shopify_inventory_item_id"] = $variant["inventory_item_id"];
					$variantData["shopify_product_id"] = $shProduct["id"];
					$variantData["shopify_product_handle"] = $shProduct["handle"];
					$variantData["shopify_variant_data"] = json_encode($variant, JSON_INVALID_UTF8_IGNORE);
					$variantData["product_id"] = $product->id;
					$variantData["store_id"] = $shopifyStore->id;
					$variantData["user_id"] = $shopifyStore->user_id;
					$newVariant = $product->variants()->create($variantData);
					Log::channel('fetchshopifyproducts')->info("variant created in db in addProduct methoddd " . json_encode($newVariant, true));
					if (!$newVariant) {
						$errors[] = "error creating product variant, product id : " . $sh_product_id . ", variant id : " . $variant["id"];
					}
				}
			} else {
				$errors[] = "error creating product, product id : " . $sh_product_id;
			}
		} else {
			Log::channel('fetchshopifyproducts')->info("Product data  " . json_encode($productData, true));
			Log::channel('fetchshopifyproducts')->info("Product error  " . json_encode($errors, true));
		}
		return $errors;
	}
	
    public function updateProduct($shProduct, $shopifyStore, $product, $shopifyClient = null){

		Log::channel('fetchshopifyproducts')->info('entered in update Product method of ImportShopifyProducts');
        $sh_product_id = $shProduct["id"];
        $sh_product_handle = $shProduct["handle"];

        $errors = array();
        $productData = array();
        $productData["title"] = $shProduct["title"];
        $productData["image"] = (isset($shProduct["image"]) && $shProduct["image"]) ? $shProduct["image"]["src"] : null;
        $productData["shopify_product_id"] = $shProduct["id"];
        $productData["shopify_product_handle"] = $sh_product_handle;
        $productData["shopify_product_type"] = $shProduct["product_type"];
        $productData["shopify_product_data"] = json_encode($shProduct, JSON_INVALID_UTF8_IGNORE);		

		// Log the total count of products
		Log::channel('fetchshopifyproducts')->info('Total number of products variants: ');

		$newvariantData = array();

        foreach ($shProduct["variants"] as $vkey => $shVariant) {

		
			Log::channel('fetchshopifyproducts')->info('entered in variants foreach loop update Product method of ImportShopifyProducts');
			$count_shVariant = count($shProduct["variants"]);
			Log::channel('fetchshopifyproducts')->info('shVariant count in loop -> ' . $count_shVariant);

		
			Log::channel('fetchshopifyproducts')->info("Making new var data array");
			$newvariantData[] = $shVariant["id"];
			// get all Product Variant from DB
			$productVariantmybdb = ProductVariant::where("shopify_variant_id", $shVariant["id"])->get();

			
			if (count($productVariantmybdb) > 0) {
				// Existing variants found in the database, no action needed.
				Log::channel('fetchshopifyproducts')->info("Existing variants found. No action needed.");

			} else {

                Log::channel('fetchshopifyproducts')->info("No existing variants found in the database, need to add new variant(s).");

				// Fetch image data if available
				if (isset($shProduct["images"]) && $shProduct["images"]) {
					$image_id = isset($shVariant["image_id"]) ? $shVariant["image_id"] : null;
					if ($image_id) {
						foreach ($shProduct["images"] as $simage) {
							if ($simage["id"] == $image_id) {
								$newvariantData["image"] = $simage["src"];
								break;
							}
						}
					}
				}

				// Set variant data
				$newvariantData["title"] = $shVariant["title"];
				$newvariantData["sku"] = $shVariant["sku"];
				$newvariantData["asin"] = isset($shVariant["sku"]) && trim($shVariant["sku"]) !== '' ? trim($shVariant["sku"]) : $shVariant["id"];
				$newvariantData["product_id_val"] = isset($shVariant["barcode"]) ? $shVariant["barcode"] : "Does not apply";
				$newvariantData["quantity"] = $shVariant["inventory_quantity"];
				$newvariantData["price"] = $shVariant["price"];
				$newvariantData["compare_at_price"] = $shVariant["compare_at_price"];
				$newvariantData["shopify_variant_id"] = $shVariant["id"];
				$newvariantData["shopify_inventory_item_id"] = $shVariant["inventory_item_id"];
				$newvariantData["shopify_product_id"] = $shProduct["id"];
				$newvariantData["shopify_product_handle"] = $shProduct["handle"];
				$newvariantData["shopify_variant_data"] = json_encode($shVariant, JSON_INVALID_UTF8_IGNORE);
				$newvariantData["product_id"] = $product->id;
				$newvariantData["store_id"] = $shopifyStore->id;
				$newvariantData["user_id"] = $shopifyStore->user_id;

				// Create new variant
				try {
                    Log::channel('fetchshopifyproducts')->info("enter try method for create new variants");
					$newVariant = $product->variants()->create($newvariantData);
					Log::channel('fetchshopifyproducts')->info("We need to add a new variant that the customer has added on Shopify: " . json_encode($newVariant, true));
				} catch (\Exception $e) {
					Log::error("Error adding new variant: " . $e->getMessage());
				}
			}
			
            /* himanshu :: end this code */
			
			
            if (!trim($shVariant["sku"])) {

				Log::channel('fetchshopifyproducts')->info('condition if not trim SKU');

                $variant = $product->variants()->where("shopify_variant_id", $shVariant["id"])->first();
                // 	Log::channel('fetchshopifyproducts')->info("shvariant data ".json_encode($shVariant,true));
                // 	Log::channel('fetchshopifyproducts')->info("shvariant id ".$shVariant["id"]);                	 	 
                if ($variant) {
                    try {
						Log::channel('fetchshopifyproducts')->info('enter try condition under variant');
                        $shsku =  $shVariant["id"];
                       // $shopifyClient->ProductVariant($shVariant["id"])->put(array("id" => $shVariant["id"], "sku" => $shsku));
                        sleep(1);
                        $shProduct["variants"][$vkey]["sku"] = $shsku;
                    } catch (\Exception $e) {
                        report($e);
                        $errors[] = $e->getMessage();
                    }
                }
            }
        }
		

        $product->update($productData);

        foreach ($shProduct["variants"] as $variant) {
			Log::channel('fetchshopifyproducts')->info('enter foreach variant loop 2');
            $variantData = array();
            if (isset($shProduct["images"]) && $shProduct["images"]) {
                $image_id = (isset($variant["image_id"])) ? $variant["image_id"] : null;
				Log::channel('fetchshopifyproducts')->info('check variant image'. $variant["image_id"]);
                if ($image_id) {
                    foreach ($shProduct["images"] as $simage) {
                        if ($simage["id"] == $image_id) {
                            $variantData["image"] = $simage["src"];
                            break;
                        }
                    }
                }
            }

            $variantData["title"] = $variant["title"];
			$variantData["sku"] = $variant["sku"];            
			$variantData["asin"] =  $variant["sku"] ? trim($variant["sku"]) : 'Empty_Sku';
			Log::channel('fetchshopifyproducts')->info("shvariant asin at 611 ".$variantData["asin"]);
            $variantData["quantity"] = $variant["inventory_quantity"];
            $variantData["price"] = $variant["price"];
            $variantData["compare_at_price"] = $variant["compare_at_price"];
            $variantData["shopify_product_handle"] = $sh_product_handle;
            $variantData["shopify_variant_data"] = json_encode($variant, JSON_INVALID_UTF8_IGNORE);

            $pvariant = $product->variants()->with('listingVariant')->where("shopify_variant_id", $variant["id"])->first();

			Log::channel('fetchshopifyproducts')->info('check log 1');

            if ($pvariant) {

				Log::channel('fetchshopifyproducts')->info('check log 2');
              
                $oldQty = $pvariant->quantity;
               
                $newQty = $variant["inventory_quantity"];
          
                $oldPrice = $pvariant->price;
           
                $newPrice = $variant["price"];
	      
                $oldCompareAtPrice = $pvariant->compare_at_price;
              
                $newCompareAtPrice = $variant["compare_at_price"];
	      
                $upres = $pvariant->update($variantData);
             
                if ($upres && $pvariant->listingVariant) {

					Log::channel('fetchshopifyproducts')->info('check log 3');

                    //	Log::info('listingVariant found in pvariant in update Product method');
                    $ebayAccount = $shopifyStore->ebayAccounts()->where("is_valid", 1)->find($pvariant->listingVariant->account_id);
                    //	Log::info("Finding Ebay account found for this shopify store");
                    // if ($ebayAccount) {
                    //   //  Log::info("Ebay account found for this shopify store" . $shopifyStore->id);
                  
                    //  if (($oldQty != $newQty && ( $oldPrice != $newPrice || $oldCompareAtPrice != $newCompareAtPrice)  ) && ($ebayAccount->price_sync == 1 && $ebayAccount->inventory_sync == 1)) {
                    //   //	Log::info("old quantity is not same as new quantity for this shopify store".$shopifyStore->id);
                    //     $quantity = $newQty;
                    //     $price = (float) $newPrice;
                    //     $compare_at_price = (float) $newCompareAtPrice;

                    //     $variant = $shopifyStore->variants()->find($pvariant->id);
                    //     $listing_quantity_value = (int) $ebayAccount->listing_quantity_value;
                    //     if ($ebayAccount->listing_quantity == 1 && $quantity > $listing_quantity_value)
                    //         $quantity = $listing_quantity_value;
                    //     if ($ebayAccount->threshold_quantity == 1 && $quantity <= $ebayAccount->threshold_quantity_value)
                    //         $quantity = 0;


                    //     $variant = $shopifyStore->variants()->find($pvariant->id);
                    //     if ($ebayAccount->pricing_mark_up == 1) {
                    //       Log::channel('fetchshopifyproducts')->info("pricing_mark_up found for this shopify store" . $shopifyStore->id);
                    //         if ($ebayAccount->pricing_mark_up_type == "percentage") {
                    //           Log::channel('fetchshopifyproducts')->info("pricing_mark_up is in percentage for this shopify store" . $shopifyStore->id);
                    //             $price = $price + (($ebayAccount->pricing_mark_up_value / 100) * $price);
                    //             $compare_at_price = $compare_at_price + (($ebayAccount->pricing_mark_up_value / 100) * $compare_at_price);
                    //         } else if ($ebayAccount->pricing_mark_up_type == "fixed") {
                    //           Log::channel('fetchshopifyproducts')->info("pricing_mark_up is in fixed for this shopify store" . $shopifyStore->id);
                    //             $price = $price + $ebayAccount->pricing_mark_up_value;
                    //             $compare_at_price = $compare_at_price + $ebayAccount->pricing_mark_up_value;
                    //         }
                    //     }
                    //     $jobData = array();
                    //     $jobData["price"] = $price;
                    //     $jobData["quantity"] = $quantity;
                    //     $jobData["compare_at_price"] = $compare_at_price;
                    //     $jobData["sku"] = $pvariant->listingVariant->sku;
                    //     $jobData["ebay_item_id"] = $pvariant->listingVariant->ebay_item_id;
                    //     $jobData["type"] = "qty&price"; 
                    //     $jobData["source"] = "update_product";
                    //     $jobData["variant_id"] = $pvariant->id;
                    //     $jobData["listing_variant_id"] = $pvariant->listing_variant_id;
                    //     $jobData["account_id"] = $pvariant->listingVariant->account_id;
                    //     $jobData["store_id"] = $shopifyStore->id;
                    //     $jobData["user_id"] = $shopifyStore->user_id;
                    //     Newpendinginvenoryupdate::dispatchNow($jobData);
                    // }
                    // else{
                    //     if ($oldQty != $newQty && $ebayAccount->inventory_sync == 1) {
                    //         //Log::info("old quantity is not same as new quantity for this shopify store" . $shopifyStore->id);
                    //          print_r("old quantity is not same as new quantity for this shopify store" . $shopifyStore->id);
                             
                    //         $quantity = $newQty;
                            
                    //         // $variant = $shopifyStore->variants()->find($pvariant->id);
                          
                    //         $listing_quantity_value = (int) $ebayAccount->listing_quantity_value;
                    //         if ($ebayAccount->listing_quantity == 1 && $quantity > $listing_quantity_value)
                    //             $quantity = $listing_quantity_value;
                    //         if ($ebayAccount->threshold_quantity == 1 && $quantity <= $ebayAccount->threshold_quantity_value)
                    //             $quantity = 0;

                    //         $jobData = array();
                    //         $jobData["quantity"] = $quantity;
                    //         $jobData["price"] = "";
                    //         $jobData["compare_at_price"] = "";
                    //         $jobData["sku"] = $pvariant->listingVariant->sku;
                    //         $jobData["ebay_item_id"] = $pvariant->listingVariant->ebay_item_id;
                    //         $jobData["type"] = "qty";
                    //         $jobData["source"] = "update_product";
                    //         $jobData["variant_id"] = $pvariant->id;
                    //         $jobData["listing_variant_id"] = $pvariant->listing_variant_id;
                    //         $jobData["account_id"] = $pvariant->listingVariant->account_id;
                    //         $jobData["store_id"] = $shopifyStore->id;
                    //         $jobData["user_id"] = $shopifyStore->user_id;
                    //         Newpendinginvenoryupdate::dispatchNow($jobData);
                    //     }
                    //     elseif (($oldPrice != $newPrice || $oldCompareAtPrice != $newCompareAtPrice) && ($ebayAccount->price_sync == 1)) {
                    //         Log::channel('fetchshopifyproducts')->info("prices dont match for this shopify store" . $shopifyStore->id);
                        
                    //         $price = (float) $newPrice;
                    //         $compare_at_price = (float) $newCompareAtPrice;
                            
                         
    
                    //         if ($ebayAccount->pricing_mark_up == 1) {
                    //             if ($ebayAccount->pricing_mark_up_type == "percentage") {
                    //                 $price = $price + (($ebayAccount->pricing_mark_up_value / 100) * $price);
                    //                 $compare_at_price = $compare_at_price + (($ebayAccount->pricing_mark_up_value / 100) * $compare_at_price);
                    //             } else if ($pricing_mark_up_type == "fixed") {
                    //                 $price = $price + $ebayAccount->pricing_mark_up_value;
                    //                 $compare_at_price = $compare_at_price + $ebayAccount->pricing_mark_up_value;
                    //             }
                    //         }
      
                    //         $jobData = array();
                    //         $jobData["price"] = $price;
                    //         $jobData["quantity"] = "";
                    //         $jobData["compare_at_price"] = $compare_at_price;
                    //         $jobData["sku"] = $pvariant->listingVariant->sku;
                    //         $jobData["ebay_item_id"] = $pvariant->listingVariant->ebay_item_id;
                    //         $jobData["type"] = "price";
                    //         $jobData["source"] = "update_product";
                    //         $jobData["variant_id"] = $pvariant->id;
                    //         $jobData["listing_variant_id"] = $pvariant->listing_variant_id;
                    //         $jobData["account_id"] = $pvariant->listingVariant->account_id;
                    //         $jobData["store_id"] = $shopifyStore->id;
                    //         $jobData["user_id"] = $shopifyStore->user_id;
    
                            
                    //         Newpendinginvenoryupdate::dispatchNow($jobData);
     
    
                    //     }
                    //     else {
                            
                    //         echo "unknown mismatch";
                    //     }
                    // }
                    // }

                   // Log::info("now comparing old price to new price for this shopify store" . $shopifyStore->id);

                }
            } else if (trim($variant["sku"])) {

				Log::channel('fetchshopifyproducts')->info('check log 4');

				Log::channel('fetchshopifyproducts')->info("variant create " . $variant["id"]);
                $variantData["sku"] = $variant["sku"];
                $variantData["asin"] = $variant["sku"] ? trim($variant["sku"]) : 'Empty_Sku';
                 Log::channel('fetchshopifyproducts')->info("variantData asin at 770 ".$variant["sku"]);
                $variantData["product_id_val"] = $variant["barcode"] ? $variant["barcode"] : "Does not apply";
                $variantData["shopify_variant_id"] = $variant["id"];
                $variantData["shopify_inventory_item_id"] = $variant["inventory_item_id"];
                $variantData["shopify_product_id"] = $shProduct["id"];
                $variantData["product_id"] = $product->id;
                $variantData["store_id"] = $shopifyStore->id;
                $variantData["user_id"] = $shopifyStore->user_id;

				Log::channel('fetchshopifyproducts')->info('check log variants create');

                $variant = $product->variants()->create($variantData);
                if (!$variant)
                    $errors[] = "error creating product variant, product id : " . $sh_product_id . ", variant id : " . $variant["id"];
            }
        }

		
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////Delete
    //   if (count($newvariantData) > 0) {

    //     $notmatchshopify_product_id = $shopifyStore->variants()->where('shopify_product_id', $shProduct["id"])->whereNotIn('shopify_variant_id', $newvariantData)->pluck('shopify_variant_id');


    //     if (count($notmatchshopify_product_id) > 0) {
    //         foreach ($notmatchshopify_product_id as $variant_id) {
    //             if ($product['status'] == "unpublished") {
    //                 Log::channel('fetchshopifyproducts')->info("Deleted variant with shopify_variant_id: $variant_id");


    //                 ProductVariant::where('shopify_variant_id', $variant_id)->delete();


    //             } elseif ($product['status'] == "published" || $product['status'] == "created" || $product['status'] == "linked" ) {
    //                 ProductVariant::where('shopify_variant_id', $variant_id)->delete();
    //                 $shopify_var_id =  $variant["id"];
    //                 $listing = Listing_variant::with('variant')->where('sku', $shopify_var_id)->first();
    //                 $ebay_environment = config('ebay.environment');
    //                 $ebayCredentials = array(
    //                     'credentials' => [
    //                         'devId' => config('ebay.' . $ebay_environment . 'devid'),
    //                         'appId' => config('ebay.' . $ebay_environment . 'appid'),
    //                         'certId' => config('ebay.' . $ebay_environment . 'certid'),
    //                     ],
    //                     'authToken' => '',
    //                     'oauthUserToken' => '',
    //                     'ruName' => config('ebay.' . $ebay_environment . 'RuName')
    //                 );
    //                 $service = new Services\TradingService([
    //                     'credentials' => $ebayCredentials['credentials'],
    //                     'sandbox' => ($ebay_environment == "sandbox") ? true : false,
    //                     'siteId' => $site_id
    //                 ]);
    //                 if (isset($listing) && $listing) {

                     
    //                     $ebay_item_id = $listing->ebay_item_id;
    //                     $listing_variant_data = $listing->listing_variant_data;
    //                     $SKU = $listing->sku;
    //                     $resultArray = array();

    //                     foreach ($listing_variant_data->VariationSpecifics as $variation) {
    //                         foreach ($variation->NameValueList as $nameValue) {
    //                             $resultArray[$nameValue->Name][] = $nameValue->Value[0];
    //                         }
    //                     }
    //                     $request = new Types\ReviseFixedPriceItemRequestType();
    //                     $request->RequesterCredentials = new Types\CustomSecurityHeaderType();
    //                     $request->RequesterCredentials->eBayAuthToken = $token;
    
    //                     $itemType = new Types\ItemType();
    //                     $itemType->ItemID = $ebayitemid;
    //                     $variationsType = new Types\VariationsType();
    //                     $variationType = new Types\VariationType();
    //                     $variationType->Quantity = 0;
    //                     $variationType->SKU = $SKU;  
    //                     $variationSpecificsSetType = new Types\NameValueListArrayType();
    //                     $variationSpecificsSetType->NameValueList = array();
    //                     foreach ($resultArray as $k => $v) {
    //                         $nameValueListType = new Types\NameValueListType();
    //                         $nameValueListType->Name = $k;
    //                         $nameValueListType->Value = array($v);
    //                         $variationSpecificsSetType->NameValueList[] = $nameValueListType;
    //                     }
    //                     $variationType->VariationSpecifics = array($variationSpecificsSetType);
    //                     $variationsType->Variation = array($variationType);
    //                     $itemType->Variations = $variationsType;
    //                     $request->Item = $itemType;
                       
    //                     $response = $service->reviseFixedPriceItem($request);
                       
    //                     if ($response->Ack !== 'Failure') {
    //                     } else {
    //                         $errmsg = "";
    //                         if (isset($response->Errors)) {
    //                             foreach ($response->Errors as $error) {
    //                                 $errmsg .= $error->LongMessage . ", ";
    //                             }
    //                         }
    //                     }
    //                 } else{
    //                     $listings = Listing_variant::with('variant')->where('custom_sku', $shopify_var_id)->first();
    //                     if ($listings) {
    //                         $listing_variant_data = $listing->listing_variant_data;
                        
    //                         $ebay_item_id = $listings->variant->ebay_item_id;

    //                         $resultArray = array();

    //                         foreach ($listing_variant_data->VariationSpecifics as $variation) {
    //                             foreach ($variation->NameValueList as $nameValue) {
    //                                 $resultArray[$nameValue->Name][] = $nameValue->Value[0];
    //                             }
    //                         }
    //                         $request = new Types\ReviseFixedPriceItemRequestType();
    //                         $request->RequesterCredentials = new Types\CustomSecurityHeaderType();
    //                         $request->RequesterCredentials->eBayAuthToken = $token;
        
    //                         $itemType = new Types\ItemType();
    //                         $itemType->ItemID = $ebayitemid;
    //                         $variationsType = new Types\VariationsType();
    //                         $variationType = new Types\VariationType();
    //                         $variationType->Quantity = 0;
    //                       // $variationType->SKU = $lvariantsku;   // not confirm to data for ebay
    //                         $variationSpecificsSetType = new Types\NameValueListArrayType();
    //                         $variationSpecificsSetType->NameValueList = array();
    //                         foreach ($resultArray as $k => $v) {
    //                             $nameValueListType = new Types\NameValueListType();
    //                             $nameValueListType->Name = $k;
    //                             $nameValueListType->Value = array($v);
    //                             $variationSpecificsSetType->NameValueList[] = $nameValueListType;
    //                         }
    //                         $variationType->VariationSpecifics = array($variationSpecificsSetType);
    //                         $variationsType->Variation = array($variationType);
    //                         $itemType->Variations = $variationsType;
    //                         $request->Item = $itemType;
                           
    //                         $response = $service->reviseFixedPriceItem($request);
                           
    //                         if ($response->Ack !== 'Failure') {
    //                         } else {
    //                             $errmsg = "";
    //                             if (isset($response->Errors)) {
    //                                 foreach ($response->Errors as $error) {
    //                                     $errmsg .= $error->LongMessage . ", ";
    //                                 }
    //                             }
    //                         }
                          
    //                     }
    //                 }


    //             }
    //         }


    //     } else {
    //         Log::channel('fetchshopifyproducts')->info("No duplicate data found");
    //     }
    // } else {
    //     Log::channel('fetchshopifyproducts')->info("New variant data is empty");
    // }

       

        return $errors;
    }
    
    public function applyMarkup_1143(){
              print_r("hello applyMarkup_1143");
               $errors = array();
               
              $shopifyStore = AppHelper::getShopifyStore('rapid-nutrition-au.myshopify.com');
         
              $pvariants = $shopifyStore->variants()->whereNotNull('listing_variant_id')->get();

             if ($pvariants) {
                 
                 foreach($pvariants as $pvariant){
                      $newPrice = $pvariant->price;
                      $ebayAccount = $shopifyStore->ebayAccounts()->where("is_valid", 1)->find($pvariant->listingVariant->account_id);
                      print_r("here is the listing detail ".$pvariant->id);
                      $site_id=$ebayAccount->siteid;
                      
                    if ($ebayAccount && $newPrice) {
                         $price = (float)$newPrice;

                      if ($ebayAccount->pricing_mark_up == 1) {
                            $newPrice = $price + ((15 / 100) * $price);
                       }
                       print_r("hhhhhhhhhhhhhhhhh   ".$pvariant->id);
                        $variant = $shopifyStore->listingVariants()->where("variant_id", $pvariant->id)->first();
                        // $variant = $shopifyStore->listingVariants()->where("variant_id", 34)->first();
                        
                        if( isset($variant)){
                         
                          $ebay_item_id = $variant->ebay_item_id;
                        $sku = $variant->sku;
                        // die();
	                    $ebay_environment = config('ebay.environment');

		            	$ebayCredentials = array(
				       'credentials' => [
					   'devId' => config('ebay.'.$ebay_environment.'devid'),
				        'appId' => config('ebay.'.$ebay_environment.'appid'),
					    'certId' => config('ebay.'.$ebay_environment.'certid'),
			            	],
				        'authToken' => '',
			        	'oauthUserToken' => '',
				        'ruName' => config('ebay.'.$ebay_environment.'RuName')
			            );
		        	   $ebay_token = $ebayAccount["access_token"];
		        	
		          //	$site_id = (isset($ebayAccount["siteid"])) ? $ebayAccount["siteid"] : 0;
            
			             	$ebayService = new Services\TradingService([
				         	'credentials' => $ebayCredentials['credentials'],
					       'sandbox' => ($ebay_environment == "sandbox" ) ? true : false,
					       'siteId' => $site_id
				          ]);
			         	      $inventoryStatus = new Types\InventoryStatusType();
													if($sku) $inventoryStatus->SKU = $sku;
													$inventoryStatus->ItemID = $ebay_item_id;
													$inventoryStatus->StartPrice = new Types\AmountType(['value' => (float) $newPrice]);
													$inventoryStatusArray = array();
													$inventoryStatusArray[] = $inventoryStatus;
				
													$ebayRequest = new Types\ReviseInventoryStatusRequestType();
													$ebayRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
													$ebayRequest->RequesterCredentials->eBayAuthToken = $ebay_token;
													$ebayRequest->InventoryStatus = $inventoryStatusArray;
													$ebayResponse = $ebayService->reviseInventoryStatus($ebayRequest);
													$ebayResponse = ($ebayResponse) ? $ebayResponse->toArray() : array();
													print_r($ebayResponse);
                     
                        }else{
                            continue;
                        }
                              }
                          }       
             }

     return $errors;
    }
    
	public function submitProductsImportRequest(Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			if(!$shopifyStore->import_products){
				$shopifyStore->import_products = 1;
				$shopifyStore->save();
			}
			return response()->json(['status' => 'success','msg' => "Import request submitted. It will be processed soon."],200);
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function show($id,Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$product = $shopifyStore->products()->with('productData')->where("shopify_product_id",$id)->first();
			if($product){
				if($product->productData->count() > 0){
					foreach($product->productData as $pdk => $proData){
						if($proData->item_specific_values) $product->productData[$pdk]->item_specific_values = json_decode($proData->item_specific_values,true);
						else $product->productData[$pdk]->item_specific_values = json_decode ("{}");
					}
				}
				return response()->json($product,200);
			}
			else{
				return response()->json(['status' => 'error','msg' => "not found"],404);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function update($id,Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$product = $shopifyStore->products()->with('productData')->where("shopify_product_id",$id)->first();
			if($product){
				/*
				$validationRules = [
					'title' => 'required|max:80',
					'condition' => 'required'
				];
				$validator = Validator::make($request->all(),$validationRules);
				if($validator->fails()){
					return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
				}
				*/

				$title = trim($request->input('title'));
				if(!$title) $title = substr($product->title,0,80);

				$sub_title = $request->input('sub_title');
				$condition = $request->input('condition');
				$condition_note = $request->input('condition_note');
				$item_specific_values = $request->input('item_specific_values');
				$profile_id = $request->input('profile_id');

				$proData = [];
				$proData["title"] = $title;
				$proData["sub_title"] = $sub_title;
				$proData["condition"] = $condition;
				$proData["condition_note"] = $condition_note;
				$proData["item_specific_values"] = (is_array($item_specific_values)) ? json_encode($item_specific_values) : NULL;
				$proData["shopify_product_id"] = $product->shopify_product_id;
				$proData["shopify_product_handle"] = $product->shopify_product_handle;
				$proData["profile_id"] = $profile_id;
				$proData["product_id"] = $product->id;
				$proData["store_id"] = $product->store_id;
				$proData["user_id"] = $product->user_id;

				$productData = [];
				if($product->productData && $product->productData->count() > 0){
					foreach($product->productData as $pData){
						if($profile_id == $pData->profile_id || !$pData->profile_id){
							$productData = $pData;
							break;
						}
					}
				}

				$pRes = false;
				if($productData){
					$pRes = $productData->update($proData);
				}
				else{
					$pRes = $product->productData()->create($proData);
				}

				if($pRes){
					return response()->json(['status' => 'success','msg' => 'product data updated successfully','product' => $product->toArray()],200);
				}
				else{
					return response()->json(['status' => 'error','msg' => 'product data not updated, please try again'],406);
				}
			}
			else{
				return response()->json(['status' => 'error','msg' => "not found"],404);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function redirectEdit(Request $request){
		$id = $request->input('id');
		$shop = $request->input('shop');
		if($id && $shop){
			$shopifyStore = ShopifyStore::with('user')->with('plan')->where('shopify_url',$shop)->first();
			if($shopifyStore && $shopifyStore->status == "active"){
				$frontend_url = config('config.frontend_url').'products/edit/'.$id.'?'.http_build_query($_GET);
				$frontend_url = $frontend_url."&login_token=".$shopifyStore->login_token;
				echo '
				<script type="text/javascript">
					window.parent.location.href = "'.$frontend_url.'";
				</script>
				';
				die();
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function delete($product_id,$shopifyStore){
		$errors = array();
		try{
			$product = $shopifyStore->products()->with('variants')->find($product_id);
			if($product && $product->listing_id){
				$listing_id = $product->listing_id;
				$listing = $shopifyStore->listings()->with('variants')->find($listing_id);
				if($listing && $listing->product_id){
					$listing->product_id = NULL;
					$listing->save();
					foreach($listing->variants as $variant){
						$variant->variant_id = NULL;
						if($variant->custom_sku) $variant->custom_sku = NULL;
						$variant->save();
					}
				}
			}
			if($product){
				try{
					// PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
					// $shopifyClient = new PHPShopify\ShopifySDK;

					$config = array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version'));
					$shopifyClient = new PHPShopify\ShopifySDK($config);

					$shopifyClient->Product($product->shopify_product_id)->delete();
				//	$product->delete();
				}
				catch(\Exception $e){
					report($e);
					$errors[] = $e->getMessage();
				}
			}
		}
		catch(\Exception $e){
			report($e);
			$errors[] = $e->getMessage();
		}
		return $errors;
	}

	public function destroy(Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$validationRules = [
				'product_ids' => 'required'
			];
			$validator = Validator::make($request->all(),$validationRules);
			if($validator->fails()){
				return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
			}
			$errProCount = 0;
			$succProCount = 0;
			$errors = array();
			$product_ids = $request->input("product_ids");
			foreach($product_ids as $product_id){
				$delerrors = $this->delete($product_id,$shopifyStore);
				if($delerrors){
					$errors = array_merge($errors,$delerrors);
					$errProCount++;
				}
				else{
					$succProCount++;
				}
			}
			if($errors) file_put_contents("deleteProductsErrorShopify_".$shopifyStore->id.".json",json_encode($errors));
			$msg = ($succProCount > 1) ? $succProCount." products deleted successfully" : "1 product deleted successfully";
			if($errProCount > 0) $msg .= ($errProCount > 1) ? ", ".$errProCount." products failed" : ", 1 product failed";
			return response()->json(['status' => 'success','msg' => $msg],200);
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function submitPublishRequest(Request $request){
	     Log::info("In submitpublish method ");
	      Log::info($request);
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$validationRules = [
				'ids' => 'required',
				'profile_id' => 'required|numeric'
			];
			$validator = Validator::make($request->all(),$validationRules);
			if($validator->fails()){
				return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
			}

			$planFeatures = json_decode($shopifyStore->plan->features,true);
			$published = $shopifyStore->products()->where("status","published")->count();
			$products_limit = (isset($planFeatures["credits"])) ? (int) $planFeatures["credits"] : 10;
               Log::info("product limit".$products_limit);
			$product_ids = $request->input("ids");
            
			if (($pikey = array_search("all",$product_ids)) !== false) unset($product_ids[$pikey]);

			$remaining_limit = $products_limit - $published;
			
			///////////////////////////////////////
            // if($shopifyStore->id == 1335){
            //     $remaining_limit = 10;
            // }
            ////////////////////////////////////
			if($remaining_limit <= 0){
				return response()->json(['status' => 'error','msg' => "This operation is not allowed due to the maximum credits limit reached. Please upgrade your plan."],406);
			}
			else if(count($product_ids) > $remaining_limit){
				return response()->json(['status' => 'error','msg' => "You don't have enough credits to publish all ".count($product_ids)." products. Please upgrade your plan."],406);
			}			

			// PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
			// $shopifyClient = new PHPShopify\ShopifySDK;

			$config = array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version'));
			$shopifyClient = new PHPShopify\ShopifySDK($config);


			$account = $shopifyStore->ebayAccounts()->where('is_valid',1)->first();
			if(!$account) return response()->json(['status' => 'error','msg' => "invalid ebay account keys"],406);
			
			$profile_id = $request->input("profile_id");
			

			$profile = $shopifyStore->profiles()->with('category1')->find($profile_id);
			if(!$profile) return response()->json(['status' => 'error','msg' => "profile not found"],406);
			if(!$profile->category1) return response()->json(['status' => 'error','msg' => "profile category not updated"],406);
			
			if($product_ids){
			    
             ////////////////////////////////////////////////////////////////////////////
              foreach($product_ids as $key => $value){
					$product = $shopifyStore->products()->with('variantsCount')->find($value);
					if($product){
						$quantity = $product->variantsCount->quantity;
						if($quantity <= 0 ){
							unset($product_ids[$key]);
						}else{
							continue;
						}
					}else{
						continue;
					}
				}
             ///////////////////////////////////////////////////////////////////////////////
             
				$site_id = (isset($account->siteid)) ? $account->siteid : 0;

				$ebay_environment = config('ebay.environment');
				$ebayCredentials = array(
					'credentials' => [
						'devId' => config('ebay.'.$ebay_environment.'devid'),
						'appId' => config('ebay.'.$ebay_environment.'appid'),
						'certId' => config('ebay.'.$ebay_environment.'certid'),
					],
					'authToken' => '',
					'oauthUserToken' => '',
					'ruName' => config('ebay.'.$ebay_environment.'RuName')
				);

				$ebayService = new Services\TradingService([
					'credentials' => $ebayCredentials['credentials'],
					'sandbox' => ($ebay_environment == "sandbox" ) ? true : false,
					'siteId' => $site_id
				]);

				$listingController = new ListingController();

				foreach($product_ids as $product_id){
				      Log::info("importing the product ".$product_id);
					$product = $shopifyStore->products()->with('variants')->find($product_id);

					if(!$product) continue;
					else if($product->listing_id){
					    
						$listing = $shopifyStore->listings()->find($product->listing_id);
						if($listing) continue;
					}

					$shProduct = json_decode($product->shopify_product_data,true);
			        $json=	$product->shopify_product_data ;
			         
			        
			         $data=json_decode($json, true);

                      $options = $data['options'];

                     foreach ($options as &$option) {
                      if ($option['name'] === 'Style') {
                      $option['name'] = 'newstyle';
                         break; // Assuming there is only one 'Style' option
                      }
                      elseif ($option['name'] === 'Quantity') {
                      $option['name'] = 'newQuantity';
                         break; // Assuming there is only one 'Style' option
                      }
                      }
                      $data['options'] = $options;
                     
                       $newJson = json_encode($data);
                      Log::info('Here is the product details');
                      Log::info($newJson);
                     $product-> where('id',$product_id)->update(['shopify_product_data' => $newJson]);
                        Log::info("updated product");
				//	$ebayResponse = $listingController->verifyEbayItem($product_id,$profile_id,$account,$shopifyStore);
			
				if($shopifyStore->id == 1227){
				    log::info("hellloooooooooooooooooooooooooooooooooo1231444".$shopifyStore->user_id);
				    $ebayResponse = $listingController->verifyEbayItem($product_id,$profile_id,$account,$shopifyStore);
				    //		$ebayResponse = $listingController->test1verifyebayitem($product_id,$profile_id,$account,$shopifyStore);
                            	log::info("the verify reponse is ".json_encode($ebayResponse));
					//$ebayResponse = $listingController->verifyEbayItemTest($product_id,$profile_id,$account,$shopifyStore);
					
					if(!$ebayResponse) return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify, please try again"],406);
					else if(isset($ebayResponse->Errors)){
						file_put_contents("ebay_errors.json",json_encode($ebayResponse->toArray()));

						$ebayResponse = $ebayResponse->toArray();

						$ebayResponse2 = $ebayResponse;
                        $shErrMsgs="";
						$shErrMsg = "";
						$longErrMsg = "";
						foreach($ebayResponse["Errors"] as $erk => $ebError){
							if($ebError["SeverityCode"] != "Warning"){
								$longErrMsg .= $ebError["LongMessage"];
								$shErrMsgs .= $ebError["ShortMessage"];
							$shErrMsg = str_replace(['<', '>','.'], '', $shErrMsgs);
								Log::info(" hoooooooooooooooaoaoaoaoaoaoaoao ".str_replace(['<', '>','.'], '', $longErrMsg) );
							}
							else if($ebError["SeverityCode"] == "Warning"){
								unset($ebayResponse2["Errors"][$erk]);
							}
						}

						$ebayResponse = $ebayResponse2;

						if($longErrMsg){
							$ebayResponse["Errors"][] = [
								"ShortMessage" => $shErrMsg,
								"LongMessage" => $longErrMsg
							];

							return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify.", 'errors' => $ebayResponse],406);
						}
					}
					else if($ebayResponse && is_array($ebayResponse) && isset($ebayResponse["error"])){
						return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify.", 'errors' => ["Errors" => ["LongMessage" => $ebayResponse["error"]]]],406);
					}
					

                  	return response()->json(['status' => 'success','msg' => "success"]);

                   
				}
				

					$description = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>',$shProduct["body_html"]);
					$description = trim(preg_replace('/\s\s+/','',strip_tags($description,'<p><br>')));
					$description = str_replace("\n","",$description);
					$description = str_replace('\n',"",$description);
					$description = str_replace('<p> </p>',"",$description);
					$description = str_replace('<p></p>',"",$description);

					//if(strlen($description) > 2000) return response()->json(['status' => 'error','msg' => $product->title."'s description length can not be greater than 2000 character"],406);

					/*
					$option1name = (isset($shProduct["options"][0]["name"])) ? strtolower($shProduct["options"][0]["name"]) : NULL;
					$option2name = (isset($shProduct["options"][1]["name"])) ? strtolower($shProduct["options"][1]["name"]) : NULL;
					$option3name = (isset($shProduct["options"][2]["name"])) ? strtolower($shProduct["options"][2]["name"]) : NULL;
					if($option1name && $option1name != "default title" && $option1name != "title"){
						if($profile->attributeMapping->count() > 0){
							$attributeMapping = array();
							foreach($profile->attributeMapping as $attrMapping) $attributeMapping[strtolower($attrMapping->option_name)] = $attrMapping->attribute_name;
				
							$option1Attr = (isset($attributeMapping[$option1name])) ? $attributeMapping[$option1name] : null;
							$option2Attr = (isset($attributeMapping[$option2name])) ? $attributeMapping[$option2name] : null;
							$option3Attr = (isset($attributeMapping[$option3name])) ? $attributeMapping[$option3name] : null;

							if(!$option1Attr) return response()->json(['status' => 'error','msg' => $product->title."'s option1 attribute mapping not updated"],406);
							if(!$option2Attr && $option2name) return response()->json(['status' => 'error','msg' => $product->title."'s option2 attribute mapping not updated"],406);
							if(!$option3Attr && $option3name) return response()->json(['status' => 'error','msg' => $product->title."'s option3 attribute mapping not updated"],406);
						}
						else{
							return response()->json(['status' => 'error','msg' => "profile attribute mapping not updated"],406);
						}
					}
					*/
				}

				foreach($product_ids as $product_id){
					$jobData = array();
					$jobData["product_id"] = (int) $product_id;
					$jobData["profile_id"] = ($profile_id) ? $profile_id : null;
					$jobData["account_id"] = $account->id;
					$jobData["store_id"] = $shopifyStore->id;
					$jobData["user_id"] = $shopifyStore->user_id;
					 Log::info("adding  the product to publish queue for user ". $shopifyStore->user_id. " and " .$product_id);
					PublishProduct::dispatchNow($jobData);
				}
			}
			return response()->json(['status' => 'success','msg' => 'request submitted successfully'],200);
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}
	
	
// 	public function updateProduct22(){
// 	    print_r('entered in updateProduct22');
//           $shopifyStores = ShopifyStore::where('id',1255)->get();  
// 		     Log::info("shopify store  ". json_encode($shopifyStores,true));
		     
//         	foreach($shopifyStores as $shopifyStore)
// 				{
// 				$shopify_store_id = $shopifyStore->id;
// 				Log::info('ImportShopifyProducts shopify store id '.$shopify_store_id);
// 				$store_database_name = config('config.store_db_prefix').$shopify_store_id;
// 				AppHelper::setConnection($store_database_name,$shopifyStore);
// 				PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
// 				$shopifyClient = new PHPShopify\ShopifySDK;
// 				if(!$shopifyClient)continue;    
			
// 				$location = $shopifyClient->Location->get();
// 				if($location){
// 				    Log::info('here is the location '.json_encode($location,true));
// 				   print_r('here is the location '.json_encode($location,true));
// 				}else{
// 				    Log::info('location not found'); 
// 				}
				
//     // 		 		try{
//     //                       $errors = array();
//     //                      $variants = $shopifyStore->variants()->get();
//     //                       Log::info("here is the variant  ". json_encode($variants,true));
                         
//     //                       foreach ($variants as $pvariant) {
                                 
//     //                                  if ($pvariant->sku == "") {
//     //                                   continue;
//     //                                   }
//     //                                     else{
                 
//     //                                   Log::info("Skus in Asin  ". $pvariant->asin);
//     //                                   if($pvariant->sku ==  $pvariant->asin ||  $pvariant->asin == null){
//     //                                       Log::info("Skus and Asin are same for ". $pvariant->sku);
//     //                                      continue;
//     //                                   }else{
//     //                                       try {
                       
//     //                                         $updatesku =  $pvariant->asin;
//     //                                         Log::info("Sku's are in Asin  ".$updatesku);
//     //                                         Log::info("shopify variant id is this   ".$pvariant->shopify_variant_id);
//     //                                          $shopifyClient->ProductVariant($pvariant->shopify_variant_id)->put(array("id" => $pvariant->shopify_variant_id, "sku" => $updatesku));
//     //                                         Log::info("Asin updated on shopify  ".$updatesku);
//     //                                          $updated = $shopifyStore->variants()->where("shopify_variant_id",$pvariant->shopify_variant_id)->update(["sku" => $updatesku]);
//     //                                       Log::info("Asin updated in db   ".json_encode($updated,true));
//     //                                       }
//     //                                         catch (\Exception $e) {
//     //                                          report($e);
//     //                                          $errors[] = $e->getMessage();
//     //                                         }
//     //                                   }
            
//     //                                 }
                 
                        
            
//     //                           }
//     // 		 		}catch(\Exception $e){
//     // 			   	report($e);
//     // 			   	$errors[] = $e->getMessage();
// 				// 	Log::info('ImportShopifyProducts products errors found id store '.$shopify_store_id);
//     // 		   	}
// 				}
//     }
	
	
	public function Updateallpublish(Request $request){
	    
	      Log::info(" In Update all publish products method ");
	     
	       // Log::info($request);
	    	$shopifyStore = AppHelper::getShopifyStore($request);
	    if($shopifyStore){
			$validationRules = [
		
				'profile_id' => 'required|numeric'
			];
			$validator = Validator::make($request->all(),$validationRules);
			if($validator->fails()){
				return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
			}

			$planFeatures = json_decode($shopifyStore->plan->features,true);
			$published = $shopifyStore->products()->where("status","published")->count();
			$products_limit = (isset($planFeatures["credits"])) ? (int) $planFeatures["credits"] : 10;
              Log::info("product limit".$products_limit);
               
          //   $product_ids = $shopifyStore->products()->where('status','unpublished')->pluck('id');
            // $product_ids = $shopifyStore->products()->where('status', 'published')->pluck('id');
             
             /////////////////////////////////////////////////////////////////////////////////////////////
             $product_ids = array();
             $products = $shopifyStore->products()->with('variantsCount')->where('status', 'published')->get();
				foreach($products as $product){
				
					if($product->variantsCount && $product->variantsCount->quantity > 0 ){
						$product_ids[] = $product->id;
					
					}else{
						continue;
					}
					 
				
				}
             ////////////////////////////////////////////////////////////////////////////////////////////

              Log::info("product idss".json_encode($product_ids));
            
			$remaining_limit = $products_limit - $published;
			
			if($remaining_limit <= 0){
				return response()->json(['status' => 'error','msg' => "This operation is not allowed due to the maximum credits limit reached. Please upgrade your plan."],406);
			}
			else if(count($product_ids) > $remaining_limit){
				return response()->json(['status' => 'error','msg' => "You don't have enough credits to publish all ".count($product_ids)." products. Please upgrade your plan."],406);
			}			

			// PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
			// $shopifyClient = new PHPShopify\ShopifySDK;

			$config = array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version'));
			$shopifyClient = new PHPShopify\ShopifySDK($config);


			$account = $shopifyStore->ebayAccounts()->where('is_valid',1)->first();
			if(!$account) return response()->json(['status' => 'error','msg' => "invalid ebay account keys"],406);
			
			$profile_id = $request->input("profile_id");
			

			$profile = $shopifyStore->profiles()->with('category1')->find($profile_id);
			if(!$profile) return response()->json(['status' => 'error','msg' => "profile not found"],406);
			if(!$profile->category1) return response()->json(['status' => 'error','msg' => "profile category not updated"],406);
			
			 
			if($product_ids){
      
				$site_id = (isset($account->siteid)) ? $account->siteid : 0;

				$ebay_environment = config('ebay.environment');
				$ebayCredentials = array(
					'credentials' => [
						'devId' => config('ebay.'.$ebay_environment.'devid'),
						'appId' => config('ebay.'.$ebay_environment.'appid'),
						'certId' => config('ebay.'.$ebay_environment.'certid'),
					],
					'authToken' => '',
					'oauthUserToken' => '',
					'ruName' => config('ebay.'.$ebay_environment.'RuName')
				);

				$ebayService = new Services\TradingService([
					'credentials' => $ebayCredentials['credentials'],
					'sandbox' => ($ebay_environment == "sandbox" ) ? true : false,
					'siteId' => $site_id
				]);

				$listingController = new ListingController();

				foreach($product_ids as $product_id){
				      Log::info("importing the product ".$product_id);
					$product = $shopifyStore->products()->with('variants')->find($product_id);

					if(!$product) continue;
					else if($product->listing_id){
					    
						$listing = $shopifyStore->listings()->find($product->listing_id);
						if($listing) continue;
					}

					$shProduct = json_decode($product->shopify_product_data,true);
			        $json=	$product->shopify_product_data ;
			         
			        
			         $data=json_decode($json, true);

                      $options = $data['options'];

                     foreach ($options as &$option) {
                      if ($option['name'] === 'Style') {
                      $option['name'] = 'newstyle';
                         break; // Assuming there is only one 'Style' option
                      }
                      elseif ($option['name'] === 'Quantity') {
                      $option['name'] = 'newQuantity';
                         break; // Assuming there is only one 'Style' option
                      }
                      }
                      $data['options'] = $options;

                       $newJson = json_encode($data);
                      Log::info('Here is the product details');
                      Log::info($newJson);
                     $product-> where('id',$product_id)->update(['shopify_product_data' => $newJson]);
                        Log::info("updated product");
				//	$ebayResponse = $listingController->verifyEbayItem($product_id,$profile_id,$account,$shopifyStore);
			
				if($shopifyStore->id == 1128 || $shopifyStore->id == 1128){
				    log::info("hellloooooooooooooooooooooooooooooooooo1231444".$shopifyStore->user_id);
				    	//	$ebayResponse = $listingController->test1verifyebayitem($product_id,$profile_id,$account,$shopifyStore);
                            	log::info("the verify reponse is ".json_encode($ebayResponse));
					//$ebayResponse = $listingController->verifyEbayItemTest($product_id,$profile_id,$account,$shopifyStore);
						$ebayResponse = $listingController->verifyEbayItem($product_id,$profile_id,$account,$shopifyStore);
					if(!$ebayResponse) return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify, please try again"],406);
					else if(isset($ebayResponse->Errors)){

						file_put_contents("ebay_errors.json",json_encode($ebayResponse->toArray()));

						$ebayResponse = $ebayResponse->toArray();

						$ebayResponse2 = $ebayResponse;
                        $shErrMsgs="";
						$shErrMsg = "";
						$longErrMsg = "";
						foreach($ebayResponse["Errors"] as $erk => $ebError){
							if($ebError["SeverityCode"] != "Warning"){
								$longErrMsg .= $ebError["LongMessage"];
								$shErrMsgs .= $ebError["ShortMessage"];
							$shErrMsg = str_replace(['<', '>','.'], '', $shErrMsgs);
								Log::info(" Hoooooooooooooooaoaoaoaoaoaoaoaoaoaoaoaoao ".str_replace(['<', '>','.'], '', $longErrMsg) );
							}
							else if($ebError["SeverityCode"] == "Warning"){
								unset($ebayResponse2["Errors"][$erk]);
							}
						}

						$ebayResponse = $ebayResponse2;

						if($longErrMsg){
							$ebayResponse["Errors"][] = [
								"ShortMessage" => $shErrMsg,
								"LongMessage" => $longErrMsg
							];

							return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify.", 'errors' => $ebayResponse],406);
						}
					}
					else if($ebayResponse && is_array($ebayResponse) && isset($ebayResponse["error"])){
						return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify.", 'errors' => ["Errors" => ["LongMessage" => $ebayResponse["error"]]]],406);
					}
					
                  //	return response()->json(['status' => 'success','msg' => "success"]);

				}
				
				// 	$description = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>',$shProduct["body_html"]);
				// 	$description = trim(preg_replace('/\s\s+/','',strip_tags($description,'<p><br>')));
				// 	$description = str_replace("\n","",$description);
				// 	$description = str_replace('\n',"",$description);
				// 	$description = str_replace('<p> </p>',"",$description);
				// 	$description = str_replace('<p></p>',"",$description);
					
				}

				foreach($product_ids as $product_id){
					$jobData = array();
					$jobData["product_id"] = (int) $product_id;
					$jobData["profile_id"] = ($profile_id) ? $profile_id : null;
					$jobData["account_id"] = $account->id;
					$jobData["store_id"] = $shopifyStore->id;
					$jobData["user_id"] = $shopifyStore->user_id;
					Log::info("adding  the product to publish queue for user ". $shopifyStore->user_id. " and " .$product_id);
					PublishProduct::dispatchNow($jobData);
				}
			}
			return response()->json(['status' => 'success','msg' => 'request submitted successfully'],200);
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}
	
	public function BulkPublishAll(Request $request){
		    
	        Log::info("In Bulk publish all method ");
	       
	        Log::info($request);
	        
	    	$shopifyStore = AppHelper::getShopifyStore($request);
	    if($shopifyStore){
			$validationRules = [
		
				'profile_id' => 'required|numeric'
			];
			$validator = Validator::make($request->all(),$validationRules);
			if($validator->fails()){
				return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
			}
        
			$planFeatures = json_decode($shopifyStore->plan->features,true);
			$published = $shopifyStore->products()->where("status","published")->count();
			$products_limit = (isset($planFeatures["credits"])) ? (int) $planFeatures["credits"] : 10;
               Log::info("product limit".$products_limit);
               
            
        
           //  $product_ids = $shopifyStore->products()->pluck('id');
                /////////////////////////////////////////////////////////////////////////////////////////////
             $product_ids = array();
             $products = $shopifyStore->products()->with('variantsCount')->get();
				foreach($products as $product){
				
					if($product->variantsCount && $product->variantsCount->quantity > 0 ){
						$product_ids[] = $product->id;
					
					}else{
						continue;
					}
					 
				
				}
             ////////////////////////////////////////////////////////////////////////////////////////////

              Log::info("product idss".json_encode($product_ids));
             
             
             
             
             /////////////////////////////////////////////////////////////////////////////////////////////////
    //     if($shopifyStore->id == 149){
    //           $prevImpArr =  [6623161876529,4574825513009,4827918860337,7602075009278,7602074845438,4674014412849,6623797608497,7635215155454,7500764020990,4695268917297,7540950368510,6536318484529,4821951447089,6637677969457,6662204129329,6579737657393,4794830225457,7610715832574,6656828538929,7521574977790,6605962805297,6613326725169,6546794020913,7600556048638,6591887278129,7560150089982,6614701998129,6579781402673,7603292274942,4752445374513,7526826508542,4700298215473,6613248376881,4829333356593,4829330047025,6592832012337,6625214136369,6613220786225,6595969613873,6579064995889,6536434614321,6576164274225,6660307877937,6660307845169,7488366018814,6541335625777,4700298444849,6657424130097,6656837124145,6657543077937,7540953481470,7573033353470,6549246181425,7573033582846,6662175555633,4753615618097,7602085232894,6606934016049,6559564496945,6568195948593,4791750983729,7493501747454,6579052183601,6544165371953,6546794086449,6570502586417,6570508550193,6582224683057,6630571999281,6575924674609,4692853358641,7515572338942,7476012810494,6660443144241,6656613449777,4692601897009,7527705542910,6598550978609,6556984737841,7507023593726,4795593982001,4739582918705,6605962739761,4534248210481,6619928821809,4806306037809,6539651088433,6612920500273,7504416211198,7578177077502,6570820829233,6637116031025,6619061977137,7506826887422,7517730603262,7475853918462,6660456611889,6633786834993,7475849298174,6591891210289,7521894596862,6637995032625,4534516711473,6536436842545,6660559831089,4743997947953,6585944768561,4830325407793,7522130264318,6538523902001,6606969045041,7500764381438,6660874076209,7527699906814,6606679244849,6656757465137,6576169025585,6579745194033,4826058948657,6544165339185,6619944190001,4829993009201,6537241329713,4534268428337,7487527321854,7526409011454,7519037686014,6599885881393,6609847255089,4654965391409,6606970290225,6598571491377,6656764870705,6553668681777,7551337169150,7493510234366,7541055324414,6656440205361,6595733979185,7553470857470,6585949978673,7526680789246,6585489522737,7501472825598,7575230415102,7560149532926,6595693969457,7472871932158,6585491849265,6605962870833,7474908201214,6544164028465,4821515403313,6560180011057,4749851033649,6564459479089,7555208675582,7602085396734,4752696410161,6567807352881,6546068308017,7526695928062,7549734289662,7500606341374,6559860686897,6608835870769,4765336109105,6633809051697,7569357996286,7603455426814,7553292239102,6641268162609,4802287271985,7575096525054,6620369387569,7507989725438,7569444241662,6586858307633,4822011576369,4675820814385,4534245523505,4793240059953,4534354477105,6641226219569,6596075946033,7569437032702,6583478255665,6633809870897,4821922480177,7553928855806,7600638853374,4835183657009,7553928495358,4686281244721,6621804724273,6609121345585,6631299350577,7569436770558,6546059264049,4534221406257,4534372499505,4822648848433,4792065130545,6663812808753,6626623946801,6536438120497,4835924410417,4821901574193,4822656909361,4822656942129,4824308744241,7504376824062,7501481574654,6612588265521,4707579134001,7500663587070,4835312074801,4674814672945,6657666449457,4675818422321,7505226072318,6582235398193,4534529065009,7506918277374,4828567568433,6598573391921,4821846032433,7492909629694,6585597689905,7506237882622,7506237751550,7601850843390,7569282269438,7517709828350,6631295811633,6585250480177,6539650203697,6633784934449,7488400949502,6569974825009,6656791642161,6620370862129,6595730407473,6598549438513,6560184959025,6620382887985,6595397124145,4534521430065,7555208806654,6586439991345,6576167780401,6660309418033,7555191800062,7575075062014,7528284881150,7574214934782,4757912518705,7488400785662,6595950149681,6595730702385,4822654943281,4738363654193,4807044890673,4804928634929,4674027749425,4704284114993,4829065412657,7461196464382,4704263340081,4534444556337,6595734569009,7553284767998,6638002896945,7651118547198,4764073754673,4825522241585,4828539322417,6619168178225,6656613384241,6660304732209,6553912311857,4583801290801,6623475531825,7574303408382,4534442164273,4534548889649,7492897145086,4746876059697,4802482929713,7600534323454,7600691151102,7603454443774,7600565911806,4776782364721,7492897014014,4776786460721,7461215011070,6596274421809,7541186527486,6544230318129,4765629612081,4828548300849,4804928929841,4575742984241,4575567970353,4824869306417,6657232994353,6536128331825,4825621364785,4824604180529,4829214179377,7654144737534,7461183258878,4821519663153,4828537290801,6609766416433,4825635946545,4825623298097,4804304863281,7506102452478,4829048111153,4743997784113,4822588489777,7553267761406,4831157157937,7459903242494,4830975066161,7488366215422,4826021953585,4826020347953,6538538549297,4765623582769,4824604114993,4798874255409,4534417752113,6606932803633,4824608014385,4791461773361,4758650159153,4825629818929,4763784904753,7487520243966,4824313069617,4829051617329,6567811776561,7474857181438,4834352562225,4825632931889,7569217356030,4829408362545,4534218915889,6656441057329,4821894332465,4752781803569,6582645489713,6664016527409,6637219348529,4763674247217,6630349111345,6630349176881,4687752757297,6539252170801,6575931686961,6619930296369,6622715052081,4829410656305,4829337190449,6630892142641,6638000406577,4765623517233,4824614699057,4824646385713,6624238600241,6656694255665,4829055156273,6608791207985,7475855720702,4824603623473,6544298803249,6661104402481,7553298465022,4830962319409,7492906483966,4822577872945,6629926142001,6637756252209,4789105033265,6637605781553,6630352355377,6631276838961,4826056327217,6540330762289,4824223121457,6608758538289,6660513234993,6606687076401,4830974607409,6605576798257,7551459098878,4822647275569,6538526720049,6538528292913,6536004862001,6598853787697,4829413015601,6592327417905,6592327483441,4785770790961,4765403971633,4765404069937,6606693171249,6542673772593,6630897483825,6592394887217,6570338287665,6630554763313,6621804527665,7475848151294,6619155103793,6630352322609,4534261645361,4782270709809,6657232633905,4736453804081,6612924727345,6656831488049,7541200879870,6570101899313,7487519883518,6592328597553,6656679575601,6637615972401,4791737974833,6539265114161,6609060855857,4822584098865,6539254890545,6586474922033,6660556947505,4822592225329,6662647578673,6630576881713,7569208803582,6548944715825,4819086966833,7475846807806,6592733970481,6663956529201,6630873858097,6609063116849,7551333859582,6624231751729,6550004039729,6609149198385,7488406290686,7476199260414,7624525873406,6544165175345,6621792862257,7600661922046,6620401926193,4788074872881,6659364192305,6631335133233,4829404495921,6538826973233,4575569838129,6569971646513,6621724442673,7462541918462,7461236015358,6622566711345,6595951853617,4726710927409,6630548930609,6660046061617,7575048421630,6546760368177,6656440238129,7472868884734,6536012333105,6609848664113,4787842777137,6570397237297,7487529058558,4817627643953,6568091844657,6664239874097,6656440926257,6631249084465,6608635199537,6550007873585,6595972890673,7460054892798,6579330416689,7517430644990,6630875594801,4785483350065,7476181958910,6586854670385,7635241730302,7635239731454,4534389440561,6569665462321,6607051522097,6546772492337,6659478683697,6596634279985,7521604894974,4824695963697,6619945697329,6579734151217,7472870850814,4765989011505,7472865050878,6592833191985,4824921112625,7602087100670,6595408756785,6591675662385,6576168763441,4829208739889,4824979275825,6591902056497,6659137044529,4687879536689,6612614610993,7552685670654,6592326107185,7489369899262,6568073625649,6609828806705,6607046606897,6559834406961,6622717739057,4830451892273,6540336889905,4830372888625,6637143556145,6657657864241,4822329131057,7574300393726,6660582015025,6540631867441,6659156017201,4773689655345,7459902095614,6572829114417,6575819653169,7487529124094,4534262431793,7475521945854,7600567517438,4835383083057,6621782048817,6659094741041,4674869002289,6591888064561,4763789393969,4742010241073,6663654506545,7541076328702,7541081866494,7492901732606,7600921673982,4807035453489,6567106773041,4821897216049,4534263382065,6599520256049,6660530733105,7474537496830,6544300900401,4794900643889,4534530211889,6660042031153,7490006778110,7504374726910,4795594014769,6548695547953,6660513005617,6659137372209,6656768507953,6622714101809,4807037616177,7600694132990,6573371588657,6656759103537,6573108002865,6656652804145,6656818053169,6559557419057,4819095388209,7504424173822,4779818483761,6621731422257,6659475505201,4575717064753,6662647611441,4798863769649,6544164061233,6627020439601,6660462084145,4821847670833,6606621802545,6567072366641,7553471054078,4798251892785,7573989490942,4534523953201,6592838107185,7573978448126,6608805003313,6626174271537,4584535359537,4826080739377,4835902980145,4674029158449,6609139859505,6638003781681,4583916503089,6660039082033,6660039180337,6621830185009,7500769263870,7501477019902,6563997253681,6567109394481,6568089649201,6544239329329,6573100695601,6621809868849,6621810098225,6572611993649,6592332824625,4674903506993,6572924633137,6564046438449,4717144506417,4830328586289,6659342499889,6536122630193,6582224748593,6607054471217,4583749451825,6660046094385,6612199702577,6622541643825,6612871610417,4754202492977,4766005329969,6663785775153,6630575996977,7502772306174,6569637740593,6657993310257,4674017329201,6657179844657,6572915785777,6661080514609,7523543711998,6620410642481,6596687724593,4787867648049,4750610137137,7472865444094,4806557335601,7551441404158,6661094998065,6663985201201,6569776414769,6585962790961,6559896567857,6540335808561,7461209211134,6544233332785,4835914776625,6606936277041,6538813964337,4773690605617,6626627977265,7517571940606,4600846221361,7459900915966,6659185115185,7472868524286,6662197248049,6596069261361,6599602208817,6592394952753,6566982516785,6659191078961,6538534486065,4830325243953,6656687374385,7600662020350,6661122654257,7492897210622,6629954584625,6592617480241,6593591672881,7549793304830,4829324378161,6564454105137,4807845052465,6592354779185,6663980908593,4824616304689,6548943142961,6593578270769,6663622131761,4763782742065,6592337412145,4534529949745,6560884916273,6609847353393,6607033073713,6663981858865,6608768663601,6546059362353,6566404489265,6623798100017,6546778259505,4833841119281,6564060823601,6586854637617,6606656733233,6663968194609,6663800684593,6563921297457,7488418021630,7555130360062,6659184721969,6544300638257,6582574743601,4575583830065,6536123744305,4575546376241,6638041268273,4819092045873,6663810678833,6660015358001,6540333711409,4779226759217,6657233682481,4749113655345,4747482660913,6559569117233,4788100169777,6580175208497,6622692704305,6575926771761,6624233291825,6641244602417,6656691568689,7488310313214,7461193974014,4534499311665,6595697213489,7502746452222,4534348775473,6660499111985,6596031545393,4720650944561,6560594722865,6656770113585,6595973185585,4752437706801,6622537351217,6536128462897,6622717706289,7574302982398,6570815455281,7541001355518,6606682062897,6657995636785,6637756350513,4824303992881,6659343286321,6585944539185,4534511829041,4828560031793,6663618789425,6663800651825,6572603637809,7460070260990,6612861616177,4534224158769,4835211968561,6585489686577,6593069285425,4761767608369,7504424141054,6626288992305,7574111158526,6572538560561,4804302340145,6660513890353,4764072476721,7551140561150,7490124644606,7490124611838,7490129199358,4758689513521,6538505617457,7494655901950,4534451241009,4725243609137,4749071712305,7521896988926,4829403807793,4742245089329,6569774710833,7522434515198,6573099483185,6573099417649,7504422895870,7553362428158,6560886194225,4626718851121,4744013348913,6569675063345,6585945292849,7504420602110,7492992762110,7575209607422,6546098192433,7578133364990,6579783008305,6572717408305,6555006107697,4701098639409,7578071466238,4804600823857,6576162996273,6596580180017,6586858242097,4822646128689,6592352845873,6608635330609,6539179884593,6569650815025,6656758743089,7519037423870,6656766967857,6596580212785,6542376566833,4824607359025,6640328900657,6663875461169,6608799236145,4824953389105,6663903117361,7635347669246,4750368440369,6612897202225,6623475662897,4753595957297,6585954369585,6570101866545,4792571822129,6605963100209,6630534512689,7602092310782,7459901571326,4819093258289,6593017937969,6657666220081,7541191934206,6546797461553,6656440631345,6598581190705,4534524084273,6545234952241,7551338021118,7526437978366,6622717116465,7544639750398,6656643170353,6606972813361,6606941290545,6657983283249,6657982595121,4534530080817,4816724131889,7521887617278,6593082916913,6572921126961,4795592966193,4583999209521,4584004386865,4720493690929,6657536163889,4674024144945,7551331008766,6567076233265,6570019192881,4534507634737,7560439103742,6559566102577,4584000061489,7500769231102,4724836007985,6609077960753,4583989870641,4534502621233,4750363295793,6657533083697,4724835516465,7569376870654,4830372921393,4785485185073,4830372102193,6660461953073,6573108559921,6623797641265,7577946456318,6570032988209,7501560807678,4575550701617,6622715805745,7460047519998,7460188717310,6575832399921,7462541164798,7560446476542,6656441712689,7492891541758,6579781369905,6538863476785,6605558513713,6596631560241,4833944567857,6612858011697,7552697827582,6572620152881,7555294429438,4829336338481,6606961410097,4753901256753,4829431529521,6656643924017,6592357498929,6660498030641,4830324981809,6539650433073,4534516449329,6641276977201,6536009121841,6564482809905,6546781143089,6627027320881,6556136636465,6609763532849,4821845999665,4599199105073,4819087163441,4534491742257,7502760902910,6605954285617,4575572951089,4646279020593,6544164454449,6623475269681,6539211046961,7555143336190,4656698130481,7461129683198,7651118678270,7459902324990,6657663828017,7575229858046,4583761346609,7507007373566,6546796183601,6656441122865,6544237101105,7521604927742,4765336469553,4824623448113,7472870392062,4835274424369,4829997989937,4534496493617,6599529005105,6567071055921,7500663783678,6656646709297,6592825655345,4701026779185,7460322279678,6585594511409,6556990603313,6573110427697,4824920293425,6657232240689,4707605282865,7472871473406,6659185475633,7460344234238,7553281294590,6537208430641,6591888261169,7651156132094,6609061183537,4835183788081,6546055200817,7557236424958,7476658077950,6656828571697,6660311089201,7555161260286,6583109582897,4633214615601,4752781148209,4758648815665,6658013003825,4836007903281,6564455350321,7528448688382,6538534518833,6612874854449,6544233070641,4787844579377,7600696033534,7600696131838,6660318691377,6613229862961,6599565213745,4704293748785,6549996208177,6559862226993,6660433215537,7506827116798,6592337346609,7555355443454,4824927633457,6536129642545,6559118393393,6613218754609,6633803907121,7517595107582,7474908168446,6549270921265,4835293036593,6663812939825,7460214440190,7544435867902,6622715084849,4795592409137,7515620606206,6613226881073,7526681018622,6656757268529,6591888523313,6624236503089,4835929817137,6585288654897,6552645533745,7544416010494,6629966315569,6552680267825,4785484300337,6549996240945,6631222771761,4765624303665,6660048420913,6536012890161,6606621999153,6537218195505,6662101598257,4821900722225,4821920809009,6564800757809,6626428747825,7553470923006,7553474953470,4824928944177,4802006614065,7475853656318,6536012955697,6657902510129,6663783514161,6592361889841,7541067219198,6564383817777,7522047656190,6608794746929,6656694779953,6613225865265,6614702522417,6660313317425,4804928995377,6592336822321,6622713249841,7560162181374,6537204334641,6633807249457,7578177372414,7575209869566,6585256214577,7569409114366,6537241231409,7553464926462,4745571663921,6608802611249,7507007275262,6638038384689,6556161015857,4806192791601,7527706001662,7506833441022,7506834718974,7526752911614,4796008366129,6544163864625,6568213577777,6536437760049,6536437792817,6564474847281,6564470456369,4756703248433,6626288762929,6536436645937,6536435892273,6625223901233,6536437006385,6564473045041,6564470423601,6564468359217,6564468129841,6612933345329,7541001486590,7460203659518,7521607090430,6566407700529,6536178761777,6583100276785,6630339969073,6606931263537,6664216018993,6587881127985,4810075045937,6595690070065,6657930854449,6660313350193,7575047504126,4801989869617,6537243721777,6662101729329,7517571678462,6656817102897,7527717208318,7527717535998,7553475051774,6537212067889,6663810809905,6663810875441,4822657794097,6536169816113,7549793501438,6637231145009,6570337599537,6662101663793,6663790657585,4799238570033,6585489719345,6626626175025,4827870986289,4793778012209,7517572432126,6592839090225,6663801372721,7541221589246,6537205317681,6605961494577,6592330104881,6582224158769,4801837269041,6661112168497,6536121090097,6592331120689,7461284479230,7526414909694,6657555726385,7635239403774,6660484595761,7507024118014,6608804970545,6608828792881,6542671773745,4802006712369,6598569066545,6560884949041,6660512514097,6656838959153,6659096150065,7551435145470,7551435342078,6663781187633,4830314201137,7472872423678,7504383705342,6573097287729,6663903510577,4807499677745,6593024426033,6570818666545,6662193315889,7521852522750,6613228257329,6613230288945,6608644931633,6538535764017,7476670234878,6586331201585,6606621868081,6662101073969,6633411215409,6660446945329,6605965852721,7569368088830,6564794007601,6663875657777,7459901636862,6605533675569,4825507954737,6608804020273,6539181359153,7523510616318,6592360775729,4787842121777,7555143696638,6586843267121,7551335170302,7549734748414,4797700505649,6564454170673,6656829653041,6599594770481,6559554928689,7522474262782,6570337468465,7540984905982,6633410854961,6633813278769,6633803776049,6661044666417,6660439244849,7578177274110,6659476062257,6657232207921,6572611764273,7528285405438,6596282286129,6605482557489,6555006140465,6605557039153,7540985463038,4807046529073,7527717732606,4692352237617,6619947171889,7569377132798,6538871636017,6586860601393,6664242233393,6605463453745,4796769468465,6564823859249,6627021586481,6656795246641,6559012257841,7459903045886,6596668719153,7506892554494,6657902805041,7555294593278,6660877418545,4821844754481,6663634780209,7507607519486,6553640828977,6559551914033,6570338353201,4634584023089,4693367881777,7527702298878,4534358540337,4704129122353,4826025590833,4822646915121,7551335956734,6564454236209];
				// 	    Log::info('count is this -> '.count($prevImpArr));
					    
				// 	    $product_ids = $shopifyStore->products()->whereIn('shopify_product_id',$prevImpArr)->pluck('id');
				// 	}
             
             /////////////////////////////////////////////////////////////////////////////////////////////////

            
            Log::info("product countttt  ".count($product_ids));
            
			$remaining_limit = $products_limit - $published;

			if($remaining_limit <= 0){
				return response()->json(['status' => 'error','msg' => "This operation is not allowed due to the maximum credits limit reached. Please upgrade your plan."],406);
			}
			else if(count($product_ids) > $remaining_limit){
				return response()->json(['status' => 'error','msg' => "You don't have enough credits to publish all ".count($product_ids)." products. Please upgrade your plan."],406);
			}			

			// PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
			// $shopifyClient = new PHPShopify\ShopifySDK;

			$config = array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version'));
			$shopifyClient = new PHPShopify\ShopifySDK($config);


			$account = $shopifyStore->ebayAccounts()->where('is_valid',1)->first();
			if(!$account) return response()->json(['status' => 'error','msg' => "invalid ebay account keys"],406);
			
			$profile_id = $request->input("profile_id");
			

			$profile = $shopifyStore->profiles()->with('category1')->find($profile_id);
			if(!$profile) return response()->json(['status' => 'error','msg' => "profile not found"],406);
			if(!$profile->category1) return response()->json(['status' => 'error','msg' => "profile category not updated"],406);
			
			 
			if($product_ids){
      
				$site_id = (isset($account->siteid)) ? $account->siteid : 0;

				$ebay_environment = config('ebay.environment');
				$ebayCredentials = array(
					'credentials' => [
						'devId' => config('ebay.'.$ebay_environment.'devid'),
						'appId' => config('ebay.'.$ebay_environment.'appid'),
						'certId' => config('ebay.'.$ebay_environment.'certid'),
					],
					'authToken' => '',
					'oauthUserToken' => '',
					'ruName' => config('ebay.'.$ebay_environment.'RuName')
				);

				$ebayService = new Services\TradingService([
					'credentials' => $ebayCredentials['credentials'],
					'sandbox' => ($ebay_environment == "sandbox" ) ? true : false,
					'siteId' => $site_id
				]);

				$listingController = new ListingController();

				foreach($product_ids as $product_id){
				      Log::info("importing the product ".$product_id);
					$product = $shopifyStore->products()->with('variants')->find($product_id);

					if(!$product) continue;
					else if($product->listing_id){
					    
						$listing = $shopifyStore->listings()->find($product->listing_id);
						if($listing) continue;
					}

					$shProduct = json_decode($product->shopify_product_data,true);
			        $json=	$product->shopify_product_data ;
			         
			        
			         $data=json_decode($json, true);

                      $options = $data['options'];

                     foreach ($options as &$option) {
                      if ($option['name'] === 'Style') {
                      $option['name'] = 'newstyle';
                         break; // Assuming there is only one 'Style' option
                      }
                      elseif ($option['name'] === 'Quantity') {
                      $option['name'] = 'newQuantity';
                         break; // Assuming there is only one 'Style' option
                      }
                      }
                      $data['options'] = $options;
                     
                       $newJson = json_encode($data);
                      Log::info('Here is the product details');
                      Log::info($newJson);
                     $product-> where('id',$product_id)->update(['shopify_product_data' => $newJson]);
                        Log::info("updated product");
				//	$ebayResponse = $listingController->verifyEbayItem($product_id,$profile_id,$account,$shopifyStore);
			
				if($shopifyStore->user_id == 1128){
				    log::info("hellloooooooooooooooooooooooooooooooooo1231444".$shopifyStore->user_id);
				    		$ebayResponse = $listingController->test1verifyebayitem($product_id,$profile_id,$account,$shopifyStore);
                            	log::info("the verify reponse is ".json_encode($ebayResponse));
					//$ebayResponse = $listingController->verifyEbayItemTest($product_id,$profile_id,$account,$shopifyStore);
					
					if(!$ebayResponse) return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify, please try again"],406);
					else if(isset($ebayResponse->Errors)){
						file_put_contents("ebay_errors.json",json_encode($ebayResponse->toArray()));

						$ebayResponse = $ebayResponse->toArray();

						$ebayResponse2 = $ebayResponse;
                        $shErrMsgs="";
						$shErrMsg = "";
						$longErrMsg = "";
						foreach($ebayResponse["Errors"] as $erk => $ebError){
							if($ebError["SeverityCode"] != "Warning"){
								$longErrMsg .= $ebError["LongMessage"];
								$shErrMsgs .= $ebError["ShortMessage"];
							$shErrMsg = str_replace(['<', '>','.'], '', $shErrMsgs);
								Log::info(" hoooooooooooooooaoaoaoaoaoaoaoao ".str_replace(['<', '>','.'], '', $longErrMsg) );
							}
							else if($ebError["SeverityCode"] == "Warning"){
								unset($ebayResponse2["Errors"][$erk]);
							}
						}

						$ebayResponse = $ebayResponse2;

						if($longErrMsg){
							$ebayResponse["Errors"][] = [
								"ShortMessage" => $shErrMsg,
								"LongMessage" => $longErrMsg
							];

							return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify.", 'errors' => $ebayResponse],406);
						}
					}
					else if($ebayResponse && is_array($ebayResponse) && isset($ebayResponse["error"])){
						return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify.", 'errors' => ["Errors" => ["LongMessage" => $ebayResponse["error"]]]],406);
					}
					

                  //	return response()->json(['status' => 'success','msg' => "success"]);

                   
				}
				

				// 	$description = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>',$shProduct["body_html"]);
				// 	$description = trim(preg_replace('/\s\s+/','',strip_tags($description,'<p><br>')));
				// 	$description = str_replace("\n","",$description);
				// 	$description = str_replace('\n',"",$description);
				// 	$description = str_replace('<p> </p>',"",$description);
				// 	$description = str_replace('<p></p>',"",$description);

					
				}

				foreach($product_ids as $product_id){
					$jobData = array();
					$jobData["product_id"] = (int) $product_id;
					$jobData["profile_id"] = ($profile_id) ? $profile_id : null;
					$jobData["account_id"] = $account->id;
					$jobData["store_id"] = $shopifyStore->id;
					$jobData["user_id"] = $shopifyStore->user_id;
					 Log::info("adding  the product to publish queue for user ". $shopifyStore->user_id. " and " .$product_id);
					PublishProduct::dispatchNow($jobData);
				}
			}
			return response()->json(['status' => 'success','msg' => 'request submitted successfully'],200);
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}
	
	public function BulkPublishUnpublished(Request $request){
		    
	        Log::info("In Bulk publish Unpublish method ");
	        
	        Log::info($request);
	    	$shopifyStore = AppHelper::getShopifyStore($request);
	    if($shopifyStore){
			$validationRules = [
		
				'profile_id' => 'required|numeric'
			];
			$validator = Validator::make($request->all(),$validationRules);
			if($validator->fails()){
				return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
			}
       
			$planFeatures = json_decode($shopifyStore->plan->features,true);
			$published = $shopifyStore->products()->where("status","published")->count();
			$products_limit = (isset($planFeatures["credits"])) ? (int) $planFeatures["credits"] : 10;
               Log::info("product limit".$products_limit);
               
            
          //   $product_ids = $shopifyStore->products()->where('status','unpublished')->pluck('id');
            // $product_ids = $shopifyStore->products()->where('status', 'unpublished')->pluck('id');

             
                /////////////////////////////////////////////////////////////////////////////////////////////
             $product_ids = array();
             $products = $shopifyStore->products()->with('variantsCount')->where('status', 'unpublished')->get();
				foreach($products as $product){
				
					if($product->variantsCount && $product->variantsCount->quantity > 0 ){
						$product_ids[] = $product->id;
					
					}else{
						continue;
					}
					 
				
				}
             ////////////////////////////////////////////////////////////////////////////////////////////

              Log::info("product idss".json_encode($product_ids));
             
			$remaining_limit = $products_limit - $published;

			if($remaining_limit <= 0){
				return response()->json(['status' => 'error','msg' => "This operation is not allowed due to the maximum credits limit reached. Please upgrade your plan."],406);
			}
			else if(count($product_ids) > $remaining_limit){
				return response()->json(['status' => 'error','msg' => "You don't have enough credits to publish all ".count($product_ids)." products. Please upgrade your plan."],406);
			}			

			// PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
			// $shopifyClient = new PHPShopify\ShopifySDK;

			$config = array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version'));
			$shopifyClient = new PHPShopify\ShopifySDK($config);


			$account = $shopifyStore->ebayAccounts()->where('is_valid',1)->first();
			if(!$account) return response()->json(['status' => 'error','msg' => "invalid ebay account keys"],406);
			
			$profile_id = $request->input("profile_id");
			

			$profile = $shopifyStore->profiles()->with('category1')->find($profile_id);
			if(!$profile) return response()->json(['status' => 'error','msg' => "profile not found"],406);
			if(!$profile->category1) return response()->json(['status' => 'error','msg' => "profile category not updated"],406);
			
			 
			if($product_ids){
      
				$site_id = (isset($account->siteid)) ? $account->siteid : 0;

				$ebay_environment = config('ebay.environment');
				$ebayCredentials = array(
					'credentials' => [
						'devId' => config('ebay.'.$ebay_environment.'devid'),
						'appId' => config('ebay.'.$ebay_environment.'appid'),
						'certId' => config('ebay.'.$ebay_environment.'certid'),
					],
					'authToken' => '',
					'oauthUserToken' => '',
					'ruName' => config('ebay.'.$ebay_environment.'RuName')
				);

				$ebayService = new Services\TradingService([
					'credentials' => $ebayCredentials['credentials'],
					'sandbox' => ($ebay_environment == "sandbox" ) ? true : false,
					'siteId' => $site_id
				]);

				$listingController = new ListingController();

				foreach($product_ids as $product_id){
				      Log::info("importing the product ".$product_id);
					$product = $shopifyStore->products()->with('variants')->find($product_id);

					if(!$product) continue;
					else if($product->listing_id){
					    
						$listing = $shopifyStore->listings()->find($product->listing_id);
						if($listing) continue;
					}

					$shProduct = json_decode($product->shopify_product_data,true);
			        $json=	$product->shopify_product_data ;
			         
			        
			         $data=json_decode($json, true);

                      $options = $data['options'];

                     foreach ($options as &$option) {
                      if ($option['name'] === 'Style') {
                      $option['name'] = 'newstyle';
                         break; // Assuming there is only one 'Style' option
                      }
                      elseif ($option['name'] === 'Quantity') {
                      $option['name'] = 'newQuantity';
                         break; // Assuming there is only one 'Style' option
                      }
                      }
                      $data['options'] = $options;

                       $newJson = json_encode($data);
                      Log::info('Here is the product details');
                      Log::info($newJson);
                     $product-> where('id',$product_id)->update(['shopify_product_data' => $newJson]);
                        Log::info("updated product");
				//	$ebayResponse = $listingController->verifyEbayItem($product_id,$profile_id,$account,$shopifyStore);
			
				if($shopifyStore->user_id == 1128){
				    log::info("hellloooooooooooooooooooooooooooooooooo1231444".$shopifyStore->user_id);
				    		$ebayResponse = $listingController->test1verifyebayitem($product_id,$profile_id,$account,$shopifyStore);
                            	log::info("the verify reponse is ".json_encode($ebayResponse));
					//$ebayResponse = $listingController->verifyEbayItemTest($product_id,$profile_id,$account,$shopifyStore);
					
					if(!$ebayResponse) return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify, please try again"],406);
					else if(isset($ebayResponse->Errors)){

						file_put_contents("ebay_errors.json",json_encode($ebayResponse->toArray()));

						$ebayResponse = $ebayResponse->toArray();

						$ebayResponse2 = $ebayResponse;
                        $shErrMsgs="";
						$shErrMsg = "";
						$longErrMsg = "";
						foreach($ebayResponse["Errors"] as $erk => $ebError){
							if($ebError["SeverityCode"] != "Warning"){
								$longErrMsg .= $ebError["LongMessage"];
								$shErrMsgs .= $ebError["ShortMessage"];
							$shErrMsg = str_replace(['<', '>','.'], '', $shErrMsgs);
								Log::info(" Hoooooooooooooooaoaoaoaoaoaoaoaoaoaoaoaoao ".str_replace(['<', '>','.'], '', $longErrMsg) );
							}
							else if($ebError["SeverityCode"] == "Warning"){
								unset($ebayResponse2["Errors"][$erk]);
							}
						}

						$ebayResponse = $ebayResponse2;

						if($longErrMsg){
							$ebayResponse["Errors"][] = [
								"ShortMessage" => $shErrMsg,
								"LongMessage" => $longErrMsg
							];

							return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify.", 'errors' => $ebayResponse],406);
						}
					}
					else if($ebayResponse && is_array($ebayResponse) && isset($ebayResponse["error"])){
						return response()->json(['status' => 'error','msg' => $product->title."'s failed to verify.", 'errors' => ["Errors" => ["LongMessage" => $ebayResponse["error"]]]],406);
					}
					
                  //	return response()->json(['status' => 'success','msg' => "success"]);

				}
				
				// 	$description = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>',$shProduct["body_html"]);
				// 	$description = trim(preg_replace('/\s\s+/','',strip_tags($description,'<p><br>')));
				// 	$description = str_replace("\n","",$description);
				// 	$description = str_replace('\n',"",$description);
				// 	$description = str_replace('<p> </p>',"",$description);
				// 	$description = str_replace('<p></p>',"",$description);
					
				}

				foreach($product_ids as $product_id){
					$jobData = array();
					$jobData["product_id"] = (int) $product_id;
					$jobData["profile_id"] = ($profile_id) ? $profile_id : null;
					$jobData["account_id"] = $account->id;
					$jobData["store_id"] = $shopifyStore->id;
					$jobData["user_id"] = $shopifyStore->user_id;
					Log::info("adding  the product to publish queue for user ". $shopifyStore->user_id. " and " .$product_id);
					PublishProduct::dispatchNow($jobData);
				}
			}
			return response()->json(['status' => 'success','msg' => 'request submitted successfully'],200);
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

    public function deletefromebay($product_id,$shopifyStore){
    Log::info("Webhook: Entered in deletefromebay method in delete Webhook Shopify");
		$errors = array();
		try{
			$product = $shopifyStore->products()->with('variants')->find($product_id);
			if($product && $product->listing_id){
			     Log::info("Webhook: product found in deletefromebay method in delete Webhook Shopify for listing id".$product->listing_id);
				$listing_id = $product->listing_id;
				$listing = $shopifyStore->listings()->with('variants')->find($listing_id);

				if($listing && $listing->product_id){
					
					foreach($listing->variants as $variant){
					     Log::info("Webhook: variant found in deletefromebay method in delete Webhook Shopify for listing id".$listing->product_id);
						$pvariant = $product->variants()->with('listingVariant')->where("shopify_variant_id",$variant["id"])->first();
						
						if($pvariant && $pvariant->listingVariant){
							$ebayAccount = $shopifyStore->ebayAccounts()->where("is_valid",1)->find($pvariant->listingVariant->account_id);
							if($ebayAccount){

						$variant = $shopifyStore->variants()->find($pvariant->id);
						$pendingInventory = $shopifyStore->pendingInventoryUpdate()->where('store_id',$shopifyStore->id)->where('account_id',$pvariant->listingVariant->account_id)->where('listing_variant_id',$variant->listing_variant_id)->where(function($query){
							$query->where('processing','!=','1')->orWhereNull('processing');
						})->first();
						if($pendingInventory){
							Log::info("Webhook:pending inventory found in deletefromebay method in delete Webhook Shopify for this shopify store".$shopifyStore->id);
							if($pendingInventory->quantity != 0){
								$pendingInventory->quantity = 0;
								$pendingInventory->save();
								Log::info("Webhook:new quantity updated in pending inventory in deletefromebay method in delete Webhook Shopify for this shopify store".$shopifyStore->id);
							}
						}

						else{
							Log::info("Webhook:pending inventory not found in deletefromebay method in delete Webhook Shopify for this shopify store".$shopifyStore->id);
							$pInvData = array();
							$pInvData["quantity"] = 0;
							$pInvData["sku"] = $pvariant->listingVariant->sku;
							$pInvData["ebay_item_id"] = $pvariant->listingVariant->ebay_item_id;
							$pInvData["source"] = "update_product";
							$pInvData["variant_id"] =  $pvariant->id;
							$pInvData["listing_variant_id"] = $variant->listing_variant_id;
							$pInvData["account_id"] = $pvariant->listingVariant->account_id;
							$pInvData["store_id"] = $shopifyStore->id;
							$pInvData["user_id"] = $shopifyStore->user_id;
							$shopifyStore->pendingInventoryUpdate()->create($pInvData);
							Log::info("Webhook:new quantity created in pending inventory in deletefromebay method in delete Webhook Shopify for this shopify store".$shopifyStore->id);

						}
						
					    }
				     }
					 $variant->variant_id = NULL;
						if($variant->custom_sku) $variant->custom_sku = NULL;
						$variant->save();
				}
				$listing->product_id = NULL;
					$listing->save();
			}
			$listing->product_id = NULL;
					$listing->save();


			





			// if($product){
			// 	try{
			// 		PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
			// 		$shopifyClient = new PHPShopify\ShopifySDK;

			// 		$shopifyClient->Product($product->shopify_product_id)->delete();
			// 		$product->delete();
			// 	}
			// 	catch(\Exception $e){
			// 		report($e);
			// 		$errors[] = $e->getMessage();
			// 	}
			// }
		}
	}
		catch(\Exception $e){
			report($e);
			$errors[] = $e->getMessage();
		}
		return $errors;
	}

}
