<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Helpers\AppHelper;
use App\ShopifyStore;

class PublishProduct implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $store_id,$user_id,$account_id,$profile_id,$product_id;

    public $timeout = 0;
    public $tries = 100;
   
    public function __construct($data){
        $this->store_id = $data["store_id"];
        $this->user_id = $data["user_id"];
        $this->account_id = $data["account_id"];
        $this->profile_id = $data["profile_id"];
        $this->product_id = $data["product_id"];
    }
    
    public function handle(){
        //$cronJob = AppHelper::getCronJob("publish_products");
        //if(!$cronJob || $cronJob->flag == 1 || $cronJob->do_stop == 1) die();
        //AppHelper::updateCronJob($cronJob->type,1);

        $errors = array();
        try{
            $shopifyStore = ShopifyStore::where('status',"active")->find($this->store_id);
            if($shopifyStore){
				$shopify_store_id = $shopifyStore->id;
				$store_database_name = config('config.store_db_prefix').$shopify_store_id;
                AppHelper::setConnection($store_database_name,$shopifyStore);

                $ebayAccount = $shopifyStore->ebayAccounts()->where('is_valid',1)->find($this->account_id);
                $product = $shopifyStore->products()->with('profile')->with('listing')->find($this->product_id);
                $profile = ($this->profile_id) ? $shopifyStore->profiles()->find($this->profile_id) : $shopifyStore->profiles()->where('is_default_profile',1)->first();
                
                if($ebayAccount && $product && $profile){
                    $pendingProduct = $shopifyStore->pendingProductPublish()->where('account_id',$ebayAccount->id)->where('product_id',$product->id)->where(function($query){
                        $query->where('processing','!=','1')->orWhereNull('processing');
                    })->first();
                    if($pendingProduct){
                        if($pendingProduct->profile_id != $profile->id){
                            $pendingProduct->profile_id = $profile->id;
                            $pendingProduct->save();

                            $product->profile_id = ($this->profile_id) ? $this->profile_id : NULL;
                            $product->save();
                        }
                    }
                    else{
                        $pProData = array();
                        $pProData["profile_id"] = $profile->id;
                        $pProData["product_id"] = $product->id;
                        $pProData["account_id"] = $ebayAccount->id;
                        $pProData["store_id"] = $shopifyStore->id;
                        $pProData["user_id"] = $shopifyStore->user_id;
                        $shopifyStore->pendingProductPublish()->create($pProData);

                        $product->profile_id = ($this->profile_id) ? $this->profile_id : NULL;
                        $product->submit = 1;
                        $product->save();
                    }
                }
                else{
                    $output_data = array();
                    if(!$ebayAccount) $output_data["errors"] = array("invalid ebay account");
                    else if(!$product) $output_data["errors"] = array("product not found");
                    else if(!$profile) $output_data["errors"] = array("profile not found");
					$logData = array();
					$logData["log_type"] = "publish_product";
					$logData["input_data"] = $this->product_id;
					$logData["log_data_id"] = $this->account_id;
					$logData["status"] = "error";
					$logData["output_data"] = json_encode($output_data,JSON_INVALID_UTF8_IGNORE);
					$logData["remarks"] = $output_data["errors"][0];
					$logData["store_id"] = $shopifyStore->id;
					$logData["user_id"] = $shopifyStore->user_id;
					$shopifyStore->logs()->create($logData);
                }              
            }
        }
        catch(\Exception $e){
            report($e);
            $errors[] = $e->getMessage();
        }

        if($errors) file_put_contents("publishProduct_".$this->store_id."_".$this->product_id.".json",json_encode($errors));

        //AppHelper::updateCronJob($cronJob->type,0);
    }
}
