<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class Listing extends Model
{
	protected $table = 'listings';
	protected $connection = 'tenants';

	public function account(){
		return $this->belongsTo('App\EbayAccount','account_id','id');
	}
	
	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}

	public function product(){
		return $this->belongsTo('App\Product','product_id','id');
	}

	public function variants(){
		return $this->hasMany('App\ListingVariant','listing_id','id');
	}
    
  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	protected $fillable = [
		'title','image','status','ebay_item_id','sku','listing_url','listing_data','additional_data','last_synced_at','last_synced_response','last_inventory_synced_at','last_pricing_synced_at','last_order_at','product_id','account_id','store_id','user_id'
  	];
}
