<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class PendingPriceUpdate extends Model
{
	protected $table = 'pending_price_update';
	protected $connection = 'mysql';

	/*
	public function __construct(){
		$this->connection = config('config.default_connection');
	}
	*/

	public function variant(){
		return $this->hasOne('App\ProductVariant','id','variant_id');
	}

	public function listingVariant(){
		return $this->hasOne('App\ListingVariant','id','listing_variant_id');
	}

	public function account(){
		return $this->belongsTo('App\ebayAccount','account_id','id');
	}

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}
    
  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	protected $fillable = [
		'price','compare_at_price','sku','ebay_item_id','processing','listing_variant_id','variant_id','source','account_id','store_id','user_id'
  	];
}
