<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class Product extends Model
{
	protected $table = 'products';
	protected $connection = 'tenants';


	public function variants(){
		return $this->hasMany('App\ProductVariant','product_id','id');
	}

	public function productData(){
		return $this->hasMany('App\ProductData','product_id','id');
	}

	public function variantsCount(){
		return $this->hasOne('App\ProductVariant','product_id','id')->selectRaw('product_id, count(*) as no_of_variants, sum(quantity) as quantity')->groupBy('product_id');
	}

	public function profile(){
		return $this->hasOne('App\Profile','id','profile_id');
	}

	public function listing(){
		return $this->belongsTo('App\Listing','listing_id','id');
	}

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}
    
  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	public function pendingProductPublish(){
		return $this->hasMany('App\PendingProductPublish','product_id','id');
	}

	protected $fillable = [
		'title','image','status','shopify_product_id','shopify_product_handle','shopify_product_type','shopify_product_data','offer_only','submit','listing_id','profile_id','store_id','user_id'
  	];
}
