<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class ProductData extends Model
{
	protected $table = 'product_data';
	protected $connection = 'tenants';


	public function product(){
		return $this->belongsTo('App\Product','product_id','id');
	}

	public function profile(){
		return $this->belongsTo('App\Profile','profile_id','id');
	}

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}
    
  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	protected $fillable = [
		'title',
		'sub_title',
		'condition',
		'condition_note',
		'item_specific_values',
		'shopify_product_id',
		'shopify_product_handle',
		'product_id',
		'profile_id',
		'store_id',
		'user_id'
  	];
}
