<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePendingInventoryUpdateTable extends Migration
{
    public function up(){
        Schema::create('pending_inventory_update',function(Blueprint $table){
            $table->bigIncrements('id');
            $table->integer('quantity');
            $table->string('sku');
            $table->string('ebay_item_id');
            $table->string('source')->nullable()->default(NULL);
            $table->tinyInteger('processing')->nullable()->default(NULL);
            $table->unsignedBigInteger('variant_id');
            $table->unsignedBigInteger('listing_variant_id');
            $table->unsignedInteger('account_id');
            $table->foreign('account_id')->references('id')->on('ebay_accounts')->onDelete('cascade');
            $table->unsignedBigInteger('store_id');
            $table->foreign('store_id')->references('id')->on('shopify_stores')->onDelete('cascade');
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }
    
    public function down(){
        Schema::dropIfExists('pending_inventory_update');
    }
}
