<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateTemplatesTable extends Migration
{
    public function up()
    {
        if(!Schema::connection('tenants')->hasTable('templates')){
            Schema::connection('tenants')->create('templates',function(Blueprint $table){
                $table->increments('id');
                $table->string('name');
                $table->longText('template_data');
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down(){
        Schema::connection('tenants')->dropIfExists('templates');
    }
}
