<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductVariantsTable extends Migration
{
    public function up(){
        if(!Schema::connection('tenants')->hasTable('product_variants')){
            Schema::connection('tenants')->create('product_variants',function(Blueprint $table){
                $table->bigIncrements('id');
                $table->string('title',500)->nullable()->default(NULL);
                $table->string('sku');
                $table->string('image',500)->nullable()->default(NULL);
                $table->string('product_id_val')->nullable()->default(NULL);
                $table->string('asin',100)->nullable()->default(NULL);
                $table->integer('quantity')->nullable()->default(NULL);
                $table->double('price')->nullable()->default(NULL);
                $table->double('compare_at_price')->nullable()->default(NULL);
                $table->unsignedBigInteger('shopify_variant_id');
                $table->unsignedBigInteger('shopify_inventory_item_id');
                $table->unsignedBigInteger('shopify_product_id');
                $table->string('shopify_product_handle',500);
                $table->longText('shopify_variant_data')->nullable()->default(NULL);
                $table->timestamp('last_inventory_synced_at')->nullable()->default(NULL);
                $table->integer('last_inventory_synced')->nullable()->default(NULL);
                $table->timestamp('last_pricing_synced_at')->nullable()->default(NULL);
                $table->double('last_price_synced')->nullable()->default(NULL);
                $table->timestamp('last_order_at')->nullable()->default(NULL);
                $table->string('last_order_id',255)->nullable()->default(NULL);
                $table->tinyInteger('inventory_sync')->nullable()->default(NULL);
                $table->tinyInteger('price_sync')->nullable()->default(NULL);
                $table->unsignedBigInteger('listing_variant_id')->nullable()->default(NULL);
                $table->foreign('listing_variant_id')->references('id')->on('listing_variants')->onDelete('set null');
                $table->unsignedBigInteger('product_id');
                $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down(){
        Schema::connection('tenants')->dropIfExists('product_variants');
    }
}
