<?php
/**
 * DO NOT EDIT THIS FILE!
 *
 * This file was automatically generated from external sources.
 *
 * Any manual change here will be lost the next time the SDK
 * is updated. You've been warned!
 */

namespace DTS\eBaySDK\Order\Services;

class OrderService extends \DTS\eBaySDK\Order\Services\OrderBaseService
{
    const API_VERSION = 'v1';

    /**
     * @property array $operations Associative array of operations provided by the service.
     */
    protected static $operations = [
        'GetCheckoutSession' => [
            'method' => 'GET',
            'resource' => 'checkout_session/{checkoutSessionId}',
            'responseClass' => '\DTS\eBaySDK\Order\Types\GetCheckoutSessionRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'InitiateCheckoutSession' => [
            'method' => 'POST',
            'resource' => 'checkout_session/initiate',
            'responseClass' => '\DTS\eBaySDK\Order\Types\InitiateCheckoutSessionRestResponse',
            'params' => [
            ]
        ],
        'PlaceOrder' => [
            'method' => 'POST',
            'resource' => 'checkout_session/{checkoutSessionId}/place_order',
            'responseClass' => '\DTS\eBaySDK\Order\Types\PlaceOrderRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UpdatePaymentInfo' => [
            'method' => 'POST',
            'resource' => 'checkout_session/{checkoutSessionId}/update_payment_info',
            'responseClass' => '\DTS\eBaySDK\Order\Types\UpdatePaymentInfoRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UpdateQuantityForLineItem' => [
            'method' => 'POST',
            'resource' => 'checkout_session/{checkoutSessionId}/update_quantity',
            'responseClass' => '\DTS\eBaySDK\Order\Types\UpdateQuantityForLineItemRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UpdateShippingAddress' => [
            'method' => 'POST',
            'resource' => '_session/{checkoutSessionId}/update_shipping_address',
            'responseClass' => '\DTS\eBaySDK\Order\Types\UpdateShippingAddressRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UpdateShippingOption' => [
            'method' => 'POST',
            'resource' => 'checkout_session/{checkoutSessionId}/update_shipping_option',
            'responseClass' => '\DTS\eBaySDK\Order\Types\UpdateShippingOptionRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetGuestCheckoutSession' => [
            'method' => 'GET',
            'resource' => 'guest_checkout_session/{checkoutSessionId}',
            'responseClass' => '\DTS\eBaySDK\Order\Types\GetGuestCheckoutSessionRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'InitiateGuestCheckoutSession' => [
            'method' => 'POST',
            'resource' => 'guest_checkout_session/initiate',
            'responseClass' => '\DTS\eBaySDK\Order\Types\InitiateGuestCheckoutSessionRestResponse',
            'params' => [
            ]
        ],
        'PlaceGuestOrder' => [
            'method' => 'POST',
            'resource' => 'guest_checkout_session/{checkoutSessionId}/place_order',
            'responseClass' => '\DTS\eBaySDK\Order\Types\PlaceGuestOrderRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UpdateGuestLineItemQuantity' => [
            'method' => 'POST',
            'resource' => 'guest_checkout_session/{checkoutSessionId}/update_quantity',
            'responseClass' => '\DTS\eBaySDK\Order\Types\UpdateGuestLineItemQuantityRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UpdateGuestLineItemShippingAddress' => [
            'method' => 'POST',
            'resource' => 'guest_checkout_session/{checkoutSessionId}/update_shipping_address',
            'responseClass' => '\DTS\eBaySDK\Order\Types\UpdateGuestLineItemShippingAddressRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UpdateGuestPaymentInfo' => [
            'method' => 'POST',
            'resource' => 'guest_checkout_session/{checkoutSessionId}/update_payment_info',
            'responseClass' => '\DTS\eBaySDK\Order\Types\UpdateGuestPaymentInfoRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UpdateGuestShippingOption' => [
            'method' => 'POST',
            'resource' => 'guest_checkout_session/{checkoutSessionId}/update_shipping_option',
            'responseClass' => '\DTS\eBaySDK\Order\Types\UpdateGuestShippingOptionRestResponse',
            'params' => [
                'checkoutSessionId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetGuestPurchaseOrder' => [
            'method' => 'GET',
            'resource' => 'guest_purchase_order/{purchaseOrderId}',
            'responseClass' => '\DTS\eBaySDK\Order\Types\GetGuestPurchaseOrderRestResponse',
            'params' => [
                'purchaseOrderId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetPurchaseOrder' => [
            'method' => 'GET',
            'resource' => 'purchase_order/{purchaseOrderId}',
            'responseClass' => '\DTS\eBaySDK\Order\Types\GetPurchaseOrderRestResponse',
            'params' => [
                'purchaseOrderId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ]
    ];

    /**
     * @param array $config Configuration option values.
     */
    public function __construct(array $config = [])
    {
        parent::__construct($config);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\GetCheckoutSessionRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\GetCheckoutSessionRestResponse
     */
    public function getCheckoutSession(\DTS\eBaySDK\Order\Types\GetCheckoutSessionRestRequest $request)
    {
        return $this->getCheckoutSessionAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\GetCheckoutSessionRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCheckoutSessionAsync(\DTS\eBaySDK\Order\Types\GetCheckoutSessionRestRequest $request)
    {
        return $this->callOperationAsync('GetCheckoutSession', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\InitiateCheckoutSessionRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\InitiateCheckoutSessionRestResponse
     */
    public function initiateCheckoutSession(\DTS\eBaySDK\Order\Types\InitiateCheckoutSessionRestRequest $request)
    {
        return $this->initiateCheckoutSessionAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\InitiateCheckoutSessionRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function initiateCheckoutSessionAsync(\DTS\eBaySDK\Order\Types\InitiateCheckoutSessionRestRequest $request)
    {
        return $this->callOperationAsync('InitiateCheckoutSession', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\PlaceOrderRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\PlaceOrderRestResponse
     */
    public function placeOrder(\DTS\eBaySDK\Order\Types\PlaceOrderRestRequest $request)
    {
        return $this->placeOrderAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\PlaceOrderRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function placeOrderAsync(\DTS\eBaySDK\Order\Types\PlaceOrderRestRequest $request)
    {
        return $this->callOperationAsync('PlaceOrder', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdatePaymentInfoRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\UpdatePaymentInfoRestResponse
     */
    public function updatePaymentInfo(\DTS\eBaySDK\Order\Types\UpdatePaymentInfoRestRequest $request)
    {
        return $this->updatePaymentInfoAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdatePaymentInfoRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePaymentInfoAsync(\DTS\eBaySDK\Order\Types\UpdatePaymentInfoRestRequest $request)
    {
        return $this->callOperationAsync('UpdatePaymentInfo', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateQuantityForLineItemRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\UpdateQuantityForLineItemRestResponse
     */
    public function updateQuantityForLineItem(\DTS\eBaySDK\Order\Types\UpdateQuantityForLineItemRestRequest $request)
    {
        return $this->updateQuantityForLineItemAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateQuantityForLineItemRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateQuantityForLineItemAsync(\DTS\eBaySDK\Order\Types\UpdateQuantityForLineItemRestRequest $request)
    {
        return $this->callOperationAsync('UpdateQuantityForLineItem', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateShippingAddressRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\UpdateShippingAddressRestResponse
     */
    public function updateShippingAddress(\DTS\eBaySDK\Order\Types\UpdateShippingAddressRestRequest $request)
    {
        return $this->updateShippingAddressAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateShippingAddressRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShippingAddressAsync(\DTS\eBaySDK\Order\Types\UpdateShippingAddressRestRequest $request)
    {
        return $this->callOperationAsync('UpdateShippingAddress', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateShippingOptionRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\UpdateShippingOptionRestResponse
     */
    public function updateShippingOption(\DTS\eBaySDK\Order\Types\UpdateShippingOptionRestRequest $request)
    {
        return $this->updateShippingOptionAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateShippingOptionRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShippingOptionAsync(\DTS\eBaySDK\Order\Types\UpdateShippingOptionRestRequest $request)
    {
        return $this->callOperationAsync('UpdateShippingOption', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\GetGuestCheckoutSessionRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\GetGuestCheckoutSessionRestResponse
     */
    public function getGuestCheckoutSession(\DTS\eBaySDK\Order\Types\GetGuestCheckoutSessionRestRequest $request)
    {
        return $this->getGuestCheckoutSessionAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\GetGuestCheckoutSessionRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGuestCheckoutSessionAsync(\DTS\eBaySDK\Order\Types\GetGuestCheckoutSessionRestRequest $request)
    {
        return $this->callOperationAsync('GetGuestCheckoutSession', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\InitiateGuestCheckoutSessionRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\InitiateGuestCheckoutSessionRestResponse
     */
    public function initiateGuestCheckoutSession(\DTS\eBaySDK\Order\Types\InitiateGuestCheckoutSessionRestRequest $request)
    {
        return $this->initiateGuestCheckoutSessionAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\InitiateGuestCheckoutSessionRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function initiateGuestCheckoutSessionAsync(\DTS\eBaySDK\Order\Types\InitiateGuestCheckoutSessionRestRequest $request)
    {
        return $this->callOperationAsync('InitiateGuestCheckoutSession', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\PlaceGuestOrderRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\PlaceGuestOrderRestResponse
     */
    public function placeGuestOrder(\DTS\eBaySDK\Order\Types\PlaceGuestOrderRestRequest $request)
    {
        return $this->placeGuestOrderAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\PlaceGuestOrderRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function placeGuestOrderAsync(\DTS\eBaySDK\Order\Types\PlaceGuestOrderRestRequest $request)
    {
        return $this->callOperationAsync('PlaceGuestOrder', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateGuestLineItemQuantityRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\UpdateGuestLineItemQuantityRestResponse
     */
    public function updateGuestLineItemQuantity(\DTS\eBaySDK\Order\Types\UpdateGuestLineItemQuantityRestRequest $request)
    {
        return $this->updateGuestLineItemQuantityAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateGuestLineItemQuantityRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateGuestLineItemQuantityAsync(\DTS\eBaySDK\Order\Types\UpdateGuestLineItemQuantityRestRequest $request)
    {
        return $this->callOperationAsync('UpdateGuestLineItemQuantity', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateGuestLineItemShippingAddressRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\UpdateGuestLineItemShippingAddressRestResponse
     */
    public function updateGuestLineItemShippingAddress(\DTS\eBaySDK\Order\Types\UpdateGuestLineItemShippingAddressRestRequest $request)
    {
        return $this->updateGuestLineItemShippingAddressAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateGuestLineItemShippingAddressRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateGuestLineItemShippingAddressAsync(\DTS\eBaySDK\Order\Types\UpdateGuestLineItemShippingAddressRestRequest $request)
    {
        return $this->callOperationAsync('UpdateGuestLineItemShippingAddress', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateGuestPaymentInfoRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\UpdateGuestPaymentInfoRestResponse
     */
    public function updateGuestPaymentInfo(\DTS\eBaySDK\Order\Types\UpdateGuestPaymentInfoRestRequest $request)
    {
        return $this->updateGuestPaymentInfoAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateGuestPaymentInfoRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateGuestPaymentInfoAsync(\DTS\eBaySDK\Order\Types\UpdateGuestPaymentInfoRestRequest $request)
    {
        return $this->callOperationAsync('UpdateGuestPaymentInfo', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateGuestShippingOptionRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\UpdateGuestShippingOptionRestResponse
     */
    public function updateGuestShippingOption(\DTS\eBaySDK\Order\Types\UpdateGuestShippingOptionRestRequest $request)
    {
        return $this->updateGuestShippingOptionAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\UpdateGuestShippingOptionRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateGuestShippingOptionAsync(\DTS\eBaySDK\Order\Types\UpdateGuestShippingOptionRestRequest $request)
    {
        return $this->callOperationAsync('UpdateGuestShippingOption', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\GetGuestPurchaseOrderRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\GetGuestPurchaseOrderRestResponse
     */
    public function getGuestPurchaseOrder(\DTS\eBaySDK\Order\Types\GetGuestPurchaseOrderRestRequest $request)
    {
        return $this->getGuestPurchaseOrderAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\GetGuestPurchaseOrderRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGuestPurchaseOrderAsync(\DTS\eBaySDK\Order\Types\GetGuestPurchaseOrderRestRequest $request)
    {
        return $this->callOperationAsync('GetGuestPurchaseOrder', $request);
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\GetPurchaseOrderRestRequest $request
     * @return \DTS\eBaySDK\Order\Types\GetPurchaseOrderRestResponse
     */
    public function getPurchaseOrder(\DTS\eBaySDK\Order\Types\GetPurchaseOrderRestRequest $request)
    {
        return $this->getPurchaseOrderAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\Order\Types\GetPurchaseOrderRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseOrderAsync(\DTS\eBaySDK\Order\Types\GetPurchaseOrderRestRequest $request)
    {
        return $this->callOperationAsync('GetPurchaseOrder', $request);
    }
}
