import React, { Component } from 'react';
import { Button, Card, Form, FormLayout, Layout, Page, Stack, Checkbox, FooterHelp, Link, Banner, TextContainer,List } from '@shopify/polaris';

class AcceptTos extends Component{
  _isMounted = false;

  state = {
    terms_accepted:false
  };

  errors_data = {};

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;    
  }
  
  constructor(props){
    super(props);
    this.handleChange = this.handleChange.bind(this);
    this.acceptTos = this.acceptTos.bind(this);
  }

  acceptTos(){
    this.setState({
      button_loading:true,
      terms_accepted: this.state.terms_accepted,
      error_message:null
    });
    

    var hasError = false;
    if(this.state.terms_accepted === false){
      hasError = true;
      this.errors_data.terms_accepted_error = "You must accept the terms and conditions";
    }

    if(hasError === false){
      var request_data = {
        terms_accepted: this.state.terms_accepted,
        update_install_step: true,
        shopify_url:this.props.store_data.shopify_url
      };

      const requestOptions = {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(request_data)
      };
      fetch(this.props.api_url+'/accept_tos?api_token='+this.props.store_data.user.api_token,requestOptions)
      .then(response => response.json())
      .then((data) => {
        if(data && data.status && data.status === "success"){
          this.props.updateInstallStep(2);
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data && data.status && data.status === "error"){
            if(data.msg){
              error_message = data.msg;
            }
          }
          if(this._isMounted){
            this.setState({
              button_loading:false,
              error_message:error_message
            }); 
          }
        }
      })
      .catch(error => {
        console.error(error);
      });
    }
    else{
      this.setState({
        button_loading:false
      });
    }
  }

  handleChange = (field) => {
    return (value) => {
      if(value.length <= 0 || value === false){
        this.errors_data[field+"_error"] = "You must accept the terms and conditions";
      }
      else{
        this.errors_data[field+"_error"] = null;
      }
      this.setState({ [field]: value });
    }
  };

  render(){
    return (
      <Page title="App Setup - Step 1 of 4" >
        <Layout>
          <Layout.AnnotatedSection title="Accept our Terms and Conditions" description="Please read the points carefully and accept the terms.">
            {this.state.error_message &&
              <Banner title="Error" status="critical">
                <p>{this.state.error_message}</p>
              </Banner>
            }
            <Card sectioned>
              <TextContainer>
                
                <p>Effective date: August 1th, 2019</p>
                <p>The company <b>InfoShore Technology Solutions LLP</b>, with registered office at <b>IT 2002, IT ZONE, RAMCHANDRAPURA INDUS. AREA, SITAPURA, JAIPUR, Rajasthan (India)</b> (hereinafter referred to as <b>"we"</b> or <b>"us"</b>), in its capacity of data controller regarding the processing of Personal Data, is committed to protecting and respecting the privacy of its users, customers and suppliers, even prospective (hereinafter singularly and collectively referred to as the <b>"you"</b> or <b>"your"</b>), pursuant to the applicable national laws on data protection (hereinafter referred to as the <b>"National Law"</b>) and, if you are citizen of a Country in the European Economic Area, also pursuant to the European Regulation no. 679/2016 (hereinafter referred to as the "GDPR") (hereinafter the National Law and the <b>GDPR</b> will be referred to as the <b>"Applicable Law"</b>).</p>
                <p>This policy (hereinafter referred to as the "Privacy Policy") is aimed to inform you about our practices related to our collection and use of your Personal Data either through our website <b>www. skububble.com</b> (hereinafter referred to as the "Site") or during the performance of any of our service (hereinafter collectively referred to as the "Services").</p>
                <p><b>"Personal Data,"</b> in this instance, means any information relating to an identified or identifiable natural person; an identifiable natural person is one who can be identified, directly or indirectly, in particular by reference to an identifier such as a name, an identification number, location data, an online identifier or to one or more factors specific to the physical, physiological, genetic, mental, economic, cultural or social identity of that natural person.</p>
                <p>We invite you to read this Privacy Policy carefully to understand our considerations and practices regarding the processing of your Personal Data.</p>	
                <h3>Information Collected</h3>
                <p>Information is collected in various ways when you use our Site and services. The collected information might also be supplemented with information from other companies. The information collected is generally of two types (personal information or ‘Personal Data’ and aggregated data).</p>
                <p>As mentioned above, Personal Data is information which specifically identifies an individual (the user of this Site). This includes email address, name, demographics, and such.</p>
                <p>Take note, no personal information is included in our Aggregated data.</p>
                <p>Aggregated Data means the information collected about a certain group or category with the user identities being removed.</p>
                <p>We use the collected Aggregated Data to understand user trends, needs, demands, etc. to help improve the Site and tailor the user experience.</p>
                <p>According to this Policy, Aggregated Data is not limited or restricted. The information can be shared with third parties for various reasons. These reasons can include the purpose of improving the website, advertising, marketing, and for better addressing customer needs.</p>
                <p>The following are the specific types of information we collect from you.</p>
                <p><b>Information You Give Us.</b> We collect information provided by you when you use the Site to register and use Services (including using the Site as a Free Trial).</p>
                <p>The Examples include the following:</p>
                <ul>
                  <li><b>Registration and Profile Information.</b> Upon registration, we collect your email address, name, title, and other profile information. We collect similar data when you use your account for our Services as well as when you update your profile information. </li>
                    <li><b>Payment Information.</b> We are compliant with Payment Card Industry Data Security Standard (PCI DSS), in order to protect your Personal Data against fraud and payment card theft when you pay for our Services.</li>
                    <li><b>Submissions and Customer Service.</b> We may use surveys, contests or sweepstakes requesting personal or demographic information and customer feedback.</li>
                    <li><b>Automatically Collected Information.</b> We automatically receive certain types of information when you interact with our Site, services and communications. This includes your computer’s IP address, browser type, language, access times, any referring websites, pages visited, and account activity.</li>
                    <li><b>Cookies and Web Beacons.</b> Cookies and Web beacons may be used for collecting information. Such data is beneficial to us for improving the Site. It lets us know about the number of computers accessing the Site, recording user preferences, tailoring customer experience, allowing users to revisit without having to re-enter passwords or account information every time.</li>
                </ul>
                <p>Take note, most browsers automatically accept cookies as a default. Cookie settings can be changed (you can accept or reject cookies).</p>
                <p><b>Encryption.</b> Although we use encryption (i.e., using a secret key to make Personal Data indecipherable unless decryption of the dataset is carried out using such assigned key) as a form of pseudonymization, we also utilize it as a secondary risk prevention measure for securing the Personal Data that we process. In particular, we utilize SSL (Secure Socket Layer) protocols for transferring Personal Data to any external party (such as, our payment processor).</p>
                <h3>Use of Personal Information</h3>
                <p>In general, the Site uses Personal Information for customizing user experience. The data helps us process your requests and transactions, inform the user about promotions, events, etc. (if the need arises).</p>
                <p>For example, we may use your personal information:</p>
                <ul>
                  <li>To request feedback and to enable us to develop, customize and improve the Site (including Services).</li>
                    <li>To conduct marketing analysis for promotional reasons.</li>
                    <li>For sending you emails as a means to remain in contact with the User as well as for responding to User emails, requests, etc.</li>
                    <li>For addressing customer support inquiries.</li>
                    <li>To offer assistance with product and service development.</li>
                </ul>
                <h3>Sharing of Personal Information</h3>
                <p>SKUBubble reserves the right to share aggregated demographic information about the Site’s Users, Traffic, and Sales with our partners and advertisers.</p>
                <p>Take note, we will never give, sell, rent, share, or trade any of your personal information or any data you store using our services to any third party except as outlined in this Policy or with your consent.</p>
                <p>We may disclose information to a third party to:</p>
                <ol>
                  <li>Comply with laws or respond to lawful requests and legal process.</li>
                    <li>To protect SKUBubble, agents, customers, and others to enforce our agreements, policies and terms of use</li>
                    <li>Respond to an emergency, or protect the personal safety of any person.</li>
                </ol>
                <p>Be sure to review the terms and the Privacy Policies of any third parties you might be using to access the Site or linking the Site to.</p>
                <p>We may share personal date due to an acquisition, merger, or sale of all or a substantial portion of our business, with or to another company. </p>
                <p>During such a case, you will be notified if your data is transferred and becomes subject to a substantially different privacy policy.</p>
                <h3>European Union, UK and Switzerland Additional Notice</h3>
                <p>We respect your privacy rights and provide you with reasonable access and rights to the Personal Data, as this term is referred to for individuals located in the countries of the EU, UK or Switzerland pursuant to the European Directives 95/46/EC and 2002/58/EC (EU General Data Protection Regulations Legislation, also known as GDPR), that you may have provided through your use of the Services. If you live in the European Economic Area (EEA), and wish to access, amend, delete, or transfer any Personal Data we hold about you, you may contact us as set forth in the “Contact Us” section below.</p>
                <p>Feel free to Contact Us if you wish to update, correct, or delete Personal Data and preferences at any time. While the changes will be updated in the active user database (immediately or after the required amount of time), we are allowed to retain all data you submit for archiving purposes, backups, fraud prevention, abuse prevention, legal obligations, and other reasons deemed legitimate by us.</p>
                <p>It’s your choice if you wish to decline sharing certain Personal Information with us. You can also object to the processing of Personal Data on applicable legitimate (lawful) grounds. You also have a right to lodge a complaint with data protection authorities.</p>
                <h3>Legal Basis for Processing Personal Data; Retention</h3>
                <p>As mentioned, we are allowed to collect and use Personal Data if we have lawful reasons for doing so. These lawful bases include when you provide consent, when we have a contractual obligation to collect or process your Personal Data, and when we have a legitimate interest in processing Personal Data.</p>
                <p>When Personal Data is collected by us, we keep it for as long as necessary for the purpose it is being processed for. For example, your email address information can be retained for as long as the Services are active and as needed to provide you the Services. After that period, Personal Data may be kept by us to help address any queries or concerns related to your use of our Services. All Personal Data is periodically reviewed. When it isn’t needed to retained any longer for business, consumer, or legal issues, it is securely deleted.</p>
                <h3>International Transfers</h3>
                <p>If Personal Data is required to be transferred outside the European Economic Area (EEA), steps are taken to ensure such transfer occurs in a manner following applicable laws and using adequate and appropriate safeguards.</p>
                <h3>Network and Information Security</h3>
                <p>We take reasonable steps to protect information we collect from you to prevent loss, misuse and unauthorized access, disclosure, alteration, and destruction. In addition, highly confidential personal information such as credit card number and password requested from you on our Site is protected with encryption, such as Secured Socket Layer (SSL) protocol, during transmission over the Internet. Such data has limited access for security purposes.</p>
                <p>While reasonable efforts are made to guard Personal Data (collected by us), no security system is impenetrable. That is why we can’t guarantee any passively-collected personal information is stored at adequate levels and meets the security needs you might have regarding that certain data.</p>
                <p>Your account information and access to our service, through our Site, is accessible only through the use of an individual user ID and password. </p>
                <p>If also falls on you to protect your password for security. If you believe your password has been stolen and account has been misused, please contact us. Always logout and close your browser when you finish your session.</p>
                <p>Your password will never be disclosed by us, unless there are legitimate concerns.</p>
                <h3>Updating and Accessing Personal Information</h3>
                <p>Upon any change in Personal Data, do correct and update the said information as soon as possible by logging into your account with the Site.</p>
                <h3>Choice/Opt-Out</h3>
                <p>You can Opt-Out of receiving promotional emails from the Site by following the Opt-Out instructions present on the said emails.</p>
                <p>We may send you emails about updates or notices about your use of the Site and Services.</p>
                <p>Opt-out requests will not apply to transactional service messages, such as security alerts and notices about your current account and services.</p>
                <h3>Alternations in our Privacy Policy</h3>
                <p>We reserve the right to modify this Privacy Policy at any time. If we decide to change our Privacy Policy, the changes will be posted in the Updated Privacy Policy as well as displayed at other areas we deem appropriate.</p>
                <p>If material changes to this Privacy Policy are to be made, we will notify you here, by email, or by means of a notice on our home page, at least thirty (30) days prior to the implementation of the said changes.</p>
                <h3>Contact us</h3>
                <p>If you have any privacy-related questions, concerns or complaints about our Privacy Policy, our practices or our Services, you may contact us at (EMAIL).</p>
                <p>In the alternative, you may contact us by either of the following means:</p>
                <blockquote><p>By Mail: Request must be sent to <b>IT 2002, IT ZONE, RAMCHANDRAPURA INDUS. AREA, SITAPURA, JAIPUR, Rajasthan (India),</b></p>
                <p>By E-Mail: <b>epihelp@infoshore.biz</b></p></blockquote>
                <p><b>We will respond to all requests, inquiries or concerns within thirty (30) days.</b></p>
                
              </TextContainer>
              <br/>
              <Form onSubmit={this.acceptTos} method="post" preventDefault="true">
                <FormLayout>
                  <Checkbox label="I agree to the terms of service" error={this.errors_data.terms_accepted_error} checked={this.state.terms_accepted} onChange={this.handleChange('terms_accepted')} />
                  <Stack distribution="trailing">
                    <Button primary submit loading={this.state.button_loading}>Next</Button>
                  </Stack>
                </FormLayout>
              </Form>
            </Card>
          </Layout.AnnotatedSection>
          <Layout.Section>
            <FooterHelp>
              For more details on App, visit our {' '}
              <Link url="https://app1.ecomshore.com/Step1.pdf" external="true">documentation</Link>.
            </FooterHelp>
          </Layout.Section>
        </Layout>
      </Page>
    );
  }
}

export default AcceptTos;