import React, {Component} from 'react';
import { BrowserRouter as Router, Switch, Route } from 'react-router-dom';
import '@shopify/polaris/styles.css';
import './Styles.css';
import enTranslations from '@shopify/polaris/locales/en.json';
import {ArrowLeftMinor, HomeMajorMonotone, OrdersMajorTwotone, ProductsMajorTwotone, OnlineStoreMajorMonotone, NoteMajorMonotone, SettingsMajorMonotone, ActivitiesMajorMonotone, TransactionMajorMonotone, LogOutMinor} from '@shopify/polaris-icons';
import {Heading, AppProvider, Page, Navigation, TopBar, Frame, Toast, Form, FormLayout, TextField, Button } from '@shopify/polaris';
import AppStep from './AppStep';
import AppHome from './AppHome';
import Products from './Products';
import Listings from './Listings';
import EbayAccount from './EbayAccount';
import Profiles from './Profiles';
import Orders from './Orders';
import OrderView from './OrderView';
import EbayAccountForm from './EbayAccountForm';
import Logs from './Logs';
import Plans from './Plans';
import ProfileForm from './ProfileForm';
import ProductForm from './ProductForm';
import Templates from './Templates';
import TemplateForm from './TemplateForm';
import Policies from './Policies';
import PaymentPolicyForm from './PaymentPolicyForm';
import ReturnPolicyForm from './ReturnPolicyForm';
import ShippingPolicyForm from './ShippingPolicyForm';
import SettingsForm from './SettingsForm';
import Logout from './Logout';
import AttributeMappingForm from './AttributeMappingForm';
import Ebaynew from './Ebaynew';
import PoliciesAdd from './PoliciesAdd';
import Setuplayout from '../Setuplayout';
import Setup2 from './Setup2';
import EditProfileForm from './EditProfileForm';
import AddProfileForm from './AddProfileForm';
//import { renderIntoDocument } from 'react-dom/test-utils';

class App extends Component{
  
  _isMounted = false;

  state = {
    app_name: "eBay Exporter by Infoshore",
    app_url: this.app_url,
    //logo_url: process.env.PUBLIC_URL + '/logo.png',
    logo_url: process.env.PUBLIC_URL + '/can.jpg',
    
    shop:"",
    store_data:{},
    plan_activated:false,
    plan_not_activated:false,
    isUserMenuOpen:false,
    install_shopify_url:"",
    requests_processed:false,
    summarydata:{}
  };

  constructor(props){
    super(props);
    this.updateInstallStep = this.updateInstallStep.bind(this);
    this.hideToast = this.hideToast.bind(this);

    this.senv = "";

    if(this.senv === "server1"){
      this.app_domain = "https://apps.infoshore.biz";
      this.app_url = "https://apps.infoshore.biz/shopify-apps/ebshopify/cp";
      this.base_url = "/shopify-apps/ebshopify/cp";
      this.sub_folder = "/ebshopify/";
    }
    else if(this.senv === "server2"){
      this.app_domain = "https://app1.ecomshore.com";
      this.app_url = "https://app1.ecomshore.com/cp";
      this.base_url = "/cp";
      this.sub_folder = "";
    }
    else{
      this.app_domain = "http://localhost/";
      this.app_url = "http://localhost:3000/";
      this.base_url = "";  
      this.sub_folder = "";
    }
    
    if(this.senv === "server2"){
      this.api_url = this.app_domain + "/service/api";
      this.service_url = this.app_domain + "/service";
    }
    else{
      this.api_url = this.app_domain+"service/api";
      this.service_url = this.app_domain+"service";
    }
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;
    const searchParams = new URLSearchParams(window.location.search);
    var shop = searchParams.get('shop');
    var login_token = searchParams.get('login_token');
    if(shop && shop.length > 0 && login_token && login_token.length > 0){
      localStorage.removeItem("infoshore_app_shop");
      localStorage.setItem('infoshore_app_shop',shop);

      localStorage.removeItem("infoshore_app_login_token");
      localStorage.setItem('infoshore_app_login_token',login_token);
    }
    else{
      shop = localStorage.getItem('infoshore_app_shop');
      login_token = localStorage.getItem('infoshore_app_login_token');
    }

    if(shop && shop.length > 0 && login_token && login_token.length > 0){
      this.setState(() => {
        return { shop: shop,login_token:login_token };
      });
     
      fetch(this.api_url+'/storedata?shop='+shop+'&login_token='+login_token)
      .then(res => res.json())
      .then((data) => {
        console.log(data);
        var store_data = data;
        //this.setState(function(){ return { store_data: data,requests_processed:true } });

        var queryData = [];
        queryData.push("shopify_url=" + store_data.shopify_url);
        queryData.push("api_token=" + store_data.user.api_token); 
        var queryStr = queryData.join("&");
        fetch(this.api_url+'/summarydata?'+queryStr)
        .then(res => res.json())
        .then((data) => {
          this.setState(() => {
            return { summarydata: data, store_data: store_data,requests_processed:true };
          });
        })
        .catch(console.log);
      })
      .catch(console.log);
    }
    else{
      this.setState(function(){ return { requests_processed: true } });
    }
    var curr_loc = window.location.href;
    var hrefArr;
    if(curr_loc.lastIndexOf("/edit/") !== -1){
      hrefArr = window.location.href.split("/edit/");

      if(hrefArr[1].lastIndexOf("?") !== -1){
        var hrefArr2 = hrefArr[1].split("?");
        this.setState({ edit_id: hrefArr2[0] });
      }
      else{
        this.setState({ edit_id: hrefArr[1] });
      }
    }
    else if(curr_loc.lastIndexOf("/orders/") !== -1){
      hrefArr = window.location.href.split("/orders/");
      this.setState({ view_id: hrefArr[1] });
    }
    else if(curr_loc.lastIndexOf("plan_activated") !== -1){
      this.setState({ plan_activated: true });
    }
    else if(curr_loc.lastIndexOf("plan_not_activated") !== -1){
      this.setState({ plan_not_activated: true });
    }
    else if(curr_loc.lastIndexOf("/profile/") !== -1 && curr_loc.lastIndexOf("attributes") !== -1){
      hrefArr = window.location.href.split("/profile/")[1];
      hrefArr = hrefArr.split("/attributes");
      this.setState({ edit_id: hrefArr[0] });
    }
  }

  hideToast(){
    this.setState(function(){ return {plan_activated: false,plan_not_activated: false} });
  }

  //isUserMenuOpen = false

  toggleIsUserMenuOpen = () => {
    //this.setState( function(){ return {isUserMenuOpen:!this.state.isUserMenuOpen} } );
    this.isUserMenuOpen = !this.isUserMenuOpen;
    window.location.href = `https://${this.state.store_data.shopify_url}/admin`
  }

  updateInstallStep(step){
    var store_data = this.state.store_data;
    store_data.install_step = step;
    this.setState(function(){ return { store_data: store_data } });
  }

  getTopBarMarkup = () => {
    let userMenuMarkup = (
      <TopBar.UserMenu 
        name={this.state.store_data.store_name}
        initials={this.state.store_data.store_name.charAt(0)}
        actions={[
          {
            items: [{content: 'Back to Shopify Admin', icon: ArrowLeftMinor, url:`https://${this.state.store_data.shopify_url}/admin`}],
          }
        ]}
        open={this.isUserMenuOpen}
        onToggle={this.toggleIsUserMenuOpen}
      />
    );

    const topBarMarkup = (
      <TopBar userMenu={userMenuMarkup} />
    );
    return topBarMarkup;
  }

  getNavigationMarkup = () => {
    var dashboard_sel = false;
    //var profiles_sel = false;
    //var listings_sel = false;
    if(window.location.pathname === "/"){ dashboard_sel = true; }
    //if(window.location.pathname.indexOf("/profiles") !== -1){ profiles_sel = true; }
    //if(window.location.pathname.indexOf("/listings") !== -1){ listings_sel = true; }

    const navigationMarkup = (
      <Navigation location={window.location.pathname}>
        <Navigation.Section
          items={[
            {
              url: this.base_url + '/',
              label: 'Dashboard',
              icon: HomeMajorMonotone,
              selected:dashboard_sel
            },
            {
              url: this.base_url + '/listings/linked',
              label: 'Listings',
              icon: OnlineStoreMajorMonotone,
              subNavigationItems: [
                {
                  url: this.base_url + '/listings/linked',
                  label: 'Linked Listings',
                },
                {
                  url: this.base_url + '/listings/unlinked',
                  label: 'Un-Linked Listings',
                }
              ]
            },
            {
              url: this.base_url + '/EbayAccount',
              label: 'Ebay Configuration',
              icon: SettingsMajorMonotone,
              subNavigationItems: [
                {
                  url: this.base_url + '/EbayAccount',
                  label: 'eBay Account',
                },
                {
                  url: this.base_url + '/policies',
                  label: 'Manage Policies',
                },
                {
                  url: this.base_url + '/templates',
                  label: 'Manage Templates',
                } 
              ]
            },
            {
              url: this.base_url + '/products',
              label: 'Products',
              icon: ProductsMajorTwotone,
            },
            // {
            //   url: this.base_url + '/orders',
            //   label: 'Ebay Orders',
            //   icon: OrdersMajorTwotone,
            //   badge: (this.state.store_data.pending_orders_count > 0) ? (this.state.store_data.pending_orders_count).toString() : null,
            // },
            // {
            //   url: this.base_url + '/templates',
            //   label: 'Manage Templates',
            //   icon: NoteMajorMonotone
            // },
            // {
            //   url: this.base_url + '/policies',
            //   label: 'Manage Policies',
            //   icon: OnlineStoreMajorMonotone,
            //   // subNavigationItems: [
            //   //   {
            //   //     url: this.base_url + '/policies/return/new',
            //   //     label: 'Add Return Profile',
            //   //   },
            //   //   {
            //   //     url: this.base_url + '/policies/payment/new',
            //   //     label: 'Add Payment Profile',
            //   //   },
            //   //   {
            //   //     url: this.base_url + '/policies/shipping/new',
            //   //     label: 'Add Shipping Profile',
            //   //   }
            //   // ]
            // },

          ]}
        />
        <Navigation.Section
          items={[
            {
              url: this.base_url + '/profiles',
              label: 'Profiles',
              icon: NoteMajorMonotone,
              subNavigationItems: [
                {
                  url: this.base_url + '/profiles',
                  label: 'All Profile',
                },
                {
                  url: this.base_url + '/profiles/new',
                  label: 'Add Profile',
                }
              ]
            }, 
           
            {
              url: this.base_url + '/settings',
              label: 'Settings',
              icon: SettingsMajorMonotone,
            },
            {
              url: this.base_url + '/logs',
              label: 'Activity Logs',
              icon: ActivitiesMajorMonotone,
            }
          ]}
          separator
        />

        <Navigation.Section
          items={[
            {
              url: this.base_url + '/plans',
              label: 'Plans & Pricings',
              icon: TransactionMajorMonotone,
            },
            {
              url: this.base_url + '/logout',
              label: 'Log out',
              icon: LogOutMinor,
            }
          ]}
          separator
        />
      </Navigation>
    );
    return navigationMarkup;
  }

  appRoutes = () => {
    return (
      <Router>

        <Switch>
          <Route exact path={this.base_url + '/'} component={() => <AppHome base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />} />

          {/* <Route exact path={this.base_url + '/step2'} component={() => <Setup2 base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />} /> */}

          <Route exact path={this.base_url + '/products'} component={() => <Products base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route exact path={this.base_url + '/EbayAccount'} component={() => <EbayAccount base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route path={this.base_url + '/products/edit/'} component={() => <ProductForm service_url={this.service_url} base_url={this.base_url} product_id={this.state.edit_id} form_type="edit_product" api_url={this.api_url} store_data={this.state.store_data} />} />
         
          <Route  path={this.base_url +'/Ebaynew'}   component={() => <Ebaynew base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />}/>
         
          <Route exact path={this.base_url + '/policies'} component={() => <Policies base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />} />
{/*           
          <Route exact path={this.base_url + '/policies/new'} component={() => <PoliciesAdd base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />} /> */}


          <Route exact path={this.base_url + '/policies/payment/new'} component={() => <PaymentPolicyForm service_url={this.service_url} base_url={this.base_url} form_type="add_policy" api_url={this.api_url} store_data={this.state.store_data} />} />
          <Route exact path={this.base_url + '/policies/return/new'} component={() => <ReturnPolicyForm service_url={this.service_url} base_url={this.base_url} form_type="add_policy" api_url={this.api_url} store_data={this.state.store_data} />} />
          <Route exact path={this.base_url + '/policies/shipping/new'} component={() => <ShippingPolicyForm service_url={this.service_url} base_url={this.base_url} form_type="add_policy" api_url={this.api_url} store_data={this.state.store_data} />} />
          
          <Route exact path={this.base_url + '/templates'} component={() => <Templates base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route exact path={this.base_url + '/templates/new'} component={() => <TemplateForm service_url={this.service_url} base_url={this.base_url} form_type="add_template" api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route path={this.base_url + '/templates/edit/'} component={() => <TemplateForm service_url={this.service_url} base_url={this.base_url} template_id={this.state.edit_id} form_type="edit_template" api_url={this.api_url} store_data={this.state.store_data} />} />
   
          <Route exact path={this.base_url + '/profiles'} component={() => <Profiles base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route exact path={this.base_url + '/profiles/new'} component={() => <AddProfileForm service_url={this.service_url} base_url={this.base_url} form_type="add_profile" api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route path={this.base_url + '/profiles/edit/'} component={() => <EditProfileForm service_url={this.service_url} base_url={this.base_url} profile_id={this.state.edit_id} form_type="edit_profile" api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route path={this.base_url + '/profile/'} component={() => <AttributeMappingForm base_url={this.base_url} profile_id={this.state.edit_id} api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route path={this.base_url + '/settings'} component={() => <SettingsForm form_type="settings" api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route path={this.base_url + '/listings/linked'} component={() => <Listings updateFrameLoading={this.updateFrameLoading} link_status="linked" api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route path={this.base_url + '/listings/unlinked'} component={() => <Listings updateFrameLoading={this.updateFrameLoading} link_status="unlinked" api_url={this.api_url} store_data={this.state.store_data} />} />

          {/* <Route exact path={this.base_url + '/orders'} component={() => <Orders base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route path={this.base_url + '/orders/'} component={() => <OrderView base_url={this.base_url} order_id={this.state.view_id} api_url={this.api_url} store_data={this.state.store_data} />} /> */}

          <Route path={this.base_url + '/logs'} component={() => <Logs api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route path={this.base_url + '/plans'} component={() => <Plans api_url={this.api_url} store_data={this.state.store_data} />} />

          <Route path={this.base_url + '/logout'} component={() => <Logout base_url={this.base_url} api_url={this.api_url} store_data={this.state.store_data} />} />
            
        </Switch>

      </Router>
    );
  }

  globalRibbon = () => {
    return (
      <div>
        {this.state.store_data.plan.identifier === "free" &&
          <p style={{background: '#D9534F', padding: '5px', color:"#FFF"}}>
            <span style={{display:"inline-block",padding:"10px 10px"}}>You are on your free plan. You can add upto {this.state.summarydata.products_limit} products. </span>
            <Button url={this.base_url + "/plans/"}>Upgrade</Button>
          </p>
        }
      </div>
    );
  }
  
  getRenderData = () => {
      return (
        <Frame 
          globalRibbon={this.globalRibbon()}
          topBar={this.getTopBarMarkup()}
          navigation={this.getNavigationMarkup()}
        >
          {this.state.plan_activated === true &&
            <Toast content="Plan activated successfully" onDismiss={this.hideToast} duration="3000" />
          }
          {this.state.plan_not_activated === true &&
            <Toast content="Plan not activated" error onDismiss={this.hideToast} duration="3000" />
          }
          {
            this.appRoutes()
          }
        </Frame>
      );
  }

  // getRenderData = () => {
  //   if(this.state.store_data.install_step === "done"){
  //     return (
  //       <Frame 
  //         globalRibbon={this.globalRibbon()}
  //         topBar={this.getTopBarMarkup()}
  //         navigation={this.getNavigationMarkup()}
  //       >
  //         {this.state.plan_activated === true &&
  //           <Toast content="Plan activated successfully" onDismiss={this.hideToast} duration="3000" />
  //         }
  //         {this.state.plan_not_activated === true &&
  //           <Toast content="Plan not activated" error onDismiss={this.hideToast} duration="3000" />
  //         }
  //         {
  //           this.appRoutes()
  //         }
  //       </Frame>
  //     );
  //   }
  //   else{
    
  //     return (
  //       <Frame>
  //         {/* <div className="app_step_head" style={{textAlign: "center"}}> */}
  //           {/* <br /> */}
  //           {/* <div style={{ display: "flex", justifyContent: "center", alignItems: "center", height: "40px" }}>
  //     <img src={logo} alt="Logo" style={{ width: "60px", height: "60px", marginRight: "10px" }} />
      
  //     <h1 style={{fontSize:"25px" , fontWeight:"bold"}}>eBay Exporter by Infoshore</h1>
    
  //   </div> */}
  //           {/* <Heading element="h1"><img src={logo} alt="Logo" style={{ width: "40px", height: "40px"}}/> eBay Exporter by Infoshore</Heading> */}
  //         {/* </div> */}
  //          {/* {console.log(this.store_data)} */}
  //           <Setuplayout api_url={this.api_url} store_data={this.state.store_data} updateInstallStep={this.updateInstallStep} />
        
  //         {/* <AppStep service_url={this.service_url} api_url={this.api_url} store_data={this.state.store_data} updateInstallStep={this.updateInstallStep} /> */}
  //       </Frame>
  //     );
  //   }
  // }

  render(){
    const theme = {
      colors: {topBar: {background: 'rgb(28, 34, 96)'}},
      logo: {
        width: 250,
        topBarSource: this.state.logo_url,
        url: this.state.app_url,
        accessibilityLabel: this.state.app_name
      }
    };

    if(this.state.store_data && this.state.store_data.status === "active" && this.state.requests_processed === true){
      return (
        <AppProvider theme={theme} title={this.state.app_name} i18n={enTranslations}>
          {this.getRenderData()}
        </AppProvider>
      );
    }
    else if(this.state.requests_processed === true){
      console.log(window.location.pathname);
      if(window.location.pathname !== "/install/index.html"){

        if(this.senv === "server2"){
          window.location.href = "/install/index.html";
        }
        else{
          window.location.href = this.app_domain+this.sub_folder+"install/index.html";
        }
        return <p></p>;
      }
      /*
      return (
        <AppProvider i18n={enTranslations}>
          <AppIntro {...this} />
        </AppProvider>
        
      );
      */
      return (
        <AppProvider i18n={enTranslations}>
          <Page>
            <Form onSubmit={() => { if(this.state.install_shopify_url === ""){alert('Please Enter Shopify Store URL'); return null;} window.location.href = `${this.app_domain}/${this.sub_folder}service/shopifyinstall?test_install=1&shop=${this.state.install_shopify_url}`;}}>
              <FormLayout>
                <TextField
                  value={this.state.install_shopify_url}
                  onChange={(e) => { this.setState(() => { return {install_shopify_url:e} }) }}
                  label="Enter Shopify Store URL"
                  type="text"
                  helpText={<span>Eg : teststore.myshopify.com</span>}
                />
                <Button submit>Install App</Button>
                <script id="ze-snippet" src="https://static.zdassets.com/ekr/snippet.js?key=76ee62d4-68f9-4902-ae5a-b7580b654265"> </script>
              </FormLayout>
            </Form>
          </Page>
        </AppProvider>
      );
    }
    else{
      return null;
    }
  }
}

export default App;
