import React, { Component } from "react";
//import ReactDOM from 'react-dom';
import {
  Page,
  Button,
  CalloutCard,
  Text,
  Layout,
  Card,
  DataTable,
  Stack,
  Thumbnail,
  FooterHelp,
  Link,
  Icon,
  Badge,
  Form,
  TextField,
  Toast,
  Accordion,
  withRouter,
  Frame, Modal, TextContainer,
} from "@shopify/polaris";

import { CirclePlusMinor } from "@shopify/polaris-icons";
import "./YourComponent.css";
import { Redirect } from "react-router-dom/cjs/react-router-dom.min";
class AppHome extends Component {
  _isMounted = false;
  state = {
    summarydata: {},
    store_data: {},
    phone: "",
    phoneError: false,
    accordionOpen: false,
    loginUserID: "",
    userLastLogin: null,
    redirect: false,
    active: true,
    secondModalActive: false
  };

  constructor(props) {
    super(props);
    this.getSummaryData = this.getSummaryData.bind(this);
    this.getDashboardData = this.getDashboardData.bind(this);
    this.handleChange = this.handleChange.bind(this);
    this.handleChangepopupClose = this.handleChangepopupClose.bind(this);
    this.handleSecondModal = this.handleSecondModal.bind(this);

  }

  handleSecondModal() {
    this.setState((prevState) => ({
      secondModalActive: !prevState.secondModalActive
    }));
  }

  handleChangepopupClose(event) {
    event.preventDefault();  

    this.handleClick2(event);

    // if (!this.state.phone || !this.state.phone.trim()) {
    //   this.setState({ phoneError: "Phone number cannot be blank" });
    //   return; // Exit function if phone number is blank or null
    // }

    this.setState((prevState) => ({
      active: !prevState.active
    }));
    

    
  }

  handleChange = (field) => {

    

    return (value) => {
      
      const numericRegex = /^[0-9]*$/;
      if (numericRegex.test(value)) {
        // If value is numeric, update the state
        this.setState(() => {
          return { [field]: value.toString() };
        });
      }

      // this.setState((prevState) => ({
      //   active: !prevState.active
      // }));

    };
  };  

  formatDateTime = (isoDateTime) => {
    const date = new Date(isoDateTime);
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const day = String(date.getDate()).padStart(2, '0');
    const hours = String(date.getHours()).padStart(2, '0');
    const minutes = String(date.getMinutes()).padStart(2, '0');
    const seconds = String(date.getSeconds()).padStart(2, '0');

    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
  }

  handleClick = async (event) => {
    event.preventDefault();  

    this.setState({ isLoading: true }); 
    const currentDate = new Date();
    const formattedDate = this.formatDateTime(currentDate.toISOString());
    try {
      // Make API call to submit form data
      const response = await fetch(this.props.api_url+'/shopify_stores/'+this.props.store_data.id, {
        method: "PUT",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify({ date: formattedDate }),
      });

      if (!response.ok) {
        throw new Error("Failed to submit form data");
      } else {        
        this.setState({redirect:true});
      }      
      // this.props.history.push('http://localhost:3000/profiles/edit/1');
      // Reset form fields and loading state upon successful submission      
    } catch (error) {
      console.error("Error submitting form:", error);
      // Set error message if API call fails
      this.setState({
        isLoading: false,
        apiError: "Failed to submit form data. Please try again later.",
      });
    }
  };

  handleClick2 = async (event) => {
    event.preventDefault();  

    this.setState({ isLoading: true }); 
    const currentDate = new Date();
    const formattedDate = this.formatDateTime(currentDate.toISOString());
    try {
      // Make API call to submit form data
      const response = await fetch(this.props.api_url+'/shopify_stores/'+this.props.store_data.id, {
        method: "PUT",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify({ date: formattedDate }),
      });

      if (!response.ok) {
        throw new Error("Failed to submit form data");
      } else {   
        // this.setState({redirect:true});
        this.setState({active: false});
      }

      // this.props.history.push('http://localhost:3000/profiles/edit/1');
      // Reset form fields and loading state upon successful submission
      
    } catch (error) {
      console.error("Error submitting form:", error);
      // Set error message if API call fails
      this.setState({
        isLoading: false,
        apiError: "Failed to submit form data. Please try again later.",
      });
    }
  };

  handleSubmit = async (event) => {

    event.preventDefault();  

    if (!this.state.phone || !this.state.phone.trim()) {
      this.setState({ phoneError: "Phone number cannot be blank" });
      return; // Exit function if phone number is blank or null
    }

    // Clear any previous error messages
    this.setState({ phoneError: "", apiError: "" });

    // Set loading state to true while waiting for API response
    this.setState({ isLoading: true });  
    try {
        // Make API call to submit form data
        const response = await fetch(this.props.api_url+'/users/'+this.props.store_data.user_id, {
            method: "PUT",
            headers: {
                "Content-Type": "application/json",
                // Add any additional headers if required
            },
            body: JSON.stringify({ phone: this.state.phone }),
        });

        if (!response.ok) {
            throw new Error("Failed to submit form data");
        }

        await this.handleClick2(event);

        const responseData = await response.json();
        const updatedPhone = responseData.phone;

        // Reset form fields and loading state upon successful submission
        this.setState({
            phone: updatedPhone, // Update phone state with the new value
            isLoading: false,
            button_loading: false,
            success_message: "Phone Number Update Successful",
            active: false,
        });
    } catch (error) {
        console.error("Error submitting form:", error);
        // Set error message if API call fails
        this.setState({
            isLoading: false,
            apiError: "Failed to submit form data. Please try again later.",
        });
    }
  };

  _isMounted = false;
  _card = false;
  _card1 = false;
  componentWillUnmount() {
    this._isMounted = false;
  }

  componentDidMount() {
    var phone = this.props.store_data.user.phone;
    var updated_at = this.props.store_data.user.updated_at;
   // console.log(this.props.store_data.ebay_account.is_valid);
    if (!this.props.store_data.ebay_account) {
      this._card = true;
    }
    if (!this._card ) {
      if(this.props.store_data.ebay_account.is_valid == 0){
        this._card1 = true;
      }
     
    }
    this._isMounted = true;
    document.title = "Dashboard - " + document.title;
    if (!this.state.summarydata || !this.state.summarydata.products_count) {
      this.getDashboardData();
    }
    this.setState(() => {
      return {
        phone: phone,
      };
    });
  }

  componentDidUpdate(prevProps, prevState) {
    if (
      this.state.success_message !== prevState.success_message &&
      this.state.success_message
    ) {
      setTimeout(() => {
        this.setState({ success_message: null }); // Remove the success_message after 1 second
      }, 1000);
    }
  }

  getDashboardData() {
    // console.log('USerID',this.props.store_data.id);
    // console.log('USerID-lastlogin',this.props.store_data.lastlogin);
    this.setState({ userLastLogin: this.props.store_data.lastlogin });
    if (this._isMounted === true) {
      var queryData = [];
      queryData.push("shopify_url=" + this.props.store_data.shopify_url);
      queryData.push("api_token=" + this.props.store_data.user.api_token);
      var queryStr = queryData.join("&");
      fetch(this.props.api_url + "/summarydata?" + queryStr)
        .then((res) => res.json())
        .then((data) => {  
          this.setState({ summarydata: data });
        })
        .catch(console.log);
      //       
    }
  }

  getSummaryData() {    
    var rows2 = [];
    if (
      this.state.summarydata.error_logs &&
      this.state.summarydata.error_logs.total > 0
    ) {
      for (var key in this.state.summarydata.error_logs.data) {
        var log = this.state.summarydata.error_logs.data[key];
        rows2.push([log.log_type, log.created_at, log.remarks]);
      }
    }

    
    return (
      <Page>
        {this._card ? (
          <>
            <Card sectioned>
              <p>Please add ebay account first.</p>
              <br />
              <p>
                <Button destructive url={this.props.base_url + "/Ebaynew"}>
                  Add Ebay Account
                </Button>
              </p>
            </Card>
          </>
        ) : (
          <>{this._card1 ? 
            <>
            <Card sectioned>
              <p>Your eBay token is expired, Please reconfigure ebay account.</p>
              <br />
              <p>
                <Button destructive url={this.props.base_url + "/Ebaynew"}>
                Reconfigure Ebay Account
                </Button>
              </p>
            </Card>
          </>:
          <></>
           }
          </>
        )}
        <Card title="Summary" sectioned>
          <Stack distribution="fill">
            <Card sectioned>
              <p>{this.state.summarydata.products_count}</p>
              <p>Products</p>
            </Card>
            <Card sectioned>
              <p>{this.state.summarydata.published_count}</p>
              <p>Published</p>
            </Card>
            <Card sectioned>
              <p>{this.state.summarydata.submitted_count}</p>
              <p>In Process</p>
            </Card>
            <Card sectioned>
              <p>{this.state.summarydata.orders_count}</p>
              <p>Ebay Orders</p>
            </Card>
          </Stack>
        </Card>
        {this.state.success_message && (
          <Toast content={this.state.success_message} duration="2000" />
        )}

        <div>
          <Stack distribution="fill">
            <div
              className="dashboard_img_center"
              style={{ textAlign: "center" }}
            >
              <img
                src={process.env.PUBLIC_URL + "/product.png"}
                style={{ maxWidth: "100%" }}
                alt="Products"
              />
              <div className="box_heading">
                <h3>Products :</h3>
                <p>
                  <Button url={`${this.props.base_url}/products`} plain>
                    Manage Products
                  </Button>
                </p>
              </div>
            </div>
            <div
              className="dashboard_img_center"
              style={{ textAlign: "center" }}
            >
              <img
                src={process.env.PUBLIC_URL + "/list.png"}
                style={{ maxWidth: "100%" }}
                alt="Listings"
              />
              <div className="box_heading">
                <h3>Listings :</h3>
                <p>
                  <Button url={`${this.props.base_url}/listings/linked`} plain>
                    Manage Listings
                  </Button>
                </p>
              </div>
            </div>
            <div
              className="dashboard_img_center"
              style={{ textAlign: "center" }}
            >
              <img
                src={process.env.PUBLIC_URL + "/product.png"}
                style={{ maxWidth: "100%" }}
                alt="Orders"
              />
              <div className="box_heading">
                <h3>Ebay Configuration :</h3>
                <p>
                  <Button url={`${this.props.base_url}/EbayAccount`} plain>
                    Manage Configurations
                  </Button>
                </p>
              </div>
            </div>
          </Stack>
        </div>
        <div>
          <Stack distribution="fill">
            <div
              className="dashboard_img_center"
              style={{ textAlign: "center" }}
            >
              <img
                src={process.env.PUBLIC_URL + "/profiles.png"}
                style={{ maxWidth: "100%" }}
                alt="Profiles"
              />
              <div className="box_heading">
                <h3>Profiles :</h3>
                <p>
                  <Button url={`${this.props.base_url}/profiles`} plain>
                    Manage Profiles
                  </Button>
                </p>
              </div>
            </div>
            <div
              className="dashboard_img_center"
              style={{ textAlign: "center" }}
            >
              <img
                src={process.env.PUBLIC_URL + "/settings.png"}
                style={{ maxWidth: "100%" }}
                alt="Settings"
              />
              <div className="box_heading">
                <h3>Settings :</h3>
                <p>
                  <Button url={`${this.props.base_url}/settings`} plain>
                    Manage Settings
                  </Button>
                </p>
              </div>
            </div>
            <div
              className="dashboard_img_center"
              style={{ textAlign: "center" }}
            >
              <img
                src={process.env.PUBLIC_URL + "/logs.png"}
                style={{ maxWidth: "100%" }}
                alt="Activity Logs"
              />
              <div className="box_heading">
                <h3>Activity Logs :</h3>
                <p>
                  <Button url={`${this.props.base_url}/logs`} plain>
                    View Activity
                  </Button>
                </p>
              </div>
            </div>
          </Stack>
        </div>      
        
      </Page>
    );
  }

  render() {
    const { userLastLogin } = this.state;
    // if (userLastLogin === null) {
    //   return <div>Loading...</div>;
    // }
    const { redirect } = this.state;

    // console.log('redirect',redirect);
    // console.log('userLastLogin',redirect);

    const { active, secondModalActive } = this.state;
    const activator = <Button onClick={this.handleChange}>Open</Button>;
    const secondModalActivator = (<Button onClick={this.handleSecondModal}>Help Video</Button>);

     if (redirect) {
        return <Redirect to='/cp/profiles'/>;
     }
     
    var billing_on = "None";
    if (  
      this.props.store_data.app_charge &&
      this.props.store_data.app_charge.app_charge_data
    ) {
      billing_on = this.props.store_data.app_charge.app_charge_data.billing_on;
    }
    var rows1 = [
      ["Plan Status", this.props.store_data.plan.name],
      ["Billing On", billing_on],
      [
        "Product Limit",
        `${this.state.summarydata.published_count} / ${this.state.summarydata.products_limit} available`,
      ],
    ];
    var rows3 = [];
    if (this.state.summarydata.logs && this.state.summarydata.logs.total > 0) {
      for (var key in this.state.summarydata.logs.data) {
        var log = this.state.summarydata.logs.data[key];
        var log_status = <Badge status="success">{log.status}</Badge>;
        if (log.status != "success") {
          log_status = <Badge status="critical">{log.status}</Badge>;
        }
        rows3.push([log_status, log.remarks, log.created_at]);
      }
    }

    return (
      <>      
      <Layout>
        <Layout.Section>{this.getSummaryData()}</Layout.Section>
        <Layout.Section secondary>
          <Card title="Account Info" sectioned>
            <DataTable
              columnContentTypes={["text", "numeric"]}
              headings={["", ""]}
              rows={rows1}
            />
          </Card>
          <Card title="Support">
            <Stack distribution="fillEvenly">
              <div
                className="apphome_img_center"
                style={{ textAlign: "center" }}
              >
                <Thumbnail
                  source={process.env.PUBLIC_URL + "/KnowledgeBaseIcon.jpg"}
                  size="large"
                  alt="Knowledge Base"
                />
                <Button
                  url="https://infoshoreapps.freshdesk.com/support/solutions/articles/36000427415"
                  fullWidth
                  external="true"
                >
                  Knowledge Base
                </Button>
              </div>
              <div
                className="apphome_img_center"
                style={{ textAlign: "center" }}
              >
                <Thumbnail
                  source={process.env.PUBLIC_URL + "/help.png"}
                  size="large"
                  alt="Contact Support"
                />
                {/* <Button
                  url="mailto:epihelp@infoshore.biz"
                  fullWidth
                  external="true"
                >
                  Contact Support
                </Button> */}

                {secondModalActivator}

              </div>
            </Stack>
          </Card>
          {rows3.length > 0 && (
            <Card title="Activity Logs Summary" sectioned>
              <DataTable
                columnContentTypes={["text", "text", "text"]}
                headings={["Type", "Description", "Log Date"]}
                rows={rows3}
                footerContent={
                  <Button url={this.props.base_url + "/logs"} plain>
                    Click here to view all activities
                  </Button>
                }
              />
            </Card>
          )}
          <FooterHelp>
            For more details on App, visit our{" "}
            <Link
              url="https://app1.ecomshore.com/Dashboard.pdf"
              external="true"
            >
              documentation 
            </Link>
            .
          </FooterHelp>
        </Layout.Section>        
      </Layout>
      
      {this.state.userLastLogin == null ? (
          <>          
            <div className="videoIframepopup">
              <Frame>
                <Modal
                  activator={activator}
                  open={active}
                  onClose={this.handleChangepopupClose}  
                  titleHidden          
                >
                  <Modal.Section>
                    <TextContainer>
                    <div className="formSection">
                      <Card sectioned>
                        {/*
                        <Form
                          onSubmit={this.handleSubmit}
                          method="post"
                          encType="multipart/form-data"
                          preventDefault="true"
                        >
                          <div className="d-flex">
                            <TextField
                              type="tel"
                              pattern="[0-9]*"
                              placeholder="required*"
                              label="Phone Number *"
                              error={this.state.phoneError}
                              // value={this.state.phone}
                              value={this.state.phone || ''}
                              onChange={this.handleChange("phone")}
                            />
                            <Button primary submit>
                              Submit
                            </Button>
                          </div>
                        </Form>
                        */}
                        <div className="editProfilelink">
                          <div
                            className="dashboard_img_center"
                            style={{ textAlign: "left" }}
                          >
                            <div>
                              
                            </div>
                          </div>
                        </div>
                        <div className="videoSection" style={{ textAlign: "center" }}>
                          <iframe
                            width="520"
                            height="315"
                            src="https://player.vimeo.com/video/942204338?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479"
                            title="YouTube video player"
                            frameBorder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowFullScreen
                          ></iframe>
                        </div>
                        <div className="addProfilelink">
                          <div
                            className="dashboard_img_center"
                            style={{ textAlign: "left" }}
                          >
                            <div>
                            <p>
                            Watch the above video to learn about profiles and listing the items.  We have created one profile to help listing your eBay items as well. <Link onClick={this.handleClick}>click here</Link> to review and make changes as per your requirements.  
                             </p>
                            </div>
                          </div>
                        </div>
                      </Card>
                    </div> 
                    </TextContainer>
                  </Modal.Section>
                </Modal>
              </Frame>
            </div>          
          </>
        ) : (
          <></>
        )}
          
        <div className="videoIframepopup">
          <Frame>
            <Modal
              activator={secondModalActivator}
              open={secondModalActive}
              onClose={this.handleSecondModal}    
              titleHidden          
            >
              <Modal.Section>
                <TextContainer>
                  <div className="videoSection2" style={{ textAlign: "center" }}>
                    <iframe
                      width="550"
                      height="350"
                      src="https://www.youtube.com/embed/6nlpPebipQc?si=WSsuERFbXDdGbGzg"
                      title="YouTube video player"
                      frameBorder="0"
                      allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                      allowFullScreen
                    ></iframe>
                  </div>
                </TextContainer>
              </Modal.Section>
            </Modal>
          </Frame>
        </div>

        {this.state.updated_at}

      </>
    );
    }
}
export default AppHome;
