import {Page,Spinner, Button,LegacyCard, EmptyState, Layout, Card, DataTable, Checkbox, ChoiceList, Filters, Banner, Popover, ActionList, Pagination, FooterHelp, Link, Badge} from '@shopify/polaris';
import { useState,useEffect } from "react";
import EbayAccountForm from './EbayAccountForm';
import Ebaynew from './Ebaynew';

function EbayAccount(props) {
    
    const [account, setAccount] = useState(false);
    const [loader, setLoader] = useState(true);
    const [value, setValue] = useState(false);
    const [queryData, setQueryData] = useState([]);
    const [rows, setRows] = useState([]);
   
    useEffect(()=>{
    getebayaccount()
   },[])

function handleclick(props){
//console.log("hii");
return (    
 
<Ebaynew  />
)
}

  function getebayaccount() {
    
    queryData.push("shopify_url=" + props.store_data.shopify_url);
    queryData.push("api_token=" + props.store_data.user.api_token);
    var queryStr = queryData.join("&");
    fetch(props.api_url+'/Ebayaccountssss?'+queryStr)
    .then(res => res.json())
    .then((data) => {
     console.log(data);
     setLoader(false);
     if( data === "Empty"){
      setAccount(true)
     }else{
      setValue(true)
      if (data.locations && data.locations[0] && data.locations[0].address1 && data.locations[0].city && data.locations[0].country_name) {
        setRows([data.sellerid, data.siteid, data.locations[0].address1 + ' & ' + data.locations[0].city, data.locations[0].country_name, data.name]);
      } else {
        setRows([data.sellerid, data.siteid, "Not Available", "Not Available", data.name]);
      }
     }
     
    })
    .catch(console.log);
  }
    return (
  <>
     <Page fullWidth="true" title="Ebay Account">
        <Card>{loader ?<>
        <div className="center-container">
        <Spinner accessibilityLabel="Spinner example" size="large" />
        </div>
       
        </>:<>
        
          {account ? <>
            <Card.Section>
      <EmptyState
        heading=""
        // action={{content: 'Add transfer'}}
        // secondaryAction={{
        //   content: 'Learn more',
        //   url: 'https://help.shopify.com',
        // }}
        image="https://cdn.shopify.com/s/files/1/0262/4071/2726/files/emptystate-files.png"
      >
        <p>No Ebay Account Found , Please Add Ebay Account .</p><br></br><br></br>

        <Button fullWidth  url={props.base_url+'/Ebaynew'}>Add Ebay Account</Button>

        
      </EmptyState>
      </Card.Section>
    
          </>:
           
          <>
          <Card.Section>
           <DataTable
          columnContentTypes={[  
            'text',
            'text',
            'text',
            'text',
            'text',
          ]}
          headings={[
           
            'Seller id',
            'Site id',
            'Location',
            'City',
            'Seller name',
          ]}
          rows={[rows]}/>
          </Card.Section>
         <br></br><br></br>
        <Card.Section>
        <div>
        <Button primary fullWidth  url={props.base_url+'/Ebaynew'}>Reconfigure Ebay Account</Button>
        </div>
        </Card.Section>
          </>}
            </>}
            </Card>
            </Page>
    </>
     );
}

export default EbayAccount;