import React, { Component } from 'react';
import {Button,Card,Form,FormLayout,Layout,Page,Stack,TextField,Select,FooterHelp,Link,Banner, Checkbox} from '@shopify/polaris';

class EbayAccountConfiguration extends Component{
  _isMounted = false;

  state = {
    reconfigure_ebay_account: false,
    automatic_sku_creation: false,
    threshold_quantity: false,
    threshold_quantity_value: 0,
    pricing_mark_up: false,
    pricing_mark_up_type: "percentage",
    pricing_mark_up_value: 0,
    order_sync: true
  };  

  ebaySiteList = [
    {value:'0', label:'eBay United States'},
    {value:'2', label:'eBay Canada (English)'},
    {value:'3', label:'eBay UK'},
    {value:'15', label:'eBay Australia'},
    {value:'16', label:'eBay Austria'},
    {value:'23', label:'eBay Belgium (French)'},
    {value:'71', label:'eBay France'},
    {value:'77', label:'eBay Germany'},
    {value:'100', label:'eBay Motors'},
    {value:'101', label:'eBay Italy'},
    {value:'123', label:'eBay Belgium (Dutch)'},
    {value:'146', label:'eBay Netherlands'},
    {value:'186', label:'eBay Spain'},
    {value:'193', label:'eBay Switzerland'},
    {value:'201', label:'eBay Hong Kong'},
    {value:'203', label:'eBay India'},
    {value:'205', label:'eBay Ireland'},
    {value:'207', label:'eBay Malaysia'},
    {value:'210', label:'eBay Canada (French)'},
    {value:'211', label:'eBay Philippines'},
    {value:'212', label:'eBay Poland'},
    {value:'216', label:'eBay Singapore'}
  ];

  errors_data = {};

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;
    this.setState({sub_title: "App Configuration"});
    this.setState({sub_description: "Review and update the App Settings."});

    var fetch_url = this.props.api_url+'/ebay_account?fetch_first=1&shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token;

    if(this.props.form_type === "app_setup"){
      this.setState({page_title: "App Setup - Step 4 of 4"});
    }
    else if(this.props.form_type === "settings"){
      this.setState({page_title: "Settings"});
      //fetch_url = this.props.api_url+'/ebay_account/'+this.props.account_id+'?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token;
    }

    fetch(fetch_url)
    .then(res => res.json())
    .then((data) => {
      console.log(data);
      if(data && data.id){
        this.setState({ account_id: data.id });
        for(var key in data){
          if(key === "automatic_sku_creation" || key === "inventory_sync" || key === "price_sync" || key === "order_sync" || key === "pricing_mark_up" || key === "listing_quantity" || key === "threshold_quantity"){
            if(data[key] === 1){
              this.setState({ [key]: true });
            }
            else{
              this.setState({ [key]: false });
            }
          }
          else{
            if(data[key] === null){
              this.setState({ [key]: data[key] });
            }
            else{
              this.setState({ [key]: data[key].toString() });
            }
          }          
        }
        if(data.is_valid === 0 || data.is_valid === null){
          this.setState({ reconfigure_ebay_account: true });
        }
      }
    })
    .catch(console.log);
  }

  pricingMarkUpTypeOptions = [
    {label: 'Percentage', value: 'percentage'},
    {label: 'Fixed', value: 'fixed'}
  ];
  
  constructor(props){
    super(props);
    this.handleChange = this.handleChange.bind(this);
    this.updateConfiguration = this.updateConfiguration.bind(this);
  }

  updateConfiguration(){
    this.setState({
      button_loading:true,
      reconfigure_ebay_account: this.state.reconfigure_ebay_account,
      automatic_sku_creation: this.state.automatic_sku_creation,
      threshold_quantity: this.state.threshold_quantity,
      threshold_quantity_value: this.state.threshold_quantity_value,
      pricing_mark_up: this.state.pricing_mark_up,
      pricing_mark_up_type: this.state.pricing_mark_up_type,
      pricing_mark_up_value: this.state.pricing_mark_up_value,
      order_sync: this.state.order_sync,
      error_message:null
    });

    var hasError = false;

    if(this.state.reconfigure_ebay_account === true){
      if(this.state.siteid.length <= 0){
        hasError = true;
        this.errors_data.siteid_error = "ebay site is required";
      }
    }
    if(this.state.threshold_quantity === true && this.state.threshold_quantity_value.length <= 0){
      hasError = true;
      this.errors_data.threshold_quantity_value_error = "threshold quantity value is required";
    }
    if(this.state.pricing_mark_up === true && this.state.pricing_mark_up_value.length <= 0){
      hasError = true;
      this.errors_data.pricing_mark_up_value_error = "pricing mark up value is required";
    }

    var update_install_step = false;
    if(this.props.form_type === "app_setup"){update_install_step = true;}

    if(hasError === false){
      var request_data = {
        reconfigure_ebay_account: this.state.reconfigure_ebay_account,
        automatic_sku_creation: this.state.automatic_sku_creation,
        threshold_quantity: this.state.threshold_quantity,
        threshold_quantity_value: this.state.threshold_quantity_value,
        pricing_mark_up: this.state.pricing_mark_up,
        pricing_mark_up_type: this.state.pricing_mark_up_type,
        pricing_mark_up_value: this.state.pricing_mark_up_value,
        order_sync: this.state.order_sync,
        update_install_step: update_install_step,
        shopify_url:this.props.store_data.shopify_url
      };

      if(this.state.reconfigure_ebay_account === true){
        request_data["merchant_id"] = this.state.merchant_id;
        request_data["merchant_token"] = this.state.merchant_token;
        request_data["siteid"] = this.state.siteid;
      }     

      const requestOptions = {
        method: 'PUT',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(request_data)
      };
      fetch(this.props.api_url+'/ebay_account/'+this.state.account_id+'?api_token='+this.props.store_data.user.api_token,requestOptions)
      .then(response => response.json())
      .then((data) => {
        console.log(data);
        if(data && data.status && data.status === "success"){
          if(this.props.form_type === "app_setup"){
            this.props.updateInstallStep("done");
          }
          else{
            if(this._isMounted){
              this.setState({button_loading:false,success_message:data.msg});
            }
          }
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data && data.status && data.status === "error"){
            if(data.errors){
              for(var key in data.errors){
                error_message += key + " : ";
                for(var fkey in data.errors[key]){
                  error_message += data.errors[key][fkey] + "\n";
                }
                error_message += "\n";
              }
            }
            else if(data.msg){
              error_message = data.msg;
            }
          }
        }
        if(this._isMounted){
          this.setState({
            button_loading:false,
            error_message:error_message
          });
        }
      })
      .catch(error => {
        console.error(error);
      });
    }
    else{
      this.setState({
        button_loading:false
      });
    }
  }

  handleChange = (field) => {
    return (value) => {
      if(value.length <= 0){
        this.errors_data[field+"_error"] = field.replace(/_/g," ") + " is required";
      }
      else{
        this.errors_data[field+"_error"] = null;
      }
      this.setState({ [field]: value });
    }
  };

  render(){
    return (
      <Page title={this.state.page_title}>
        <Layout>
          <Layout.Section>
            {this.state.error_message &&
              <Banner title="Error" status="critical"><p>{this.state.error_message}</p></Banner>
            }
            {this.state.success_message &&
              <Banner title="Success" status="success"><p>{this.state.success_message}</p></Banner>
            }
          </Layout.Section>
          <Layout.AnnotatedSection title={this.state.sub_title} description={this.state.sub_description}>
            <Card sectioned>
              <Form onSubmit={this.updateConfiguration} method="post" preventDefault="true">
                <FormLayout>

                  {this.props.form_type !== "app_setup" &&
                  <Checkbox label="Re-configure ebay account details" checked={this.state.reconfigure_ebay_account} onChange={this.handleChange('reconfigure_ebay_account')} />
                  }

                  {this.state.reconfigure_ebay_account &&

                  <div>
                    <Select label="Ebay Site" options={this.ebaySiteList} error={this.errors_data.siteid_error} onChange={this.handleChange('siteid')} value={this.state.siteid} />
                  </div>

                  }

                  <Checkbox label="Automatic SKU Creation" checked={this.state.automatic_sku_creation} onChange={this.handleChange('automatic_sku_creation')} />

                  <Checkbox label="Threshold Inventory" checked={this.state.threshold_quantity} onChange={this.handleChange('threshold_quantity')} />

                  {this.state.threshold_quantity &&
                  <TextField type="number" min="0" label="Threshold Quantity Value" error={this.errors_data.threshold_quantity_value_error} value={this.state.threshold_quantity_value} onChange={this.handleChange('threshold_quantity_value')} />
                  }

                  <Checkbox label="Pricing Mark-up" checked={this.state.pricing_mark_up} onChange={this.handleChange('pricing_mark_up')} />

                  {this.state.pricing_mark_up &&
                  <Select label="Pricing Mark-up Type" options={this.pricingMarkUpTypeOptions} error={this.errors_data.pricing_mark_up_type_error} onChange={this.handleChange('pricing_mark_up_type')} value={this.state.pricing_mark_up_type} />
                  }

                  {this.state.pricing_mark_up &&
                  <TextField type="number" label="Pricing Mark-up Value" error={this.errors_data.pricing_mark_up_value_error} value={this.state.pricing_mark_up_value} onChange={this.handleChange('pricing_mark_up_value')} />
                  }

                  <Checkbox label="Import Orders From Ebay" checked={this.state.order_sync} onChange={this.handleChange('order_sync')} />

                  <Stack distribution="trailing">
                    <Button primary submit loading={this.state.button_loading}>Done</Button>
                  </Stack>
                </FormLayout>
              </Form>
            </Card>
          </Layout.AnnotatedSection>
          <Layout.Section>
            <FooterHelp>
              For more details on App, visit our{' '}
              <Link url="https://app1.ecomshore.com/step4.pdf" external="true">documentation</Link>.
            </FooterHelp>
          </Layout.Section>
        </Layout>
      </Page>
    );
  }
}

export default EbayAccountConfiguration;