import React from 'react';

class NumericPagination extends React.Component {
  render() {
    const { currentPage, totalPages, onPageChange, pageRangeDisplayed } = this.props;
    const pages = [];
    const halfRange = Math.floor(pageRangeDisplayed / 2);
    let startPage = Math.max(1, currentPage - halfRange);
    let endPage = Math.min(totalPages, currentPage + halfRange);

    if (endPage - startPage + 1 < pageRangeDisplayed) {
      if (currentPage <= halfRange) {
        endPage = Math.min(totalPages, startPage + pageRangeDisplayed - 1);
      } else {
        startPage = Math.max(1, endPage - pageRangeDisplayed + 1);
      }
    }

    for (let i = startPage; i <= endPage; i++) {
      pages.push(
        <button
          key={i}
          className={currentPage === i ? 'currentPageButton' : 'numberButton'}
          onClick={() => onPageChange(i)}
        >
          {i}
        </button>
      );
    }

    return (
      <div className="numericPagination">
        {pages}
      </div>
    );
  }
}

export default NumericPagination;
