import React, {Component} from 'react';

import {Page, Button, Layout, Card, DataTable, Checkbox, ChoiceList, Filters, Banner, Popover, ActionList, Pagination, FooterHelp, Link, Badge} from '@shopify/polaris';

import {ImportMinor} from '@shopify/polaris-icons';

class Orders extends Component
{
  _isMounted = false;
  
  state = {
    orders:{},
    actions:{},
    checkboxes:{},
    queryValue:"",
    queryType:"",
    orderStatus:"",
    appliedFilters : [],
    hasActiveCheckBox : false,
    lastQueryType: "",
    sortBy:"order_date",
    sortOrder:"desc",
  };

  constructor(props){
    super(props);
    this.getOrders = this.getOrders.bind(this);
    this.getOrdersData = this.getOrdersData.bind(this);
    // this.toggleAction = this.toggleAction.bind(this);
    // this.toggleCheckbox = this.toggleCheckbox.bind(this);

    this.handleQueryChange = this.handleQueryChange.bind(this);
    this.handleOrderStatusChange = this.handleOrderStatusChange.bind(this);
    this.handleQueryTypeChange = this.handleQueryTypeChange.bind(this);
    this.handleQueryRemove = this.handleQueryRemove.bind(this);
    this.handleFiltersClearAll = this.handleFiltersClearAll.bind(this);

    this.clearQueryTypeChange = this.clearQueryTypeChange.bind(this);
    this.clearOrderStatusChange = this.clearOrderStatusChange.bind(this);
    this.handleSort = this.handleSort.bind(this);
    
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;
    document.title = 'Orders - ' + document.title;
    this.getOrders();
  }

  getOrders(pageno=1){
    if(this._isMounted === true){
      var queryData = [];
      
      if(this.state.queryValue && this.state.queryValue.length > 0){
        if(this.state.queryType.length > 0){queryData.push(this.state.queryType + "=" + this.state.queryValue);}
        else{queryData.push("order_id=" + this.state.queryValue);}
      }
      if(this.state.orderStatus && this.state.orderStatus.length > 0){queryData.push("status=" + this.state.orderStatus);}
      queryData.push("sort_by=" + this.state.sortBy);
      queryData.push("sort_order=" + this.state.sortOrder);
      queryData.push("page=" + pageno);
      queryData.push("shopify_url=" + this.props.store_data.shopify_url);
      queryData.push("api_token=" + this.props.store_data.user.api_token);
      var queryStr = queryData.join("&");
      fetch(this.props.api_url+'/orders?'+queryStr)
      .then(res => res.json())
      .then((data) => {
        this.setState({ orders: data });
      })
      .catch(console.log);
    }
  }

  handleSort(colind){
    var sortBy = this.state.sortBy;
    var sortOrder = this.state.sortOrder;
    if(colind === 1){sortBy = "order_id";}
    else if(colind === 2){sortBy = "order_date";}

    if(sortOrder === "asc"){sortOrder = "desc";}
    else{sortOrder = "asc";}

    this.setState({sortBy: sortBy,sortOrder: sortOrder},() => {
      this.getOrders();
    });
  }

  handleQueryTypeChange(value){
    var queryType = value[0] || "";
    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "queryType"){fk = key;}}
    var filterObj = {key: 'queryType',label: "Query Type : " + queryType,onRemove: this.clearQueryTypeChange};
    if(fk && fk !== null){
      appliedFilters[fk] = filterObj;
    }
    else{appliedFilters.push(filterObj);}
    this.setState({appliedFilters: appliedFilters,queryType: queryType,lastQueryType:queryType},() => {
      this.getOrders();
    });
    
  }

  clearQueryTypeChange(){
    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "queryType"){fk = key;}}
    if(fk && fk !== null){appliedFilters.splice(fk,1);}

    fk = null;
    for(key in appliedFilters){if(appliedFilters[key]["key"] === "queryValue"){fk = key;}}
    if(fk && fk !== null){appliedFilters.splice(fk,1);}

    this.setState({appliedFilters: appliedFilters,queryType: "",queryValue: ""},() => {
      this.getOrders();
    });
    
  }

  handleOrderStatusChange(value){
    var orderStatus = value[0] || "";

    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "orderStatus"){fk = key;}}
    var filterObj = {key: 'orderStatus',label: "Status : " + orderStatus,onRemove: this.clearOrderStatusChange};
    if(fk && fk !== null){appliedFilters[fk] = filterObj;}
    else{appliedFilters.push(filterObj);}
    this.setState({appliedFilters: appliedFilters,orderStatus: orderStatus},() => {
      this.getOrders();
    });
    
  }

  clearOrderStatusChange(){
    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "orderStatus"){fk = key;}}
    if(fk && fk !== null){appliedFilters.splice(fk,1);}
    this.setState({appliedFilters: appliedFilters,orderStatus: ""},() => {
      this.getOrders();
    });
  }

  handleQueryChange(value){
    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "queryValue"){fk = key;}}

    if(!value || value.length === 0){
      if(fk && fk !== null){appliedFilters.splice(fk,1);}
      fk = null;
      for(key in appliedFilters){if(appliedFilters[key]["key"] === "queryType"){fk = key;}}
      if(fk && fk !== null){appliedFilters.splice(fk,1);}
    }
    else{
      var filterObj = {key: 'queryValue',label: "Query : " + value,onRemove: this.handleQueryRemove};
      if(fk && fk !== null){appliedFilters[fk] = filterObj;}
      else{appliedFilters.push(filterObj);}

      fk = null;
      for(key in appliedFilters){if(appliedFilters[key]["key"] === "queryType"){fk = key;}}
      if(!fk || fk === null){
        var queryType = this.state.lastQueryType;
        if(!queryType || queryType === "" || queryType.length === 0){queryType = "orderid";}
        filterObj = {key: 'queryType',label: "Query Type : " + queryType,onRemove: this.clearQueryTypeChange};
        appliedFilters.push(filterObj);
        this.setState({queryType: queryType});
      }
    }
    this.setState({queryValue: value,appliedFilters: appliedFilters},() => {
      this.getOrders();
    });
  }

  handleQueryRemove(){
    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "queryValue"){fk = key;}}
    if(fk && fk !== null){appliedFilters.splice(fk,1);}

    fk = null;
    for(key in appliedFilters){if(appliedFilters[key]["key"] === "queryType"){fk = key;}}
    if(fk && fk !== null){appliedFilters.splice(fk,1);}

    this.setState({queryValue: "",queryType: "",appliedFilters: appliedFilters},() => {
      this.getOrders();
    });
  }
  
  handleFiltersClearAll(value){
    this.setState({appliedFilters: [],queryValue: null,queryType: "",orderStatus: ""},() => {
      this.getOrders();
    });
  }

  // toggleAction(value){
  //   var actions = this.state.actions;
  //   if(actions[value]){
  //     actions[value] = false;
  //   }
  //   else{
  //     actions[value] = true;
  //   }
  //   this.setState({ actions: actions });
  // }

  toggleCheckbox(value){
    var checkboxes = this.state.checkboxes;
    if(checkboxes[value]){
      checkboxes[value] = false;
    }
    else{
      checkboxes[value] = true;
    }
    this.setState({ checkboxes: checkboxes });
    var hasActiveCheckBox = false;
    for(var key in checkboxes){
      if(checkboxes[key] === true){
        hasActiveCheckBox = true;
        break;
      }
    }
    this.setState({ hasActiveCheckBox: hasActiveCheckBox });
  }

  getOrdersData(){
    var activator,checkbox;
    var filters = [
      {
        key: 'queryType',
        label: 'Query Type',
        filter: (
          <ChoiceList
            title="Query Type"
            titleHidden
            choices={[
              {label: 'Order ID', value: 'orderid'},
              {label: 'Order Date', value: 'orderdate'}
            ]}
            selected={this.state.queryType || ""}
            onChange={this.handleQueryTypeChange}
          />
        ),
        shortcut: true,
      },
      {
        key: 'orderStatus',
        label: 'Order Status',
        filter: (
          <ChoiceList
            title="Order Status"
            titleHidden
            choices={[
              {label: 'Pending', value: 'pending'},
              {label: 'Shipped', value: ' shipped'},
              {label: 'UnShipped', value: 'unshipped'},
              {label: 'Processed', value: 'processed'},
              {label: 'Cancelled', value: 'cancelled'},
            ]}
            selected={this.state.orderStatus || ""}
            onChange={this.handleOrderStatusChange}
          />
        ),
      }
    ];

    const rows = [];
    if(this.state.orders && this.state.orders.total > 0){
      for(var key in this.state.orders.data){
        var order = this.state.orders.data[key];

        // activator = <Button onClick={this.toggleAction.bind(this,order.id)} disclosure>Actions</Button>;
        // checkbox = <Checkbox checked={this.state.checkboxes[order.id]} onChange={this.toggleCheckbox.bind(this,order.id)} />;

        var status;
        if((order.status).toLowerCase() === "shipped"){
          status = <Badge progress="complete">Fulfilled</Badge>;
        }
        else if((order.status).toLowerCase() === "pending"){
          status = <Badge progress="incomplete" status="warning">Pending</Badge>;
        }
        else if((order.status).toLowerCase() === "unshipped"){
          status = <Badge progress="incomplete" status="attention">Unfulfilled</Badge>;
        }
        else if((order.status).toLowerCase() === "partiallyshipped"){
          status = <Badge progress="partiallyComplete" status="attention">Unfulfilled</Badge>;
        }
        else if((order.status).toLowerCase() === "canceled"){
          status = <Badge progress="incomplete" status="critical">Canceled</Badge>;
        }

        rows.push([
         // <div style={{width: '20px'}}>{checkbox}</div>,
          <Link url={this.props.base_url + "/orders/" + order.id}>{order.order_id}</Link>,
          order.order_date_str,
          status,
          // <div>
          //   <Popover active={this.state.actions[order.id]} activator={activator} onClose={this.toggleAction.bind(this,order.id)}>
          //     <ActionList
          //       items={[
          //         {
          //           content: 'Import file',
          //           icon: ImportMinor,
          //           onAction: this.toggleAction
          //         },
          //         {
          //           content: 'Export file',
          //           icon: ImportMinor,
          //           onAction: this.toggleAction
          //         },
          //       ]}
          //     />
          //   </Popover>
          // </div>
        ]);
      }
      //this.setState({active: active});
    }
    //activator = <Button onClick={this.toggleAction.bind(this,"common")} disclosure>Actions</Button>;
    var currentPage = 1;
    var hasNext = false;
    var nextPage = 0;
    var hasPrevious = false;
    var previousPage = 0;
    if(this.state.orders){
      currentPage = this.state.orders.current_page;
      if(this.state.orders.next_page_url){
        hasNext = true;
        nextPage = currentPage + 1;
      }
      if(this.state.orders.prev_page_url){
        hasPrevious = true;
        previousPage = currentPage - 1;
      }      
    }
    return (
      <Page fullWidth="true" title="Ebay Orders">
        <Card>
          <Card.Section>
            <Filters
              queryValue={this.state.queryValue}
              filters={filters}
              appliedFilters={this.state.appliedFilters}
              onQueryChange={this.handleQueryChange}
              onQueryClear={this.handleQueryRemove}
              onClearAll={this.handleFiltersClearAll}
            />
            {/* {this.state.hasActiveCheckBox &&
            <div>
              <br />
              <Popover active={this.state.actions["common"]} activator={activator} onClose={this.toggleAction.bind(this,"common")}>
                <ActionList
                  items={[
                    {
                      content: 'Publish',
                      icon: ImportMinor,
                      onAction: this.toggleAction
                    },
                    {
                      content: 'Unpublish',
                      icon: ImportMinor,
                      onAction: this.toggleAction
                    },
                  ]}
                />
              </Popover>
            </div>
            } */}
          </Card.Section>
          
          <DataTable
            columnContentTypes={[
              'text',
              'text',
              'text'
            ]}
            headings={[
              'Order ID',
              'Date',
              'Status',
            ]}
            rows={rows}
            sortable={[false,true,true,false,false]}
            defaultSortDirection="descending"
            initialSortColumnIndex={2}
            onSort={this.handleSort}
            truncate="true"
            footerContent={`Showing from ${this.state.orders.from || 0} to ${this.state.orders.to || 0} of total ${this.state.orders.total || 0}`}
          />


          {rows && rows.length > 0 &&
          <Card.Section align="center">
            <Pagination
              hasPrevious={hasPrevious}
              previousKeys={[74]}
              previousTooltip={previousPage}
              onPrevious={() => {
                console.log('Previous');
                this.getOrders(previousPage);
              }}
              hasNext={hasNext}
              nextKeys={[75]}
              nextTooltip={nextPage}
              onNext={() => {
                console.log('Next');
                this.getOrders(nextPage);
              }}
            />
          </Card.Section>
          }
        </Card>
      </Page>
    );
  }
  
  render(){
    return(
      <Layout>
        <Layout.Section>
          <Page title="" fullWidth="true">
            {this.state.error_message &&
            <Banner title="Error" status="critical"><p>{this.state.error_message}</p></Banner>
            }
            {this.state.success_message &&
            <Banner title="Success" status="success"><p>{this.state.success_message}</p></Banner>
            }
          </Page>
        </Layout.Section>
        <Layout.Section>
          {this.getOrdersData()}
          <FooterHelp>
               For more details on App, visit our {' '}
              <Link url="https://app1.ecomshore.com/Manage_Orders.pdf" external="true">documentation</Link>.
            </FooterHelp>
        </Layout.Section>
      </Layout>
    );
  }
}

export default Orders;