import React, { Component } from "react";
import {
  Page,
  EmptyState,
  Button,
  Layout,
  Popover,
  ActionList,
  Card,
  DataTable,
  Banner,
  Icon,
  buttonFrom,
  Select,
} from "@shopify/polaris";
import {
  EditMajorMonotone,
  FolderUpMajorMonotone,
  DeleteMajorMonotone,
} from "@shopify/polaris-icons";
class Policies extends Component {
  _isMounted = false;
  state = {
    policies: {},
    spinner: true,
    empty: false,
  };
  constructor(props) {
    super(props);
    this.getPoliciesData = this.getPoliciesData.bind(this);
    this.confirmDelete = this.confirmDelete.bind(this);
    this.getPolicies = this.getPolicies.bind(this);
    this.handleImportedAction = this.handleImportedAction.bind(this);
    this.handleImportedAction2 = this.handleImportedAction2.bind(this);
    this.handleImportedAction3 = this.handleImportedAction3.bind(this);
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  getPolicies() {
    fetch(
      this.props.api_url +
        "/policies?shopify_url=" +
        this.props.store_data.shopify_url +
        "&api_token=" +
        this.props.store_data.user.api_token
    )
      .then((res) => res.json())
      .then((data) => {
        
        this.setState({ spinner: false });
        if (data[0] === "error_occured") {
          this.setState({ empty: true });
        } else {
          // const data1 = data.data;
          //  console.log("data1",data);
          this.setState(() => {
            return{
             policies: data 
            }
          });
        }
      })
      .catch(console.log);
  }
  componentDidMount() {
    this._isMounted = true;
    document.title = "Policies - " + document.title;
    this.getPolicies();
    this.state = {
      popoverActive: true,
    };
    this.togglePopoverActive = this.togglePopoverActive.bind(this);
    // this.fetchBusinessPolicies();
  }
  togglePopoverActive() {
    this.setState((prevState) => ({
      popoverActive: !prevState.popoverActive,
    }));
  }
  handleSort() {
    console.log("sorting...");
  }
  handleAvailabilityChange(value) {
    console.log(value);
  }
  handleProductTypeChange(value) {
    console.log(value);
  }
  handleTaggedWithChange(value) {
    console.log(value);
  }
  handleFiltersQueryChange(value) {
    console.log(value);
  }
  handleQueryValueRemove(value) {
    console.log(value);
  }
  handleFiltersClearAll(value) {
    console.log(value);
  }
  confirmDelete(policy_id) {
    this.setState({ error_message: null });
    this.setState({ success_message: null });
    console.log("delete policy");
    var confirm = window.confirm("Are you sure, you want to delete?");
    if (confirm) {
      var fetch_url =
        this.props.api_url +
        "/policies/" +
        policy_id +
        "?shopify_url=" +
        this.props.store_data.shopify_url +
        "&api_token=" +
        this.props.store_data.user.api_token;
      var requestOptions = {
        method: "DELETE",
      };
      fetch(fetch_url, requestOptions)
        .then((response) => response.json())
        .then((data) => {
          console.log(data);
          if (data && data.status && data.status === "success") {
            if (this._isMounted) {
              this.setState({ success_message: data.msg });
              this.getPolicies();
            }
          } else {
            var error_message = "there was something wrong, please try again.";
            if (data.msg) {
              error_message = data.msg;
            }
          }
          if (this._isMounted) {
            this.setState({ error_message: error_message });
          }
        })
        .catch((error) => {
          console.error(error);
        });
    }
  }
  fetchBusinessPolicies = () => {
    var fetch_url =
      this.props.api_url +
      "/fetch_profiles?shopify_url=" +
      this.props.store_data.shopify_url +
      "&api_token=" +
      this.props.store_data.user.api_token;
    var requestOptions = {
      method: "GET",
      headers: { "Content-Type": "application/json" },
    };
    fetch(fetch_url, requestOptions)
      .then((response) => response.json())
      .then((data) => {
        this.setState(() => {
          return {
            fetch_profile_text: "Fetching Done",
          };
        });
        setTimeout(function () {
          this.setState(() => {
            return {
              fetch_profile_text: "Fetch Business Policies",
            };
          });
        }, 5000);
       // console.log(data);
        this.setState({ button_loading: false, success_message: "" });
        var ckey;
        this.setState({
          button_loading: false,
          success_message: "request has been submitted",
        });
        if (data.shipping_profiles.length != 0) {
          //console.log("entered in the fetch business poilcy function");
          this.state.symbol_policy = true;
          var shipping_profiles = [
            { label: "Select a Shipping Profile", value: "" },
          ];
          //shipping_profiles = shipping_profiles.slice(1);
          for (ckey in data.shipping_profiles) {
            shipping_profiles.push({
              label: data.shipping_profiles[ckey].name,
              value: data.shipping_profiles[ckey].id.toString(),
            });
          }
        } else {
          var shipping_profiles = [
            {
              label: "Please add Shipping policiy to your eBay account",
              value: "",
            },
          ];
        }
        // var shipping_profiles = [{ label: "Select a Shipping Profile", value: "" }];
        // for (ckey in data.shipping_profiles) {
        //   shipping_profiles.push({ label: data.shipping_profiles[ckey].name, value: (data.shipping_profiles[ckey].id).toString() });
        // }
        if (data.payment_profiles.length != 0) {
          // console.log(data.payment_profiles);
          this.state.symbol_policy = true;
          var payment_profiles = [
            { label: "Select a Payment Profile", value: "" },
          ];
          // payment_profiles = payment_profiles.slice(1);
          for (ckey in data.payment_profiles) {
            payment_profiles.push({
              label: data.payment_profiles[ckey].name,
              value: data.payment_profiles[ckey].id.toString(),
            });
          }
        } else {
          var payment_profiles = [
            {
              label: "Please add Payment policiy to your eBay account",
              value: "",
            },
          ];
        }
        // var payment_profiles = [{ label: "Select a Payment Profile", value: "" }];
        // for (ckey in data.payment_profiles) {
        //   payment_profiles.push({ label: data.payment_profiles[ckey].name, value: (data.payment_profiles[ckey].id).toString() });
        // }
        if (data.return_profiles.length != 0) {
          // console.log(data.return_profiles);
          this.state.symbol_policy = true;
          var return_profiles = [
            { label: "Select a Return Profile", value: "" },
          ];
          // return_profiles = return_profiles.slice(1);
          for (ckey in data.return_profiles) {
            return_profiles.push({
              label: data.return_profiles[ckey].name,
              value: data.return_profiles[ckey].id.toString(),
            });
          }
        } else {
          var return_profiles = [
            {
              label: "Please add Return policiy to your eBay account",
              value: "",
            },
          ];
        }
        this.setState({ button_loading: false, success_message: null });
        // var return_profiles = [{ label: "Select a Return Profile", value: "" }];
        // for (ckey in data.return_profiles) {
        //   return_profiles.push({ label: data.return_profiles[ckey].name, value: (data.return_profiles[ckey].id).toString() });
        // }
        this.setState(() => {
          return {
            shipping_profiles: shipping_profiles,
            // shipping_profiles_msg:shipping_profiles_msg,
            payment_profiles: payment_profiles,
            // payment_profiles_msg:payment_profiles_msg,
            return_profiles: return_profiles,
            // return_profiles_msg:return_profiles_msg,
          };
        });
        window.location.reload();
      })
      .catch((error) => {
        console.error(error);
      });
  };
  getPoliciesData() {
   
    const rows = [];
    if (this.state.policies && this.state.policies.total > 0) {
      
      for (var key in this.state.policies.data) {
        var policy = this.state.policies.data[key];
        //console.log("hihihhhhhh",policy.type);
        rows.push([
          policy.name,
          policy.type,
          <div>
            <Button
              id={"del_policy_" + policy.id}
              onClick={this.confirmDelete.bind(this, policy.id)}
              destructive
            >
              <Icon source={DeleteMajorMonotone} />
            </Button>
          </div>,
        ]);
      }
    }
    return (
      <>
        {!this.getPolicies ? (
        <>
                <Page fullWidth="true" title="Policies">
                  <Card>
                    <Card.Section>
                    <Card.Section>
                      <EmptyState
                      heading=""						
                      image="https://cdn.shopify.com/s/files/1/0262/4071/2726/files/emptystate-files.png"
                      >
                      <p>
                      No Policies Found , Please
                      Add Policies .
                      </p>						
                      </EmptyState>
                      </Card.Section>
                    </Card.Section>						
                  </Card>
                </Page>
                </>
        ) : (
        <Page
                fullWidth="true"
                title="Policies"
                //  primaryAction= {<Button variant="primary" disclosure="select" onClick={() => console.log('Open Popover')}>Select options </Button>}
                // primaryAction={{content: 'Add Policy',url:this.props.base_url + '/policies/new'}}
              >
                <Card>
                  <DataTable
                    columnContentTypes={["text", "text", "text"]}
                    headings={["Name", "Type", "Action"]}
                    rows={rows}
                    sortable={[true, false]}
                    defaultSortDirection="ascending"
                    initialSortColumnIndex={1}
                    onSort={this.handleSort}
                  />
                </Card>
              </Page>
        )}
        </>
    );
  }

handleImportedAction() {
    window.open(
        "https://www.bizpolicy.ebay.com/businesspolicy/shipping?pageNumber=1&totalPages=1&source=manage",
        "_blank"
    );
}

handleImportedAction2(){
  window.open(
      "https://www.bizpolicy.ebay.com/businesspolicy/payment?pageNumber=1&totalPages=1&source=manage",
      "_blank"
  );
}

handleImportedAction3(){
  window.open(
      "https://www.ebay.com/bp/rtn/create",
      "_blank"
  );
}

  render() {
    const activator = (
      <Button onClick={this.togglePopoverActive} disclosure>
        Create Policy
      </Button>
    );
    return (
      <Layout>
        <Layout.Section>
          <Page title="" fullWidth="true">
            {this.state.error_message && (
              <Banner title="Error" status="critical">
                <p>{this.state.error_message}</p>
              </Banner>
            )}
            {this.state.success_message && (
              <Banner title="Success" status="success">
                <p>{this.state.success_message}</p>
              </Banner>
            )}
          </Page>
        </Layout.Section>
        <Layout.Section>
          <div
            className="topButton"
            style={{ height: "25px", padding: "0 35px 0 0px" }}
          >
            <Popover
              active={this.state.popoverActive}
              activator={activator}
              autofocusTarget="first-node"
              onClose={this.togglePopoverActive}
            >
              {
                <ActionList actionRole="menuitem"
                items={[
                    {
                        content: 'Shipping',
                        onAction: this.handleImportedAction,
                    },
                    {
                        content: 'Payment',
                        onAction: this.handleImportedAction2,
                    },
                    {
                      content: 'Return',
                      onAction: this.handleImportedAction3,
                    }
                ]} />
              }
            </Popover>
            <Button onClick={this.fetchBusinessPolicies}>
              Fetch eBay Policy
            </Button>
          </div>
          {this.getPoliciesData()}
        </Layout.Section>
      </Layout>
    );
  }
}
export default Policies;