import React, { Component } from "react";
import {
	Icon,
	Page,
	Button,
	Layout,
	Card,
	DataTable,
	Checkbox,
	ChoiceList,
	Filters,
	Banner,
	Thumbnail,
	Popover,
	ActionList,
	Pagination,
	Modal,
	Stack,
	Select,
	Spinner,
	Toast,
	Link,
	Badge,
	FooterHelp,
	EmptyState,
} from "@shopify/polaris";
import {
	DeleteMajorMonotone,
	FolderUpMajorMonotone,
	EditMajorMonotone,
} from "@shopify/polaris-icons";
import DataModal from "./DataModal";

import NumericPagination from './NumericPagination';



class Products extends Component {
	_isMounted = false;

	state = {
		
		products: {},
		actions: {},
		checkboxes: {},
		singlepublish:"",
		queryValue: "",
		queryType: "",
		productStatus: "",
		appliedFilters: [],
		hasActiveCheckBox: false,
		lastQueryType: "",
		sortBy: "updated_at",
		sortOrder: "asc",
		showPublishModel: false,
		showPublishModelOne: false,
		productid:"",
		quantityvalue:"",
		showPublishModel_All: false,
		showPublishModel_Unpublish: false,
		showPublishModel_Publish: false,
		loadingProfiles: false,
		profile_id: "",
		showVariationList: false,
		submitProductSuccMsg: null,
		submitProductErrMsg: null,
		submitProductLoading: false,
		actionLoading: false,
		actionSuccMsg: null,
		actionErrMsg: null,
		checkboxhovermsg:null,
		paction_loading: false,
		showDefaultPagination: true,
		showAlternativePagination: false,
		currentPage: 1,
		totalPages: 1,
		loading: true,
		activePage: 15,
		BulkPublishprofileid: "",
		searchdata: ""
		
	};

	errors_data = {};

	handlePageChange(pageNumber) {
		console.log(`active page is ${pageNumber}`);
		this.setState({activePage: pageNumber});
	}

	constructor(props) {
		super(props);
		this.getProducts = this.getProducts.bind(this);
		this.getProductsData = this.getProductsData.bind(this);
		this.toggleAction = this.toggleAction.bind(this);
		this.toggleCheckbox = this.toggleCheckbox.bind(this);
		this.handleChange = this.handleChange.bind(this);
        this.handleChange_All = this.handleChange_All.bind(this);
        this.handleChange_Unpublish = this.handleChange_Unpublish.bind(this);
        this.handleChange_Publish = this.handleChange_Publish.bind(this);
		this.showVariationPopup = this.showVariationPopup.bind(this);
		this.handleQueryChange = this.handleQueryChange.bind(this);
		this.handleProductStatusChange =this.handleProductStatusChange.bind(this);
		this.handleQueryTypeChange = this.handleQueryTypeChange.bind(this);
		this.handleQueryRemove = this.handleQueryRemove.bind(this);
		this.handleFiltersClearAll = this.handleFiltersClearAll.bind(this);

		this.clearQueryTypeChange = this.clearQueryTypeChange.bind(this);
		this.clearProductStatusChange = this.clearProductStatusChange.bind(this);
		this.handleSort = this.handleSort.bind(this);
		this.checkboxhovermethod = this.checkboxhovermethod.bind(this);
		

		this.showPublishRequestModel = this.showPublishRequestModel.bind(this);
		this.showPublishRequestModelOne = this.showPublishRequestModelOne.bind(this);
        this.showPublishRequestModel_All = this.showPublishRequestModel_All.bind(this);
        this.showPublishRequestModel_Unpublish = this.showPublishRequestModel_Unpublish.bind(this);
        this.showPublishRequestModel_publish = this.showPublishRequestModel_publish.bind(this);
        

		this.submitPublishRequest = this.submitPublishRequest.bind(this);
		this.submitPublishRequestOne =this.submitPublishRequestOne.bind(this);
        this.submitPublishRequestForPublishAll = this.submitPublishRequestForPublishAll.bind(this);
        this.submit_PublishUnpublishproducts_Request = this.submit_PublishUnpublishproducts_Request.bind(this);
        this.submit_UpdateAllPublished_Request = this.submit_UpdateAllPublished_Request.bind(this);
        
		
		this.cancelPublishRequest = this.cancelPublishRequest.bind(this);
		// this.BulkPublish = this.BulkPublish.bind(this);
		// this.BulkPublishAllProduct = this.BulkPublishAllProduct.bind(this);
		// this.UpdateBulkPublishAllProduct = this.UpdateBulkPublishAllProduct.bind(this);
		this.hideToast = this.hideToast.bind(this);
		this.submitDeleteProducts = this.submitDeleteProducts.bind(this);

		this.submitProductsImportRequest =
			this.submitProductsImportRequest.bind(this);

		this.handleNextPage = this.handleNextPage.bind(this);
		this.handlePrevPage = this.handlePrevPage.bind(this);
	}

	profileOptions = [];
	profileOptions_All = [];
	profileOptions_Unpublish = [];
	profileOptions_Publish = [];

	componentWillUnmount() {
		this._isMounted = false;
	}

	componentDidMount() {
		this._isMounted = true;
		document.title = "Products - " + document.title;
		this.getProducts();
		this.state = {
			popoverActive: true,
		};
		this.togglePopoverActive = this.togglePopoverActive.bind(this);
	}
	
    togglePopoverActive() {
		this.setState((prevState) => ({
			popoverActive: !prevState.popoverActive,
		}));
	}

	hideModel = () => {
		this.setState(function () {
			return { show_mode: false };
		});
	};

	submitPublishRequest() {
		if (this.state.submitProductLoading === false) {
			var productIds = [];
			for (var key in this.state.checkboxes) {
				if (this.state.checkboxes[key] === true) {
					productIds.push(key);
					console.log("this is the id ",key);
				}
			}

			if (productIds.length > 0 && this.state.profile_id) {
				this.setState({
					submitProductLoading: true,
					submitProductSuccMsg: null,
					submitProductErrMsg: null,
				});

				var request_data = {
					ids: productIds,
					profile_id: this.state.profile_id,
					shopify_url: this.props.store_data.shopify_url,
				};

				var requestOptions = {
					method: "POST",
					headers: { "Content-Type": "application/json" },
					body: JSON.stringify(request_data),
				};
				var fetch_url =
					this.props.api_url +
					"/submitpublishrequest?api_token=" +
					this.props.store_data.user.api_token;

				fetch(fetch_url, requestOptions)
					.then((response) => response.json())
					.then((data) => {
						if (data && data.status && data.status === "success") {
							console.log("count -> ",data.count);
							return;
							this.setState({
								submitProductLoading: false,
								submitProductSuccMsg: data.msg,
								showPublishModel: false,
								hasActiveCheckBox: false,
								checkboxes: {},
							});
						} else {
							if (data.errors) {
								let model_content = "";
								if (data.errors_data) {
									model_content = data.errors_data;
								} else if (data.errors.Errors) {
									for (var ekey in data.errors.Errors) {
										model_content =
											model_content +
											"<p>" +
											data.errors.Errors[ekey]
												.LongMessage +
											"</p>";
									}
								} else {
									model_content =
										"<p>" + data.errors + "</p>";
								}

								this.setState(() => {
									return {
										hasActiveCheckBox: false,
										checkboxes: {},
										submitProductLoading: false,
										showPublishModel: false,
										show_mode: true,
										model_title: "Verify Add Item Errors",
										model_content: model_content,
									};
								});
							}

							var error_message =
								"there was something wrong, please try again.";
							if (data.msg) {
								error_message = data.msg;
							}
							this.setState({
								submitProductLoading: false,
								submitProductErrMsg: error_message,
							});
						}
					})
					.catch((error) => {
						console.error(error);
					});
			} else {
				alert("please select both profile and products to submit");
			}
		}
	}
	submitPublishRequestOne(id) {
		if (this.state.submitProductLoading === false) {
			var productIds =[] ;
			productIds.push(id);
			console.log("hello",productIds);
			

			if (productIds.length > 0 && this.state.profile_id) {
				this.setState({
					submitProductLoading: true,
					submitProductSuccMsg: null,
					submitProductErrMsg: null,
				});

				var request_data = {
					ids: productIds,
					profile_id: this.state.profile_id,
					shopify_url: this.props.store_data.shopify_url,
				};

				var requestOptions = {
					method: "POST",
					headers: { "Content-Type": "application/json" },
					body: JSON.stringify(request_data),
				};
				var fetch_url =
					this.props.api_url +
					"/submitpublishrequest?api_token=" +
					this.props.store_data.user.api_token;

				fetch(fetch_url, requestOptions)
					.then((response) => response.json())
					.then((data) => {
						if (data && data.status && data.status === "success") {
							this.setState({
								submitProductLoading: false,
								submitProductSuccMsg: data.msg,
								showPublishModelOne: false,
								hasActiveCheckBox: false,
								//checkboxes: {},
							});
						} else {
							if (data.errors) {
								let model_content = "";
								if (data.errors_data) {
									model_content = data.errors_data;
								} else if (data.errors.Errors) {
									for (var ekey in data.errors.Errors) {
										model_content =
											model_content +
											"<p>" +
											data.errors.Errors[ekey]
												.LongMessage +
											"</p>";
									}
								} else {
									model_content =
										"<p>" + data.errors + "</p>";
								}

								this.setState(() => {
									return {
										hasActiveCheckBox: false,
										//checkboxes: {},
										submitProductLoading: false,
										showPublishModelOne: false,
										show_mode: true,
										model_title: "Verify Add Item Errors",
										model_content: model_content,
									};
								});
							}

							var error_message =
								"there was something wrong, please try again.";
							if (data.msg) {
								error_message = data.msg;
							}
							this.setState({
								submitProductLoading: false,
								submitProductErrMsg: error_message,
							});
						}
					})
					.catch((error) => {
						console.error(error);
					});
			} else {
				alert("please select both profile and products to submit");
			}
		}
	}
    submitPublishRequestForPublishAll() {
        console.log("submitPublishRequestForPublishAll ",this.state.profile_id);
		if (this.state.submitProductLoading === false) {
			var productIds = [];
			
				this.setState({
					submitProductLoading: true,
					submitProductSuccMsg: null,
					submitProductErrMsg: null,
				});

				var request_data = {
					ids: productIds,
					profile_id: this.state.profile_id,
					shopify_url: this.props.store_data.shopify_url,
				};

				var requestOptions = {
					method: "POST",
					headers: { "Content-Type": "application/json" },
					body: JSON.stringify(request_data),
				};
				var fetch_url =
					this.props.api_url +
					"/BulkPublishAll?api_token=" +
					this.props.store_data.user.api_token;

				fetch(fetch_url, requestOptions)
					.then((response) => response.json())
					.then((data) => {
                        console.log(data.msg);
						if (data && data.status && data.status === "success") {
							this.setState({
								submitProductLoading: false,
								submitProductSuccMsg: data.msg,
								showPublishModel_All: false,
								hasActiveCheckBox: false,
								checkboxes: {},
							});
						} else {
							if (data.errors) {
								let model_content = "";
								if (data.errors_data) {
									model_content = data.errors_data;
								} else if (data.errors.Errors) {
									for (var ekey in data.errors.Errors) {
										model_content =
											model_content +
											"<p>" +
											data.errors.Errors[ekey]
												.LongMessage +
											"</p>";
									}
								} else {
									model_content =
										"<p>" + data.errors + "</p>";
								}

								this.setState(() => {
									return {
										hasActiveCheckBox: false,
										checkboxes: {},
										submitProductLoading: false,
										showPublishModel_All: false,
										show_mode: true,
										model_title: "Verify Add Item Errors",
										model_content: model_content,
									};
								});
							}

							var error_message =
								"there was something wrong, please try again.";
							if (data.msg) {
								error_message = data.msg;
							}
							this.setState({
								submitProductLoading: false,
								submitProductErrMsg: error_message,
							});
						}
					})
					.catch((error) => {
						console.error(error);
					});
			
		}
	}
    
    submit_PublishUnpublishproducts_Request() {
        console.log("submit_PublishUnpublishproducts_Request ",this.state.profile_id);
		if (this.state.submitProductLoading === false) {
			var productIds = [];
			
				this.setState({
					submitProductLoading: true,
					submitProductSuccMsg: null,
					submitProductErrMsg: null,
				});

				var request_data = {
					ids: productIds,
					profile_id: this.state.profile_id,
					shopify_url: this.props.store_data.shopify_url,
				};

				var requestOptions = {
					method: "POST",
					headers: { "Content-Type": "application/json" },
					body: JSON.stringify(request_data),
				};
				var fetch_url =
					this.props.api_url +
					"/BulkPublishunpublishedproduct?api_token=" +
					this.props.store_data.user.api_token;

				fetch(fetch_url, requestOptions)
					.then((response) => response.json())
					.then((data) => {
                        console.log(data.msg);
						if (data && data.status && data.status === "success") {
							this.setState({
								submitProductLoading: false,
								submitProductSuccMsg: data.msg,
								showPublishModel_Unpublish: false,
								hasActiveCheckBox: false,
								checkboxes: {},
							});
						} else {
							if (data.errors) {
								let model_content = "";
								if (data.errors_data) {
									model_content = data.errors_data;
								} else if (data.errors.Errors) {
									for (var ekey in data.errors.Errors) {
										model_content =
											model_content +
											"<p>" +
											data.errors.Errors[ekey]
												.LongMessage +
											"</p>";
									}
								} else {
									model_content =
										"<p>" + data.errors + "</p>";
								}

								this.setState(() => {
									return {
										hasActiveCheckBox: false,
										checkboxes: {},
										submitProductLoading: false,
										showPublishModel_Unpublish: false,
										show_mode: true,
										model_title: "Verify Add Item Errors",
										model_content: model_content,
									};
								});
							}

							var error_message =
								"there was something wrong, please try again.";
							if (data.msg) {
								error_message = data.msg;
							}
							this.setState({
								submitProductLoading: false,
								submitProductErrMsg: error_message,
							});
						}
					})
					.catch((error) => {
						console.error(error);
					});
			
		}
	}

    submit_UpdateAllPublished_Request() {
        console.log("submit_UpdateAllPublished_Request " ,this.state.profile_id);
		if (this.state.submitProductLoading === false) {
			var productIds = [];
			
				this.setState({
					submitProductLoading: true,
					submitProductSuccMsg: null,
					submitProductErrMsg: null,
				});

				var request_data = {
					ids: productIds,
					profile_id: this.state.profile_id,
					shopify_url: this.props.store_data.shopify_url,
				};

				var requestOptions = {
					method: "POST",
					headers: { "Content-Type": "application/json" },
					body: JSON.stringify(request_data),
				};

				var fetch_url =
					this.props.api_url +
					"/Updateallpublish?api_token=" +
					this.props.store_data.user.api_token;

				fetch(fetch_url, requestOptions)
					.then((response) => response.json())
					.then((data) => {
                        console.log(data.msg);
						if (data && data.status && data.status === "success") {
                            console.log("2222222222222");
							this.setState({
								submitProductLoading: false,
								submitProductSuccMsg: data.msg,
								showPublishModel_Publish: false,
								hasActiveCheckBox: false,
								checkboxes: {},
							});
						} else {
							if (data.errors) {
								let model_content = "";
								if (data.errors_data) {
									model_content = data.errors_data;
								} else if (data.errors.Errors) {
									for (var ekey in data.errors.Errors) {
										model_content =
											model_content +
											"<p>" +
											data.errors.Errors[ekey]
												.LongMessage +
											"</p>";
									}
								} else {
									model_content =
										"<p>" + data.errors + "</p>";
								}

								this.setState(() => {
									return {
										hasActiveCheckBox: false,
										checkboxes: {},
										submitProductLoading: false,
										showPublishModel_Publish: false,
										show_mode: true,
										model_title: "Verify Add Item Errors",
										model_content: model_content,
									};
								});
							}

							var error_message =
								"there was something wrong, please try again.";
							if (data.msg) {
								error_message = data.msg;
							}
							this.setState({
								submitProductLoading: false,
								submitProductErrMsg: error_message,
							});
						}
					})
					.catch((error) => {
						console.error(error);
					});
			
		}
	}

	submitDeleteProducts() {
		console.log('submitDeleteProducts');
		this.setState({
			actionLoading: true,
			actionErrMsg: null,
			actionSuccMsg: null,
		});

		var checkboxes = this.state.checkboxes;
		var product_ids = [];
		for (var id in checkboxes) {
			if (checkboxes[id]) {
				product_ids.push(id);
			}
		}

		var request_data = {
			product_ids: product_ids,
			shopify_url: this.props.store_data.shopify_url,
		};

		var requestOptions = {
			method: "DELETE",
			headers: { "Content-Type": "application/json" },
			body: JSON.stringify(request_data),
		};
		var fetch_url =
			this.props.api_url +
			"/products?api_token=" +
			this.props.store_data.user.api_token;

		fetch(fetch_url, requestOptions)
			.then((response) => response.json())
			.then((data) => {
				if (data && data.status && data.status === "success") {
					this.setState(
						{
							actionLoading: false,
							actionSuccMsg: data.msg,
							actionErrMsg: null,
							hasActiveCheckBox: false,
							checkboxes: {},
						},
						() => {
							this.getProducts();
						},
						2000
					);
				} else {
					var error_message =
						"there was something wrong, please try again.";
					if (data.msg) {
						error_message = data.msg;
					}
					this.setState({
						actionLoading: false,
						actionErrMsg: error_message,
					});
				}
			})
			.catch((error) => {
				console.error(error);
			});
	}

	hideToast() {
		this.setState({
			submitProductSuccMsg: null,
			submitProductErrMsg: null,
			actionSuccMsg: null,
			actionErrMsg: null,
			checkboxhovermsg: null,
		});
	}

	cancelPublishRequest() {
		if (this.state.submitProductLoading === false) {
			this.setState({ showPublishModel: false });
			this.setState({ showPublishModelOne: false });
			this.setState({ showPublishModel_All: false });
			this.setState({ showPublishModel_Unpublish: false });
			this.setState({ showPublishModel_Publish: false });
			this.setState({ showVariationList: false });
		}
	}

	handleChange = (field) => {
		// console.log('aaa', field);
		return (value) => {			
			this.setState({ [field]: value });
			// this.setState({ BulkPublishprofileid: value });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.BulkPublish();				
			// });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.BulkPublishAllProduct();				
			// });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.UpdateBulkPublishAllProduct();				
			// });
		};
	};

	handleChange_All = (field) => {
		// console.log('aaa', field);
		return (value) => {			
			this.setState({ [field]: value });
			// this.setState({ BulkPublishprofileid: value });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.BulkPublish();				
			// });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.BulkPublishAllProduct();				
			// });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.UpdateBulkPublishAllProduct();				
			// });
		};
	};
    
	handleChange_Unpublish = (field) => {
		// console.log('aaa', field);
		return (value) => {			
			this.setState({ [field]: value });
			// this.setState({ BulkPublishprofileid: value });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.BulkPublish();				
			// });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.BulkPublishAllProduct();				
			// });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.UpdateBulkPublishAllProduct();				
			// });
		};
	};
    
	handleChange_Publish = (field) => {
		// console.log('aaa', field);
		return (value) => {			
			this.setState({ [field]: value });
			// this.setState({ BulkPublishprofileid: value });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.BulkPublish();				
			// });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.BulkPublishAllProduct();				
			// });
			// this.setState({ BulkPublishprofileid: value }, () => {
			// 	this.UpdateBulkPublishAllProduct();				
			// });
		};
	};
    showVariationPopup = (productId) => {

		console.log('Product ID:', productId);

		this.setState({ showVariationList: true });

		this.setState({ clickedProductId: productId });

	
	}
	showPublishRequestModel() {
		this.setState({ showPublishModel: true });
		if (this.profileOptions.length === 0) {
			this.profileOptions.push({ label: "Select Profile", value: "" });
			this.setState({ loadingProfiles: true });
			var queryData = [];
			queryData.push("shopify_url=" + this.props.store_data.shopify_url);
			queryData.push("api_token=" + this.props.store_data.user.api_token);
			queryData.push("fetch_all=1");
			var queryStr = queryData.join("&");
			fetch(this.props.api_url + "/profile?" + queryStr)
				.then((res) => res.json())
				.then((data) => {
					if (data && data.length > 0) {
						//if(data && data.data && data.data.length > 0){
						for (var key in data) {
							var pname = data[key].name;
							if (data[key].is_default_profile === 1) {
								pname = pname + " (default)";
							}
							this.profileOptions.push({
								label: pname,
								value: data[key].id.toString(),
							});
							if (data[key].is_default_profile === 1) {
								this.setState({
									profile_id: data[key].id.toString(),
								});
							}
						}
					}
					this.setState({ loadingProfiles: false });
				})
				.catch(console.log);
		}
	}

	showPublishRequestModelOne(id,quantity) {
		//console.log("id is this ",id);
		this.setState({ showPublishModelOne: true, productid: id ,quantityvalue: quantity});
		if (this.profileOptions.length === 0) {
			this.profileOptions.push({ label: "Select Profile", value: "" });
			this.setState({ loadingProfiles: true });
			var queryData = [];
			queryData.push("shopify_url=" + this.props.store_data.shopify_url);
			queryData.push("api_token=" + this.props.store_data.user.api_token);
			queryData.push("fetch_all=1");
			var queryStr = queryData.join("&");
			fetch(this.props.api_url + "/profile?" + queryStr)
				.then((res) => res.json())
				.then((data) => {
					if (data && data.length > 0) {
						//if(data && data.data && data.data.length > 0){
						for (var key in data) {
							var pname = data[key].name;
							if (data[key].is_default_profile === 1) {
								pname = pname + " (default)";
							}
							this.profileOptions.push({
								label: pname,
								value: data[key].id.toString(),
							});
							if (data[key].is_default_profile === 1) {
								this.setState({
									profile_id: data[key].id.toString(),
								});
							}
						}
					}
					this.setState({ loadingProfiles: false });
				
				})
				.catch(console.log);
		}
	}
    showPublishRequestModel_All() {
        
		this.setState({ showPublishModel_All: true });
        
		if (this.profileOptions_All.length === 0) {
            
			this.profileOptions_All.push({ label: "Select Profile", value: "" });
			this.setState({ loadingProfiles: true });
			var queryData = [];
			queryData.push("shopify_url=" + this.props.store_data.shopify_url);
			queryData.push("api_token=" + this.props.store_data.user.api_token);
			queryData.push("fetch_all=1");
			var queryStr = queryData.join("&");
           
			fetch(this.props.api_url + "/profile?" + queryStr)
				.then((res) => res.json())
				.then((data) => {
					if (data && data.length > 0) {
                        console.log("hiiiiiiiiii ",data);
						//if(data && data.data && data.data.length > 0){
						for (var key in data) {
							var pname = data[key].name;
							if (data[key].is_default_profile === 1) {
								pname = pname + " (default)";
							}
							this.profileOptions_All.push({
								label: pname,
								value: data[key].id.toString(),
							});
							if (data[key].is_default_profile === 1) {
								this.setState({
									profile_id: data[key].id.toString(),
								});
							}
						}
                        
					}
					this.setState({ loadingProfiles: false });
				})
				.catch(console.log);
		}
	}
    
	showPublishRequestModel_Unpublish() {
        
		this.setState({ showPublishModel_Unpublish: true });
        
		if (this.profileOptions_Unpublish.length === 0) {
            
			this.profileOptions_Unpublish.push({ label: "Select Profile", value: "" });
			this.setState({ loadingProfiles: true });
			var queryData = [];
			queryData.push("shopify_url=" + this.props.store_data.shopify_url);
			queryData.push("api_token=" + this.props.store_data.user.api_token);
			queryData.push("fetch_all=1");
			var queryStr = queryData.join("&");
           
			fetch(this.props.api_url + "/profile?" + queryStr)
				.then((res) => res.json())
				.then((data) => {
					if (data && data.length > 0) {
                        console.log("hiiiiiiiiii ",data);
						//if(data && data.data && data.data.length > 0){
						for (var key in data) {
							var pname = data[key].name;
							if (data[key].is_default_profile === 1) {
								pname = pname + " (default)";
							}
							this.profileOptions_Unpublish.push({
								label: pname,
								value: data[key].id.toString(),
							});
							if (data[key].is_default_profile === 1) {
								this.setState({
									profile_id: data[key].id.toString(),
								});
							}
						}
                        
					}
					this.setState({ loadingProfiles: false });
				})
				.catch(console.log);
		}
	}
    
	showPublishRequestModel_publish() {
        
		this.setState({ showPublishModel_Publish: true });
        
		if (this.profileOptions_Publish.length === 0) {
            
			this.profileOptions_Publish.push({ label: "Select Profile", value: "" });
			this.setState({ loadingProfiles: true });
			var queryData = [];
			queryData.push("shopify_url=" + this.props.store_data.shopify_url);
			queryData.push("api_token=" + this.props.store_data.user.api_token);
			queryData.push("fetch_all=1");
			var queryStr = queryData.join("&");
           
			fetch(this.props.api_url + "/profile?" + queryStr)
				.then((res) => res.json())
				.then((data) => {
					if (data && data.length > 0) {
                        console.log("hiiiiiiiiii ",data);
						//if(data && data.data && data.data.length > 0){
						for (var key in data) {
							var pname = data[key].name;
							if (data[key].is_default_profile === 1) {
								pname = pname + " (default)";
							}
							this.profileOptions_Publish.push({
								label: pname,
								value: data[key].id.toString(),
							});
							if (data[key].is_default_profile === 1) {
								this.setState({
									profile_id: data[key].id.toString(),
								});
							}
						}
                        
					}
					this.setState({ loadingProfiles: false });
				})
				.catch(console.log);
		}
	}

	getProducts(pageno = 1) {
		console.log('getProducts');
		if (this._isMounted === true) {
			var queryData = [];

			if (this.state.queryValue && this.state.queryValue.length > 0) {
				if (this.state.queryType.length > 0) {
					queryData.push(
						this.state.queryType + "=" + this.state.queryValue
					);
				} else {
					queryData.push("title=" + this.state.queryValue);
				}
			}

			if (
				this.state.productStatus &&
				this.state.productStatus.length > 0
			) {
				queryData.push("status=" + this.state.productStatus.trim());
			}

			queryData.push("sort_by=" + this.state.sortBy);
			queryData.push("sort_order=" + this.state.sortOrder);
			queryData.push("page=" + pageno);

			queryData.push("shopify_url=" + this.props.store_data.shopify_url);
			queryData.push("api_token=" + this.props.store_data.user.api_token);
			var queryStr = queryData.join("&");
			fetch(this.props.api_url + "/products?" + queryStr)
				.then((res) => res.json())
				.then((data) => {
					console.log('data', data);
					// this.setState({ products: data, loading: false });
					if (data && data.data && data.data.length > 0) {
						this.setState({ products: data, loading: false, searchdata: "" });
						// alert("data found!");
					} else {
						this.setState({ products: data, loading: false, searchdata: "do not search data" });
						// alert("No data found!");
					}  
				})
				.catch(console.log);
		}
	}

	handleSort(colind) {
		console.log('handleSort');
		var sortBy = this.state.sortBy;
		var sortOrder = this.state.sortOrder;
		if (colind === 2) {
			sortBy = "title";
		} else if (colind === 8) {
			// If sorting by createdAt column
			sortBy = "created_at";
		} else if (colind === 9) {
			// If sorting by updatedAt column
			sortBy = "updated_at";
		}

		if (sortOrder === "asc") {
			sortOrder = "desc";
		} else {
			sortOrder = "asc";
		}

		this.setState({ sortBy: sortBy, sortOrder: sortOrder }, () => {
			this.getProducts();
		});
	}

	handleQueryTypeChange(value) {
		console.log('handleQueryTypeChange');
		var queryType = value[0] || "";
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryType") {
				fk = key;
			}
		}
		var filterObj = {
			key: "queryType",
			label: "Query Type : " + queryType,
			onRemove: this.clearQueryTypeChange,
		};
		if (fk && fk !== null) {
			appliedFilters[fk] = filterObj;
		} else {
			appliedFilters.push(filterObj);
		}
		this.setState(
			{
				appliedFilters: appliedFilters,
				queryType: queryType,
				lastQueryType: queryType,
			},
			() => {
				this.getProducts();
			}
		);
	}

	clearQueryTypeChange() {
		console.log('clearQueryTypeChange');
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryType") {
				fk = key;
			}
		}
		if (fk && fk !== null) {
			appliedFilters.splice(fk, 1);
		}

		fk = null;
		for (key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryValue") {
				fk = key;
			}
		}
		if (fk && fk !== null) {
			appliedFilters.splice(fk, 1);
		}

		this.setState(
			{ appliedFilters: appliedFilters, queryType: "", queryValue: "" },
			() => {
				this.getProducts();
			}
		);
	}

	handleProductStatusChange(value) {
		console.log('handleProductStatusChange');
		var productStatus = value[0] || "";

		var appliedFilters = this.state.appliedFilters;

		// console.log(value);
		// console.log(appliedFilters);
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "productStatus") {
				fk = key;
			}
		}
		var filterObj = {
			key: "productStatus",
			label: "Status : " + productStatus,
			onRemove: this.clearProductStatusChange,
		};
		if (fk && fk !== null) {
			appliedFilters[fk] = filterObj;
		} else {
			appliedFilters.push(filterObj);
		}
		this.setState(
			{ appliedFilters: appliedFilters, productStatus: productStatus },
			() => {
				this.getProducts();
			}
		);
	}

	clearProductStatusChange() {
		console.log('clearProductStatusChange');
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "productStatus") {
				fk = key;
			}
		}
		if (fk && fk !== null) {
			appliedFilters.splice(fk, 1);
		}
		this.setState(
			{ appliedFilters: appliedFilters, productStatus: "" },
			() => {
				this.getProducts();
			}
		);
	}

	handleQueryChange(value) {
		console.log('handleQueryChange');
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryValue") {
				fk = key;
			}
		}

		if (!value || value.length === 0) {
			if (fk && fk !== null) {
				appliedFilters.splice(fk, 1);
			}
			fk = null;
			for (key in appliedFilters) {
				if (appliedFilters[key]["key"] === "queryType") {
					fk = key;
				}
			}
			if (fk && fk !== null) {
				appliedFilters.splice(fk, 1);
			}
		} else {
			var filterObj = {
				key: "queryValue",
				label: "Query : " + value,
				onRemove: this.handleQueryRemove,
			};
			if (fk && fk !== null) {
				appliedFilters[fk] = filterObj;
			} else {
				appliedFilters.push(filterObj);
			}

			fk = null;
			for (key in appliedFilters) {
				if (appliedFilters[key]["key"] === "queryType") {
					fk = key;
				}
			}
			if (!fk || fk === null) {
				var queryType = this.state.lastQueryType;
				if (!queryType || queryType === "" || queryType.length === 0) {
					queryType = "title";
				}
				filterObj = {
					key: "queryType",
					label: "Query Type : " + queryType,
					onRemove: this.clearQueryTypeChange,
				};
				appliedFilters.push(filterObj);
				this.setState({ queryType: queryType });
			}
		}

		this.setState(
			{ queryValue: value, appliedFilters: appliedFilters },
			() => {
				this.getProducts();
				// this.getProductsviasearch();
			}
		);
	}

	handleQueryRemove() {
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryValue") {
				fk = key;
			}
		}
		if (fk && fk !== null) {
			appliedFilters.splice(fk, 1);
		}

		fk = null;
		for (key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryType") {
				fk = key;
			}
		}
		if (fk && fk !== null) {
			appliedFilters.splice(fk, 1);
		}

		this.setState(
			{ queryValue: "", queryType: "", appliedFilters: appliedFilters },
			() => {
				this.getProducts();
			}
		);
	}

	handleFiltersClearAll(value) {
		console.log('handleFiltersClearAll');
		this.setState(
			{
				appliedFilters: [],
				queryValue: null,
				queryType: "",
				productStatus: "",
			},
			() => {
				this.getProducts();
			}
		);
	}

	toggleAction(value) {
		var actions = this.state.actions;
		if (actions[value]) {
			actions[value] = false;
		} else {
			actions[value] = true;
		}
		this.setState({ actions: actions });
	}

	submitProductsImportRequest() {
		this.setState(
			{ paction_loading: true, actionSuccMsg: null, actionErrMsg: null },
			function () {
				var request_data = {
					shopify_url: this.props.store_data.shopify_url,
				};
				var requestOptions = {
					method: "POST",
					headers: { "Content-Type": "application/json" },
					body: JSON.stringify(request_data),
				};
				var fetch_url =
					this.props.api_url +
					"/importproducts?api_token=" +
					this.props.store_data.user.api_token;
				fetch(fetch_url, requestOptions)
					.then((response) => response.json())
					.then((data) => {
						if (data && data.status && data.status === "success") {
							this.setState({
								paction_loading: false,
								actionSuccMsg: data.msg,
								actionErrMsg: null,
							});
						} else {
							var error_message =
								"there was something wrong, please try again.";
							if (data.msg) {
								error_message = data.msg;
							}
							this.setState({
								paction_loading: false,
								actionSuccMsg: null,
								actionErrMsg: error_message,
							});
						}
					})
					.catch((error) => {
						console.error(error);
					});
			}
		);
	}

	toggleCheckbox(value) {
		var checkboxes = this.state.checkboxes;
		if (checkboxes[value]) {
			checkboxes[value] = false;
		} else {
			checkboxes[value] = true;
		}

		if (value == "all") {
			for (var key in this.state.products.data) {
				checkboxes[this.state.products.data[key].id] =
					checkboxes[value];
			}

			var hasActiveCheckBox = false;
			for (var key in checkboxes) {
				if (checkboxes[key] === true) {
					hasActiveCheckBox = true;
					break;
				}
			}
			this.setState(() => {
				return {
					hasActiveCheckBox: hasActiveCheckBox,
					checkboxes: checkboxes,
				};
			});

			return;
		}

		var hasActiveCheckBox = false;
		for (var key in checkboxes) {
			if (checkboxes[key] === true) {
				hasActiveCheckBox = true;
				break;
			}
		}

		this.setState(() => {
			return {
				hasActiveCheckBox: hasActiveCheckBox,
				checkboxes: checkboxes,
			};
		});
	}
	
    // BulkPublish() {

	// 	const BulkPublishprofileidValue = this.state.BulkPublishprofileid;    
		
	// 	this.setState({ showPublishModel_All: true });		
		
	// 	// alert(BulkPublishprofileidValue);
		
	// 	if (this.profileOptions2.length === 0) {
	// 		this.profileOptions2.push({ label: "Select Profile", value: "" });
	// 		this.setState({ loadingProfiles: true });
	// 		var queryData = [];
	// 		queryData.push("shopify_url=" + this.props.store_data.shopify_url);
	// 		queryData.push("api_token=" + this.props.store_data.user.api_token);
	// 		queryData.push("fetch_all=1");
	// 		var queryStr = queryData.join("&");
	// 		fetch(this.props.api_url + "/profile?" + queryStr)
	// 			.then((res) => res.json())
	// 			.then((data) => {
	// 				if (data && data.length > 0) {
	// 					//if(data && data.data && data.data.length > 0){
	// 					for (var key in data) {
	// 						var pname = data[key].name;
	// 						if (data[key].is_default_profile === 1) {
	// 							pname = pname + " (default)";
	// 						}
	// 						this.profileOptions2.push({
	// 							label: pname,
	// 							value: data[key].id.toString(),
	// 						});
	// 						if (data[key].is_default_profile === 1) {
	// 							this.setState({
	// 								profile_id: data[key].id.toString(),
	// 							});
	// 						}
	// 					}
	// 				}
	// 				this.setState({ loadingProfiles: false });
	// 			})
	// 			.catch(console.log);
	// 	}

	// 	// BulkPublishprofileidValue ki value yahaan set karein
	// 	var selectedProductID = BulkPublishprofileidValue;
		
		

	// 	// if (selectedProductID) {
	// 	// 	var request_data = {
	// 	// 		profile_id: selectedProductID,
	// 	// 		shopify_url: this.props.store_data.shopify_url,
	// 	// 	};

	// 	// 	var requestOptions = {
	// 	// 		method: "POST",
	// 	// 		headers: { "Content-Type": "application/json" },
	// 	// 		body: JSON.stringify(request_data),
	// 	// 	};

	// 	// 	var fetch_url = this.props.api_url + "/BulkPublishAll?api_token=" + this.props.store_data.user.api_token;

	// 	// 	console.log(fetch_url);

	// 	// 	fetch(fetch_url, requestOptions)
	// 	// 		.then((response) => response.json())
	// 	// 		.then((data) => {
	// 	// 			// code continues...

	// 	// 			this.setState({ showPublishModel2: false });
	// 	// 		})
	// 	// 		.catch((error) => {
	// 	// 			console.error(error);
	// 	// 		});
	// 	// } else {
	// 	// 	// Agar BulkPublishprofileidValue ki value available nahi hai, to koi aur action lijiye
	// 	// 	console.log("BulkPublishprofileidValue ki value available nahi hai");
	// 	// }

	// }

	// BulkPublishAllProduct() {
	// 	// alert(3);
	// 	const BulkPublishprofileidValue = this.state.BulkPublishprofileid;    
		
	// 	this.setState({ showPublishModel3: true });

	// 	if (this.profileOptions3.length === 0) {
	// 		this.profileOptions3.push({ label: "Select Profile", value: "" });
	// 		this.setState({ loadingProfiles: true });
	// 		var queryData = [];
	// 		queryData.push("shopify_url=" + this.props.store_data.shopify_url);
	// 		queryData.push("api_token=" + this.props.store_data.user.api_token);
	// 		queryData.push("fetch_all=1");
	// 		var queryStr = queryData.join("&");
	// 		fetch(this.props.api_url + "/profile?" + queryStr)
	// 			.then((res) => res.json())
	// 			.then((data) => {
	// 				if (data && data.length > 0) {
	// 					//if(data && data.data && data.data.length > 0){
	// 					for (var key in data) {
	// 						var pname = data[key].name;
	// 						if (data[key].is_default_profile === 1) {
	// 							pname = pname + " (default)";
	// 						}
	// 						this.profileOptions3.push({
	// 							label: pname,
	// 							value: data[key].id.toString(),
	// 						});
	// 						if (data[key].is_default_profile === 1) {
	// 							this.setState({
	// 								profile_id: data[key].id.toString(),
	// 							});
	// 						}
	// 					}
	// 				}
	// 				this.setState({ loadingProfiles: false });
	// 			})
	// 			.catch(console.log);
	// 	}

	// 	// BulkPublishprofileidValue ki value yahaan set karein
	// 	var selectedProductID = BulkPublishprofileidValue;

	// 	console.log('bulk publish product',selectedProductID);
	// }	

	// UpdateBulkPublishAllProduct() {
	// 	// alert(3);
	// 	const BulkPublishprofileidValue = this.state.BulkPublishprofileid;    
		
	// 	this.setState({ showPublishModel4: true });
	// 	// this.setState({ showPublishModel3: false });
	// 	// this.setState({ showPublishModel2: false });

	// 	if (this.profileOptions4.length === 0) {
	// 		this.profileOptions4.push({ label: "Select Profile", value: "" });
	// 		this.setState({ loadingProfiles: true });
	// 		var queryData = [];
	// 		queryData.push("shopify_url=" + this.props.store_data.shopify_url);
	// 		queryData.push("api_token=" + this.props.store_data.user.api_token);
	// 		queryData.push("fetch_all=1");
	// 		var queryStr = queryData.join("&");
	// 		fetch(this.props.api_url + "/profile?" + queryStr)
	// 			.then((res) => res.json())
	// 			.then((data) => {
	// 				if (data && data.length > 0) {
	// 					//if(data && data.data && data.data.length > 0){
	// 					for (var key in data) {
	// 						var pname = data[key].name;
	// 						if (data[key].is_default_profile === 1) {
	// 							pname = pname + " (default)";
	// 						}
	// 						this.profileOptions4.push({
	// 							label: pname,
	// 							value: data[key].id.toString(),
	// 						});
	// 						if (data[key].is_default_profile === 1) {
	// 							this.setState({
	// 								profile_id: data[key].id.toString(),
	// 							});
	// 						}
	// 					}
	// 				}
	// 				this.setState({ loadingProfiles: false });
	// 			})
	// 			.catch(console.log);
	// 	}

	// 	// BulkPublishprofileidValue ki value yahaan set karein
	// 	var selectedProductID = BulkPublishprofileidValue;

	// 	console.log('bulk publish product',selectedProductID);
	// }

	handleItemsPerPageChange = (event, pageno = 1) => {
		const itemsPerPage = event.target.value;
		// const itemsPerPage = 50;
		// console.log('itemsPerPage',itemsPerPage);
		this.setState({ itemsPerPage: itemsPerPage });
		this.setState({ totalPages: "" });
		this.setState({ loading: true });

		if (this._isMounted === true) {
			var queryData = [];
			this.setState({ showDefaultPagination: false });

			if (this.state.queryValue && this.state.queryValue.length > 0) {
				if (this.state.queryType.length > 0) {
					queryData.push(
						this.state.queryType + "=" + this.state.queryValue
					);
				} else {
					queryData.push("title=" + this.state.queryValue);
				}
			}
			if (
				this.state.productStatus &&
				this.state.productStatus.length > 0
			) {
				queryData.push("status=" + this.state.productStatus.trim());
			}

			queryData.push("sort_by=" + this.state.sortBy);
			queryData.push("sort_order=" + this.state.sortOrder);
			// queryData.push("page=" + pageno);
			queryData.push("page=" + this.state.currentPage);
			queryData.push("limit=" + itemsPerPage);
			queryData.push("shopify_url=" + this.props.store_data.shopify_url);
			queryData.push("api_token=" + this.props.store_data.user.api_token);
			var queryStr = queryData.join("&");
			fetch(this.props.api_url + "/products?" + queryStr)
				.then((res) => res.json())
				.then((data) => {
					// console.log('data', data);
					this.setState({ products: data, loading: false });
					this.setState({ showAlternativePagination: true });

					// const currrentpagecount = data.from;
					// console.log('next_page_url:', currrentpagecount);
				})
				.catch(console.log);
		}
	};

	handleNextPage = () => {
		// console.log('total product',this.state.products.total);
		const { itemsPerPage } = this.state; // Extracting itemsPerPage from state
		this.setState(
			(prevState) => ({
				currentPage: prevState.currentPage + 1,
			}),
			() => {
				this.handleItemsPerPageChange({
					target: { value: itemsPerPage },
				}); // Passing itemsPerPage value
			}
		);
	};

	handlePrevPage = () => {
		const { itemsPerPage } = this.state; // Extracting itemsPerPage from state
		this.setState(
			(prevState) => ({
				currentPage: prevState.currentPage - 1,
			}),
			() => {
				this.handleItemsPerPageChange({
					target: { value: itemsPerPage },
				}); // Passing itemsPerPage value
			}
		);
	};
	checkboxhovermethod(){
		console.log("hhhhhhhhhhhhhhhhhhh");
		this.setState({
		checkboxhovermsg: "Can't select ,Product Inventory is zero",
		});
		setTimeout(() => {
			this.setState({ checkboxhovermsg: null });
			
		  }, 1000);

	}
	getProductsData() {
		
		// alert(this);
		var activator, checkbox ,checkboxx;
		var filters = [
			{
				key: "queryType",
				label: "Query Type",
				filter: (
					<ChoiceList
						title="Query Type"
						titleHidden
						choices={[
							{ label: "Title", value: "title" },
							{ label: "Sku", value: "sku" },
							{ label: "Barcode", value: "barcode" },
							{ label: "Tags", value: "tags" },
						]}
						selected={this.state.queryType || ""}
						onChange={this.handleQueryTypeChange}
					/>
				),
				shortcut: true,
			},
			{
				key: "productStatus",
				label: "Product Status",
				filter: (
					<ChoiceList
						title="Product Status"
						titleHidden
						choices={[
							{ label: "Published", value: " published" },
							{ label: "Unpublished", value: "unpublished" },
							{ label: "Error", value: "error" },
						]}
						selected={this.state.productStatus || ""}
						onChange={this.handleProductStatusChange}
					/>
				),
			},
		];

		const rows = [];
		if (this.state.products && this.state.products.total > 0) {
			
			//for (var key in this.state.products.data) {
				this.state.products.data.forEach(product => {
				// console.log('aaaaaaaaaaaaaaa',this.state.products.data);
				//var product = this.state.products.data[key];
				var img_url = product.image;
				if (!img_url || img_url === "") {
					img_url = process.env.PUBLIC_URL + "/no_image.png";
				}
				var thumbnail = (
					<Thumbnail source={img_url} alt={product.title} />
				);
				var profile_name = "-";
				if(product.status == "published" || product.status == "Created" || product.status == "Linked" && product.profile){
				// if (product.profile) {
					profile_name = (
						<Link
							external
							url={
								this.props.base_url +
								"/profiles/edit/" +
								product.profile.id
							}
						>
							{product.profile.name}
						</Link>
					);
				}else{
					 profile_name = "-";
				}
				var profile_ID = "-";
				if (product.id) {
					profile_ID = (
						<div className="variantpopup">
							{/* <div onClick={() => alert(product.id)} > */}
							<Link external onClick={() => this.showVariationPopup(product.id)} >variant
								<span className="Polaris-Link__IconLockup">
									<span className="Polaris-Link__IconLayout">
										<span className="Polaris-Icon" aria-label="(opens a new window)">
											<svg viewBox="0 0 20 20" className="Polaris-Icon__Svg" focusable="false" aria-hidden="true">
												<path d="M13 12a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H6c-.575 0-1-.484-1-1V7a1 1 0 0 1 1-1h1a1 1 0 0 1 0 2v5h5a1 1 0 0 1 1-1zm-2-7h4v4a1 1 0 1 1-2 0v-.586l-2.293 2.293a.999.999 0 1 1-1.414-1.414L11.586 7H11a1 1 0 0 1 0-2z"></path>
											</svg>
										</span>
									</span>
								</span>
							</Link>
						</div>
					);
				}
				activator = (
					<Button
						onClick={this.toggleAction.bind(this, product.id)}
						disclosure
					>
						Actions
					</Button>
				);

				checkbox = checkbox = (
					<Checkbox
						checked={this.state.checkboxes[product.id]}
						onChange={this.toggleCheckbox.bind(this, product.id)}
					/>
				);
				
				checkboxx = checkboxx = (
					<Checkbox 
					onChange = {()=>(this.checkboxhovermethod())}
					/>
				);
				
				//var singlepublish = this.state.singlepublish[product.id];

				var statusData = <Badge >unpublished</Badge>;
				// if(product.listing){
				// statusData = <Badge status="success"><Link external url={product.listing.listing_url} title="View Listing">published</Link></Badge>
				// }
				
				if(product.status === "published"){
				statusData = <Badge status="success"><Link external url={product.listing.listing_url} title="View Listing">published</Link></Badge>
				}
				else if(product.status === "Created"){
				statusData = <Badge status="success"><Link external url={product.listing.listing_url} title="View Listing">Created</Link></Badge>
				}
				else if(product.status === "Linked"){
					statusData = <Badge status="success"><Link external url={product.listing.listing_url} title="View Listing">Linked</Link></Badge>
				}
				// if(product.status === "Created" ){
				// 	rows.push([
				// 		<div>{product.variants_count.quantity > 0 ?
				// 			<div style={{ width: "20px" }}>{checkbox}</div>:
				// 			<div style={{ width: "20px"}}></div>
				// 		}</div>,
				// 		<div style={{ width: "50px" }}>{thumbnail}</div>,
				// 		<div style={{ maxWidth: "700px", overflow: "hidden"}}>{product.title}</div>,
				// 		<div><div className="showvarianttext">{product.variants_count.no_of_variants}</div> {profile_ID}</div>,

				// 		product.variants_count.quantity,
				// 		profile_name,
				// 		statusData,
				// 		<div>
				// 			<Button disabled
				// 				url={
				// 					this.props.base_url +
				// 					"/products/edit/" +
				// 					product.shopify_product_id
				// 				}
				// 			>
				// 				<Icon source={EditMajorMonotone} />
				// 			</Button>
				// 		</div>,
				// 		// <div style={{ width: "50px" }}>{product.created_at}</div>,
				// 		//<div style={{ width: "50px" }}>{product.updated_at}</div>,
				// 		<div>
				// 		<Button primary size = 'slim'
				// 		onClick={()=>(this.showPublishRequestModelOne(product.id,product.variants_count.quantity))}
				// 			>
				// 				Publish to eBay
				// 			</Button>
				// 			</div>
				// 	]);
				// }else if(product.status === "Linked"){
				// 	rows.push([
				// 		<div>{product.variants_count.quantity > 0 ?
				// 			<div style={{ width: "20px" }}>{checkbox}</div>:
				// 			<div style={{ width: "20px"}}></div>
				// 		}</div>,
				// 		<div style={{ width: "50px" }}>{thumbnail}</div>,
				// 		<div style={{ maxWidth: "700px", overflow: "hidden"}}>{product.title}</div>,
				// 		// product.variants_count.no_of_variants,
				// 		<div><div className="showvarianttext">{product.variants_count.no_of_variants}</div> {profile_ID}</div>,

				// 		product.variants_count.quantity,
				// 		profile_name,
				// 		statusData,
				// 		<div>
				// 			<Button disabled
				// 				url={
				// 					this.props.base_url +
				// 					"/products/edit/" +
				// 					product.shopify_product_id
				// 				}
				// 			>
				// 				<Icon source={EditMajorMonotone} />
				// 			</Button>
				// 		</div>,
				// 		// <div style={{ width: "50px" }}>{product.created_at}</div>,
				// 		//<div style={{ width: "50px" }}>{product.updated_at}</div>,
				// 		<div>
				// 		<Button primary size = 'slim'
				// 		onClick={()=>(this.showPublishRequestModelOne(product.id,product.variants_count.quantity))}
				// 			>
				// 				Publish to eBay
				// 			</Button>
				// 			</div>
				// 	]);
				// }else if(product.status === "published"){
				// 	rows.push([
				// 		<div>{product.variants_count.quantity > 0 ?
				// 			<div style={{ width: "20px" }}>{checkbox}</div>:
				// 			<div style={{ width: "20px"}}></div>
				// 		}</div>,
				// 		//<div style={{ width: "20px" }}></div>,
				// 		<div style={{ width: "50px" }}>{thumbnail}</div>,
				// 		<div style={{ maxWidth: "700px", overflow: "hidden"}}>{product.title}</div>,
				// 		<div><div className="showvarianttext">{product.variants_count.no_of_variants}</div> {profile_ID}</div>,

				// 		product.variants_count.quantity,
				// 		profile_name,
				// 		statusData,
				// 		<div>
				// 			<Button disabled
				// 				url={
				// 					this.props.base_url +
				// 					"/products/edit/" +
				// 					product.shopify_product_id
				// 				}
				// 			>
				// 				<Icon source={EditMajorMonotone} />
				// 			</Button>
				// 		</div>,
				// 		// <div style={{ width: "50px" }}>{product.created_at}</div>,
				// 		//<div style={{ width: "50px" }}>{product.updated_at}</div>,
				// 		<div>
				// 		<Button primary size = 'slim'
				// 		onClick={()=>(this.showPublishRequestModelOne(product.id,product.variants_count.quantity))}
				// 			>
				// 				Publish to eBay
				// 			</Button>
				// 			</div>
				// 	]);
				// }else{
					rows.push([
						<div>{product.variants_count.quantity > 0 ?
							<div style={{ width: "20px" }}>{checkbox}</div>:
							<div style={{ width: "20px"}}>{checkboxx}</div>
						}</div>,
						<div style={{ width: "50px" }}>{thumbnail}</div>,
						<div style={{ maxWidth: "700px", overflow: "hidden"}}><Link external url={"https://"+this.props.store_data.shopify_url+"/admin/products/"+product.shopify_product_id}>{product.title}</Link></div>,
						<div><div className="showvarianttext">{product.variants_count.no_of_variants}</div> {profile_ID}</div>,

						<>{product.variants_count.quantity <= 0 ? <div style={{ color:"red",fontSize:"16px" }}>0</div> : product.variants_count.quantity}</>,
						profile_name,
						statusData,
						<div>
							<Button
								url={
									this.props.base_url +
									"/products/edit/" +
									product.shopify_product_id
								}
							>
								<Icon source={EditMajorMonotone} />
							</Button>
						</div>,
						<div>
						{/* // <div style={{ width: "50px" }}>{product.created_at}</div>,
						//<div style={{ width: "50px" }}>{product.updated_at}</div>, */}
						<Button primary size = 'slim'
						onClick={()=>(this.showPublishRequestModelOne(product.id,product.variants_count.quantity))}
							>
								Publish to eBay
							</Button>
							</div>
					]);
				//}	

			}
		)
		}
		activator = (
			<>
				{/* <Button onClick={this.toggleAction.bind(this, "common")} disclosure>
				Actions
				</Button> */}
				<Button onClick={this.showPublishRequestModel} primary>
				Publish Selected Products
				</Button>
			</>
		);
		const activator1 = (
			<Button onClick={this.togglePopoverActive} disclosure primary>
				Publish All Products
			</Button>
		);
		var currentPage = 1;
		var hasNext = false;
		var nextPage = 0;
		var hasPrevious = false;
		var previousPage = 0;
		if (this.state.products) {
			currentPage = this.state.products.current_page;
			if (this.state.products.next_page_url) {
				hasNext = true;
				nextPage = currentPage + 1;
			}
			if (this.state.products.prev_page_url) {
				hasPrevious = true;
				previousPage = currentPage - 1;
			}
		}

		const { itemsPerPage } = this.state;
		const { products } = this.state;
		const { searchdata } = this.state;
		console.log(searchdata);
		const { queryValue } = this.state;
		console.log(queryValue);

		const disableNextButton = products.to === products.total;
		const disablePrevButton = currentPage === 1;

		return (
			<>

			{/* {console.log('products',products.data.length)} */}
			
			<Page
				fullWidth="true"
				title="Products"
				primaryAction={{
					content: "Fetch Shopify Products",
					loading: this.state.paction_loading,
					primary: false,
					onAction: this.submitProductsImportRequest,
				}}
			>
				<Card>	

					{this.state.submitProductSuccMsg && (
						<Toast
							content={this.state.submitProductSuccMsg}
							onDismiss={this.hideToast}
							duration="6000"
						/>
					)}
					{this.state.submitProductErrMsg && (
						<Toast
							content={this.state.submitProductErrMsg}
							error
							onDismiss={this.hideToast}
							duration="6000"
						/>
					)}

					{this.state.actionSuccMsg && (
						<Toast
							content={this.state.actionSuccMsg}
							onDismiss={this.hideToast}
							duration="6000"
						/>
					)}
					{this.state.actionErrMsg && (
						<Toast
							content={this.state.actionErrMsg}
							error
							onDismiss={this.hideToast}
							duration="6000"
						/>
					)}

                    {this.state.checkboxhovermsg && (
						<Toast
							content={this.state.checkboxhovermsg}
							error
							onDismiss={this.hideToast}
							duration="1000"
						/>
					)}

					{rows && rows.length <= 0 && (				
						<>				
										
							<Card.Section>
								{this.state.queryValue && this.state.queryValue.length > 0 && (
								<>
									<Filters
									queryValue={this.state.queryValue}
									filters={filters}
									appliedFilters={this.state.appliedFilters}
									onQueryChange={this.handleQueryChange}
									onQueryClear={this.handleQueryRemove}
									onClearAll={this.handleFiltersClearAll}
									/>
								</>
								)}
								<EmptyState
								heading=""						
								image="https://cdn.shopify.com/s/files/1/0262/4071/2726/files/emptystate-files.png"
								>
								<p>
								No Product Found , Please
								Add Product .
								</p>						
								</EmptyState>
							</Card.Section>
						</>
					)}

					{/* {!this.state.searchdata && ( */}
						<>
							{rows && rows.length > 0 && (
								<>
								<Card.Section>
									
									<Filters
										queryValue={this.state.queryValue}
										filters={filters}
										appliedFilters={this.state.appliedFilters}
										onQueryChange={this.handleQueryChange}
										onQueryClear={this.handleQueryRemove}
										onClearAll={this.handleFiltersClearAll}
									/>							

									<div
										className="topbuttonrow"
										style={{
											display: "flex",
											alignItems: "center",
											justifyContent: "space-between",
											padding: "10px 0px 0px 0px",
										}}
									>
										{rows && rows.length > 0 && (
											<div className="selectallcheckbox">
												<Checkbox
													checked={this.state.checkboxes["all"]}
													onChange={this.toggleCheckbox.bind(
														this,
														"all"
													)}
												/>
												<span
													style={{
														position: "relative",
														top: "-3px",
													}}
												>
													Select All
												</span>
											</div>
										)}

										<div
											style={{
												display: "flex",
												justifyContent: "flex-end",
											}}
										>
											{!this.state.actionLoading &&
												this.state.hasActiveCheckBox && (
													<div
														className="topButton2"
														style={{
															padding: "0px 10px 0px 0px",
														}}
													>
														<br />
														<Popover
															active={
																this.state.actions["common"]
															}
															activator={activator}
															onClose={this.toggleAction.bind(
																this,
																"common"
															)}
														>
															{/* <ActionList
																items={[
																	{
																		content: "Publish to eBay",
																		icon: FolderUpMajorMonotone,
																		onAction: this.showPublishRequestModel,
																	},
																	// {
																	//   content: "Delete",
																	//   icon: DeleteMajorMonotone,
																	//   onAction: this.submitDeleteProducts,
																	// },
																]}
															/> */}
														</Popover>
													</div>
												)}

											<div
												className="topButton2"
												style={{ marginLeft: "10px" }}
											>
												<Popover
													active={this.state.popoverActive}
													activator={activator1}
													autofocusTarget="first-node"
													onClose={this.togglePopoverActive}
												>
													<ActionList
														actionRole="menuitem"
														items={[
															{
																content: "Publish All",
																onAction: this.showPublishRequestModel_All
																
															},
															{
																content: "Publish Unpublish Products", 
																onAction: this.showPublishRequestModel_Unpublish
															},
															{
																content: "Update All Publish Products", 
																onAction: this.showPublishRequestModel_publish
															},
															
														]}
													/>
												</Popover>
											</div>
										</div>
									</div>

									<Modal
										open={this.state.showPublishModel}
										title="Submit Publish Request"
										onClose={this.cancelPublishRequest}
										primaryAction={{
											content: "Submit",
											onAction: this.submitPublishRequest,
										}}
										secondaryActions={[
											{
												content: "Cancel",
												onAction: this.cancelPublishRequest,
											},
										]}
										loading={this.state.loadingProfiles}
									>
										<Modal.Section>
											<Stack vertical>
												<Stack.Item>
													{!this.state.submitProductLoading && (
														<Select
															label="Select Profile"
															options={this.profileOptions}
															onChange={this.handleChange("profile_id")}
															value={this.state.profile_id}
														/>
													)}
													{this.state.submitProductLoading && (
														<p>
															<Spinner
																accessibilityLabel="Submitting..."
																size="large"
																color="teal"
															/>
															<p>We are verifying data</p>
														</p>
													)}
												</Stack.Item>
											</Stack>
										</Modal.Section>
									</Modal>


									<Modal
										open={this.state.showPublishModelOne}
										title="Submit Publish Request"
										onClose={this.cancelPublishRequest}
										
										primaryAction={{
											disabled:this.state.quantityvalue <= 0 ? true : false,
											destructive: this.state.quantityvalue <= 0 ? true : false,
											content: this.state.quantityvalue <= 0 ? "Can't Submit Product" :  "Submit",
											onAction: ()=>(this.submitPublishRequestOne(this.state.productid)),
											
										}}
										secondaryActions={[
											{
												content: "Cancel",
												onAction: this.cancelPublishRequest,
											},
										]}
										loading={this.state.loadingProfiles}
									>
										<Modal.Section>
											<Stack vertical>
												<Stack.Item>
													
													{this.state.quantityvalue <= 0 && (
														<h1 style={{color:"red",fontSize: '15px'}}>
															Inventory of this item or variants is zero. Please add inventory on shopify so that we can publish this product on eBay.
														</h1>
													)
													}
													{!this.state.submitProductLoading && this.state.quantityvalue > 0 && (
														<Select
															label="Select Profile"
															options={this.profileOptions}
															onChange={this.handleChange("profile_id")}
															value={this.state.profile_id}
														/>
													)}

													{this.state.submitProductLoading && (
														<p>
															<Spinner
																accessibilityLabel="Submitting..."
																size="large"
																color="teal"
															/>
															<p>We are verifying data</p>
														</p>
													)}
												</Stack.Item>
											</Stack>
										</Modal.Section>
									</Modal>

									{/* For Publish All Products Button*/}
									
									<Modal
										open={this.state.showPublishModel_All}
										title="Submit Publish Request"
										onClose={this.cancelPublishRequest}
										primaryAction={{
											content: "Submit",
											onAction: this.submitPublishRequestForPublishAll,
										}}
										secondaryActions={[
											{
												content: "Cancel",
												onAction: this.cancelPublishRequest,
											},
										]}
										loading={this.state.loadingProfiles}
									>
										<Modal.Section>
											<Stack vertical>
												<Stack.Item>
													{!this.state.submitProductLoading && (
														<Select
															label="Select Profile"
															options={this.profileOptions_All}
															onChange={this.handleChange_All("profile_id")}
															value={this.state.profile_id}
														/>
													)}
													{this.state.submitProductLoading && (
														<p>
															<Spinner
																accessibilityLabel="Submitting..."
																size="large"
																color="teal"
															/>
															<p>We are verifying data</p>
														</p>
													)}
												</Stack.Item>
											</Stack>
										</Modal.Section>
									</Modal>
									

									{/* For Publish Unpublish Product Button*/}
									
									<Modal
										open={this.state.showPublishModel_Unpublish}
										title="Submit Publish Request"
										onClose={this.cancelPublishRequest}
										primaryAction={{
											content: "Submit",
											onAction: this.submit_PublishUnpublishproducts_Request,
										}}
										secondaryActions={[
											{
												content: "Cancel",
												onAction: this.cancelPublishRequest,
											},
										]}
										loading={this.state.loadingProfiles}
									>
										<Modal.Section>
											<Stack vertical>
												<Stack.Item>
													{!this.state.submitProductLoading && (
														<Select
															label="Select Profile"
															options={this.profileOptions_Unpublish}
															onChange={this.handleChange_Unpublish("profile_id")}
															value={this.state.profile_id}
														/>
													)}
													{this.state.submitProductLoading && (
														<p>
															<Spinner
																accessibilityLabel="Submitting..."
																size="large"
																color="teal"
															/>
															<p>We are verifying data</p>
														</p>
													)}
												</Stack.Item>
											</Stack>
										</Modal.Section>
									</Modal>
									
									<Modal
										open={this.state.showPublishModel_Publish}
										title="Submit Publish Request"
										onClose={this.cancelPublishRequest}
										primaryAction={{
											content: "Submit",
											onAction: this.submit_UpdateAllPublished_Request,
										}}
										secondaryActions={[
											{
												content: "Cancel",
												onAction: this.cancelPublishRequest,
											},
										]}
										loading={this.state.loadingProfiles}
									>
										<Modal.Section>
											<Stack vertical>
												<Stack.Item>
													{!this.state.submitProductLoading && (
														<Select
															label="Select Profile"
															options={this.profileOptions_Publish}
															onChange={this.handleChange_Publish("profile_id")}
															value={this.state.profile_id}
														/>
													)}
													{this.state.submitProductLoading && (
														<p>
															<Spinner
																accessibilityLabel="Submitting..."
																size="large"
																color="teal"
															/>
															<p>We are verifying data</p>
														</p>
													)}
												</Stack.Item>
											</Stack>
										</Modal.Section>
									</Modal>
									
                                      <Modal
										open={this.state.showVariationList}
										title="Product Variation List"
										onClose={this.cancelPublishRequest}										
										
										loading={this.state.loadingProfiles}
									>
										<Modal.Section>
											<Stack vertical>
												<Stack.Item>
													{/* Filter out the clicked product and display its ID */}
													<>
														<style>
														{`
														table {
															font-family: arial, sans-serif;
															border-collapse: collapse;
															width: 100%;
														}

														td, th {
															border: 1px solid #dddddd;
															text-align: left;
															padding: 8px;
														}
														`}
														</style>

														<table>
															<thead>
																<tr>
																	<th>Title</th>
																	<th>Sku</th>
																	<th>Quantity</th>
																	<th>Price</th>
																	<th>option1</th>
																	<th>option2</th>
																	<th>option3</th>
																</tr>
															</thead>
															<tbody>
															{this.state.products.data
																.filter(product => product.id === this.state.clickedProductId)
																.map(product => (
																	product.variants.map(variantdata => (
																		<>
																			<tr key={variantdata.id}>
																				<td>{variantdata.shopify_variant_data && JSON.parse(variantdata.shopify_variant_data).title}</td>
																				<td>{variantdata.shopify_variant_data && JSON.parse(variantdata.shopify_variant_data).sku}</td>
																				<td>{variantdata.shopify_variant_data && JSON.parse(variantdata.shopify_variant_data).inventory_quantity}</td>
																				<td>{variantdata.shopify_variant_data && JSON.parse(variantdata.shopify_variant_data).price}</td>
																				<td>{variantdata.shopify_variant_data && JSON.parse(variantdata.shopify_variant_data).option1 ? JSON.parse(variantdata.shopify_variant_data).option1 : "-"}</td>
																				<td>{variantdata.shopify_variant_data && JSON.parse(variantdata.shopify_variant_data).option2 ? JSON.parse(variantdata.shopify_variant_data).option2 : "-"}</td>
																				<td>{variantdata.shopify_variant_data && JSON.parse(variantdata.shopify_variant_data).option3 ? JSON.parse(variantdata.shopify_variant_data).option3 : "-"}</td>
																			</tr>
																		</>
																	))
																))
															}
															</tbody>
														</table>
													</>


												</Stack.Item>
											</Stack>
										</Modal.Section>
									</Modal>
									

									{this.state.actionLoading && (
										<div>
											<br />
											<Spinner
												accessibilityLabel="Processing..."
												size="large"
												color="teal"
											/>
										</div>
									)}
								</Card.Section>

								<DataTable
									columnContentTypes={[
										"text",
										"text",
										"text",
										"numeric",
										"numeric",
										"text",
										"text",
										"text",
									]}
									headings={[
										"",
										"",
										"Title",
										"Variants",
										"Inventory",
										"Profile",
										"Status",
										"Actions",
										"Publish"
										// "Created",
										//"Updated",
									]}
									rows={rows}
									sortable={[
										false,
										false,
										true,
										false,
										false,
										false,
										false,
										false,
										true,
									]}
									defaultSortDirection="ascending"
									initialSortColumnIndex={2}
									onSort={this.handleSort}
									truncate="true"
									footerContent={`Showing from ${
										this.state.products.from || 0
									} to ${this.state.products.to || 0} of total ${
										this.state.products.total || 0
									}`}
								/>
							
								<Card.Section align="center">
									<div>

										{this.state.showDefaultPagination && (
											<Pagination
												hasPrevious={hasPrevious}
												previousKeys={[74]}
												previousTooltip={previousPage}
												onPrevious={() => {
													// console.log("Previous");
													this.getProducts(previousPage);
												}}
												hasNext={hasNext}
												nextKeys={[75]}
												nextTooltip={nextPage}
												onNext={() => {
													// console.log("Next");
													this.getProducts(nextPage);
												}}
											/>
										)}

										{this.state.showAlternativePagination && (
											<>
												<button
													className="previousButton"
													onClick={this.handlePrevPage}
													disabled={disablePrevButton}
												>
													<svg
														viewBox="0 0 20 20"
														className="Polaris-Icon__Svg"
														focusable="false"
														aria-hidden="true"
													>
														<path
															d="M17 9H5.414l3.293-3.293a.999.999 0 1 0-1.414-1.414l-5 5a.999.999 0 0 0 0 1.414l5 5a.997.997 0 0 0 1.414 0 .999.999 0 0 0 0-1.414L5.414 11H17a1 1 0 1 0 0-2"
															fillRule="evenodd"
														></path>
													</svg>
												</button>

												<button
													className="nextButton"
													onClick={this.handleNextPage}
													disabled={disableNextButton}
												>
													<svg
														viewBox="0 0 20 20"
														className="Polaris-Icon__Svg"
														focusable="false"
														aria-hidden="true"
													>
														<path
															d="M17.707 9.293l-5-5a.999.999 0 1 0-1.414 1.414L14.586 9H3a1 1 0 1 0 0 2h11.586l-3.293 3.293a.999.999 0 1 0 1.414 1.414l5-5a.999.999 0 0 0 0-1.414"
															fillRule="evenodd"
														></path>
													</svg>
												</button>
											</>
										)}
										
										{/* Dropdown Pagination */}
										<select
											id="itemsPerPage"
											onChange={this.handleItemsPerPageChange}
											value={itemsPerPage}
										>
											<option value="20">20</option>
											<option value="50">50</option>
											<option value="100">100</option>
											<option value="200">200</option>
											<option value="300">300</option>
											<option value="400">400</option>
											<option value="500">500</option>
										</select>

										{/* Numeric pagination */}

										
											{/* <NumericPagination
												currentPage={1}
												totalPages={141}
												onPageChange={this.getProducts}
												pageRangeDisplayed={5}
												// pageRangeDisplayed={10}
												// prevPageText='prev'
												// nextPageText='next'
												// firstPageText='first'
												// lastPageText='last'
											/> */}
									

									</div>
								</Card.Section>
								</>
							)}
						</>
					{/* )} */}

				</Card>
			</Page>

			</>
		);
	}

	render() {
		const { loading } = this.state;
		const { BulkPublishprofileid } = this.state;
		// console.log('BulkPublishprofileid',BulkPublishprofileid);

		if (loading) {
			return (
				<div
					style={{
						display: "flex",
						justifyContent: "center",
						alignItems: "center",
						height: "100vh",
					}}
				>
					<Spinner accessibilityLabel="Loading" size="large" />
					{/* Render Spinner while loading */}
				</div>
			);
		}

		return (
			<Layout>
				{this.state.show_mode && this.state.show_mode === true && (
					<DataModal
						hideModel={this.hideModel}
						active={true}
						title={this.state.model_title}
						content={this.state.model_content}
					/>
				)}
				<Layout.Section>
					<Page title="" fullWidth="true">
						{this.state.error_message && (
							<Banner title="Error" status="critical">
								<p>{this.state.error_message}</p>
							</Banner>
						)}
						{this.state.success_message && (
							<Banner title="Success" status="success">
								<p>{this.state.success_message}</p>
							</Banner>
						)}
					</Page>
				</Layout.Section>
				<Layout.Section>
					{this.getProductsData()}
					<FooterHelp>
						For more details on App, visit our{" "}
						<Link
							url="https://app1.ecomshore.com/manage_products.pdf"
							external="true"
						>
							documentation
						</Link>
						.
					</FooterHelp>
				</Layout.Section>
			</Layout>
		);
	}
}

export default Products;
