import React, { useState, useCallback, useEffect } from "react";
import {
	Button,
	Checkbox,
	Card,
	FormLayout,
	Layout,
	Page,
	Select,
	Tabs,
	TextField,
	Banner,
	Icon,
	Label,
	Link,
	Toast,
} from "@shopify/polaris";
import axios from "axios";

import AutoCompleteField from "./AutoCompleteField";

export default function ProfileForm(props) {
	// console.log("props", props);
	const [errors, setErrors] = useState({});
	const [page_title, setpage_title] = useState("");
	const [subTitle, setSubTitle] = useState("");
	const [subDescription, setSubDescription] = useState("");
	const [trimTitle, setTrimTitle] = useState(false);
	const [selectedTab, setSelectedTab] = useState(0);
	const [isDefaultProfile, setIsDefaultProfile] = useState("");
	const [name, setName] = useState("");
	const [listingFormat, setListingFormat] = useState("");
	const [listingDuration, setListingDuration] = useState("");
	const [itemLocation, setItemLocation] = useState("");
	const [postalCode, setPostalCode] = useState("");
	const [templateId, setTemplateId] = useState("");
	
	/******start category********/
	const [profileId, setProfileId] = useState(props.profile_id);
	const [profilename, setProfilename] = useState("");

	const [ebayCategories, setEbayCategories] = useState([]);
	const [selectedCategory, setSelectedCategory] = useState(null);
	const [selectedCategoryID, setSelectedCategoryID] = useState("");

	const [ebay_account, setEbayaccount] = useState(
		props.store_data.ebay_account
	);
	const [filteredCategories, setFilteredCategories] = useState([]);
	const [searchTerm, setSearchTerm] = useState();
	const [ebayCategoryID, setEbayCategoryID] = useState();
	const [searchTermedit, setSearchTermedit] = useState();
	const [menuIsOpen, setMenuIsOpen] = useState(false);
	/******end category********/

	/******start sub category********/
	const [shopify_url, setShopify_url] = useState(
		props.store_data.shopify_url
	);
	const [api_token, setApi_token] = useState(props.store_data.api_token);
	const [additionalCategoryData, setAdditionalCategoryData] = useState([]);
	const [subCategoryEdit, setSubCategoryEdit] = useState([]);

	/******end sub category********/

	/******start ebayspecificdata ********/
	const [api_url, setApiurl] = useState(props.api_url);
	const [store_data, setStoredata] = useState(props.store_data);
	const [storeCategories, setStoreCategories] = useState([
		{ label: "Select a Category", value: "" },
	]);
	const [shippingProfiles, setShippingProfiles] = useState([]);
	const [paymentProfiles, setPaymentProfiles] = useState([]);
	const [returnProfiles, setReturnProfiles] = useState([]);
	const [paymentMethodOptions, setPaymentMethodOptions] = useState([]);
	const [salesTaxStates, setSalesTaxStates] = useState([
		{ label: "Select a Tax Region", value: "" },
	]);
	const [domesticShippings, setDomesticShippings] = useState([
		{ label: "Select Shipping", value: "" },
	]);
	const [intlShippings, setIntlShippings] = useState([
		{ label: "Select Shipping", value: "" },
	]);
	const [domesticShipServices, setDomesticShipServices] = useState({});
	const [intlShipServices, setIntlShipServices] = useState([]);
	const [
		intlShipServicesOptionsDropdown,
		setIntlShipServicesOptionsDropdown,
	] = useState([]);
	const [shippingStatus, setShippingStatus] = useState(true);
	const [paymentStatus, setPaymentStatus] = useState(true);
	const [returnStatus, setReturnStatus] = useState(true);
	const [symbolPolicy, setSymbolPolicy] = useState(false);
	const [fetchProfileText, setFetchProfileText] = useState(
		"Fetch Business Policies"
	);
	const [buttonLoading, setButtonLoading] = useState(false);

	const [shippingProfile, setShippingProfile] = useState("");
	const [paymentProfile, setPaymentProfile] = useState("");
	const [returnProfile, setReturnProfile] = useState("");

	// State for selected profiles
	const [selectedShippingProfile, setSelectedShippingProfile] = useState("");
	const [selectedPaymentProfile, setSelectedPaymentProfile] = useState("");
	const [selectedReturnProfile, setSelectedReturnProfile] = useState("");
	const [product_id_type, setpProductidtype] = useState("");
	const [item_condition, setItemCondition] = useState("");
	const [item_specifics, setitem_specifics] = useState({});
	/******end ebayspecificdata ********/

	const [selectedOption, setSelectedOption] = useState();

	const [successMessage, setSuccessMessage] = useState(null);
	const [errorMessage, setErrorMessage] = useState(null);

	const [templateOptions, setTemplateOptions] = useState([]);

	const [categoryId, setCategory] = useState("");
	const [ebayCategoryAttributes, setEbayCategoryAttributes] = useState();
	const [selectedOptions, setSelectedOptions] = useState([]);
	const [itemSpecifics, setItemSpecifics] = useState([]);
	  
	console.log("additionalCategoryData", additionalCategoryData);
	console.log("itemSpecifics-1", itemSpecifics);


	const hideToast = () => {
		setSuccessMessage(null);
		setErrorMessage(null);
	};

	const tabs = [
		{
			id: "required",
			content: "Required Fields",
			accessibilityLabel: "Required Fields",
			panelID: "required-fields",
		},
		{
			id: "category",
			content: "Category Fields",
			accessibilityLabel: "Category Fields",
			panelID: "category-fields",
			onClick: () => handleCategoryClick1, // Assuming handleTabClick is the function you want to call
		},
		{
			id: "optional",
			content: "Optional Field",
			accessibilityLabel: "Optional Fields",
			panelID: "optional-fields",
		},
	];

	const handleCategoryClick1 = async () => {
		alert(2);
	};

	const yesNoOptions = [
		{ label: "Select a Option", value: "" },
		{ value: "1", label: "Yes" },
		{ value: "0", label: "No" },
	];

	const listingFormats = [
		{ label: "Select a Option", value: "" },
		{ value: "fixed_price", label: "Fixed Price" },
		{ value: "auction", label: "Auction" },
	];

	const fixedListingDuration = [
		{ label: "Select a Option", value: "" },
		{ value: "Days_14", label: "Days_14" },
		{ value: "Days_21", label: "Days_21" },
		{ value: "Days_30", label: "Days_30" },
		{ value: "Days_60", label: "Days_60" },
		{ value: "Days_90", label: "Days_90" },
		{ value: "Days_120", label: "Days_120" },
		{ value: "GTC", label: "GTC" },
	];

	const auctionListingDuration = [
		{ label: "Select a Option", value: "" },
		{ value: "Days_1", label: "Days_1" },
		{ value: "Days_3", label: "Days_3" },
		{ value: "Days_5", label: "Days_5" },
		{ value: "Days_7", label: "Days_7" },
		{ value: "Days_10", label: "Days_10" },
	];

	

	const product_id_type_options = [
		{ label: "Select a Option", value: "" },
		{ value: "UPC", label: "UPC" },
		{ value: "ISBN", label: "ISBN" },
		{ value: "EAN", label: "EAN" },
		{ value: "MPN", label: "MPN" },
	];

	const item_condition_options = [
		{ label: "Select a Option", value: "" },
		{ value: "New", label: "New" },
		{ value: "New other (see details)", label: "New other (see details)" },
		{ value: "New with defects", label: "New with defects" },
		{ value: "Certified refurbished", label: "Certified refurbished" },
		{ value: "Seller refurbished", label: "Seller refurbished" },
		{ value: "Like New", label: "Like New" },
		{ value: "Used", label: "Used" },
		{ value: "Very Good", label: "Very Good" },
		{ value: "Good", label: "Good" },
		{ value: "Acceptable", label: "Acceptable" },
		{
			value: "For parts or not working",
			label: "For parts or not working",
		},
	];

	const handleTabChange = useCallback(
		(selectedTabIndex) => setSelectedTab(selectedTabIndex),
		[]
	);
	const handleChangeDefaultProfile = useCallback(
		(value) => setIsDefaultProfile(value),
		[]
	);
	const handleChangeProfileName = useCallback((value) => setName(value), []);
	const handleChangeListingFormat = useCallback(
		(value) => setListingFormat(value),
		[]
	);
	const handleChangeListingDuration = useCallback(
		(value) => setListingDuration(value),
		[]
	);
	const handleChangeItemLocation = useCallback(
		(value) => setItemLocation(value),
		[]
	);
	const handleChangePostalCode = useCallback(
		(value) => setPostalCode(value),
		[]
	);
	const handleChangeTemplateOption = useCallback(
		(value) => setTemplateId(value),
		[]
	);
	const handleChangeProductType = useCallback(
		(value) => setpProductidtype(value),
		[]
	);
	const handleChangeConditionOption = useCallback(
		(value) => setItemCondition(value),
		[]
	);
	const getListingDurationOptions = () => {
		if (listingFormat === "auction") {
			return auctionListingDuration;
		} else if (listingFormat === "fixed_price") {
			return fixedListingDuration;
		} else {
			return [{ label: "Select a Option", value: "" }];
		}
	};

	const validateForm = () => {
		let errors = {};

		if (!name) errors.name = "Profile Name is required";
		if (isDefaultProfile === "")
			errors.isDefaultProfile = "Default Profile is required";
		if (!listingFormat) errors.listingFormat = "Listing Format is required";
		if (!listingDuration)
			errors.listingDuration = "Listing Duration is required";
		if (!itemLocation) errors.itemLocation = "Item Location is required";
		if (!postalCode) errors.postalCode = "Postal Code is required";
		// if (!templateId) errors.templateId = "Description Template is required";

		setErrors(errors);

		return Object.keys(errors).length === 0;
	};

	// console.log("anshu additionalCategoryData", additionalCategoryData);

	useEffect(() => {
		fetch(
			`${props.api_url}/templates?shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`
		)
			.then((res) => res.json())
			.then((data) => {
				if (data && data.total > 0) {
					const options = data.data.map((template) => ({
						label: template.name,
						value: template.id.toString(),
					}));
					setTemplateOptions((prevOptions) => [
						...prevOptions,
						...options,
					]);
				}
			})
			.catch(console.log);
	}, [
		props.api_url,
		props.store_data.shopify_url,
		props.store_data.user.api_token,
	]);
	// start category function
	useEffect(() => {
		const fetchData = async () => {
			try {
				const response = await axios.get(
					`${props.service_url}/public/category-json/categories_${ebay_account.siteid}.json`
				);
				const data = response.data;
				// console.log("categories_-data", data);
				setEbayCategories(data);
				setFilteredCategories(data);
				setSuccessMessage(data.msg);
			} catch (error) {
				console.log(error);
			}
		};

		fetchData();
	}, [props.service_url, ebay_account.siteid]);

	const handleSearchChange = (value) => {
		// console.log("cate value", value);
		setSearchTerm(value);
		filterCategories(value);
		setMenuIsOpen(value.length > 0); // Open the dropdown if search input is not empty
	};
	// console.log("searchTerm", searchTerm);
	const filterCategories = (inputValue) => {
		// console.log("inputValue", inputValue);
		const filtered = ebayCategories.filter((category) =>
			category.category_tree_name
				.toLowerCase()
				.includes(inputValue.toLowerCase())
		);
		setFilteredCategories(filtered);
	};
	const handleCategoryClick = async (category) => {
		alert(category);
		setSelectedCategory(category);
		setSearchTerm(category.category_tree_name);
		setMenuIsOpen(false); // Close the dropdown upon selection
		setSelectedCategoryID(category.id);
		// alert(category.id);
		// Construct the URL with query parameters
		const apiUrl = `${props.api_url}/ebaycategory?category_id=${category.id}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
		// Make the API call
		try {
			const response = await axios.get(apiUrl);
			let category_attributes = response.data.category_attributes;
			setAdditionalCategoryData(category_attributes);
			setSuccessMessage(response.msg);
		} catch (error) {
			console.error("Error calling the API:", error);
		}
	};
	// end category function
	const handleShippingProfileChange = (value) => {
		setSelectedShippingProfile(value);
	};
	const handlePaymentProfileChange = (value) => {
		setSelectedPaymentProfile(value);
	};
	const handleReturnProfileChange = (value) => {
		setSelectedReturnProfile(value);
	};

	// console.log("ebayCategoryID", ebayCategoryID);
	// end ebay specification data	
	const handleNext = async () => {
		if (!validateForm()) {
			return;
		}
		const formData = {
			name: name,
			trim_title: trimTitle,
			is_default_profile: isDefaultProfile,
			listing_format: listingFormat,
			listing_duration: listingDuration,
			item_location: itemLocation,
			postal_code: postalCode,
			template_id: templateId,
			update_install_step: false,
			shopify_url: "dyd-clothing.myshopify.com",
		};

		try {
			const fetch_url =
				props.api_url +
				"/profile" +
				"?api_token=" +
				props.store_data.user.api_token;
			const response = await fetch(fetch_url, {
				method: "POST",
				headers: {
					"Content-Type": "application/json",
				},
				body: JSON.stringify(formData),
			});
			if (!response.ok) {
				throw new Error("Failed to save profile data");
			}

			const data = await response.json();
			setSuccessMessage(data.msg);
			// alert("Profile saved successfully");
			// console.log("Response Data:", data);

			// Get the profile ID from the response
			const profileId = data.profile.id;
			const profilename = data.profile.name;
			setProfileId(profileId);
			setProfilename(profilename);
			// console.log("Profile ID:", profileId);

			const nextTab = selectedTab + 1;
			if (nextTab < tabs.length) {
				setSelectedTab(nextTab);
				// alert(`Profile ID: ${profileId}`);
				// alert(`profile name: ${profilename}`);
				// handleSecondStep(profileId);
			}
		} catch (error) {
			console.error(error);
			setSuccessMessage(error.name);
		}
	};
	const handleSecondStep = async () => {
		// if (!searchTerm) errors.searchTerm = "category is required";

		let formIsValid = true;
		let errors = {};

		if (!searchTerm) {
			formIsValid = false;
			errors.searchTerm = "Category is required";
		}
		const ebayCategoryAttributesJSON = JSON.stringify(
			ebayCategoryAttributes
		);		
		const ebayCategory = selectedCategoryID || categoryId;
		// console.log("ebayCategory", ebayCategory);

		const formData = {
			profile_id: profileId,
			name: name,
			ebay_category_1: ebayCategory,
			item_specifics: ebayCategoryAttributes,
			update_install_step: false,
			shopify_url: "dyd-clothing.myshopify.com",
		};
		const fetch_url = `${props.api_url}/profile/${profileId}?api_token=${props.store_data.user.api_token}`;
		try {
			const response = await fetch(fetch_url, {
				method: "PUT",
				headers: {
					"Content-Type": "application/json",
				},
				body: JSON.stringify(formData),
			});

			if (!response.ok) {
				throw new Error("Failed to save profile data in step 2");
			}

			const data = await response.json();
			setSuccessMessage(data.msg);
			// alert("Profile saved successfully");
			// console.log("Response Data:", data);

			// Move to the next tab
			const nextTab = selectedTab + 1;
			if (nextTab < tabs.length) {
				setSelectedTab(nextTab);
			}
		} catch (error) {
			console.error(error);
		}
	};
	const handleThirdStep = async () => {		

		const formData = {
			profile_id: profileId,
			name: name,
			ebay_category_1: selectedCategoryID,
			item_specifics: additionalCategoryData,
			shipping_profile: shippingProfile,
			payment_profile: paymentProfile,
			return_profile: returnProfile,
			item_condition: item_condition,
			product_id_type: product_id_type,
			update_install_step: false,
			shopify_url: "dyd-clothing.myshopify.com",
		};
		const fetch_url = `${props.api_url}/profile/${profileId}?api_token=${props.store_data.user.api_token}`;
		try {
			const response = await fetch(fetch_url, {
				method: "PUT",
				headers: {
					"Content-Type": "application/json",
				},
				body: JSON.stringify(formData),
			});

			if (!response.ok) {
				throw new Error("Failed to save profile data in step 2");
			}

			const data = await response.json();
			setSuccessMessage(data.msg);
			// alert("Profile saved successfully");
			// console.log("Response Data:", data);

			// Move to the next tab
		} catch (error) {
			console.error(error);
		}
	};
	const handlePrevious = () => {
		const prevTab = selectedTab - 1;
		if (prevTab >= 0) {
			setSelectedTab(prevTab);
		}
	};
	

	const handleSelectionChange = (selectedOption, index) => {
		const updatedSelectedOptions = [...selectedOptions];
		updatedSelectedOptions[index] = selectedOption;
		setSelectedOptions(updatedSelectedOptions);
		console.log("Selected option value:", selectedOption);

		// Send all dropdown values with their names
		sendAllDropdownValues(updatedSelectedOptions);
	};

	const sendAllDropdownValues = (options) => {
		const dropdownValues = options.map((option, index) => ({
			name: additionalCategoryData[index].name,
			value: option,
		}));

		// Do whatever you need to do with all dropdown values
		console.log("All dropdown values:", dropdownValues);
		setEbayCategoryAttributes(dropdownValues);
	};

	

	useEffect(() => {
		if (props.form_type === "edit_profile") {
			setpage_title("Update Profile");
			setSubTitle("Edit Ebay Profile");
			setSubDescription("Enter profile data and click on Save");
			const fetchData = async () => {
				try {
					const response = await axios.get(
						`${props.api_url}/profile/${props.profile_id}?shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`
					);
					const data = response.data;
					setTrimTitle(data.trim_title === 1);
					setIsDefaultProfile(data.is_default_profile.toString());
					setName(data.name);
					setListingFormat(data.listing_format);
					setListingDuration(data.listing_duration);
					setItemLocation(data.item_location);
					setPostalCode(data.postal_code);
					setSearchTermedit(data.ebay_category_1.category_tree_name);
					// Set values from the provided data
					setSearchTerm(
						data.ebay_category_1.category_tree_name || ""
					);
					setEbayCategoryID(data.ebay_category_1.id || "");
					setAdditionalCategoryData(data.item_specifics || []);
					setItemSpecifics(data.item_specifics || []);
					console.log("item_specifics", data.item_specifics);
					
					const selected = {};
					for (const key in data.item_specifics) {
						const modifiedKey = key.replace(); // Replace slashes with underscores
						selected[modifiedKey] = data.item_specifics[key];
					}
					setSelectedOption(selected);
					console.log("selected", selected);
					const dataArray = Object.entries(selected).map(
						([key, value]) => ({ key, value })
					);
					setSubCategoryEdit(dataArray);

					console.log("dataArray", subCategoryEdit);
					// Set shipping, payment, and return profiles if available
					setShippingProfile(data.shipping_profile || "");
					setPaymentProfile(data.payment_profile || "");
					setReturnProfile(data.return_profile || "");
					setItemCondition(data.item_condition);
					setpProductidtype(data.product_id_type);
					setTemplateId(data.template_id || ""); // Set templateId from fetched data
					const categoryId = data.ebay_category_1.id;
					setCategory(categoryId); 					
				} catch (error) {
					console.error(
						"There was an error fetching the profile:",
						error
					);
				}
			};
			fetchData();
		} else if (props.form_type === "app_setup") {
			setpage_title("App Setup - Step 3 of 4");
			setSubTitle("Add Ebay Profile");
			setSubDescription("Enter profile data and click on Save.");
		}
	}, [
		props.form_type,
		props.api_url,
		props.profile_id,
		props.store_data.user.api_token,
		props.store_data.shopify_url, // Including shopify_url in dependencies
	]);

	useEffect(() => {
		const fetchcategoryData = async (categoryID) => {
			if (props.form_type === "edit_profile") { 

				console.log("categoryID", categoryID);

				try {
					console.log("categoryID", categoryID);
					const response = await axios.get(
						`${props.api_url}/ebaycategory?category_id=${categoryID}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`
					);
					const data = response.data;					
					setAdditionalCategoryData(
						response.data.category_attributes
					);
				} catch (error) {
					console.error(
						"There was an error fetching the profile:",
						error
					);
				}

			}
			
		};

		if (ebayCategoryID !== null && ebayCategoryID !== undefined) {
			fetchcategoryData(ebayCategoryID);
		}
	}, [
		ebayCategoryID,
		props.api_url,
		props.store_data.shopify_url,
		props.store_data.user.api_token,
	]);


	return (
		<Page title={page_title}>
			<Layout>
				<Layout.AnnotatedSection
					title={subTitle}
					description={subDescription}
				>
					<Card sectioned>
						<Tabs
							tabs={tabs}
							selected={selectedTab}
							onSelect={handleTabChange}
						>
							<Card.Section>
								<form
									onSubmit={handleNext}
									method="post"
									encType="multipart/form-data"
									// preventDefault="true"
								>
									{selectedTab === 0 && (
										<FormLayout>
											<Checkbox
												label="Trim Title"
												checked={trimTitle}
												onChange={() =>
													setTrimTitle(!trimTitle)
												}
												error={errors.trimTitle}
											/>
											<Select
												label="Default Profile ?"
												options={yesNoOptions}
												onChange={
													handleChangeDefaultProfile
												}
												value={isDefaultProfile}
												error={errors.isDefaultProfile}
											/>
											<TextField
												type="text"
												label="Profile Name"
												value={name}
												onChange={
													handleChangeProfileName
												}
												error={errors.name}
											/>
											<Select
												label="Listing Format"
												options={listingFormats}
												onChange={
													handleChangeListingFormat
												}
												value={listingFormat}
												error={errors.listingFormat}
											/>
											{listingFormat && (
												<Select
													label="Listing Duration"
													options={getListingDurationOptions()}
													onChange={
														handleChangeListingDuration
													}
													value={listingDuration}
													error={
														errors.listingDuration
													}
												/>
											)}
											<TextField
												type="text"
												label="Item Location"
												value={itemLocation}
												onChange={
													handleChangeItemLocation
												}
												error={errors.itemLocation}
											/>
											<TextField
												type="text"
												label="Postal Code"
												value={postalCode}
												onChange={
													handleChangePostalCode
												}
												error={errors.postalCode}
											/>
											<Select
												label="Description Template"
												options={templateOptions}
												onChange={
													handleChangeTemplateOption
												}
												value={templateId}
												error={errors.templateId}
											/>
										</FormLayout>
									)}
									{selectedTab === 1 && (
										<FormLayout>
											<div className="dropdown-container">
												<TextField
													label="Select Category"
													value={searchTerm}
													onChange={
														handleSearchChange
													}
													placeholder="Search category..."
													autoComplete="off"
													error={errors.searchTerm}
												/>
												{menuIsOpen &&
													filteredCategories.length >
														0 && (
														<ul className="dropdown-menu">
															{filteredCategories.map(
																(category) => (
																	<li
																		key={
																			category.id
																		}
																		onClick={() =>
																			handleCategoryClick(
																				category
																			)
																		}
																		className="dropdown-item"
																	>
																		{
																			category.category_tree_name
																		}
																	</li>
																)
															)}
														</ul>
													)}
												

												
												<div className="subcategory-dropdown">
													{additionalCategoryData.length >
														0 && (
														<div>
															{additionalCategoryData.map(
																(
																	item,
																	index
																) => (
																	<div
																		key={
																			index
																		}
																	>
																		<label>
																			Name:{" "}
																			{
																				item.name
																			}
																		</label>
																		<Select
																			options={item.values.map(
																				(
																					val
																				) => ({
																					label: val,
																					value: val,
																				})
																			)}
																			onChange={(
																				selectedOption
																			) =>
																				handleSelectionChange(
																					selectedOption,
																					index
																				)
																			}
																			value={
																				selectedOptions[
																					index
																				]
																			} // Ensure this is set to the correct selected option
																		/>
																	</div>
																)
															)}
														</div>
													)}
												</div>

											</div>
										</FormLayout>
									)}
									{selectedTab === 2 && (
										<FormLayout>
											<div
												style={{
													width: "100%",
													display: "flex",
													alignItems: "center",
												}}
											>
												<div style={{ width: "100%" }}>
													<Select
														label="Shipping Profile"
														options={
															shippingProfile
														}
														onChange={
															handleShippingProfileChange
														}
														value={shippingProfile}
														disabled
													/>
												</div>
												<Link to="https://www.bizpolicy.ebay.com/businesspolicy/shipping?pageNumber=1&totalPages=1&source=manage">
													<svg
														viewBox="0 0 20 20"
														className="Icon_Icon__uZZKy"
														style={{
															width: "20px",
															height: "20px",
															marginLeft: "5px",
															marginTop: "20px",
														}}
													>
														<path d="M11.5 4.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"></path>
														<path d="M11.5 10a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"></path>
														<path d="M11.5 15.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"></path>
													</svg>
												</Link>
											</div>
											<div
												style={{
													width: "100%",
													display: "flex",
													alignItems: "center",
												}}
											>
												<div style={{ width: "100%" }}>
													<Select
														label="Payment Profile"
														options={paymentProfile}
														onChange={
															handlePaymentProfileChange
														}
														value={paymentProfile}
														disabled
													/>
												</div>
												<Link to="https://www.bizpolicy.ebay.com/businesspolicy/payment?pageNumber=1&totalPages=1&source=manage">
													<svg
														viewBox="0 0 20 20"
														className="Icon_Icon__uZZKy"
														style={{
															width: "20px",
															height: "20px",
															marginLeft: "5px",
															marginTop: "20px",
														}}
													>
														<path d="M11.5 4.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"></path>
														<path d="M11.5 10a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"></path>
														<path d="M11.5 15.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"></path>
													</svg>
												</Link>
											</div>
											<div
												style={{
													width: "100%",
													display: "flex",
													alignItems: "center",
												}}
											>
												<div style={{ width: "100%" }}>
													<Select
														label="Return Profile"
														options={returnProfile}
														onChange={
															handleReturnProfileChange
														}
														value={returnProfile}
														disabled
													/>
												</div>
												<Link to="https://www.ebay.com/bp/rtn/create">
													<svg
														viewBox="0 0 20 20"
														className="Icon_Icon__uZZKy"
														style={{
															width: "20px",
															height: "20px",
															marginLeft: "5px",
															marginTop: "20px",
														}}
													>
														<path d="M11.5 4.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"></path>
														<path d="M11.5 10a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"></path>
														<path d="M11.5 15.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"></path>
													</svg>
												</Link>
											</div>

											<Select
												label="Product ID Type"
												options={
													product_id_type_options
												}
												onChange={
													handleChangeProductType
												}
												value={product_id_type}
											/>
											<Select
												label="Item Condition"
												options={item_condition_options}
												onChange={
													handleChangeConditionOption
												}
												value={item_condition}
											/>
										</FormLayout>
									)}
									{/* <button type="submit">Submit</button> */}
								</form>
							</Card.Section>
						</Tabs>
						<div
							style={{
								display: "flex",
								justifyContent: "space-between",
								marginTop: "20px",
							}}
						>
							{selectedTab == 0 && (
								<>
									<Button primary onClick={handleNext}>
										Next
									</Button>
								</>
							)}

							{selectedTab == 1 && (
								<>
									<Button primary onClick={handlePrevious}>
										Previous
									</Button>
									<Button
										primary
										id="secondStepNextButton"
										onClick={() =>
											handleSecondStep(profileId)
										}
									>
										Next
									</Button>
								</>
							)}
							{selectedTab == 2 && (
								<>
									<Button primary onClick={handlePrevious}>
										Previous
									</Button>
									<Button
										primary
										id="thirdStepNextButton"
										onClick={() =>
											handleThirdStep(profileId)
										}
									>
										Save
									</Button>
								</>
							)}
						</div>
					</Card>
				</Layout.AnnotatedSection>
			</Layout>
			<>
				{successMessage && (
					<Toast
						content={successMessage}
						onDismiss={hideToast}
						duration="6000"
					/>
				)}
				{errorMessage && (
					<Toast
						content={errorMessage}
						error
						onDismiss={hideToast}
						duration="6000"
					/>
				)}
			</>
		</Page>
	);
}
