import React, { useState, useCallback, useEffect } from "react";

import {
	Button,
	Checkbox,
	Card,
	ProgressBar,
	FormLayout,
	Layout,
	ButtonGroup,
	SkeletonBodyText,
	Page,
	Popover,
	ActionList,
	Select,
	Tabs,
	Form,
	Stack,
	TextField,
	Banner,
	Icon,
	Label,
	Link,
	Toast,
} from "@shopify/polaris";
import { PlusMinor } from '@shopify/polaris-icons';
import axios from "axios";

export default function Setup3(props) {
	const [errors, setErrors] = useState({});
	const [shopify_url, setShopify_url] = useState(props.store_data.shopify_url);
	const [errorMessage, setErrorMessage] = useState(null);
	const [error_message2, setError_message2] = useState(null)
	const [successMessage, setSuccessMessage] = useState(null);
	const [pageTitle, setpage_title] = useState("");
	const [subTitle, setSubTitle] = useState("");
	const [subDescription, setSubDescription] = useState("");
	const [profileId, setProfileId] = useState(props.profile_id);
	const [trimTitle, setTrimTitle] = useState(false);
	const [isDefaultProfile, setIsDefaultProfile] = useState('');
	const [name, setName] = useState('');
	const [listingFormat, setListingFormat] = useState('');
	const [listingDuration, setListingDuration] = useState('');
	const [conidtion_fetched, setConidtion_fetched] = useState(false)
	const [conidtion_fetched2, setConidtion_fetched2] = useState(false)
	const [itemLocation, setItemLocation] = useState('');
	const [postalCode, setPostalCode] = useState('');
	const [templateId, setTemplateId] = useState('');
	const [searchTerm, setSearchTerm] = useState('');
	const [menuIsOpen, setMenuIsOpen] = useState(false);
	const [filteredCategories, setFilteredCategories] = useState([]);
	const [additionalCategoryData, setAdditionalCategoryData] = useState([]);
	const [selectedOptions, setSelectedOptions] = useState([]);
	const [selectedOption, setSelectedOption] = useState([]);
	const [shippingProfile, setShippingProfile] = useState('');
	const [paymentProfile, setPaymentProfile] = useState('');
	const [returnProfile, setReturnProfile] = useState('');
	const [productIDType, setProductIDType] = useState('');
	const [item_condition, setItemCondition] = useState('');
	const [profilename, setProfilename] = useState("");
	const [ebayCategoryAttributes, setEbayCategoryAttributes] = useState();
	const [selectedCategoryID, setSelectedCategoryID] = useState("");
	const [ebayCategoryID, setEbayCategoryID] = useState();
	const [categoryId, setCategory] = useState("");
	const [product_id_type, setpProductidtype] = useState("");
	const [searchTermedit, setSearchTermedit] = useState();
	const [itemSpecifics, setItemSpecifics] = useState([]);
	const [subCategoryEdit, setSubCategoryEdit] = useState([]);
	const [templateOptions, setTemplateOptions] = useState([]);
	const [selectedCondition, setSelectedCondition] = useState(null);
	const [selectedReturnProfile, setSelectedReturnProfile] = useState("");
	const [selectedPaymentProfile, setSelectedPaymentProfile] = useState("");
	const [selectedCategory, setSelectedCategory] = useState(null);
	const [conditions_true, setConditions_true] = useState(false)
	const [shipping_profiles, setShipping_profiles] = useState([])
	const [selectedShippingProfile, setSelectedShippingProfile] = useState("");
	const [paymentProfiles, setPaymentProfiles] = useState([])
	const [paymentProfile_val, setPaymentProfile_val] = useState("")
	const [returnProfiles, setReturnProfiles] = useState([])
	const [returnProfile_val, setReturnProfile_val] = useState("")
	const [conditionDescriptorVal, setConditionDescriptorVal] = useState([])
	const [conditions, setConditionOptions] = useState([]);
	const [businesspolicy_refresh, set_businesspolicy_refresh] = useState(false);

	const [ebay_account, setEbayaccount] = useState(
		props.store_data.ebay_account
	);
	const [ebayCategories, setEbayCategories] = useState([]);
	const [options, setOptions] = useState([]);
	const [isFieldHidden, setIsFieldHidden] = useState(false);
	const [actionActive, toggleAction] = useState(false);
	const [actionActive2, toggleAction2] = useState(false);
	const [actionActive3, toggleAction3] = useState(false);
	const [selectedValues, setSelectedValues] = useState({});
	const [conditionDescriptors, setConditionDescriptors] = useState([]);
    const [selectedDescriptor, setSelectedDescriptor] = useState('');
    const [descriptorValues, setDescriptorValues] = useState([]);
    const [selectedDescriptorValue, setSelectedDescriptorValue] = useState('');
    const [descriptor, setDescriptor] = useState('');
    const [descriptorValue, setDescriptorValue] = useState('');
    const [selectedDescriptorName, setSelectedDescriptorName] = useState('');
    const [selectedDescriptorValueName, setSelectedDescriptorValueName] = useState({});
    const [selectedItemConditionName, setSelectedConditionName] = useState('');
	const [selectedDescriptorValues, setSelectedDescriptorValues] = useState({});

   
	const [profileID, setProfileID] = useState(() => localStorage.getItem('profileID') || '');
	const [profileName, setProfileName] = useState(() => localStorage.getItem('profileName') || '');

	const handleImportedAction = useCallback(() => {
		handleToggle()
		window.open(
			"https://www.bizpolicy.ebay.com/businesspolicy/shipping?pageNumber=1&totalPages=1&source=manage",
			"_blank"
		);

	}, []);

	const handleImportedAction2 = useCallback(() => {
		handleToggle2()
		window.open(
			"https://www.bizpolicy.ebay.com/businesspolicy/payment?pageNumber=1&totalPages=1&source=manage",
			"_blank"
		);

	}, []);

	const handleImportedAction3 = useCallback(() => {
		handleToggle3()
		window.open(
			"https://www.ebay.com/bp/rtn/create",
			"_blank"
		);

	}, []);


	const catdataArray = Object.entries(selectedValues).map(([key, value]) => ({ key, value }));

	const handleValueChange = (attributeName, newValue) => {
		setSelectedValues(prevState => ({
			...prevState,
			[attributeName]: newValue
		}));
	};

	const fetchBusinessPolicies = () => {

		var hasError = false;
		//console.log("entered in the fetch business ()");
		//var fetch_profile_text = this.state.fetch_profile_text;
		var fetch_profile_text = "Fetch Business Policies";
		if (fetch_profile_text === "Fetch Business Policies") {
			// this.setState(() => {
			// 	return {
			// 		fetch_profile_text: "Fetching...",
			// 	};
			// });
			if (hasError === false) {
				// this.setState({ button_loading: true });
			}

			var fetch_url =
				props.api_url +
				"/fetch_profiles?shopify_url=" +
				props.store_data.shopify_url +
				"&api_token=" +
				props.store_data.user.api_token;
			var requestOptions = {
				method: "GET",
				headers: { "Content-Type": "application/json" },
			};
			fetch(fetch_url, requestOptions)
				.then((response) => response.json())
				.then((data) => {
					console.log("here is the policy ", data)

					if (data.shipping_profiles.length != 0) {


						var ship = [
							{ label: "Select Shipping", value: "" },
						];

						for (ckey in data.shipping_profiles) {
							ship.push({
								label: data.shipping_profiles[ckey].name,
								value: data.shipping_profiles[
									ckey
								].id.toString(),
							});
						}
						setShipping_profiles(ship)

						console.log(shipping_profiles);
					} else {

						var ship = [
							{
								label: "Please add Shipping policy to your eBay account",
								value: "",
							},
						];
						setShipping_profiles(ship)
					}

					if (data.payment_profiles.length != 0) {


						var pay = [
							{ label: "Select Payment", value: "" },
						];

						for (ckey in data.payment_profiles) {
							pay.push({
								label: data.payment_profiles[ckey].name,
								value: data.payment_profiles[
									ckey
								].id.toString(),
							});
						}
						setPaymentProfiles(pay)


					} else {

						var pay = [
							{
								label: "Please add Payment policy to your eBay account",
								value: "",
							},
						];
						setPaymentProfiles(pay)
					}

					if (data.return_profiles.length != 0) {

						var ret = [
							{ label: "Select Return", value: "" },
						];

						for (ckey in data.return_profiles) {
							ret.push({
								label: data.return_profiles[ckey].name,
								value: data.return_profiles[ckey].id.toString(),
							});
						}
						setReturnProfiles(ret)
					} else {
						var ret = [
							{
								label: "Please add Return policy to your eBay account",
								value: "",
							},
						];
						setReturnProfiles(ret)
					}


					return
					// this.setState(() => {
					// 	return {
					// 		fetch_profile_text: "Fetching Done",
					// 	};
					// });
					setTimeout(function () {
						// this.setState(() => {
						// 	return {
						// 		fetch_profile_text: "Fetch Business Policies",
						// 	};
						// });
					}, 5000);
					//   console.log(data);
					// this.setState({
					// 	button_loading: false,
					// 	success_message: "",
					// });					
					var ckey;
					// this.setState({
					// 	button_loading: false,
					// 	success_message: "request has been submitted",
					// });
					if (data.shipping_profiles.length != 0) {
						this.state.shipping_status = false;
						//console.log("made shipping_status true on line no 1161");
						//console.log("entered in the fetch business poilcy function");
						this.state.symbol_policy = true;
						var shipping_profiles = [
							{ label: "Select a Shipping Profile", value: "" },
						];
						//shipping_profiles = shipping_profiles.slice(1);
						for (ckey in data.shipping_profiles) {
							shipping_profiles.push({
								label: data.shipping_profiles[ckey].name,
								value: data.shipping_profiles[
									ckey
								].id.toString(),
							});
						}
					} else {

						var shipping_profiles = [
							{
								label: "Please add Shipping policiy to your eBay account",
								value: "",
							},
						];
					}
					if (data.payment_profiles.length != 0) {
						this.state.payment_status = false;
						// console.log(data.payment_profiles);
						this.state.symbol_policy = true;
						var payment_profiles = [
							{ label: "Select a Payment Profile", value: "" },
						];
						// payment_profiles = payment_profiles.slice(1);
						for (ckey in data.payment_profiles) {
							payment_profiles.push({
								label: data.payment_profiles[ckey].name,
								value: data.payment_profiles[
									ckey
								].id.toString(),
							});
						}
					} else {
						var payment_profiles = [
							{
								label: "Please add Payment policiy to your eBay account",
								value: "",
							},
						];
					}
					if (data.return_profiles.length != 0) {
						this.state.return_status = false;
						// console.log(data.return_profiles);
						this.state.symbol_policy = true;
						var return_profiles = [
							{ label: "Select a Return Profile", value: "" },
						];
						// return_profiles = return_profiles.slice(1);
						for (ckey in data.return_profiles) {
							return_profiles.push({
								label: data.return_profiles[ckey].name,
								value: data.return_profiles[ckey].id.toString(),
							});
						}
					} else {
						var return_profiles = [
							{
								label: "Please add Return policiy to your eBay account",
								value: "",
							},
						];
					}
					this.setState({
						button_loading: false,
						success_message: null,
					});
					this.setState(() => {
						return {
							shipping_profiles: shipping_profiles,
							// shipping_profiles_msg:shipping_profiles_msg,
							payment_profiles: payment_profiles,
							// payment_profiles_msg:payment_profiles_msg,
							return_profiles: return_profiles,
							// return_profiles_msg:return_profiles_msg,
						};
					});
				})
				.catch((error) => {
					//console.error(error);
				});
		} else {
			console.log("here is not the policy ")
		}
	};

	const fetchBusinessPolicies1 = (num) => {

		console.log("num -> ", num);
		if (num == 1) {
			handleToggle()
		} else if (num == 2) {
			handleToggle2()
		} else if (num == 3) {
			handleToggle3()
		}


		var hasError = false;
		var fetch_profile_text = "Fetch Business Policies";
		if (fetch_profile_text === "Fetch Business Policies") {

			if (hasError === false) {

			}

			var fetch_url =
				props.api_url +
				"/fetch_profiles?shopify_url=" +
				props.store_data.shopify_url +
				"&api_token=" +
				props.store_data.user.api_token;
			var requestOptions = {
				method: "GET",
				headers: { "Content-Type": "application/json" },
			};
			fetch(fetch_url, requestOptions)
				.then((response) => response.json())
				.then((data) => {
					console.log("here is the policy ", data)
					var ckey;
					if (data.shipping_profiles.length != 0) {

						var ship = [];

						for (ckey in data.shipping_profiles) {
							ship.push({
								label: data.shipping_profiles[ckey].name,
								value: data.shipping_profiles[
									ckey
								].id.toString(),
							});
						}
						setShipping_profiles(ship)

						console.log(shipping_profiles);
					} else {

						var ship = [
							{
								label: "Please add Shipping policy to your eBay account",
								value: "",
							},
						];
						setShipping_profiles(ship)
					}

					if (data.payment_profiles.length != 0) {


						var pay = [];

						for (ckey in data.payment_profiles) {
							pay.push({
								label: data.payment_profiles[ckey].name,
								value: data.payment_profiles[
									ckey
								].id.toString(),
							});
						}
						setPaymentProfiles(pay)


					} else {

						var pay = [
							{
								label: "Please add Payment policy to your eBay account",
								value: "",
							},
						];
						setPaymentProfiles(pay)
					}

					if (data.return_profiles.length != 0) {

						var ret = [];

						for (ckey in data.return_profiles) {
							ret.push({
								label: data.return_profiles[ckey].name,
								value: data.return_profiles[ckey].id.toString(),
							});
						}
						setReturnProfiles(ret)
					} else {
						var ret = [
							{
								label: "Please add Return policy to your eBay account",
								value: "",
							},
						];
						setReturnProfiles(ret)
					}

					set_businesspolicy_refresh(false)
					
					return


				})
				.catch((error) => {
					//console.error(error);
				});
		} else {
			console.log("here is not the policy ")
		}
	};

	// const handleChange = (event) => {
	// 	setSelectedCondition(event.target.value);
	// }


	const handleChange = async (event) => {
        // alert(event.target.value);
        const selectedConditionId = event.target.value;
        setSelectedCondition(selectedConditionId);
        // Find the selected condition by ID
        const selectedCondition = conditions[0].find(condition => condition.conditionId === selectedConditionId);
        // alert(1);
        // If the selected condition is found
        if (selectedCondition) {
            // Set both the ID and the name
            console.log("Condition found for name:", selectedCondition.conditionDescription);
            setSelectedConditionName(selectedCondition.conditionDescription);
        } else {
        console.log("Condition not found for ID:", selectedConditionId);
        }
        
        const ebayCategory = selectedCategoryID || categoryId;
        const apiUrl = `${props.api_url}/ebaycategory?category_id=${ebayCategory}&conditionId=${event.target.value}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
        try {
            const response = await axios.get(apiUrl);
            const conditionDescriptors = response.data.conditionDescriptors; // Assuming conditionDescriptors is a property in the response data
            setConditionDescriptors(conditionDescriptors);
        } catch (error) {
            console.error("Error calling the API:", error);
        }
    }; 

	const handleExportedAction = useCallback(

		() => {
			set_businesspolicy_refresh(true)
			fetchBusinessPolicies1(1)
		},
		[]
	);

	const handleExportedAction2 = useCallback(
		() => {
			set_businesspolicy_refresh(true)
			fetchBusinessPolicies1(2)

		},
		[]
	);

	const handleExportedAction3 = useCallback(
		() => {
			set_businesspolicy_refresh(true)
			fetchBusinessPolicies1(3)
		},
		[]
	);

	const handleToggleAction = () => {

		toggleAction(!actionActive);
	};
	const handleToggleAction2 = () => {

		toggleAction2(!actionActive2);
	};
	const handleToggleAction3 = () => {

		toggleAction3(!actionActive3);
	};

	const handleToggle = () => {
		toggleAction(false);
	};
	const handleToggle2 = () => {
		toggleAction2(false);
	};
	const handleToggle3 = () => {
		toggleAction3(false);
	};
	const disclosureButtonActivator = (
		<Button icon={PlusMinor} onClick={handleToggleAction}>

		</Button>
	);
	const disclosureButtonActivator2 = (
		<Button icon={PlusMinor} onClick={handleToggleAction2}>

		</Button>
	);
	const disclosureButtonActivator3 = (
		<Button icon={PlusMinor} onClick={handleToggleAction3}>

		</Button>
	);

	// console.log('categoryId', categoryId);

	const hideToast = () => {
		setSuccessMessage(null);
		setErrorMessage(null);
	};

	const tabs = [
		{
			id: "required",
			content: "Step 1",
			accessibilityLabel: "Required Fields",
			panelID: "required-fields",
		},
		{
			id: "category",
			content: "Step 2",
			accessibilityLabel: "Category Fields",
			panelID: "category-fields",
			onClick: () => handleCategoryClick1, // Assuming handleTabClick is the function you want to call
		}
	];

	const handleCategoryClick1 = async () => {
		alert(2);
	};

	const item_condition_options = [
		{ label: "Select a Option", value: "" },
		{ value: "New", label: "New" },
		{ value: "New other (see details)", label: "New other (see details)" },
		{ value: "New with defects", label: "New with defects" },
		{ value: "Certified refurbished", label: "Certified refurbished" },
		{ value: "Seller refurbished", label: "Seller refurbished" },
		{ value: "Like New", label: "Like New" },
		{ value: "Used", label: "Used" },
		{ value: "Very Good", label: "Very Good" },
		{ value: "Good", label: "Good" },
		{ value: "Acceptable", label: "Acceptable" },
		{
			value: "For parts or not working",
			label: "For parts or not working",
		},
	];

	const handleChangeConditionOption = useCallback(
		(value) => setItemCondition(value),
		[]
	);	

	useEffect(() => {
		fetchBusinessPolicies()
		const fetchData = async () => {
			try {
				const response = await axios.get(
					// `${props.api_url}/public/category-json/categories_${ebay_account.siteid}.json`
					`http://localhost/service/public/category-json/categories_${ebay_account.siteid}.json`
				);
				const data = response.data;
				console.log("categories_-data", data);
				setEbayCategories(data);
				setFilteredCategories(data);
				setSuccessMessage(data.msg);
			} catch (error) {
				console.log(error);
			}
		};

		fetchData();
	}, [props.service_url, ebay_account.siteid]);

	const handleSearchChange = (value) => {
		console.log('search 1',value);
		setIsFieldHidden(false);
		setConditions_true(false);
		setSearchTerm(value);
		filterCategories(value);
		setMenuIsOpen(value.length > 0); // Open the dropdown if search input is not empty
	};
	// console.log("searchTerm", searchTerm);
	const filterCategories = (inputValue) => {
		// console.log("inputValue", inputValue);
		const filtered = ebayCategories.filter((category) =>
			category.category_tree_name
				.toLowerCase()
				.includes(inputValue.toLowerCase())
		);
		setFilteredCategories(filtered);
	};

	const handleCategoryClick = async (category) => {
		setError_message2(null)
		setConidtion_fetched(true)
		setConidtion_fetched2(true)
		setIsFieldHidden(false);
		setSelectedCategory(category);
		setSearchTerm(category.category_tree_name);
		setMenuIsOpen(false); // Close the dropdown upon selection
		setSelectedCategoryID(category.id);
		// alert(category.id);
		// Construct the URL with query parameters

		const apiUrl = `${props.api_url}/ebaycategory?category_id=${category.id}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
		// Make the API call
		try {
			// const response = await axios.get(apiUrl);

			fetch(apiUrl)
				.then(response => response.json())
				.then((data) => {
					// console.log("wwwwwwww1111111");
					// console.log("3331111",data.category_attributes);



					console.log("wwwwwwwwwwww", data);
					console.log("2222222222", data.item_condition_data);
					let category_attributes = data.category_attributes;

					setAdditionalCategoryData(category_attributes);
					const item_condition_data = data.item_condition_data
					if (data.category_attributes) {
						setIsFieldHidden(true);
						setConidtion_fetched2(false)
					}
					if (data.item_condition_data) {
						setConidtion_fetched(false)
						setConditions_true(true)

					}
					//console.log("dataaa",data.item_condition_data);

					// 	data.item_condition_data.forEach(element => {
					// 	if(element.conditionDescriptors){
					// 		element.conditionDescriptors.forEach(ele => {
					// 			//console.log(ele);
					// 			if(ele.conditionDescriptorConstraint.usage == "REQUIRED"){
					// 				// console.log("yes it is required ",ele.conditionDescriptorValues);
					// 				setConditionDescriptorVal(ele.conditionDescriptorValues)


					// 			}else{
					// 				console.log("it is not required");
					// 			}
					// 		});
					// 		setConditionOptions([
					// 			item_condition_data 
					// 		]);

					// 	}else{

					// 		setConditionOptions([
					// 			item_condition_data 
					// 		]);
					// 	}
					//   });

					setConditionOptions([
						item_condition_data
					]);

					// const itemDatajson = Object.entries(item_condition_data).map(([key, value]) => ({ key, value }));

					// console.log('bbbbbbbbbbbbbbbbb', getItemConditionData);




					let initialSelectedValues = {};
					category_attributes.forEach(attr => {
						if (attr.values.length > 0) {
							initialSelectedValues[attr.name] = attr.values[0];
						}
					});
					// console.log('1',initialSelectedValues);
					setSelectedValues(initialSelectedValues);

					setSuccessMessage(data.msg);
				})
		} catch (error) {
			console.error("Error calling the API:", error);
		}
	};
	// end category function
	const handleShippingProfileChange = (value) => {
		setSelectedShippingProfile(value);
	};
	const handlePaymentProfileChange = (value) => {
		setPaymentProfile_val(value);
	};
	const handleReturnProfileChange = (value) => {
		setReturnProfile_val(value);
	};
	//console.log("additionalCategoryData", additionalCategoryData);

	const handleDescriptorValueChange = (descriptorId ,descriptorName, selectedValueId, selectedValueName) => {
        setSelectedDescriptorValues(prevState => ({
            ...prevState,
            [descriptorId]: { id: selectedValueId, name: selectedValueName }
        }));

        console.log('3333333333333333',     selectedDescriptorValues );
	};
	
	const handleNext = async () => {

		console.log('selectedCategoryID-----length',selectedCategoryID);
		console.log('categoryId',categoryId);

		// if (selectedCategoryID == "" || categoryId <= 0) {
		// 	setErrorMessage("Please select a category");
		// 	setError_message2("Category is required")
		// 	return
		// }

		if(selectedShippingProfile == "" && paymentProfile_val == "" && returnProfile_val ==""){
			setErrorMessage("Please select eBay business policy")
			return

		}
		const ebayCategory = selectedCategoryID || categoryId;

		if (ebayCategory === "") {
			setErrorMessage("Please select a category");
			// setError_message2("Category is required")
			return
		}

		const selecteItemdCondition = {
            name: selectedItemConditionName, // Save the selected condition name
            value: selectedCondition, // Save the selected condition ID
        }

		const formData = {
			profile_id: profileID,
			name: profileName,
			shipping_profile: selectedShippingProfile,
			payment_profile: paymentProfile_val,
			return_profile: returnProfile_val,
			ebay_category_1: ebayCategory,
			item_specifics: selectedValues,
			// item_condition: selectedCondition,
			item_condition: selecteItemdCondition,
            child_item_condition: [selectedDescriptorValues], // Save as JSON
			update_install_step: false,
			shopify_url: shopify_url,
		};

		console.log('setup3', formData);

		try {
			const fetch_url = `${props.api_url}/profile/${profileID}?api_token=${props.store_data.user.api_token}`;

			const response = await fetch(fetch_url, {
				method: "PUT",
				headers: {
					"Content-Type": "application/json",
				},
				body: JSON.stringify(formData),
			});

			// if (!response.ok) {
			// 	throw new Error("Failed to save profile data");
			// }

			if (!response.ok) {
				const errorData = await response.json();
				if (errorData.errors) {
					// Assuming errorData.errors is an object with field-specific error messages
					const fieldErrors = {};
					Object.keys(errorData.errors).forEach((field) => {
						fieldErrors[field] = errorData.errors[field][0];
					});
					setErrors(fieldErrors);
					return;
				} else {
					throw new Error("Failed to save profile data");
				}
			}

			const data = await response.json();
			setSuccessMessage(data.msg);
			setTimeout(() => {
				localStorage.removeItem('profileID');
				localStorage.removeItem('profileName');
				// alert('Profile saved and then removed from local storage');
			}, 1000);
			window.location.reload();

		} catch (error) {
			console.error("Error while updating profile data:", error);
			setErrorMessage("Failed to update profile data"); // Set error message appropriately
		}
	};


	return (

		<div>
			<ProgressBar progress={67} size="small" />
			<h1 style={{ marginBottom: "40px", fontSize: "13px" }}>App Setup - Step 3 of 3</h1>

			<Form onSubmit={handleNext} method="post" encType="multipart/form-data" preventDefault="true">

				<FormLayout
					popoverActions={[{ content: 'Dismiss', onAction: () => { } }]}>
					<div style={{
						width: "100%",
						display: "flex",

					}}>

						<div style={{
							width: "50%",
							fontSize: "15px",
							fontWeight: "bold",
							padding: "5%"
						}}
						>
							Business policies
						</div>

						<div style={{ width: "100%" }}>
							{businesspolicy_refresh ? 
							  <Card sectioned roundedAbove="sm">
							  <div>
								  <label className="category-lable">Fetching Business Policies...</label>
								  <SkeletonBodyText  lines={8}/>

							  </div>
						  </Card>
							: <Card sectioned roundedAbove="sm">

								<div
									style={{
										width: "100%",
										display: "flex",
									}}
								>
									<div style={{ width: "100%" }}>
										<Select
											label="Shipping Profile"
											options={shipping_profiles}
											onChange={handleShippingProfileChange}
											value={selectedShippingProfile}

										/>

									</div>
									<div style={{ padding: "24px 0px 0px 10px" }}>

										<Popover
											active={actionActive}
											activator={disclosureButtonActivator}
											onClose={handleToggleAction}
											autofocusTarget="first-node"
										>
											<ActionList actionRole="menuitem"
												items={[
													{
														content: 'Create',
														onAction: handleImportedAction,
													},
													{
														content: 'Refresh',
														onAction: handleExportedAction,
													},
												]} />
										</Popover>

									</div>
								</div>

								<div
									style={{
										width: "100%",
										display: "flex"
									}}
								>
									<div style={{ width: "100%" }}>
										<Select
											label="Payment Profile"
											options={paymentProfiles}
											onChange={handlePaymentProfileChange}
											value={paymentProfile_val}
										/>
									</div>

									<div style={{ padding: "24px 0px 0px 10px" }}>
										<Popover
											active={actionActive2}
											activator={disclosureButtonActivator2}
											onClose={handleToggleAction2}
											autofocusTarget="first-node"
										>
											<ActionList actionRole="menuitem"
												items={[
													{
														content: 'Create',
														onAction: handleImportedAction2,
													},
													{
														content: 'Refresh',
														onAction: handleExportedAction2,
													},
												]} />
										</Popover>
									</div>


								</div>

								<div
									style={{
										width: "100%",
										display: "flex",
									}}
								>
									<div style={{ width: "100%" }}>
										<Select
											label="Return Profile"
											options={returnProfiles}
											onChange={handleReturnProfileChange}
											value={returnProfile_val}
										/>
									</div>
									<div style={{ padding: "24px 0px 0px 10px" }}>
										<Popover
											active={actionActive3}
											activator={disclosureButtonActivator3}
											onClose={handleToggleAction3}
											autofocusTarget="first-node"
										>
											<ActionList actionRole="menuitem"
												items={[
													{
														content: 'Create',
														onAction: handleImportedAction3,
													},
													{
														content: 'Refresh',
														onAction: handleExportedAction3,
													},
												]} />
										</Popover>
									</div>

								</div>
							</Card>}

						</div>
					</div>


					{/* <div style={{paddingLeft:"87%",margin:"1%"}}>
							  <Tooltip active content="Click here to get newly added policies">
								<Button primary size="large" onClick={handleExportedAction}> Refresh </Button>
							  </Tooltip>
							  </div> */}
					<br></br>

					<div style={{
						width: "100%",
						display: "flex",


					}}>

						<div style={{
							width: "50%",
							fontSize: "15px",
							fontWeight: "bold",
							padding: "5%"
						}}
						>Category Template</div>

						<div style={{ width: "100%" }}>

							<Card sectioned roundedAbove="sm">
								<div
									style={{
										width: "100%",

									}}
								>
									<TextField
										label="Select Category"
										value={searchTerm}
										error={error_message2}
										onChange={
											handleSearchChange
										}
										placeholder="Search category..."
										autoComplete="off"
									// error={errors.searchTerm}
									/>
									{menuIsOpen &&
										filteredCategories.length >
										0 && (
											<ul className="dropdown-menu">
												{filteredCategories.map(
													(category) => (
														<li
															key={
																category.id
															}
															onClick={() =>
																handleCategoryClick(category)
															}
															className="dropdown-item"
														>
															{
																category.category_tree_name
															}
														</li>
													)
												)}
											</ul>
										)}{ }


								</div>
							</Card>

						</div>

					</div>
					<br></br>

					{isFieldHidden && (
						<div style={{
							width: "100%",
							display: "flex",

						}}>

							<div style={{
								width: "50%",
								fontSize: "15px",
								fontWeight: "bold",
								padding: "5%"
							}}
							>Item Specifics
							</div>
							<div style={{ width: "100%" }}>
								<Card sectioned roundedAbove="sm">
									<div
										style={{
											width: "100%",
										}}
									>
										<span>
											<div className="subcategory-dropdown custom-polaris-select">
												{/* {console.log(additionalCategoryData)} */}
												{additionalCategoryData.map(attribute => (
													<div key={attribute.name} className="Polaris-Select">
														<label className="category-lable">{attribute.name}</label>
														<select
															value={selectedValues[attribute.name] || ''}
															onChange={(e) => handleValueChange(attribute.name, e.target.value)}
															className="selected-cat"
														>
															{attribute.values.map(value => (
																<option class="" key={value} value={value}>
																	{value}
																</option>
															))}
														</select>
													</div>
												))}

											</div>
										</span>
									</div>
								</Card>
							</div>

						</div>
					)}

					{conidtion_fetched2 && (
						<div style={{
							width: "100%",
							display: "flex",

						}}>

							<div style={{
								width: "50%",
								fontSize: "15px",
								fontWeight: "bold",
								padding: "5%"
							}}
							>Item Specifics
							</div>
							<div style={{ width: "100%" }}>
								<Card sectioned roundedAbove="sm">
									<div >
										<label className="category-lable">Loading...</label>
										<SkeletonBodyText />

									</div>
								</Card>
							</div>

						</div>
					)}

					<br></br>

					{conditions_true && (
						<div style={{
							width: "100%",
							display: "flex",
						}}>

							<div style={{
								width: "50%",
								fontSize: "15px",
								fontWeight: "bold",
								padding: "5%"
							}}
							>Product condition
							</div>
							<div style={{ width: "100%" }}>
								<Card sectioned roundedAbove="sm">
									<div
										style={{
											width: "100%",
										}}
									>
										<label className="category-lable">Select Condition</label>
										<select className="selected-cat" value={selectedCondition} onChange={handleChange}>
											<option value="">select</option>
											{conditions.length > 0 && conditions[0].map(condition => (
												<option key={condition.conditionId} value={condition.conditionId}>
													{condition.conditionDescription}
												</option>
											))}

										</select>

										<div class="item-child-category">
											{conditionDescriptors.map(descriptor => {
												// Check if the descriptor has values
												const hasValues = descriptor.conditionDescriptorValues && descriptor.conditionDescriptorValues.length > 0;
												return hasValues ? (
													<div key={descriptor.conditionDescriptorId}>
														<label className="category-label">{descriptor.conditionDescriptorName}</label>
														<select 
															className="selected-cat" 
															id={`selected-descriptor-value-${descriptor.conditionDescriptorId}`} 
															value={selectedDescriptorValues[descriptor.conditionDescriptorId]?.id || ""} 
															onChange={(e) => {
																const selectedValueId = e.target.value;
																const selectedValueName = e.target.options[e.target.selectedIndex].text;
																handleDescriptorValueChange(descriptor.conditionDescriptorId, descriptor.conditionDescriptorName, selectedValueId, selectedValueName);
															}}
														>
															<option value="" disabled hidden>
																{selectedDescriptorValues[descriptor.conditionDescriptorId] ? '' : `Select ${descriptor.conditionDescriptorName} Value`}
															</option>
															{descriptor.conditionDescriptorValues.map(value => (
																<option key={value.conditionDescriptorValueId} value={value.conditionDescriptorValueId}>
																	{value.conditionDescriptorValueName}
																</option>
															))}
														</select>
													</div>
												) : null;
											})}
										</div> 

									</div>
								</Card>
							</div>

						</div>
					)}

					{conidtion_fetched && (
						<div style={{
							width: "100%",
							display: "flex",

						}}>

							<div style={{
								width: "50%",
								fontSize: "15px",
								fontWeight: "bold",
								padding: "5%"
							}}
							>Product condition
							</div>
							<div style={{ width: "100%" }}>
								<Card sectioned roundedAbove="sm">
									<div >
										<label className="category-lable">Loading...</label>
										<SkeletonBodyText />

									</div>
								</Card>
							</div>

						</div>
					)}


					<Stack distribution="trailing">
						<Button primary submit >Next</Button>
					</Stack>
				</FormLayout>
			</Form>

			{/* </div>               */}
			{/* <div
                                style={{
                                    display: "flex",
                                    justifyContent: "space-between",
                                    marginTop: "20px",
                                }}
                            >
                                

                                    <>
                                      
                                        <Button
                                            primary
                                            id="secondStepNextButton"
                                            onClick={() =>
                                                handleSecondStep(profileId)
                                            }
                                        >
                                            Next
                                        </Button>
                                    </>
                           
                                
                            </div> */}


			<>
				{successMessage && (
					<Toast
						content={successMessage}
						onDismiss={hideToast}
						duration="2000"
					/>
				)}
				{errorMessage && (
					<Toast
						content={errorMessage}
						error
						onDismiss={hideToast}
						duration="2000"
					/>
				)}
			</>

		</div>
	)
}

