import React, { Component } from 'react';

import {Button,ChoiceList, Checkbox, Card, Form, FormLayout, Layout, Page, Stack, TextField, Select, FooterHelp, Link, Toast, Tabs} from '@shopify/polaris';

import AutoCompleteField from './AutoCompleteField';

class ShippingPolicyForm extends Component{
  _isMounted = false;

  state = {
    name: "Ebay Shipping Profile",
    domestic_shipping:"NotSpecified",
    domestic_ship_service1:"",
    ship_fee1:"0",
    x_ship_fee1:"0",
    domestic_free_shipping:"0",
    domestic_fast_shipping:"0",
    domestic_local_pickup:"0",
    domestic_ships_within_handling_days:"-1",
    domestic_pkg_handling_fee:"0",
    intl_shipping:"NotSpecified",
    intl_ship_options1:"0",
    intl_locations1:[],
    intl_ship_service1:"",
    intl_ship_fee1:"0",
    intl_x_ship_fee1:"0",
    intl_pkg_handling_fee:"0",
    ship_options:"1",
    ship_global_locations:"",
    postal_code:"",
    
    selected_tab:0,
    fields_type:'required',

    domestic_shippings: [],
    intl_shippings: [],

    domestic_ship_services: {},
    intl_ship_services: {},

    domestic_ship_services_options: [],
    intl_ship_services_options: [],

    domestic_ship_additional_services: [],
    domestic_ship_additional_services_count: 0,

    intl_ship_additional_services: [],
    intl_ship_additional_services_count: 0
  };

  errors_data = {};
  
  ebay_profile = {};

  handling_days_options = [
    {label:"Select a Option",value:""},
    {value:'0',label:'Same Business Day'},
    {value:'1',label:'1 Business Day'},
    {value:'2',label:'2 Business Days'},
    {value:'3',label:'3 Business Days'},
    {value:'4',label:'4 Business Days'},
    {value:'5',label:'5 Business Days'},
    {value:'10',label:'10 Business Days'},
    {value:'15',label:'15 Business Days'},
    {value:'20',label:'20 Business Days'},
    {value:'30',label:'30 Business Days'}
  ];


  yes_no_options = [
    {label:"Select a Option",value:""},
    {value:"1",label:'Yes'},
    {value:"0",label:'No'}
  ];

  intl_ship_options = [
    {value:'1',label:'Worldwide'},
    {value:'2',label:'Choose custom location'},
    {value:'3',label:'Canada'}
  ];

  intl_locations = [
    {value:'Americas',label:'N. and S. America'},
    {value:'Europe',label:'Europe'},
    {value:'Asia',label:'Asia'},
    {value:'CA',label:'Canada'},
    {value:'GB',label:'United Kingdom'},
    {value:'CN',label:'China'},
    {value:'JP',label:'Japan'},
    {value:'MX',label:'Mexico'},
    {value:'DE',label:'Germany'},
    {value:'BR',label:'Brazil'},
    {value:'FR',label:'France'},
    {value:'AU',label:'Australia'},
    {value:'RU',label:'Russian Federation'}
  ];

  tabs = [
    {
      id: 'required',
      content: 'Required Fields',
      accessibilityLabel: 'Required Fields',
      panelID: 'required-fields',
    }
  ];

  constructor(props){
    super(props);
    this.handleChange = this.handleChange.bind(this);
    this.addProfile = this.addProfile.bind(this);
    this.hideToast = this.hideToast.bind(this);
    
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;

    this.ebay_profile = this.props.store_data.ebay_profile || {};

    

    fetch(this.props.api_url+'/ebayspecificdata'+'?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token)
    .then(res => res.json())
    .then((data) => {
      if(data){
        var ckey;

        var domestic_shippings = [{label:"Select Shipping",value:""}];
        for(ckey in data.domestic_shipping){
          domestic_shippings.push({label: data.domestic_shipping[ckey].value, value: (data.domestic_shipping[ckey].id).toString()});
        }

        var intl_shippings = [{label:"Select Shipping",value:""}];
        for(ckey in data.intl_shipping){
          intl_shippings.push({label: data.intl_shipping[ckey].value, value: (data.intl_shipping[ckey].id).toString()});
        }

        var domestic_ship_services = data.domestic_ship_services;
        var intl_ship_services = data.intl_ship_services;


        this.setState(() => {
          return {
            domestic_shippings:domestic_shippings,
            intl_shippings:intl_shippings,
            domestic_ship_services:domestic_ship_services,
            intl_ship_services:intl_ship_services
          };
        });
      }
    })
    .catch(console.log);

    this.setState({page_title: "New Shipping Profile",sub_title: "Add Ebay Shipping Profile",sub_description: "Enter profile data and click on Save."});
  }

  handleTabChange = (value) => {
    let tab = this.tabs[value];
    this.setState(() => { return {fields_type:tab.id,selected_tab:value} });
  };

  addProfile(){    
    var hasError = false;
    this.errors_data = {};
    if(this.state.name.length <= 0){
      hasError = true;
      this.errors_data.name_error = "name is required";
    }
    
    if(this.state.domestic_shipping.length <= 0){
      hasError = true;
      this.errors_data.domestic_shipping_error = "shipping is required";
    }

    var update_install_step = false;
    if(this.props.form_type === "app_setup"){
      update_install_step = true;
    }

    if(hasError === false){
      this.setState({button_loading:true});
     
      var request_data = {
        name: this.state.name,
        domestic_shipping: this.state.domestic_shipping,
        domestic_ship_service1: this.state.domestic_ship_service1,
        ship_fee1: this.state.ship_fee1,
        x_ship_fee1: this.state.x_ship_fee1,
        domestic_free_shipping: this.state.domestic_free_shipping,
        domestic_fast_shipping:this.state.domestic_fast_shipping,
        domestic_local_pickup: this.state.domestic_local_pickup,
        domestic_ships_within_handling_days: this.state.domestic_ships_within_handling_days,
        domestic_pkg_handling_fee: this.state.domestic_pkg_handling_fee,
        intl_shipping: this.state.intl_shipping,
        intl_ship_options1: this.state.intl_ship_options1,
        intl_locations1: this.state.intl_locations1,
        intl_ship_service1: this.state.intl_ship_service1,
        intl_ship_fee1: this.state.intl_ship_fee1,
        intl_x_ship_fee1: this.state.intl_x_ship_fee1,
        intl_pkg_handling_fee: this.state.intl_pkg_handling_fee,
        ship_options: this.state.ship_options,
        ship_global_locations: this.state.ship_global_locations,
        postal_code: this.state.postal_code,
        domestic_ship_additional_services: this.state.domestic_ship_additional_services,
        intl_ship_additional_services: this.state.intl_ship_additional_services,
        shopify_url:this.props.store_data.shopify_url,
        profile_type:"SHIPPING"
      };

      console.log(request_data);
      // return;

      var requestOptions = {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(request_data)
      };
      var fetch_url = this.props.api_url+'/policies?api_token='+this.props.store_data.user.api_token;

      fetch(fetch_url,requestOptions)
      .then(response => response.json())
      .then((data) => {
        if(data && data.status && data.status === "success"){
          this.setState(() => { return {button_loading:false,success_message:data.msg}; });
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data && data.status && data.status === "error"){
            if(data.errors){
              for(var key in data.errors){
                error_message += key + " : ";
                for(var fkey in data.errors[key]){error_message += data.errors[key][fkey] + "\n";}
                error_message += "\n";
              }
            }
            else if(data.msg){error_message = data.msg;}
          }
        }
        this.setState(() => { return {button_loading:false,error_message:error_message}; } );
      })
      .catch(error => {
        console.error(error);
      });
    }
    else{
      this.setState({button_loading:false});
    }
  }

  hideToast(){
    this.setState({success_message: null,error_message: null});
  }

  handleChange = (field) => {
    return (value) => {
      console.log(field);
      var ckey;
      if(field === "domestic_shipping"){
        let domestic_ship_services_options = [];
        if(this.state.domestic_ship_services && this.state.domestic_ship_services[value]){
          let domestic_ship_services = this.state.domestic_ship_services[value];
          domestic_ship_services_options = [{label:"Select a Option",value:""}];
          for(ckey in domestic_ship_services){
            domestic_ship_services_options.push({label: domestic_ship_services[ckey].value, value: (domestic_ship_services[ckey].id).toString()});
          }
        }
        this.setState(() => { return { domestic_ship_services_options: domestic_ship_services_options, [field]: value.toString() } });        
      }
      else if(field === "intl_shipping"){
        let intl_ship_services_options = [];
        if(this.state.intl_ship_services && this.state.intl_ship_services[value]){
          let intl_ship_services = this.state.intl_ship_services[value];
          intl_ship_services_options = [{label:"Select a Option",value:""}];
          for(ckey in intl_ship_services){
            intl_ship_services_options.push({label: intl_ship_services[ckey].value, value: (intl_ship_services[ckey].id).toString()});
          }
        }
        this.setState(() => { return { intl_ship_services_options: intl_ship_services_options, [field]: value.toString() } });        
      }
      else{
        this.setState(() => { return { [field]: value.toString() } });
      }
    }
  };

  handleChoiceListChange = (field) => {
    return (value) => {
      this.setState({ [field]: value });
    }
  };

  render(){
    return (
      <Page title={this.state.page_title}>

        {this.state.success_message &&
          <Toast content={this.state.success_message} onDismiss={this.hideToast} duration="6000" />
        }
        {this.state.error_message &&
          <Toast content={this.state.error_message} error onDismiss={this.hideToast} duration="6000" />
        }

        <Layout>
          <Layout.AnnotatedSection title={this.state.sub_title} description={this.state.sub_description}>
            <Card sectioned>
              <Form onSubmit={this.addProfile} method="post" encType="multipart/form-data" preventDefault="true">

                <Tabs tabs={this.tabs} selected={this.state.selected_tab} onSelect={this.handleTabChange}>

                  {this.state.fields_type === "required" &&

                  <FormLayout>

                    <TextField type="text" label="Profile Name" error={this.errors_data.name_error} value={this.state.name} onChange={this.handleChange('name')} />
                    
                    
                    <Select label="Domestic Shipping" options={this.state.domestic_shippings} error={this.errors_data.domestic_shipping_error} onChange={this.handleChange('domestic_shipping')} value={this.state.domestic_shipping} />

                    {this.state.domestic_shipping !== '' && this.state.domestic_shipping !== 'NotSpecified' &&
                    <div>
                      <Select label="Fast Shipping" options={this.yes_no_options} error={this.errors_data.domestic_fast_shipping_error} onChange={this.handleChange('domestic_fast_shipping')} value={this.state.domestic_fast_shipping} />
                      
                      <Select label="Free Shipping" options={this.yes_no_options} error={this.errors_data.domestic_free_shipping_error} onChange={this.handleChange('domestic_free_shipping')} value={this.state.domestic_free_shipping} />
                      
                      <FormLayout>
                        <FormLayout.Group condensed>
                          <Select label="Shipping Service" options={this.state.domestic_ship_services_options} error={this.errors_data.domestic_ship_service1_error} onChange={this.handleChange('domestic_ship_service1')} value={this.state.domestic_ship_service1} />
                          <TextField type="text" label="Cost" error={this.errors_data.ship_fee1_error} value={this.state.ship_fee1} onChange={this.handleChange('ship_fee1')} />
                          <TextField type="text" label="Additional" error={this.errors_data.x_ship_fee1_error} value={this.state.x_ship_fee1} onChange={this.handleChange('x_ship_fee1')} />                         
                        </FormLayout.Group>
                      </FormLayout>

                      <Select label="Local Pickup" options={this.yes_no_options} error={this.errors_data.domestic_local_pickup_error} onChange={this.handleChange('domestic_local_pickup')} value={this.state.domestic_local_pickup} />
                      <Select label="Handling Time" options={this.handling_days_options} error={this.errors_data.domestic_ships_within_handling_days_error} onChange={this.handleChange('domestic_ships_within_handling_days')} value={this.state.domestic_ships_within_handling_days} />
                    
                    </div>
                    }

                    
                    {this.state.domestic_shipping === 'Calculated' &&
                    <TextField type="text" label="Handling Cost" error={this.errors_data.domestic_pkg_handling_fee_error} value={this.state.domestic_pkg_handling_fee} onChange={this.handleChange('domestic_pkg_handling_fee')} />
                    }

                  


                    <Select label="International Shipping" options={this.state.intl_shippings} error={this.errors_data.intl_shipping_error} onChange={this.handleChange('intl_shipping')} value={this.state.intl_shipping} />

                    {this.state.intl_shipping !== '' && this.state.intl_shipping !== 'NotSpecified' &&
                    <div>
                      
                      <FormLayout>
                        <FormLayout.Group condensed>
                          <Select label="Shipping Service" options={this.state.intl_ship_services_options} error={this.errors_data.intl_ship_service1_error} onChange={this.handleChange('intl_ship_service1')} value={this.state.intl_ship_service1} />
                          <TextField type="text" label="Cost" error={this.errors_data.intl_ship_fee1_error} value={this.state.intl_ship_fee1} onChange={this.handleChange('intl_ship_fee1')} />
                          <TextField type="text" label="Additional" error={this.errors_data.intl_x_ship_fee1_error} value={this.state.intl_x_ship_fee1} onChange={this.handleChange('intl_x_ship_fee1')} />                         
                        </FormLayout.Group>

                        {this.state.intl_ship_service1 &&
                        <FormLayout.Group condensed>
                          <Select label="Ship to" options={this.intl_ship_options} error={this.errors_data.intl_ship_options1_error} onChange={this.handleChange('intl_ship_options1')} value={this.state.intl_ship_options1} />

                          <ChoiceList
                            allowMultiple
                            title="Locations"
                            choices={this.intl_locations}
                            error={this.errors_data.intl_locations1_error}
                            onChange={this.handleChoiceListChange('intl_locations1')}
                            selected={this.state.intl_locations1}
                          />
                          
                        </FormLayout.Group>
                        }

                      </FormLayout>
                    </div>
                    }

                    {this.state.intl_shipping === 'Calculated' &&
                    <TextField type="text" label="Handling Cost" error={this.errors_data.intl_pkg_handling_fee_error} value={this.state.intl_pkg_handling_fee} onChange={this.handleChange('intl_pkg_handling_fee')} />
                    }
                  
                  </FormLayout>

                  }

                </Tabs>

                <FormLayout>
                  <Stack distribution="trailing">
                    <Button primary submit loading={this.state.button_loading}>Save</Button>
                  </Stack>
                </FormLayout>
              </Form>
            </Card>
          </Layout.AnnotatedSection>
          <Layout.Section>
          
          </Layout.Section>
        </Layout>
      </Page>
    );
  }
}


export default ShippingPolicyForm;