<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class AppCharge extends Model
{
	protected $table = 'app_charges';
	protected $connection= 'mysql';

	public function __construct(){
		$this->connection = config('config.default_connection');
	}

  	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}

	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	public function plan(){
		return $this->hasOne('App\Plan','id','plan_id');
	}
	
  	protected $fillable = [
		'name','charge_id','status','is_test','app_charge_data','plan_id','store_id','user_id'
  	];
}
