<?php

namespace App\Helpers;

use Illuminate\Support\Facades\DB;
use App\Http\Requests;
use Illuminate\Support\Facades\Auth;
use App\MappingListingsVariant;
use PHPShopify;

class EbayHelper{

	public static function getEbayCountry($site_id = 0){
		$countryCodes = array(
			15 => "AU",
			16 => "AT",
			123 => "BE",
			23 => "BE",
			2 => "CA",
			210 => "CA",
			71 => "FR",
			77 => "DE",
			201 => "HK",
			203 => "IN",
			205 => "IE",
			101 => "IT",
			207 => "MY",
			146 => "NL",
			211 => "PH",
			212 => "PL",
			215 => "RU",
			216 => "SG",
			186 => "ES",
			193 => "CH",
			//3 => "UK",
			3 => "GB",
			0 => "US"
		);
		return (isset($countryCodes[$site_id])) ? $countryCodes[$site_id] : "ZZ";
	}

	public static function getEbayCurrency($site_id = 0){
		$currencyCodes = array(
			15 => "AUD",
			16 => "EUR",
			123 => "EUR",
			23 => "EUR",
			2 => "CAD",
			210 => "CAD",
			71 => "EUR",
			77 => "EUR",
			201 => "HKD",
			203 => "INR",
			205 => "EUR",
			101 => "EUR",
			207 => "MYR",
			146 => "EUR",
			211 => "PHP",
			212 => "PLN",
			215 => "RUB",
			216 => "SGD",
			186 => "EUR",
			193 => "CHF",
			3 => "GBP",
			0 => "USD"
		);
		return (isset($currencyCodes[$site_id])) ? $currencyCodes[$site_id] : "USD";
	}

	public static function getEbaySiteNameFromID($site_id = 0){
		$countryCodes = array(
			15 => "Australia",
			16 => "Austria",
			123 => "Belgium_Dutch",
			23 => "Belgium_French",
			2 => "Canada",
			210 => "CanadaFrench",
			71 => "France",
			77 => "Germany",
			201 => "HongKong",
			203 => "India",
			205 => "Ireland",
			101 => "Italy",
			207 => "Malaysia",
			146 => "Netherlands",
			211 => "Philippines",
			212 => "Poland",
			215 => "Russia",
			216 => "Singapore",
			186 => "Spain",
			193 => "Switzerland",
			3 => "UK",
			//3 => "GB",
			0 => "US"
		);
		return (isset($countryCodes[$site_id])) ? $countryCodes[$site_id] : "ZZ";
	}

	public static function getEbaySiteIDFromSite($site_name = ""){
		$countryIDs = array(
			"Australia" => "15",
			"Austria" => "16",
			"Belgium_Dutch" => "123",
			"Belgium_French" => "23",
			"Canada" => "2",
			"CanadaFrench" => "2",
			"France" => "71",
			"Germany" => "77",
			"HongKong" => "201",
			"India" => "203",
			"Ireland" => "205",
			"Italy" => "101",
			"Malaysia" => "207",
			"Netherlands" => "146",
			"Philippines" => "211",
			"Poland" => "212",
			"Russia" => "215",
			"Singapore" => "216",
			"Spain" => "186",
			"Switzerland" => "193",
			"UK" => "3",
			"GB" => "3",
			"US" => "0"
		);
		return (isset($countryIDs[$site_name])) ? $countryIDs[$site_name] : null;
	}

	public static function ebayTradeAPI($call,$body,$field,$EBAY){
		$siteid = (isset($_GET["siteid"]) && $_GET["siteid"]) ? $_GET["siteid"] : "0";
		$requestBody = "<?xml version='1.0' encoding='utf-8'?>"."<{$call}Request xmlns='urn:ebay:apis:eBLBaseComponents'>{$body}</{$call}Request>";
		$headers = array (
			'X-EBAY-API-COMPATIBILITY-LEVEL: 681',
			'X-EBAY-API-DEV-NAME: '.$EBAY['devid'],
			'X-EBAY-API-APP-NAME: '.$EBAY['appid'],
			'X-EBAY-API-CERT-NAME: '.$EBAY['certid'],
			'X-EBAY-API-CALL-NAME: '.$call,
			'X-EBAY-API-SITEID: '.$siteid
		);
		
		$curl = curl_init();
		curl_setopt($curl,CURLOPT_URL,$EBAY['trade']);
		curl_setopt($curl,CURLOPT_SSL_VERIFYPEER,0);
		curl_setopt($curl,CURLOPT_SSL_VERIFYHOST,0);
		curl_setopt($curl,CURLOPT_HTTPHEADER,$headers);
		curl_setopt($curl,CURLOPT_POST,0);
		curl_setopt($curl,CURLOPT_POSTFIELDS,$requestBody);
		curl_setopt($curl,CURLOPT_RETURNTRANSFER,1);
		$response = curl_exec($curl);
		if(curl_error($curl)) $curl_error = curl_error($curl);
		curl_close($curl);
		
		if($response === FALSE) exit('No response from eBay server!');
		if(($begin = strpos($response,"<{$field}>")) !== FALSE){
			$begin += strlen($field) + 2;
			if(($end = strpos($response,"</{$field}>",$begin)) !== FALSE){
				return substr($response,$begin,$end - $begin);
			}
		}
		return null;
		//exit("Field <b>{$field}</b> not found in eBay response!<p/>\n\n{$response}");
	}

	public static function getEbayClient($ebayAcocunt){
		if($ebayAcocunt){
		}
		return null;
	}



	public static function submitAmazonFeed($amazonAccount,$feedXML,$feedType){
		$errors = [];

		if($amazonAccount && $feedXML && $feedType){
			$amazonConfig = AmazonHelper::getAmazonClient($amazonAccount);
			try{
				$amazonClient = new \ClouSale\AmazonSellingPartnerAPI\Api\FeedsApi($amazonConfig);

				$body = new \ClouSale\AmazonSellingPartnerAPI\Models\Feeds\CreateFeedDocumentSpecification([
					"content_type" => "application/xml; charset=UTF-8"
				]);
				$result = $amazonClient->createFeedDocument($body);
				$documentPayload = $result->getPayload();
				$document_id = $documentPayload->getFeedDocumentId();
				$document_url = $documentPayload->getUrl();
				$document_key = base64_decode($documentPayload->getEncryptionDetails()->getKey());
				$document_iv = base64_decode($documentPayload->getEncryptionDetails()->getInitializationVector());

				$feedData = utf8_encode($feedXML);
				//$feedData = $feedXML;
				
				$feedDataEncrypted = openssl_encrypt($feedData,'AES-256-CBC',$document_key,OPENSSL_RAW_DATA,$document_iv);

				$ch = curl_init($document_url);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
				curl_setopt($ch,CURLOPT_CUSTOMREQUEST,"PUT");
				curl_setopt($ch,CURLOPT_HTTPHEADER,["Content-Type: application/xml; charset=UTF-8"]);
				curl_setopt($ch,CURLOPT_POSTFIELDS,$feedDataEncrypted);
				curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
				$response = trim(curl_exec($ch));
				curl_close($ch);
				if($response === null || $response === ""){
					$body = new \ClouSale\AmazonSellingPartnerAPI\Models\Feeds\CreateFeedSpecification([
						"feed_type" => $feedType,
						"marketplace_ids" => [$amazonAccount->marketplace_id],
						"input_feed_document_id" => $document_id
					]);
				
					$feedResult = $amazonClient->createFeed($body);
					$feedPayload = $feedResult->getPayload();
					
					$feed_id = $feedPayload->getFeedId();

					return ["feed_id" => $feed_id];
				}
				else{
					$errors[] = "error submitting inventory feed | response : ".$response;
				}
			}
			catch(\Exception $e){
				report($e);
				$errors[] = "error submitting inventory feed | response : ".$e->getMessage();
			}
		}
		return $errors;
	}

	public static function getDeleteProductFeedXML($productsObj,$amazonAccount){
		$xml = '<?xml version="1.0" encoding="iso-8859-1"?>';
		$xml .= '<AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="amzn-envelope.xsd">';
			$xml .= '<Header>';
				$xml .= '<DocumentVersion>1.01</DocumentVersion>';
				$xml .= '<MerchantIdentifier>'.$amazonAccount->merchant_id.'</MerchantIdentifier>';
			$xml .= '</Header>';
			$xml .= '<MessageType>Product</MessageType>';
			$xml .= '<PurgeAndReplace>false</PurgeAndReplace>';
		$msgCount = 1;
		foreach($productsObj as $productObj){
			$variants = $productObj["variants"];
			$option1name = strtolower($productObj->option1name);
			if($option1name){
				$variant = $productObj->variants[0];
				$vsku = $variant->sku;
				$amzListingVariant = AmazonListingVariant::where('variant_id',$variant->variant_id)->first();
				if($amzListingVariant){
					if($amzListingVariant->sku && $amzListingVariant->sku != $vsku){
						$vsku = $amzListingVariant->sku;
					}
					else if(!$amzListingVariant->sku){
						$amzListingVariant->sku = $vsku;
						$amzListingVariant->save();
					}
				}
				$vsku = $vsku.'-APRO';
				$xml .= '<Message>';
					$xml .= '<MessageID>'.$msgCount.'</MessageID>';
					$xml .= '<OperationType>Delete</OperationType>';
					$xml .= '<Product>';
						$xml .= '<SKU><![CDATA['.$vsku.']]></SKU>';
					$xml .= '</Product>';
				$xml .='</Message>';
				$msgCount++;
			}
			foreach($variants as $vkey => $variant){
				$vsku = $variant->sku;
				$amzListingVariant = AmazonListingVariant::where('variant_id',$variant->variant_id)->first();
				if($amzListingVariant){
					if($amzListingVariant->sku && $amzListingVariant->sku != $vsku){
						$vsku = $amzListingVariant->sku;
					}
					else if(!$amzListingVariant->sku){
						$amzListingVariant->sku = $vsku;
						$amzListingVariant->save();
					}
				}
				$xml .= '<Message>';
					$xml .= '<MessageID>'.$msgCount.'</MessageID>';
					$xml .= '<OperationType>Delete</OperationType>';
					$xml .= '<Product>';
						$xml .= '<SKU><![CDATA['.$vsku.']]></SKU>';
					$xml .= '</Product>';
				$xml .='</Message>';
				$msgCount++;
			}
		}
		$xml .='</AmazonEnvelope>';
		return $xml;
	}

	public static function getProductsFeedXML($pendingPublishs,$amazonAccount,$shopifyStore){
		$user_id = $amazonAccount->user_id;
		$xml = '<?xml version="1.0" encoding="iso-8859-1"?>';
		$xml .= '<AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="amzn-envelope.xsd">';
			$xml .= '<Header>';
				$xml .= '<DocumentVersion>1.01</DocumentVersion>';
				$xml .= '<MerchantIdentifier>'.$amazonAccount->merchant_id.'</MerchantIdentifier>';
			$xml .= '</Header>';
			$xml .= '<MessageType>Product</MessageType>';
			$xml .= '<PurgeAndReplace>false</PurgeAndReplace>';
		
		$errors = array();

		PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
		$shopifyClient = new PHPShopify\ShopifySDK;

		$msgCount = 1;
		$hasProduct = false;
		foreach($pendingPublishs as $pendingPublish){
			$product = $shopifyStore->products()->with('variants')->find($pendingPublish->product_id);
			$profile = $shopifyStore->profiles()->with('attributeMapping')->with('category')->find($pendingPublish->profile_id);
			if($product && $product->offer_only == 1){
				
				try{
					$shProduct = json_decode($product->shopify_product_data,true);
					$variants = $product->variants;
					
					foreach($variants as $vkey => $variant){
						$shVariant = array();
						foreach($shProduct["variants"] as $sVariant){
							if($sVariant["id"] == $variant->shopify_variant_id){
								$shVariant = $sVariant;
								break;
							}
						}
						if(!$shVariant || !$variant->asin) continue;

						$vsku = $variant->sku;
						
						$xml .= '<Message>';
							$xml .= '<MessageID>'.$msgCount.'</MessageID>';
							$xml .= '<OperationType>Update</OperationType>';
							$xml .= '<Product>';
								$xml .= '<SKU><![CDATA['.$vsku.']]></SKU>';
								$xml .= '<StandardProductID>';
									$xml .= '<Type>ASIN</Type>';
									$xml .= '<Value>'.$variant->asin.'</Value>';
								$xml .= '</StandardProductID>';

								if($profile->product_tax_code) $xml .= '<ProductTaxCode>'.$profile->product_tax_code.'</ProductTaxCode>';

								if($profile->item_condition){
									$xml .= '<Condition>';
										$xml .= '<ConditionType>'.$profile->item_condition .'</ConditionType>';
										if(strtolower($profile->item_condition) != "new" && $profile->item_note) $xml .= '<ConditionNote><![CDATA['.$profile->item_note.']]></ConditionNote>';
									$xml .= '</Condition>';
								}
							$xml .= '</Product>';
						$xml .='</Message>';

						$hasProduct = true;

						$msgCount++;
					}
				}
				catch(\Exception $e){
					report($e);
					$errors[] = $e->getMessage();
				}
			}
			else if($product && $profile && $profile->category){
				$deleteSkus = array();
				$listing = array();
				if($product->listing_id){
					$listing = $shopifyStore->listings()->with('variants')->find($product->listing_id);
					if($listing && $listing->variants){
						foreach($listing->variants as $lvariant){
							$varFound = false;
							foreach($product->variants as $pvariant){
								if($pvariant->id == $lvariant->variant_id){
									$varFound = true;
									break;
								}
							}
							if(!$varFound && !in_array($lvariant->sku,$deleteSkus)){
								$deleteSkus[] = $lvariant->sku;
								if($lvariant->variant_id){
									$lvariant->variant_id = NULL;
									$lvariant->save();
								}
							}
						}
					}
				}

				try{
					//$shProduct = $shopifyClient->Product($product->shopify_product_id)->get();
					$shProduct = json_decode($product->shopify_product_data,true);

					if($shProduct["vendor"] == "LA' BELLO BEAUTY") $shProduct["vendor"] = "LA 'BELLO BEAUTY";
					//$shProduct["vendor"] = "The Maine Sales Company";

					$description = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>',$shProduct["body_html"]);
					$description = trim(preg_replace('/\s\s+/','',strip_tags($description,'<p><br>')));
					$description = str_replace("\n","",$description);
					$description = str_replace('\n',"",$description);
					$description = str_replace('<p> </p>',"",$description);
					$description = str_replace('<p></p>',"",$description);

					$categoryData = ($profile->category_fields_data) ? json_decode($profile->category_fields_data,true) : array();
					$productTypeData = ($profile->product_type_fields_data) ? json_decode($profile->product_type_fields_data,true) : array();

					$amazonCategory = $profile->category;

					$option1name = (isset($shProduct["options"][0]["name"])) ? strtolower($shProduct["options"][0]["name"]) : NULL;
					$option2name = (isset($shProduct["options"][1]["name"])) ? strtolower($shProduct["options"][1]["name"]) : NULL;
					$option3name = (isset($shProduct["options"][2]["name"])) ? strtolower($shProduct["options"][2]["name"]) : NULL;

					$tags = $shProduct["tags"];
					$variants = $product->variants;

					$browse_node_ids = ($profile->browse_node_ids) ? explode(",",$profile->browse_node_ids) : array();
					$bullet_points = ($profile->bullet_points) ? explode(",",$profile->bullet_points) : array();
					//$search_terms = ($profile->search_terms) ? explode(",",$profile->search_terms) : array();
					$search_terms = array(trim($profile->search_terms));
					$platinum_keywords = ($profile->platinum_keywords) ? explode(",",$profile->platinum_keywords) : array();
					$target_audiences = ($profile->target_audience) ? explode(",",$profile->target_audience) : array();

					
					//$deleteSkus[] = ($listing) ? $listing->sku : $variants[0]->sku.'-APRO';

					if($option1name && $shProduct["variants"][0]["option1"] && $shProduct["variants"][0]["option1"] != "Default Title"){
						$variant = $variants[0];
						$vsku = ($listing) ? $listing->sku : $variant->sku.'-APRO';
						/*
						if($listing && $listing->variants){
							foreach($listing->variants as $lvariant){
								if($variant->id == $lvariant->variant_id){
									$vsku = $lvariant->sku;
									break;
								}
							}
						}
						*/
						$xml .= '<Message>';
							$xml .= '<MessageID>'.$msgCount.'</MessageID>';
							$xml .= '<OperationType>Update</OperationType>';
							$xml .= '<Product>';
								$xml .= '<SKU><![CDATA['.$vsku.']]></SKU>';
								if($profile->item_condition){
									$xml .= '<Condition>';
										$xml .= '<ConditionType>'.$profile->item_condition .'</ConditionType>';
										if(strtolower($profile->item_condition) != "new"){
											if($profile->item_note) $xml .= '<ConditionNote><![CDATA['.$profile->item_note.']]></ConditionNote>';
										}
									$xml .= '</Condition>';
								}

								$xml .= '<DescriptionData>';
									$xml .= '<Title><![CDATA['.$shProduct["title"].']]></Title>';
									if($shProduct["vendor"]) $xml .= '<Brand><![CDATA['.$shProduct["vendor"].']]></Brand>';
									$xml .= '<Description><![CDATA['.$description.']]></Description>';
									
									if($bullet_points){
										$bpc = 0;
										foreach($bullet_points as $bullet_point){
											if($bpc < 5 && $bullet_point){
												$xml .= '<BulletPoint><![CDATA['.$bullet_point.']]></BulletPoint>';
												$bpc++;
											}
										}
									}

									//if($profile->manuf_name) $xml .= '<Manufacturer><![CDATA['.$profile->manuf_name.']]></Manufacturer>';
									//if($profile->manuf_part_no) $xml .= '<MfrPartNumber><![CDATA['.$profile->manuf_part_no.']]></MfrPartNumber>';
		
									if($search_terms){
										$stc = 0;
										foreach($search_terms as $search_term){
											if($stc < 5 && $search_term){
												$xml .= '<SearchTerms><![CDATA['.$search_term.']]></SearchTerms>';
												$stc++;
											}
										}
									}

									if($platinum_keywords){
										$pkc = 0;
										foreach($platinum_keywords as $platinum_keyword){
											if($pkc < 20 && $platinum_keyword){
												$xml .= '<PlatinumKeywords><![CDATA['.$platinum_keyword.']]></PlatinumKeywords>';
												$pkc++;
											}
										}
									}

									if($profile->item_type) $xml .= '<ItemType>'.$profile->item_type.'</ItemType>';
									
									if($target_audiences){
										$tac = 0;
										foreach($target_audiences as $target_audience){
											if($tac < 4 && $target_audience){
												$xml .= '<TargetAudience>'.$target_audience.'</TargetAudience>';
												$tac++;
											}
										}
									}

									$xml .= '<IsGiftWrapAvailable>false</IsGiftWrapAvailable>';
									$xml .= '<IsGiftMessageAvailable>false</IsGiftMessageAvailable>';

									if($browse_node_ids){
										$bnic = 0;
										foreach($browse_node_ids as $browse_node_id){
											if($bnic < 2 && $browse_node_id){
												$xml .= '<RecommendedBrowseNode>'.$browse_node_id.'</RecommendedBrowseNode>';
												$bnic++;
											}
										}
									}
		
									if(trim($profile->merchant_shipping_group_name)){
										$xml .= '<MerchantShippingGroupName><![CDATA['.trim($profile->merchant_shipping_group_name).']]></MerchantShippingGroupName>';
									}
		
								$xml .= '</DescriptionData>';
								if(($amazonCategory) && ($categoryData || $productTypeData)){
									$categoryData["Parentage"] = "parent";
									$xml .= '<ProductData>';
										$xml .= AmazonHelper::getParentProductCategoryXML($amazonCategory,$categoryData,$productTypeData,$profile,$product,$shProduct);
									$xml .= '</ProductData>';
								}
							$xml .= '</Product>';
						$xml .='</Message>';
			
						$msgCount++;
					}

					foreach($variants as $vkey => $variant){
						$shVariant = array();
						foreach($shProduct["variants"] as $sVariant){
							if($sVariant["id"] == $variant->shopify_variant_id){
								$shVariant = $sVariant;
								break;
							}
						}
						if(!$shVariant) continue;

						$vsku = $variant->sku;
						if($listing && $listing->variants){
							foreach($listing->variants as $lvariant){
								if($variant->id == $lvariant->variant_id){
									$vsku = $lvariant->sku;
									break;
								}
							}
						}

						$xml .= '<Message>';
							$xml .= '<MessageID>'.$msgCount.'</MessageID>';
							$xml .= '<OperationType>Update</OperationType>';
							$xml .= '<Product>';
								$xml .= '<SKU><![CDATA['.$vsku.']]></SKU>';
								if($variant->product_id_val){
									$xml .= '<StandardProductID>';
										$xml .= '<Type>UPC</Type>';
										$xml .= '<Value>'.$variant->product_id_val.'</Value>';
									$xml .= '</StandardProductID>';
								}

								if($profile->product_tax_code) $xml .= '<ProductTaxCode>'.$profile->product_tax_code.'</ProductTaxCode>';

								if($profile->item_condition){
									$xml .= '<Condition>';
										$xml .= '<ConditionType>'.$profile->item_condition .'</ConditionType>';
										if(strtolower($profile->item_condition) != "new" && $profile->item_note) $xml .= '<ConditionNote><![CDATA['.$profile->item_note.']]></ConditionNote>';
									$xml .= '</Condition>';
								}

								$pro_title = $shProduct["title"];

								$opvalstr = "";
								if($shVariant && $shVariant["title"] && $shVariant["title"] != "Default Title") $opvalstr = " (".$shVariant["title"].")";

								$xml .= '<DescriptionData>';
									$xml .= '<Title><![CDATA['.$pro_title.$opvalstr.']]></Title>';

									if($shProduct["vendor"]) $xml .= '<Brand><![CDATA['.$shProduct["vendor"].']]></Brand>';
									$xml .= '<Description><![CDATA['.$description.']]></Description>';
									if($bullet_points){
										$bpc = 0;
										foreach($bullet_points as $bullet_point){
											if($bpc < 5 && $bullet_point){
												$bullet_point = substr($bullet_point,0,500);
												$xml .= '<BulletPoint><![CDATA['.$bullet_point.']]></BulletPoint>';
												$bpc++;
											}
										}
									}
								
									$weight_unit = "";
									if($shVariant["weight_unit"] == "lb") $weight_unit = "LB";
									else if($shVariant["weight_unit"] == "g" || $shVariant["weight_unit"] == "gr") $weight_unit = "GR";
									else if($shVariant["weight_unit"] == "oz") $weight_unit = "OZ";
									else if($shVariant["weight_unit"] == "kg" || $shVariant["weight_unit"] == "k") $weight_unit = "KG";
									else if($shVariant["weight_unit"] == "mg") $weight_unit = "MG";

									/*
									if($productObj->length || $productObj->height || $productObj->width){
										$xml .= '<ItemDimensions>';
										if($productObj->length) $xml .= '<Length unitOfMeasure="IN">'.$productObj->length.'</Length>';
										if($productObj->width) $xml .= '<Width unitOfMeasure="IN">'.$productObj->width.'</Width>';
										if($productObj->height) $xml .= '<Height unitOfMeasure="IN">'.$productObj->height.'</Height>';
										$xml .= '</ItemDimensions>';
									}
									*/

									$var_weight = ($shVariant["weight"]) ? number_format($shVariant["weight"],2) : null;

									if($var_weight && $weight_unit) $xml .= '<ShippingWeight unitOfMeasure="'.$weight_unit.'">'.$var_weight.'</ShippingWeight>';
									
									//if($profile->manuf_name) $xml .= '<Manufacturer><![CDATA['.$profile->manuf_name.']]></Manufacturer>';
									//if($profile->manuf_part_no) $xml .= '<MfrPartNumber><![CDATA['.$profile->manuf_part_no.']]></MfrPartNumber>';

									if($search_terms){
										$stc = 0;
										foreach($search_terms as $search_term){
											if($stc < 5 && $search_term){
												$xml .= '<SearchTerms><![CDATA['.$search_term.']]></SearchTerms>';
												$stc++;
											}
										}
									}
									if($platinum_keywords){
										$pkc = 0;
										foreach($platinum_keywords as $platinum_keyword){
											if($pkc < 20 && $platinum_keyword){
												$xml .= '<PlatinumKeywords><![CDATA['.$platinum_keyword.']]></PlatinumKeywords>';
												$pkc++;
											}
										}
									}


									if($profile->item_type) $xml .= '<ItemType>'.$profile->item_type.'</ItemType>';

									else if($profile->item_type) $xml .= '<ItemType>'.$profile->item_type.'</ItemType>';

									if($target_audiences){
										$tac = 0;
										foreach($target_audiences as $target_audience){
											if($tac < 4 && $target_audience){
												$xml .= '<TargetAudience><![CDATA['.$target_audience.']]></TargetAudience>';
												$tac++;
											}
										}
									}

									$xml .= '<IsGiftWrapAvailable>false</IsGiftWrapAvailable>';
									$xml .= '<IsGiftMessageAvailable>false</IsGiftMessageAvailable>';

									if($browse_node_ids){
										$bnic = 0;
										foreach($browse_node_ids as $browse_node_id){
											if($bnic < 2 && $browse_node_id){
												$xml .= '<RecommendedBrowseNode>'.$browse_node_id.'</RecommendedBrowseNode>';
												$bnic++;
											}
										}
									}

									if(trim($profile->merchant_shipping_group_name)) $xml .= '<MerchantShippingGroupName><![CDATA['.trim($profile->merchant_shipping_group_name).']]></MerchantShippingGroupName>';
									
								$xml .= '</DescriptionData>';
								if($amazonCategory){
									if($option1name && $shProduct["variants"][0]["option1"] && $shProduct["variants"][0]["option1"] != "Default Title") $categoryData["Parentage"] = "child";

									$xml .= '<ProductData>';
										$xml .= AmazonHelper::getProductCategoryXML($amazonCategory,$categoryData,$productTypeData,$profile,$product,$shProduct,$shVariant);
									$xml .= '</ProductData>';
								}
							$xml .= '</Product>';
						$xml .='</Message>';
			
						$msgCount++;
					}

					$hasProduct = true;

					if($deleteSkus){
						foreach($deleteSkus as $dSku){
							$xml .= '<Message>';
								$xml .= '<MessageID>'.$msgCount.'</MessageID>';
								$xml .= '<OperationType>Delete</OperationType>';
								$xml .= '<Product>';
									$xml .= '<SKU><![CDATA['.$dSku.']]></SKU>';
								$xml .= '</Product>';
							$xml .='</Message>';
							$msgCount++;
						}
					}

				}
				catch(\Exception $e){
					report($e);
					$errors[] = $e->getMessage();
				}
			}
			else{
				if(!$product) $errors[] = "product not found | product_id:".$pendingPublish->product_id;
				else if(!$profile) $errors[] = "profile not found | product_id:".$pendingPublish->product_id;
				else if(!$profile->category) $errors[] = "amazon category not found | profile_id:".$pendingPublish->profile_id;
			}
		}

		$xml .='</AmazonEnvelope>';

		return ($hasProduct) ? $xml : null;
	}

	public static function getParentProductCategoryXML($amazonCategory,$categoryData,$productTypeData,$profile,$product,$shProduct){
		$user_id = $product->user_id;
		$productType = $profile->product_type;
		$variant = $shProduct["variants"][0];

		$option1name = (isset($shProduct["options"][0]["name"])) ? strtolower($shProduct["options"][0]["name"]) : NULL;
		$option2name = (isset($shProduct["options"][1]["name"])) ? strtolower($shProduct["options"][1]["name"]) : NULL;
		$option3name = (isset($shProduct["options"][2]["name"])) ? strtolower($shProduct["options"][2]["name"]) : NULL;

		if($productType && (isset($productTypeData["VariationTheme"])) && ($productTypeData["VariationTheme"])) $variationTheme = $productTypeData["VariationTheme"];
		else $variationTheme = ((isset($categoryData["VariationTheme"])) && ($categoryData["VariationTheme"])) ? $categoryData["VariationTheme"] : "";
		

		$option1Attr = "";
		$option2Attr = "";
		$option3Attr = "";

		if($profile->attributeMapping->count() > 0){
			$attributeMapping = array();
			foreach($profile->attributeMapping as $attrMapping) $attributeMapping[strtolower($attrMapping->option_name)] = $attrMapping->attribute_name;

			$option1Attr = (isset($attributeMapping[$option1name])) ? $attributeMapping[$option1name] : null;
			$option2Attr = (isset($attributeMapping[$option2name])) ? $attributeMapping[$option2name] : null;
			$option3Attr = (isset($attributeMapping[$option3name])) ? $attributeMapping[$option3name] : null;

			if($option1Attr){
				$categoryData[$option1Attr] = $variant["option1"];
				$productTypeData[$option1Attr] = $variant["option1"];
				if((strpos($option1Attr,'Name') !== false)){
					$tmpOption1Attr = str_replace("Name","",$option1Attr);
					if($tmpOption1Attr){
						$categoryData[$tmpOption1Attr] = $variant["option1"];
						$productTypeData[$tmpOption1Attr] = $variant["option1"];
					}
				}
			}
			if($option2Attr){
				$categoryData[$option2Attr] = $variant["option2"];
				$productTypeData[$option2Attr] = $variant["option2"];
				if((strpos($option2Attr,'Name') !== false)){
					$tmpOption2Attr = str_replace("Name","",$option2Attr);
					if($tmpOption2Attr){
						$categoryData[$tmpOption2Attr] = $variant["option2"];
						$productTypeData[$tmpOption2Attr] = $variant["option2"];
					}
				}
			}
			if($option3Attr){
				$categoryData[$option3Attr] = $variant["option3"];
				$productTypeData[$option3Attr] = $variant["option3"];
				if((strpos($option3Attr,'Name') !== false)){
					$tmpOption3Attr = str_replace("Name","",$option3Attr);
					if($tmpOption3Attr){
						$categoryData[$tmpOption3Attr] = $variant["option3"];
						$productTypeData[$tmpOption3Attr] = $variant["option3"];
					}
				}
			}
		}

		$varDataAdded = false;

		$xml = "<".$amazonCategory->name.">";
		if($amazonCategory->name == "Toys"){
			$varDataAdded = true;
			$xml .= "<VariationData>";
				$xml .= '<Parentage>parent</Parentage>';
				$xml .= '<VariationTheme>'.$variationTheme.'</VariationTheme>';
			$xml .= "</VariationData>";
		}

		//product type start
		if($productType){
			$xml .= "<ProductType>";
			if($amazonCategory->name == "Sports" || $amazonCategory->name == "RawMaterials"){
				$xml .= $productType;
			}
			else{
				$xml .= "<".$productType.">";

					$product_types_fields = ($amazonCategory->product_type_fields) ? json_decode($amazonCategory->product_type_fields,true) : array();
					$product_type_fields = (isset($product_types_fields[$productType]) && $product_types_fields[$productType]) ? $product_types_fields[$productType] : array();

					if($amazonCategory->name == "Home" && $product_type_fields){
						foreach($product_type_fields as $product_type_field){
							$ignoreField = false;
							$field_name = $product_type_field["name"];
							if($field_name == $option1Attr) $ignoreField = true;
							else if(str_replace("Name","",$option1Attr) == $field_name) $ignoreField = true;
							else if($field_name == $option2Attr) $ignoreField = true;
							else if(str_replace("Name","",$option2Attr) == $field_name) $ignoreField = true;
							else if($field_name == $option3Attr) $ignoreField = true;
							else if(str_replace("Name","",$option3Attr) == $field_name) $ignoreField = true;

							if($field_name != "ProductType" && $field_name != "Parentage" && $field_name != "VariationTheme" && $field_name != "VariationData" && $field_name != "Color" && $field_name != "Size" && $field_name != "Wattage"){
								if(!$ignoreField && (isset($productTypeData[$field_name])) && ($productTypeData[$field_name])){
									$xml .= '<'.$field_name.'><![CDATA['.$productTypeData[$field_name].']]></'.$field_name.'>';
								}
							}
						}
					}

					if($amazonCategory->name != "Toys"){
						$varDataAdded = true;
						$xml .= "<VariationData>";
							if($amazonCategory->name != "Home") $xml .= '<Parentage>parent</Parentage>';
							$xml .= '<VariationTheme>'.$variationTheme.'</VariationTheme>';
						$xml .= "</VariationData>";
					}

					if($amazonCategory->name != "Home" && $product_type_fields){
						foreach($product_type_fields as $product_type_field){
							$ignoreField = false;
							$field_name = $product_type_field["name"];
							if($field_name == $option1Attr) $ignoreField = true;
							else if(str_replace("Name","",$option1Attr) == $field_name) $ignoreField = true;
							else if($field_name == $option2Attr) $ignoreField = true;
							else if(str_replace("Name","",$option2Attr) == $field_name) $ignoreField = true;
							else if($field_name == $option3Attr) $ignoreField = true;
							else if(str_replace("Name","",$option3Attr) == $field_name) $ignoreField = true;
							if($field_name != "ProductType" && $field_name != "Parentage" && $field_name != "VariationTheme" && $field_name != "VariationData" && $field_name != "Color" && $field_name != "Size"){
								if(!$ignoreField && (isset($productTypeData[$field_name])) && ($productTypeData[$field_name])){
									$xml .= '<'.$field_name.'><![CDATA['.$productTypeData[$field_name].']]></'.$field_name.'>';
								}
							}
						}
					}

				$xml .= "</".$productType.">";
			}
			$xml .= "</ProductType>";

			if($amazonCategory->name == "Home"){
				$xml .= '<Parentage>parent</Parentage>';
			}
		}
		//product type end


		//category start
		if(!$varDataAdded){
			if($amazonCategory->name == "Home") $xml .= '<Parentage>parent</Parentage>';
			$xml .= "<VariationData>";
			if($amazonCategory->name != "Home") $xml .= '<Parentage>parent</Parentage>';
				$xml .= '<VariationTheme>'.$variationTheme.'</VariationTheme>';
			$xml .= "</VariationData>";
		}

		$productTypeExits = false;
		$category_fields_xml = "";

		$category_fields = ($amazonCategory->category_fields) ? json_decode($amazonCategory->category_fields,true) : array();
		if($category_fields){
			foreach($category_fields as $category_field){
				$ignoreField = false;
				$field_name = $category_field["name"];
				if($field_name == "ProductType") $productTypeExits = true;
				if($field_name == $option1Attr) $ignoreField = true;
				else if(str_replace("Name","",$option1Attr) == $field_name) $ignoreField = true;
				else if($field_name == $option2Attr) $ignoreField = true;
				else if(str_replace("Name","",$option2Attr) == $field_name) $ignoreField = true;
				else if($field_name == $option3Attr) $ignoreField = true;
				else if(str_replace("Name","",$option3Attr) == $field_name) $ignoreField = true;
				if($field_name != "ProductType" && $field_name != "Parentage" && $field_name != "VariationTheme" && $field_name != "VariationData" && $field_name != "Color" && $field_name != "Size" && $field_name != "AgeRecommendation"){
					if(!$ignoreField && (isset($categoryData[$field_name])) && ($categoryData[$field_name])){
						$category_fields_xml .= '<'.$field_name.'><![CDATA['.$categoryData[$field_name].']]></'.$field_name.'>';
					}
				}
			}
		}

		if($amazonCategory->name == "Toys"){
			$category_fields_xml .= '<AgeRecommendation>';
				$category_fields_xml .= '<MinimumManufacturerAgeRecommended unitOfMeasure="years">3</MinimumManufacturerAgeRecommended>';
				$category_fields_xml .= '<MaximumManufacturerAgeRecommended unitOfMeasure="years">17</MaximumManufacturerAgeRecommended>';
			$category_fields_xml .= '</AgeRecommendation>';
		}

		if($category_fields_xml && !$productTypeExits){
			$xml .= '<ClassificationData>';
				$xml .= $category_fields_xml;
			$xml .= '</ClassificationData>';
		}
		else if($category_fields_xml){
			$xml .= $category_fields_xml;
		}
		//category end

		$xml .= "</".$amazonCategory->name.">";

		return $xml;
	}

	public static function getProductCategoryXML($amazonCategory,$categoryData,$productTypeData,$profile,$product,$shProduct,$variant){
		$user_id = $product->user_id;
		$productType = $profile->product_type;

		$option1name = (isset($shProduct["options"][0]["name"])) ? strtolower($shProduct["options"][0]["name"]) : NULL;
		$option2name = (isset($shProduct["options"][1]["name"])) ? strtolower($shProduct["options"][1]["name"]) : NULL;
		$option3name = (isset($shProduct["options"][2]["name"])) ? strtolower($shProduct["options"][2]["name"]) : NULL;

		if($productType && (isset($productTypeData["VariationTheme"])) && ($productTypeData["VariationTheme"])) $variationTheme = $productTypeData["VariationTheme"];
		else $variationTheme = ((isset($categoryData["VariationTheme"])) && ($categoryData["VariationTheme"])) ? $categoryData["VariationTheme"] : "";

		if(!$variant["option1"]) $variationTheme = "";
		
		

		$option1Attr = "";
		$option2Attr = "";
		$option3Attr = "";

		if($profile->attributeMapping->count() > 0 && $variationTheme){
			$attributeMapping = array();
			foreach($profile->attributeMapping as $attrMapping) $attributeMapping[strtolower($attrMapping->option_name)] = $attrMapping->attribute_name;

			$option1Attr = (isset($attributeMapping[$option1name])) ? $attributeMapping[$option1name] : null;
			$option2Attr = (isset($attributeMapping[$option2name])) ? $attributeMapping[$option2name] : null;
			$option3Attr = (isset($attributeMapping[$option3name])) ? $attributeMapping[$option3name] : null;

			if($option1Attr){
				$categoryData[$option1Attr] = $variant["option1"];
				$productTypeData[$option1Attr] = $variant["option1"];
				if((strpos($option1Attr,'Name') !== false)){
					$tmpOption1Attr = str_replace("Name","",$option1Attr);
					if($tmpOption1Attr){
						$categoryData[$tmpOption1Attr] = $variant["option1"];
						$productTypeData[$tmpOption1Attr] = $variant["option1"];
					}
				}
			}
			if($option2Attr){
				$categoryData[$option2Attr] = $variant["option2"];
				$productTypeData[$option2Attr] = $variant["option2"];
				if((strpos($option2Attr,'Name') !== false)){
					$tmpOption2Attr = str_replace("Name","",$option2Attr);
					if($tmpOption2Attr){
						$categoryData[$tmpOption2Attr] = $variant["option2"];
						$productTypeData[$tmpOption2Attr] = $variant["option2"];
					}
				}
			}
			if($option3Attr){
				$categoryData[$option3Attr] = $variant["option3"];
				$productTypeData[$option3Attr] = $variant["option3"];
				if((strpos($option3Attr,'Name') !== false)){
					$tmpOption3Attr = str_replace("Name","",$option3Attr);
					if($tmpOption3Attr){
						$categoryData[$tmpOption3Attr] = $variant["option3"];
						$productTypeData[$tmpOption3Attr] = $variant["option3"];
					}
				}
			}
		}

		$varDataAdded = false;
		
		$xml = "<".$amazonCategory->name.">";

		$category_fields = (isset($amazonCategory->fields) && $amazonCategory->fields) ? json_decode($amazonCategory->fields,true) : array();

		$fieldsIgnore = array();

		if($amazonCategory->name == "Toys" && $variationTheme){
			$varDataAdded = true;
			$xml .= "<VariationData>";
				$xml .= '<Parentage>child</Parentage>';
				$xml .= '<VariationTheme>'.$variationTheme.'</VariationTheme>';
			$xml .= "</VariationData>";
		}

		if($productType){
			$product_types_fields = ($amazonCategory->product_type_fields) ? json_decode($amazonCategory->product_type_fields,true) : array();
			$product_type_fields = (isset($product_types_fields[$productType]) && $product_types_fields[$productType]) ? $product_types_fields[$productType] : array();

			$xml .= "<ProductType>";
			if($amazonCategory->name == "Sports" || $amazonCategory->name == "RawMaterials"){
				$xml .= $productType;
			}
			else{
				$xml .= "<".$productType.">";

				if( ($variationTheme) && (isset($categoryData["Parentage"])) && ($categoryData["Parentage"] != "") ){

					$variationDataXML = "";

					if($amazonCategory->name != "Toys"){
						$varDataAdded = true;
						$variationDataXML .= "<VariationData>";
							if($amazonCategory->name != "Home") $variationDataXML .= '<Parentage>child</Parentage>';
							if($amazonCategory->name == "Home" || $amazonCategory->name == "Sports" || $amazonCategory->name == "Beauty") $variationDataXML .= '<VariationTheme>'.$variationTheme.'</VariationTheme>';

							if($product_type_fields && $amazonCategory->name != "HomeImprovement"){
								foreach($product_type_fields as $product_type_field){
									$field_name = $product_type_field["name"];
									if($field_name == $option1Attr){
										$fieldsIgnore[] = $field_name;
										$variationDataXML .= '<'.$field_name.'><![CDATA['.$variant["option1"].']]></'.$field_name.'>';
									}
									else if(str_replace("Name","",$option1Attr) == $field_name){
										$fieldsIgnore[] = $field_name;
										$variationDataXML .= '<'.$field_name.'><![CDATA['.$variant["option1"].']]></'.$field_name.'>';
									}
									else if($field_name == $option2Attr){
										$fieldsIgnore[] = $field_name;
										$variationDataXML .= '<'.$field_name.'><![CDATA['.$variant["option2"].']]></'.$field_name.'>';
									}
									else if(str_replace("Name","",$option2Attr) == $field_name){
										$fieldsIgnore[] = $field_name;
										$variationDataXML .= '<'.$field_name.'><![CDATA['.$variant["option2"].']]></'.$field_name.'>';
									}
									else if($field_name == $option3Attr){
										$fieldsIgnore[] = $field_name;
										$variationDataXML .= '<'.$field_name.'><![CDATA['.$variant["option3"].']]></'.$field_name.'>';
									}
									else if(str_replace("Name","",$option3Attr) == $field_name){
										$fieldsIgnore[] = $field_name;
										$variationDataXML .= '<'.$field_name.'><![CDATA['.$variant["option3"].']]></'.$field_name.'>';
									}
								}
							}

							if($amazonCategory->name != "Home" && $amazonCategory->name != "Sports" && $amazonCategory->name != "Beauty") $variationDataXML .= '<VariationTheme>'.$variationTheme.'</VariationTheme>';

						$variationDataXML .= "</VariationData>";
					}

					$product_type_fields_xml = "";

					if($product_type_fields){

						foreach($product_type_fields as $product_type_field){
							$field_name = $product_type_field["name"];
							if(in_array($field_name,$fieldsIgnore)) continue;

							$field_type = $product_type_field["type"];
							
							if($field_name != "ProductType" && $field_name != "Parentage" && $field_name != "VariationTheme" && $field_name != "VariationData" && $field_name != "Color" && $field_name != "Size"){
								if((isset($productTypeData[$field_name])) && ($productTypeData[$field_name])){
									$product_type_fields_xml .= '<'.$field_name.'><![CDATA['.$productTypeData[$field_name].']]></'.$field_name.'>';
								}
							}
							else if($field_name != "ProductType" && $field_name != "Parentage" && $field_name != "VariationTheme" && $field_name != "VariationData" && ($amazonCategory->name == "Toys" || $amazonCategory->name == "HomeImprovement")){
								if($field_name == $option1Attr){
									$product_type_fields_xml .= '<'.$field_name.'><![CDATA['.$variant["option1"].']]></'.$field_name.'>';
								}
								else if(str_replace("Name","",$option1Attr) == $field_name){
									$product_type_fields_xml .= '<'.$field_name.'><![CDATA['.$variant["option1"].']]></'.$field_name.'>';
								}
								else if($field_name == $option2Attr){
									$product_type_fields_xml .= '<'.$field_name.'><![CDATA['.$variant["option2"].']]></'.$field_name.'>';
								}
								else if(str_replace("Name","",$option2Attr) == $field_name){
									$product_type_fields_xml .= '<'.$field_name.'><![CDATA['.$variant["option2"].']]></'.$field_name.'>';
								}
								else if($field_name == $option3Attr){
									$product_type_fields_xml .= '<'.$field_name.'><![CDATA['.$variant["option3"].']]></'.$field_name.'>';
								}
								else if(str_replace("Name","",$option3Attr) == $field_name){
									$product_type_fields_xml .= '<'.$field_name.'><![CDATA['.$variant["option3"].']]></'.$field_name.'>';
								}
							}
						}

					}

					if($amazonCategory->name == "Home"){
						$xml .= $product_type_fields_xml;
						$xml .= $variationDataXML;
					}
					else{
						$xml .= $variationDataXML;
						$xml .= $product_type_fields_xml;
					}
				}
				else{
					if($product_type_fields){
						$variationData = '';
						$otherData = '';
						$variationDataAfter = false;
						foreach($product_type_fields as $product_type_field){
							$field_name = $product_type_field["name"];
							$field_type = $product_type_field["type"];
							
							if($field_name == "VariationData") $variationDataAfter = true;

							if(($amazonCategory->name == "Home") && ($field_name == "Size" || $field_name == "Color" || $field_name == "Scent" || $field_name == "StyleName" || $field_name == "CustomerPackageType")){
								if((isset($productTypeData[$field_name])) && ($productTypeData[$field_name])){
									$variationData .= '<'.$field_name.'><![CDATA['.$productTypeData[$field_name].']]></'.$field_name.'>';
								}
							}
							else if($field_name != "ProductType" && $field_name != "Parentage" && $field_name != "VariationTheme" && $field_name != "VariationData" && $field_name != "Color" && $field_name != "Size"){
								if((isset($productTypeData[$field_name])) && ($productTypeData[$field_name])){
									if($variationDataAfter) $otherData .= '<'.$field_name.'><![CDATA['.$productTypeData[$field_name].']]></'.$field_name.'>';
									else $xml .= '<'.$field_name.'><![CDATA['.$productTypeData[$field_name].']]></'.$field_name.'>';
								}
							}
							else if($field_name != "ProductType" && $field_name != "Parentage" && $field_name != "VariationTheme" && $field_name != "VariationData" && $amazonCategory->name == "Toys"){
								if((isset($productTypeData[$field_name])) && ($productTypeData[$field_name])){
									if($variationDataAfter) $otherData .= '<'.$field_name.'><![CDATA['.$productTypeData[$field_name].']]></'.$field_name.'>';
									else $xml .= '<'.$field_name.'><![CDATA['.$productTypeData[$field_name].']]></'.$field_name.'>';
								}
							}
						}
						if($variationData) $xml .= "<VariationData>".$variationData."</VariationData>";
						if($otherData) $xml .= $otherData;
					}
				}
				$xml .= "</".$productType.">";
			}
			$xml .= "</ProductType>";

			if($amazonCategory->name == "Home" && ($variationTheme) && (isset($categoryData["Parentage"])) && ($categoryData["Parentage"] != "")) $xml .= '<Parentage>child</Parentage>';
		}



		if( ($variationTheme) && (isset($categoryData["Parentage"])) && ($categoryData["Parentage"] != "") ){
			$fieldsIgnore = array();
			if(!$varDataAdded){
				if($amazonCategory->name == "Home") $xml .= '<Parentage>child</Parentage>';
				$xml .= "<VariationData>";
					if($amazonCategory->name != "Home") $xml .= '<Parentage>child</Parentage>';
					if($amazonCategory->name == "Home" || $amazonCategory->name == "Sports" || $amazonCategory->name == "Beauty") $xml .= '<VariationTheme>'.$variationTheme.'</VariationTheme>';
					if($category_fields){
						foreach($category_fields as $category_field){
							$field_name = $category_field["name"];
							if($field_name == $option1Attr){
								$fieldsIgnore[] = $field_name;
								$xml .= '<'.$field_name.'><![CDATA['.$variant["option1"].']]></'.$field_name.'>';
							}
							else if(str_replace("Name","",$option1Attr) == $field_name){
								$fieldsIgnore[] = $field_name;
								$xml .= '<'.$field_name.'><![CDATA['.$variant["option1"].']]></'.$field_name.'>';
							}
							else if($field_name == $option2Attr){
								$fieldsIgnore[] = $field_name;
								$xml .= '<'.$field_name.'><![CDATA['.$variant["option2"].']]></'.$field_name.'>';
							}
							else if(str_replace("Name","",$option2Attr) == $field_name){
								$fieldsIgnore[] = $field_name;
								$xml .= '<'.$field_name.'><![CDATA['.$variant["option2"].']]></'.$field_name.'>';
							}
							else if($field_name == $option3Attr){
								$fieldsIgnore[] = $field_name;
								$xml .= '<'.$field_name.'><![CDATA['.$variant["option3"].']]></'.$field_name.'>';
							}
							else if(str_replace("Name","",$option3Attr) == $field_name){
								$fieldsIgnore[] = $field_name;
								$xml .= '<'.$field_name.'><![CDATA['.$variant["option3"].']]></'.$field_name.'>';
							}
						}
					}
					if($amazonCategory->name != "Home" && $amazonCategory->name != "Sports" && $amazonCategory->name != "Beauty") $xml .= '<VariationTheme>'.$variationTheme.'</VariationTheme>';
				$xml .= "</VariationData>";
			}

			$productTypeExits = false;
			$category_fields_xml = "";

			if($category_fields){
				foreach($category_fields as $category_field){
					$field_name = $category_field["name"];
					$field_type = $category_field["type"];
					if($field_name == "ProductType") $productTypeExits = true;

					$ignoreField = false;
					if($field_name == $option1Attr) $ignoreField = true;
					else if(str_replace("Name","",$option1Attr) == $field_name) $ignoreField = true;
					else if($field_name == $option2Attr) $ignoreField = true;
					else if(str_replace("Name","",$option2Attr) == $field_name) $ignoreField = true;
					else if($field_name == $option3Attr) $ignoreField = true;
					else if(str_replace("Name","",$option3Attr) == $field_name) $ignoreField = true;
					if($ignoreField) continue;

					if($field_name != "ProductType" && $field_name != "Parentage" && $field_name != "VariationTheme" && $field_name != "VariationData" && !in_array($field_name,$fieldsIgnore) && $field_name != "Color" && $field_name != "Size" && $field_name != "AgeRecommendation"){
						if((isset($categoryData[$field_name])) && ($categoryData[$field_name])){
							$category_fields_xml .= '<'.$field_name.'><![CDATA['.$categoryData[$field_name].']]></'.$field_name.'>';
						}
					}
				}
			}

			if($amazonCategory->name == "Toys"){
				$category_fields_xml .= '<AgeRecommendation>';
					$category_fields_xml .= '<MinimumManufacturerAgeRecommended unitOfMeasure="years">3</MinimumManufacturerAgeRecommended>';
					$category_fields_xml .= '<MaximumManufacturerAgeRecommended unitOfMeasure="years">17</MaximumManufacturerAgeRecommended>';
				$category_fields_xml .= '</AgeRecommendation>';
			}

			if($category_fields_xml && !(isset($categoryData["ProductType"])) && !$productTypeExits){
				$xml .= '<ClassificationData>';
					$xml .= $category_fields_xml;
				$xml .= '</ClassificationData>';
			}
			else{
				$xml .= $category_fields_xml;
			}

		}
		else{
			$productTypeExits = false;
			$category_fields_xml = "";

			if($category_fields){
				$variationData = '';
				$otherData = '';
				$variationDataAfter = false;

				foreach($category_fields as $category_field){
					$field_name = $category_field["name"];
					$field_type = $category_field["type"];
					if($field_name == "ProductType") $productTypeExits = true;
					if(in_array($field_name,$fieldsIgnore)) continue;

					if($field_name == "VariationData") $variationDataAfter = true;
					if(($amazonCategory->name == "Home") && ($field_name == "Size" || $field_name == "Color")){
						if((isset($categoryData[$field_name])) && ($categoryData[$field_name])){
							$variationData .= '<'.$field_name.'><![CDATA['.$categoryData[$field_name].']]></'.$field_name.'>';
						}
					}
					else if($field_name != "ProductType" && $field_name != "Parentage" && $field_name != "VariationTheme" && $field_name != "VariationData" && $field_name != "AgeRecommendation"){
						if((isset($categoryData[$field_name])) && ($categoryData[$field_name])){
							if($variationDataAfter) $otherData .= '<'.$field_name.'><![CDATA['.$categoryData[$field_name].']]></'.$field_name.'>';
							else $category_fields_xml .= '<'.$field_name.'><![CDATA['.$categoryData[$field_name].']]></'.$field_name.'>';
						}
					}
				}
				if($variationData) $category_fields_xml .= "<VariationData>".$variationData."</VariationData>";
				if($otherData) $category_fields_xml .= $otherData;
			}

			if($amazonCategory->name == "Toys"){
				$category_fields_xml .= '<AgeRecommendation>';
					$category_fields_xml .= '<MinimumManufacturerAgeRecommended unitOfMeasure="years">3</MinimumManufacturerAgeRecommended>';
					$category_fields_xml .= '<MaximumManufacturerAgeRecommended unitOfMeasure="years">17</MaximumManufacturerAgeRecommended>';
				$category_fields_xml .= '</AgeRecommendation>';
			}

			if($category_fields_xml && !$productTypeExits){
				$xml .= '<ClassificationData>';
					$xml .= $category_fields_xml;
				$xml .= '</ClassificationData>';
			}
			else{
				$xml .= $category_fields_xml;
			}
		}

		$xml .= "</".$amazonCategory->name.">";

		return $xml;
	}

	public static function getInventoryFeedXML($amazonAccount,$inventoryArray){
		$xml = '<?xml version="1.0" encoding="iso-8859-1"?>';
		$xml .= '<AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="amzn-envelope.xsd">';
			$xml .= '<Header>';
				$xml .= '<DocumentVersion>1.01</DocumentVersion>';
				$xml .= '<MerchantIdentifier>'.$amazonAccount->merchant_id.'</MerchantIdentifier>';
			$xml .= '</Header>';
			$xml .= '<MessageType>Inventory</MessageType>';
			$xml .= '<PurgeAndReplace>false</PurgeAndReplace>';
		$msgCount = 1;
		foreach($inventoryArray as $ikey => $inventory){
			if($inventory["quantity"] < 0) $inventory["quantity"] = 0;
			$xml .= '<Message>';
				$xml .= '<MessageID>'.$msgCount.'</MessageID>';
				$xml .= '<OperationType>Update</OperationType>';
				$xml .= '<Inventory>';
					$xml .= '<SKU><![CDATA['.$inventory["sku"].']]></SKU>';
					$xml .= '<Quantity>'.$inventory["quantity"].'</Quantity>';
				$xml .= '</Inventory>';
			$xml .='</Message>';
			$msgCount++;
		}
		$xml .='</AmazonEnvelope>';
		return $xml;
	}

	public static function getPriceFeedXML($amazonAccount,$priceArray){
		$xml = '<?xml version="1.0" encoding="iso-8859-1"?>';
		$xml .= '<AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="amzn-envelope.xsd">';
			$xml .= '<Header>';
				$xml .= '<DocumentVersion>1.01</DocumentVersion>';
				$xml .= '<MerchantIdentifier>'.$amazonAccount->merchant_id.'</MerchantIdentifier>';
			$xml .= '</Header>';
			$xml .= '<MessageType>Price</MessageType>';
			$xml .= '<PurgeAndReplace>false</PurgeAndReplace>';
		$msgCount = 1;
		foreach($priceArray as $ikey => $price){
			$price["price"] = number_format($price["price"],2);

			$xml .= '<Message>';
				$xml .= '<MessageID>'.$msgCount.'</MessageID>';
				$xml .= '<OperationType>Update</OperationType>';
				$xml .= '<Price>';
					$xml .= '<SKU><![CDATA['.$price["sku"].']]></SKU>';
					$xml .= '<StandardPrice currency="DEFAULT">'.$price["price"].'</StandardPrice>';
					//if($price["compare_at_price"] && $price["compare_at_price"] > $price["price"]) $xml .= '<MAP currency="DEFAULT">'.$price["compare_at_price"].'</MAP>';
				$xml .= '</Price>';
			$xml .='</Message>';
			$msgCount++;
		}
		$xml .='</AmazonEnvelope>';
		return $xml;
	}

	public static function getImagesFeedXML($amazonAccount,$imagesArray){
		$xml = '<?xml version="1.0" encoding="iso-8859-1"?>';
		$xml .= '<AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="amzn-envelope.xsd">';
			$xml .= '<Header>';
				$xml .= '<DocumentVersion>1.01</DocumentVersion>';
				$xml .= '<MerchantIdentifier>'.$amazonAccount->merchant_id.'</MerchantIdentifier>';
			$xml .= '</Header>';
			$xml .= '<MessageType>ProductImage</MessageType>';
			$xml .= '<PurgeAndReplace>false</PurgeAndReplace>';
		$msgCount = 1;
		foreach($imagesArray as $ikey => $image){
			$xml .= '<Message>';
				$xml .= '<MessageID>'.$msgCount.'</MessageID>';
				$xml .= '<OperationType>Update</OperationType>';
				$xml .= '<ProductImage>';
					$xml .= '<SKU>'.$image["sku"].'</SKU>';
					$xml .= '<ImageType>'.$image["type"].'</ImageType>';
					$xml .= '<ImageLocation>'.$image["image_url"].'</ImageLocation>';					
				$xml .= '</ProductImage>';
			$xml .='</Message>';
			$msgCount++;
		}
		$xml .='</AmazonEnvelope>';
		return $xml;
	}

	public static function getRelationshipFeedXML($amazonAccount,$relationshipArray){
		$xml = '<?xml version="1.0" encoding="iso-8859-1"?>';
		$xml .= '<AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="amzn-envelope.xsd">';
			$xml .= '<Header>';
				$xml .= '<DocumentVersion>1.01</DocumentVersion>';
				$xml .= '<MerchantIdentifier>'.$amazonAccount->merchant_id.'</MerchantIdentifier>';
			$xml .= '</Header>';
			$xml .= '<MessageType>Relationship</MessageType>';
			$xml .= '<PurgeAndReplace>false</PurgeAndReplace>';
		$msgCount = 1;
		foreach($relationshipArray as $ikey => $relationship){
			if(!isset($relationship["variants"]) || !$relationship["variants"]) continue;
			$xml .= '<Message>';
				$xml .= '<MessageID>'.$msgCount.'</MessageID>';
				$xml .= '<OperationType>Update</OperationType>';
				$xml .= '<Relationship>';
					$xml .= '<ParentSKU>'.$relationship["parent_sku"].'</ParentSKU>';
					foreach($relationship["variants"] as $variantsku){
						$xml .= '<Relation>';
							$xml .= '<SKU>'.$variantsku.'</SKU>';
							$xml .= '<Type>Variation</Type>';
						$xml .= '</Relation>';
					}
				$xml .= '</Relationship>';
			$xml .='</Message>';
			$msgCount++;
		}
		$xml .='</AmazonEnvelope>';
		return $xml;
	}

	public static function getFulfillmentFeedXML($userChannelObj,$fulfillments){
		
		$xml = '<?xml version="1.0" encoding="iso-8859-1"?>';
		$xml .= '<AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="amzn-envelope.xsd">';
			$xml .= '<Header>';
				$xml .= '<DocumentVersion>1.01</DocumentVersion>';
				$xml .= '<MerchantIdentifier>'.$userChannelObj->amzConfig->merchant_id.'</MerchantIdentifier>';
			$xml .= '</Header>';
			$xml .= '<MessageType>OrderFulfillment</MessageType>';
			$xml .= '<PurgeAndReplace>false</PurgeAndReplace>';
		$msgCount = 1;
		foreach($fulfillments as $ikey => $fulfillment){

			$xml .= '<Message>';
				$xml .= '<MessageID>'.$msgCount.'</MessageID>';
				$xml .= '<OrderFulfillment>';
					$xml .= '<AmazonOrderID>'.$fulfillment["amazon_order_id"].'</AmazonOrderID>';
					$xml .= '<FulfillmentDate>'.$fulfillment["fulfillment_date"].'</FulfillmentDate>';
					if($fulfillment["carrier_name"] || $fulfillment["shipping_method"] || $fulfillment["tracking_number"]){
						$xml .= '<FulfillmentData>';
							if($fulfillment["carrier_name"]){
								$xml .= '<CarrierName>'.$fulfillment["carrier_name"].'</CarrierName>';
							}
							if($fulfillment["shipping_method"]){
								$xml .= '<ShippingMethod>'.$fulfillment["shipping_method"].'</ShippingMethod>';
							}
							if($fulfillment["tracking_number"]){
								$xml .= '<ShipperTrackingNumber>'.$fulfillment["tracking_number"].'</ShipperTrackingNumber>';
							}
						$xml .= '</FulfillmentData>';
					}
				$xml .= '</OrderFulfillment>';
			$xml .='</Message>';

			$msgCount++;
		}
		$xml .='</AmazonEnvelope>';
		return $xml;
	}

	public static function getOrderAcknowledgeMentFeedXML($userChannelObj,$orderAcknowledgements){
		
		$xml = '<?xml version="1.0" encoding="iso-8859-1"?>';
		$xml .= '<AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="amzn-envelope.xsd">';
			$xml .= '<Header>';
				$xml .= '<DocumentVersion>1.01</DocumentVersion>';
				$xml .= '<MerchantIdentifier>'.$userChannelObj->amzConfig->merchant_id.'</MerchantIdentifier>';
			$xml .= '</Header>';
			$xml .= '<MessageType>OrderAcknowledgement</MessageType>';
			$xml .= '<PurgeAndReplace>false</PurgeAndReplace>';
		$msgCount = 1;
		foreach($orderAcknowledgements as $ikey => $orderAcknowledgement){
			$xml .= '<Message>';
				$xml .= '<MessageID>'.$msgCount.'</MessageID>';
				$xml .= '<OrderAcknowledgement>';
					$xml .= '<AmazonOrderID>'.$orderAcknowledgement["amazon_order_id"].'</AmazonOrderID>';
					$xml .= '<StatusCode>'.$orderAcknowledgement["status_code"].'</StatusCode>';
				$xml .= '</OrderAcknowledgement>';
			$xml .='</Message>';

			$msgCount++;
		}
		$xml .='</AmazonEnvelope>';
		return $xml;
	}



	public static function xmlToArray($xmlContent = ""){
		$xmlArray = array();
		if($xmlContent){
			$xmlContent = str_replace("ns2:","",$xmlContent);
			$xmlObj = simplexml_load_string($xmlContent,"SimpleXMLElement",LIBXML_NOCDATA);
			unset($xmlContent);
			$jsonString = json_encode($xmlObj);
			unset($xmlObj);
			$xmlArray = json_decode($jsonString,true);
		}
		return $xmlArray;
	}

	

}