<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Requests;
use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Artisan;
use Carbon\Carbon;
use PHPShopify;
use Mail;
use Illuminate\Support\Facades\Storage;
use App\User;
use App\ShopifyStore;
use App\StoreCronJob;
use App\Helpers\AppHelper;
use App\AmazonAccount;
use App\Template;
use App\EbayCategory;

class TemplateController extends Controller{

	public $shopifyStore = null;
	
	public function __construct(Request $request){
	}

	public function index(Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$templates = $shopifyStore->templates()->paginate(10);
			return response()->json($templates,200);
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function save(Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$validationRules = [
				'name' => 'required|unique:tenants.templates',
				'template_data' => 'required'
			];
			$validator = Validator::make($request->all(),$validationRules);
			if($validator->fails()){
				return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
			}

			$tempData = $request->all();
			$tempData["store_id"] = $shopifyStore->id;
			$tempData["user_id"] = $shopifyStore->user->id;

			$template = $shopifyStore->templates()->create($tempData);
			if($template){
				return response()->json(['status' => 'success','msg' => 'template added successfully','template' => $template->toArray()],200);
			}
			else{
				return response()->json(['status' => 'error','msg' => 'template not added, please try again'],406);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function show($id,Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$template = $shopifyStore->templates()->find($id);
			if($template){
				return response()->json($template,200);
			}
			else{
				return response()->json(['status' => 'error','msg' => "not found"],404);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function update($id,Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$template = $shopifyStore->templates()->find($id);
			if($template){
				$validationRules = [
					'template_id' => 'required',
					'name' => 'required|unique:tenants.templates,name,'.$template->id,
					'template_data' => 'required'
				];
				$validator = Validator::make($request->all(),$validationRules);
				if($validator->fails()){
					return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
				}
	
				$tempData = $request->all();
				
				$ups = $template->update($tempData);
				if($ups){
					return response()->json(['status' => 'success','msg' => 'template updated successfully','template' => $template->toArray()],200);
				}
				else{
					return response()->json(['status' => 'error','msg' => 'template not updated, please try again'],406);
				}
			}
			else{
				return response()->json(['status' => 'error','msg' => "template not found"],404);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	
	public function destroy($id,Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$template = $shopifyStore->templates()->find($id);
			if($template){
				$template->delete();
				return response()->json(['status' => 'success','msg' => "template deleted successfully"],200);
			}
			else{
				return response()->json(['status' => 'error','msg' => "not found"],404);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}
}