<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\ShopifyStore;
use Illuminate\Support\Facades\DB;
use App\Helpers\AppHelper;

class TenantiDB
{
    public function __construct(User $user){
	}
	
	public function handle($request, Closure $next){
		$shopifyStore = array();
		$shopify_url = null;
		if(Auth::check() && Auth::user()){
			$user_id = Auth::user()->id;
			$shopify_url = session('user_'.$user_id.'_shopify_url');
		}
		else{
			$shopify_url = $request->input('shop');
		}
		if($shopify_url) $shopifyStore = ShopifyStore::where('shopify_url',$shopify_url)->first();
		if($shopifyStore) AppHelper::setStoreConnection($shopifyStore);
        return $next($request);
    }  
}
