<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    public function up(){
        if(!Schema::connection('tenants')->hasTable('orders')){
            Schema::connection('tenants')->create('orders',function(Blueprint $table){
                $table->bigIncrements('id');
                $table->string('order_id',100);
                $table->string('linked_order_id',100)->nullable()->default(NULL);
                $table->string('order_date_str',100)->nullable()->default(NULL);
                $table->timestamp('order_date')->nullable()->default(NULL);
                $table->string('status',100)->nullable()->default(NULL);
                $table->text('items')->nullable()->default(NULL);
                $table->text('order_data')->nullable()->default(NULL);
                $table->tinyInteger('order_sync')->nullable()->default(NULL);
                $table->tinyInteger('inventory_sync')->nullable()->default(NULL);
                $table->tinyInteger('shipment_sync')->nullable()->default(NULL);
                $table->tinyInteger('cancel_sync')->nullable()->default(NULL);
                $table->tinyInteger('data_removed')->nullable()->default(NULL);
                $table->string('type',100);
                $table->string('source',100);
                $table->unsignedInteger('account_id')->nullable()->default(NULL);
                $table->foreign('account_id')->references('id')->on(config('config.default_database').'.ebay_accounts')->onDelete('set null');
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down(){
        Schema::connection('tenants')->dropIfExists('orders');
    }
}
