<?php

namespace App;

use Illuminate\Database\Eloquent\Model;


class DupProduct extends Model {
	
	protected $table = 'dup_products';

	protected $primaryKey = 'product_id';

    public function user() {
		return $this->belongsTo('App\User', 'user_id', 'id');
	}
	
	public function variants() {
		return $this->hasMany('App\DupProductVariant', 'product_id', 'product_id');
	}
	
	public function origProduct() {
		return $this->belongsTo('App\Product', 'orig_product_id', 'product_id');
	}

    protected $fillable = [
        'status', 'sub_status'
	];
	
}
