<?php

namespace App\Http\Controllers;

use Mail;
use App\User;
use App\Newsletter;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Collection;

use App\Http\Requests;
use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class ContactController extends Controller
{
    public function __construct()
    {
        // Apply the jwt.auth middleware to all methods in this controller
        // except for the authenticate method. We don't want to prevent
        // the user from retrieving their token if they don't already have it
        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }  

    public function requestquote(Request $request)
    {
		$currUser = Auth::User();
		$servicetype = "";
		$description = "";
		if($request->has("servicetype")){
			$servicetype = $request->input("servicetype");
		}
		if($request->has("description")){
			$description = $request->input("description");
		}
		if(strlen($servicetype) == 0 || strlen($description) == 0){
			return response()->json(['error' => ["msg"=>['Invalid input data.']]], 406);
		}
		$data = array("fromemail" => $currUser->email, "fromname" => $currUser->ownername, "servicetype" => $servicetype, "description" => $description, "shopurl" => $currUser->shopurl);
		Log::info($data);
		Mail::send('emails.requestquote', ['data' => $data], function ($m) use ($data) {
			Log::info($data['fromemail']);
            $m->from($data['fromemail'], $data['fromname']);
			$m->replyTo($data['fromemail'], $data['fromname']);
            $m->to("khariwal.rohit@gmail.com", "Rohit Khariwal")->subject('New Quote Request!');
        });
		return response()->json(['success'], 200);				
    }

    public function addSubscriber(Request $request)
    {
		$currUser = Auth::User();
		$email = "";		
		if($request->has("email")){
			$email = $request->input("email");
		}		
		if(strlen($email) == 0){
			return response()->json(['error' => ["msg"=>['Invalid input data.']]], 406);
		}
		$newsLetterObj = new Newsletter;
		$newsLetterObj->email = $email;
		$newsLetterObj->user_id = $currUser->id;
		$newsLetterObj->save();		
		return response()->json(['success'], 200);				
    }   
}