<?php

namespace App\Http\Controllers;

use App\EbCategory;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\Translation\Tests\Dumper\IniFileDumperTest;
use Validator;
use File;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

class EbCategoryController extends Controller
{
    public function __construct()
    {
        // Apply the jwt.auth middleware to all methods in this controller
        // except for the authenticate method. We don't want to prevent
        // the user from retrieving their token if they don't already have it
        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }

    public function index() {
        $site = 0;
        $currUser = Auth::User();
        if($currUser->id == '2522'){
            $site = 3;
        }
		$ebCategories = EbCategory::where('category_level', '=', 1)->where('site', '=', $site)->get();
        return $ebCategories;		
	}    
	
	public function getSubCategories($id){
        $site = 0;
        $currUser = Auth::User();
        if($currUser->id == '2522'){
            $site = 3;
        }
		$ebCategories = EbCategory::where('parent_category_id', '=', $id)->where("category_id", "!=", $id)->where('site', '=', $site)->get();
        return $ebCategories;
	}
}