<?php

namespace App;

use Illuminate\Database\Eloquent\Model;


class DupProductVariant extends Model {
	
	protected $table = 'dup_product_variants';

	protected $primaryKey = 'id';
	
	public function user() {
		return $this->belongsTo('App\User', 'user_id', 'id');
	}

	public function product() {
		return $this->belongsTo('App\DupProduct', 'product_id', 'product_id');
	}	

	public function origVariant() {
		return $this->belongsTo('App\ProductVariant', 'orig_variant_id', 'id');
	}

    protected $fillable = [
        'product_id', 'old_sku', 'new_sku', 'old_asin', 'new_asin', 'upc', 'status'
    ];
	
}
