<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Shop extends Model {

	protected $table = 'shops';

	protected $primaryKey = 'id';

    public function user() {
		return $this->belongsTo('App\User', 'user_id', 'id');
	}
		
	public function products() {
		return $this->hasMany('App\Product', 'shop_id', 'id');
	}
	
	public function amzKey(){
		return $this->hasOne('App\AmzKey', 'shop_id', 'id');
	}
    
	protected $fillable = [
        'user_id','ownername','email','shopurl','token'
    ];
}
