'use strict';

angular.module('ng-laravel').service('EbProductService', function($rootScope, Restangular,CacheFactory) {
    
	/*
     * Build collection /product
     */
	var _ebProductService = Restangular.all('ebproduct');
    
	if (!CacheFactory.get('ebProductsCache')) {
		var ebProductsCache = CacheFactory('ebProductsCache');
    }

    /*
     * Get list of products from cache.
     * if cache is empty, data fetched and cache create else retrieve from cache
     */
    this.cachedList = function() {
        // GET /api/product
		if (!ebProductsCache.get('list')) {
			return this.list();
        } else{
			return ebProductsCache.get('list');
        }
    };

    /*
     * Get list of products
     */
    this.list = function() {
		// GET /api/product		
        var data = _ebProductService.getList();
        ebProductsCache.put('list', data);
        return data;
    };

	/*
     * Pagination change
     */
    this.pageChange = function(pageNumber, per_page, end, pagination) {
        // GET /api/product?page=2		
		if(end == pagination) {
			pageNumber = 1;
			return _ebProductService.getList({page:pageNumber, per_page:per_page});
		} else {
			return _ebProductService.getList({page:pageNumber,per_page:per_page});
		}
    };    

	/*
     * Search in product
     */
	this.search = function(query, per_page, pageNumber, end, pagination) {
	    // GET /api/product/search?query=test&per_page=10
		//alert(JSON.stringify(query));
		//alert(JSON.stringify(pageNumber));
        if(query !=''){
			if(end == pagination) {
				pageNumber = 1;
				return _ebProductService.customGETLIST("search", {page:pageNumber, query:query, per_page:per_page});
			} else {
				return _ebProductService.customGETLIST("search", {page:pageNumber, query:query, per_page:per_page});	
			}
        } else {
			return _ebProductService.getList({page:pageNumber,per_page:per_page});
        }
    }
	
	/*
     * pushall Product (PUT)
     */
    this.pushall = function() {        
		Restangular.all('ebproduct/pushall').post().then(function(response) {
			$rootScope.$broadcast('product.pushall', response.skuconsumed);
        }, function(response) {			
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };

	/*
     * push Product 
     */
    this.push = function(selection) {
		Restangular.several('ebproduct/push',selection).post().then(function(response) {
			$rootScope.$broadcast('product.push', selection, response.skuconsumed);
        }, function(response){
			//console.log(response);
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };	

	/*
     * unblock Product 
     */
    this.unblock = function(selection) {      
		Restangular.several('ebproduct/unblock',selection).post().then(function() {
			$rootScope.$broadcast('product.unblock', selection);
        }, function(response){			
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };

	/*
     * block Product
     */
    this.block = function(selection) {  
	    Restangular.several('ebproduct/block', selection).post().then(function() {
		    $rootScope.$broadcast('product.block', selection);
        }, function(response){
			$rootScope.$broadcast('product.validationError',response.data.error);
        });
    };

	this.fetchStatus = function() {
        // GET /api/amzconfig/status
		var _amzconfigService = Restangular.one('amzconfig');
        var data = _amzconfigService.customGET("status");  
		return data;
    };	
});