import React, { useState } from 'react';
import { Frame } from '@shopify/polaris';
import Header from './common/Header';
import Footer from './common/Footer';
import Sidenav from './common/Sidenav';

function Layout({ children }) {
  const [mobileNavigationActive, setMobileNavigationActive] = useState(false);

  const toggleMobileNavigationActive = () => {
    setMobileNavigationActive(!mobileNavigationActive);
  };

  return (
    <div style={{ height: '100vh', display: 'flex', flexDirection: 'column' }}>
      <Frame 
        navigation={<Sidenav onNavigate={toggleMobileNavigationActive} />} 
        topBar={<Header onNavigationToggle={toggleMobileNavigationActive} />}
        showMobileNavigation={mobileNavigationActive}
        onNavigationDismiss={toggleMobileNavigationActive}
      >
        <div style={{ flex: 1, width: '100%', overflow: 'auto' }}>
          {children}
          <Footer />
        </div>
      </Frame>
    </div>
  );
}

export default Layout;