import React from 'react';
import { Navigation } from '@shopify/polaris';
import { useNavigate, useLocation } from 'react-router-dom';
import {
  HomeIcon,
  ProductIcon,
  LinkIcon,
  SettingsIcon,
  CreditCardIcon,
  QuestionCircleIcon
} from '@shopify/polaris-icons';

function Sidenav({ onNavigate }) {
  const navigate = useNavigate();
  const location = useLocation();

  const handleNav = (path) => {
    navigate(path);
    if (onNavigate) onNavigate();
  };

  const navigationMarkup = (
    <Navigation location={location.pathname}>
      <Navigation.Section
        items={[
          {
            label: 'Dashboard',
            icon: HomeIcon,
            onClick: () => handleNav('/'),
            selected: location.pathname === '/'
          },
          {
            label: 'Products',
            icon: ProductIcon,
            onClick: () => handleNav('/products'),
            selected: location.pathname === '/products'
          },
          {
            label: 'Amazon Account',
            icon: LinkIcon,
            onClick: () => handleNav('/amazon-account'),
            selected: location.pathname === '/amazon-account'
          },
          {
            label: 'Settings',
            icon: SettingsIcon,
            onClick: () => handleNav('/settings'),
            selected: location.pathname === '/settings'
          },
          {
            label: 'Plan And Pricing',
            icon: CreditCardIcon,
            onClick: () => handleNav('/plan-pricing'),
            selected: location.pathname === '/plan-pricing'
          },
          {
            label: 'FAQ',
            icon: QuestionCircleIcon,
            onClick: () => handleNav('/faqs'),
            selected: location.pathname === '/faqs'
          }
        ]}
      />
    </Navigation>
  );
  return navigationMarkup;
}

export default Sidenav;