<?php
require_once("includes/ohshopify/shopify.php");
require_once("includes/config.php");
require_once("includes/sendgrid/sendgrid-php.php");

$conn = new mysqli($host, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
	// TODO: Add some logging and email notification here
	die("Connection failed: " . $conn->connect_error);
}

define('SHOPIFY_SCOPE', 'read_products,write_products,read_inventory,write_inventory,write_publications,read_locations');
if (isset($_GET['code'])) { // if the code param has been sent to this page... we are in Step 2
	// Step 2: do a form POST to get the access token
    $shopifyClient = new ShopifyClient($_GET['shop'], "", SHOPIFY_API_KEY, SHOPIFY_API_PASSWORD);	
    session_unset();

    // Now, request the token and store it in your session.
    $token = $shopifyClient->getAccessToken($_GET['code']);
	$_SESSION['token'] = $token;
	if ($_SESSION['token'] != '') {
		$_SESSION['shop'] = $_GET['shop'];
		$tempcode = insertShop($_GET['shop'], $token);
	//	sendLogs("[Shopify APP] - Xpert Importer - authorization", $_GET['shop']);
	     $result = $conn->query("select * from users where shopurl = '".$_GET['shop']."'");
	
		$row = $result->fetch_assoc();
		$id = $row['id'];
		if($id > 15003064){
         
			header("Location: https://shopify.infoshore.biz/xpert/cp3/?tempcode=".$tempcode);
			exit;
		}
		else{

		
		header("Location: https://shopify.infoshore.biz/xpert/cp/#/login/".$tempcode);
		exit;
		}
	}	
    die("Unauthorized access!!");
} else if (isset($_POST['shop']) || isset($_GET['shop'])) { // if they posted the form with the shop name
	// Step 1: get the shopname from the user and redirect the user to the
    // shopify authorization page where they can choose to authorize this app
    $shop = isset($_POST['shop']) ? $_POST['shop'] : $_GET['shop'];
    $shopifyClient = new ShopifyClient($shop, "", SHOPIFY_API_KEY, SHOPIFY_SECRET);
	if(!$shopifyClient->validateSignature($_GET))
		//die('Error: invalid signature.');

    // get the URL to the current page
    $pageURL = 'http';
    if ($_SERVER["HTTPS"] == "on") { $pageURL .= "s"; }
		$pageURL .= "://";
	if ($_SERVER["SERVER_PORT"] != "80") {
		$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["SCRIPT_NAME"];
	} else {
		$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["SCRIPT_NAME"];
		//$pageURL .= $_SERVER["SERVER_NAME"].'/amzimporter/';
	}

	// redirect to authorize url
    header("Location: " . $shopifyClient->getAuthorizeUrl(SHOPIFY_SCOPE, $pageURL));
    exit;
} else {
	header("Location: https://apps.shopify.com/xpert-importer");
}

function insertShop($shop, $token){
	global $conn;
	$result = $conn->query("select * from users where shopurl = '".$shop."'");
	$tempcode = GenCode(10);
	if ($result->num_rows > 0) {
		$row = $result->fetch_assoc();
		if($row['installationstatus'] == 0){
		    $conn->query("update users set plan = 0,membershiptype='free',skulimit=25,tempcode = '".$tempcode."', token = '".mysqli_real_escape_string($conn, $token)."', `status` = 'active', installationstatus = 1, updated_at = now() where shopurl = '".mysqli_real_escape_string($conn, $shop)."'");
			addUninstallationHook($shop, $token);
		} else {
		    $conn->query("update users set tempcode = '".$tempcode."', token = '".mysqli_real_escape_string($conn, $token)."', `status` = 'active', installationstatus = 1, updated_at = now() where shopurl = '".mysqli_real_escape_string($conn, $shop)."'");
		}
	} else {
		$conn->query("insert into users(tempcode, shopurl, token, status, installationstatus, created_at) values('".$tempcode."', '".mysqli_real_escape_string($conn,$shop)."','".mysqli_real_escape_string($conn,$token)."','active', 1, now())");
		$shop_id = $conn->insert_id;
		addUninstallationHook($shop, $token);
		$msg = updateShopifyData($shop_id, $token, $shop);
		sendWelcomeMail($msg["name"], $msg["email"]);
	}
	return $tempcode;
}

function sendWelcomeMail($name, $email){
	global $conn;
	$to = $email;
	$subject = "Welcome to Shopify APP [Xpert Importer - Amazon to Shopify]";
	$body = '<p>Dear '.$name.',</p>
				<p>Thank you for choosing our app to import your Amazon listings into your Shopify store!</p>

			<p><strong>Next Step:</strong></p>
			<p>Please connect your Amazon Seller account to start fetching your products from Amazon.</p>

			<p>If you have any questions or need assistance, simply reply to this email. I’ll be happy to guide you through the setup process.</p>

			<p>You can also <a href="https://calendly.com/madhu-infoshore/30min" target="_blank">schedule a 30-minute meeting</a> with our support team for personalized assistance with your account setup and product import.</p>

			<p>Need quick help? <a href="https://direct.lc.chat/18704628/" target="_blank">Click here</a> to start a live chat or open a support ticket to learn more about the setup process.</p>

			<p>Best Regards,<br />
			Pankaj Narang<br />
			Manager – Shopify Applications</p>

			<p>InfoShore Software Private Limited<br />
			Skype: pankaj.narang<br />
			<a href="http://www.infoshore.biz" target="_blank">www.infoshore.biz</a></p>';
	$email = new \SendGrid\Mail\Mail(); 
    $email->setFrom("shopifyapps@infoshore.biz", "Rohit Khariwal");
    $email->setSubject($subject);
    $email->addTo($to);
    $email->addBcc("khariwal.rohit@gmail.com");
    $email->addContent(
        "text/html", $body
    );
    $sendgrid = new \SendGrid('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');
    try {
        $response = $sendgrid->send($email);
    } catch (Exception $e) {
        @mail("khariwal.rohit@gmail.com", "Error sending welcome email", 'A sendgrid error occurred: '.$e->getMessage());
    }
}

function addUninstallationHook($shopurl, $token){
	global $conn;

	$query = <<<GQL
	mutation {
	webhookSubscriptionCreate(
		topic: APP_UNINSTALLED,
		webhookSubscription: {
		callbackUrl: "https://shopify.infoshore.biz/xpert/uninstall.php",
		format: JSON
		}
	) {
		webhookSubscription {
		id
		}
		userErrors {
		field
		message
		}
	}
	}
	GQL;

	$url = "https://{$shopurl}/admin/api/2024-10/graphql.json";

	$headers = [
		"X-Shopify-Access-Token: {$token}",
		"Content-Type: application/json"
	];

	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_POST, true);
	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode(['query' => $query]));
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

	$response = curl_exec($curl);
	curl_close($curl);
}

function updateShopifyData($user_id, $token, $shopurl){	
	global $conn;
	$query = <<<GRAPHQL
	query {
		shop {
			name
			email
			shopOwnerName
			createdAt
			updatedAt
			plan {
				displayName
			}
		}
	}
	GRAPHQL;

	$url = "https://".$shopurl."/admin/api/2024-10/graphql.json";

	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_POST, true);
	curl_setopt($curl, CURLOPT_HTTPHEADER, [
		"Content-Type: application/json",
		"X-Shopify-Access-Token: $token"
	]);
	curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode(['query' => $query]));
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

	$response = curl_exec($curl);
	$httpStatusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
	curl_close($curl);

	if ($httpStatusCode === 200) {
		$shopData = json_decode($response, true);
		if (isset($shopData['data']['shop'])) {
			$shop = $shopData['data']['shop'];
			$shop_owner = $shop['shopOwnerName'];
			$email = $shop['email'];
			$created_at = $shop['createdAt'];
			$updated_at = $shop['updatedAt'];
			$plan_name = $shop['plan']['displayName'];

			$conn->query("UPDATE users SET 
				plan_name = '".mysqli_real_escape_string($conn, $plan_name)."', 
				ownername = '".mysqli_real_escape_string($conn, $shop_owner)."', 
				email = '".mysqli_real_escape_string($conn, $email)."', 
				storecreated_at = '".$created_at."', 
				storeupdated_at = '".$updated_at."' 
				WHERE id = ".$user_id
			);

			return array("name" => $shop_owner, "email" => $email);
		}
	}

	return false;
	
}
function GenCode($size=10){
	global $conn;
	$code = '';
	$validchars = 'ABCDEFGHIJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz23456789';
	mt_srand ((double) microtime() * 1000000);
	for ($i = 0; $i < $size; $i++)
	{
		$index = mt_rand(0, strlen($validchars));
		$code .= $validchars[$index];
	}
	$result = $conn->query("select * from users where tempcode = '".mysqli_real_escape_string($conn, $code)."'");
	if($result->num_rows > 0){
		return GenCode(10);
	}
	return $code;
}

    // first time to the page, show the form below
?>
<h1>Xpert Importer (BETA)</h1>
<p>Install this app to your shopify shop to import products from your Amazon Seller Central Account to your store.</p> 
<form action="" method="post">
	<label for='shop'><strong>The URL of the Shop</strong> 
		<span class="hint">(enter it exactly like this: myshop.myshopify.com)</span> 
	</label> 
    <p> 
		<input id="shop" name="shop" size="45" type="text" value="" /> 
        <input name="commit" type="submit" value="Install" /> 
	</p> 
</form>