/**
 * UI-Router and Basic App Configuration
 */
'use strict';

app
    .run(function($rootScope, $state,$stateParams,$translate,tmhDynamicLocale,Restangular) {
        // add listener for change page title and parent menu activation
        $rootScope.$state = $state;
        $rootScope.$stateParams = $stateParams;

        // translate refresh is necessary to load translate table
        $rootScope.$on('$translatePartialLoaderStructureChanged', function () {
            $translate.refresh();
        });

        $rootScope.$on('$translateChangeEnd', function() {
            // get current language
            $rootScope.currentLanguage = $translate.use();

            //dynamic load angularjs locale
            tmhDynamicLocale.set($rootScope.currentLanguage);

            // change direction to right-to-left language
            if($rootScope.currentLanguage==='ar-ae' || $rootScope.currentLanguage==='fa-ir'){
                $rootScope.currentDirection = 'rtl';
            } else{
                $rootScope.currentDirection = 'ltr';
            }

            // set lang parameter for any request that with Restangular
            Restangular.setDefaultRequestParams({lang: $rootScope.currentLanguage});
        });
    })

    .config(function($stateProvider,$urlRouterProvider,$locationProvider,$breadcrumbProvider,$authProvider,RestangularProvider,CacheFactoryProvider,$translateProvider,tmhDynamicLocaleProvider,NotificationProvider,$translatePartialLoaderProvider) {

        /**
         * Angular translate config
         */
        $translatePartialLoaderProvider.addPart('shared');
        $translateProvider
            .useSanitizeValueStrategy(null)// for prevent from XSS vulnerability but this has problem with utf-8 language
            .fallbackLanguage('en-us') //Registering a fallback language
            .registerAvailableLanguageKeys(['en-us', 'ar-ae','pt-br'], { // register your language key and browser key find
                'en_*': 'en-us',
                'ar_*': 'ar-ae',
                'pt_*': 'pt-br'
            })
            .useLoader('$translatePartialLoader', { // for lazy load we use this service
                urlTemplate: 'app/{part}/lang/locale_{lang}.json',// in this section we define our structure
                loadFailureHandler: 'MyErrorHandler'//it's a factory to error handling
            })
            .useLoaderCache(true)//use cache to loading translate file
            .useCookieStorage()// using cookie to keep current language
            //.useMissingTranslationHandlerLog() // you can remove in production
            //.determinePreferredLanguage();// define language by browser language
            .preferredLanguage('en-us');

        /* angular locale dynamic load */
        tmhDynamicLocaleProvider.localeLocationPattern('../assets/vendors/angularjs/js/i18n/angular-locale_{{locale}}.js');

        /**
         * Angular-ui-notification
         */
        NotificationProvider.setOptions({
            delay: 7000,
            startTop: 80,
            startRight: 10,
            verticalSpacing: 20,
            horizontalSpacing: 20,
            positionX: 'right',
            positionY: 'top'
        });

        /**
         * Angular-Cache basic configuration
         */
        //Cache will hold data in client memory. Data is cleared when the page is refreshed.
        angular.extend(CacheFactoryProvider.defaults, {
            maxAge: 5 * 60 * 1000, // 5 minutes
            deleteOnExpire: 'aggressive'
        });


        /**
         * Restangular API URL
         */
        RestangularProvider.setBaseUrl('../api/public/v1');
        /* force Restangular's getList to work with Laravel 5's pagination object  */
        RestangularProvider.addResponseInterceptor(parseApiResponse);
        function parseApiResponse(data, operation) {
            var response = data;
            if (operation === 'getList' && data.data) {
                response = data.data;
                response.metadata = _.omit(data, 'data');
            }
            return response;
        }


        /**
         *  ngAA Config
         */
        $authProvider.signinUrl = '../api/public/v1/authenticate';
        $authProvider.signinState = 'login';
        $authProvider.signinRoute = '/login/:key';
        $authProvider.signinTemplateUrl ='app/shared/views/login.html';
		$authProvider.afterSigninRedirectTo = 'admin';
		$authProvider.afterSignoutRedirectTo = 'login';

        /**
         *  breadcrumb config
         */
        $breadcrumbProvider.setOptions({
            templateUrl: 'app/shared/views/ncyBreadcrumb.tpl.bs3.html',
            translations: true
        });

        /**
         * UI-Router config
         */
        // config prefix and unmatched route handler - UI-Router
        $urlRouterProvider.otherwise(function($injector){
            var $state = $injector.get("$state");
            $state.go('admin');
        });
        $stateProvider            
            .state('admin', {
                url: '/admin',
                templateUrl: 'app/shared/views/admin.html',
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.admin'// angular translate variable
                },
                data:{
                    authenticated:true
                },
                controller:'AdminCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['ui-bs-paging']).then(
                                function(){
                                    return $ocLazyLoad.load(['app/shared/controllers/AdminCtrl.js']);
                                }
                            );
                        }]
                }
            })
            .state('admin.dashboard',{ // define nested route with ui-router with (.) dot
                url: "/dashboard",
                templateUrl: "app/shared/views/dashboard.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.dashboard',// angular translate variable
                    parent:'admin'
                }              
            })            
			.state('admin.products',{
                url: "/products",
                templateUrl: "app/modules/product/views/products.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.products',// angular translate variable
                    parent:'admin'
                },
                
                controller:'ProductListCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['sweet-alert','ui-bs-paging','ProductServiceModule','EBCategoryMappingServiceModule','EBCategoryServiceModule','datatable']).then(
                                function(){
                                    return $ocLazyLoad.load('app/modules/product/controllers/ProductListCtrl.js');
                                }
                            );
                        }],
                    resolvedItems:['dep','ProductService',
                        function(dep,ProductService) {
                            return ProductService.cachedList().then(function(data){
                                return data;
                            });
                        }]
                }
            })
			.state('admin.productsnew',{
                url: "/productsnew",
                templateUrl: "app/modules/product/views/productsnew.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.products',// angular translate variable
                    parent:'admin'
                },                
                controller:'ProductListCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['sweet-alert','ui-bs-paging','ProductServiceModule','EBCategoryMappingServiceModule','EBCategoryServiceModule','datatable']).then(
                                function(){
                                    return $ocLazyLoad.load('app/modules/product/controllers/ProductListCtrl.js');
                                }
                            );
                        }],
                    resolvedItems:['dep','ProductService',
                        function(dep,ProductService) {
                            return ProductService.cachedList().then(function(data){
                                return data;
                            });
                        }]
                }
            })
			.state('admin.products1828',{
                url: "/products1828",
                templateUrl: "app/modules/product/views/products_1828.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.products',// angular translate variable
                    parent:'admin'
                },                
                controller:'ProductListCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['sweet-alert','ui-bs-paging','ProductServiceModule','EBCategoryMappingServiceModule','EBCategoryServiceModule','datatable']).then(
                                function(){
                                    return $ocLazyLoad.load('app/modules/product/controllers/ProductListCtrl.js');
                                }
                            );
                        }],
                    resolvedItems:['dep','ProductService',
                        function(dep,ProductService) {
                            return ProductService.cachedList().then(function(data){
                                return data;
                            });
                        }]
                }
            })
			.state('admin.products2820',{
                url: "/products2820",
                templateUrl: "app/modules/product/views/products_2820.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.products',// angular translate variable
                    parent:'admin'
                },                
                controller:'ProductListCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['sweet-alert','ui-bs-paging','ProductServiceModule','EBCategoryMappingServiceModule','EBCategoryServiceModule','datatable']).then(
                                function(){
                                    return $ocLazyLoad.load('app/modules/product/controllers/ProductListCtrl.js');
                                }
                            );
                        }],
                    resolvedItems:['dep','ProductService',
                        function(dep,ProductService) {
                            return ProductService.cachedList().then(function(data){
                                return data;
                            });
                        }]
                }
            })			
			.state('admin.amzconfig',{
                url: "/amzconfig",
                templateUrl: "app/modules/amzconfig/views/amzconfigform.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.amzconfig',// angular translate variable
                    parent:'admin'
                },
               	controller:'AmzConfigCreateCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['select2','AmzConfigServiceModule','ui-select-filter']).then(
                                function(){
                                    return $ocLazyLoad.load(['app/modules/amzconfig/controllers/AmzConfigCreateCtrl.js']);
                                }
                            );
                        }],
					resolvedItems:['dep','AmzConfigService',
                        function(dep, AmzConfigService) {							
                            return AmzConfigService.list().then(function(data){
								if(data.marketplace_id){									
									return data;
								} else {
									var ndata = {'marketplace_id':'ATVPDKIKX0DER'};
									return ndata;
								}
                            });
                        }]
                }
            })
			.state('admin.ebcategorymapping',{
                url: "/ebcategorymapping",
                templateUrl: "app/modules/ebcategorymapping/views/mappings.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.ebcategorymapping',// angular translate variable
                    parent:'admin'
                },
               	controller:'EBCategoryMappingListCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['select2','EBCategoryMappingServiceModule','EBCategoryServiceModule','ui-select-filter']).then(
                                function(){
                                    return $ocLazyLoad.load(['app/modules/ebcategorymapping/controllers/EBCategoryMappingListCtrl.js']);
                                }
                            );
                        }],
					resolvedItems:['dep','EBCategoryMappingService',
                        function(dep, EBCategoryMappingService) {							
                            return EBCategoryMappingService.list().then(function(data){
								return data;							
                            });
                        }]
                }
            })			
			.state('admin.plans',{
                url: "/plans",
                templateUrl: "app/modules/plans/views/plansform.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.plans',// angular translate variable
                    parent: 'admin'
                },
              	controller:'PlansCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load([]).then(
                                function(){
                                    return $ocLazyLoad.load(['app/modules/plans/controllers/PlansCtrl.js']);
                                }
                            );
                        }]
                }
            })
            .state('admin.plansnew',{
                url: "/plansnew",
                templateUrl: "app/modules/plans/views/plansformnew.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.plans',// angular translate variable
                    parent: 'admin'
                },
              	controller:'PlansCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load([]).then(
                                function(){
                                    return $ocLazyLoad.load(['app/modules/plans/controllers/PlansCtrl.js']);
                                }
                            );
                        }]
                }
            })
			.state('admin.subscription',{
                url: "/subscribe",
                templateUrl: "app/modules/plans/views/subscriptionform.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.subscription',// angular translate variable
                    parent: 'admin'
                },
              	controller:'SubscriptionCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['PlansServiceModule']).then(
                                function(){
                                    return $ocLazyLoad.load(['app/modules/plans/controllers/SubscriptionCtrl.js']);
                                }
                            );
                        }]
                }
            })
			.state('admin.settings',{
                url: "/settings",
                templateUrl: "app/modules/settings/views/settingform.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.settings',// angular translate variable
                    parent:'admin'
                },
               	controller:'SettingsCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['select2','SettingsServiceModule','ui-select-filter']).then(
                                function(){
                                    return $ocLazyLoad.load(['app/modules/settings/controllers/SettingsCtrl.js']);
                                }
                            );
                        }],
					resolvedItems:['dep','SettingsService',
                        function(dep, SettingsService) {							
                            return SettingsService.list().then(function(data){
                                return data;
                            });
                        }]
                }
            })
			.state('admin.ebproducts',{
                url: "/ebproducts",
                templateUrl: "app/modules/ebproduct/views/products.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.products',// angular translate variable
                    parent:'admin'
                },                
                controller:'EbProductListCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['sweet-alert','ui-bs-paging','EbProductServiceModule','datatable']).then(
                                function(){
                                    return $ocLazyLoad.load('app/modules/ebproduct/controllers/EbProductListCtrl.js');
                                }
                            );
                        }],
                    resolvedItems:['dep','EbProductService',
                        function(dep, EbProductService) {
                            return EbProductService.cachedList().then(function(data){
                                return data;
                            });
                        }]
                }
            })
			.state('admin.contact',{
                url: "/contact",
                templateUrl: "app/modules/contact/views/contactform.html",
                ncyBreadcrumb: {
                    label: 'app.breadcrumb.contact',// angular translate variable
                    parent:'admin'
                },
               	controller:'ContactCtrl',
                resolve: {
                    trans:['RequireTranslations',
                        function (RequireTranslations) {
                            RequireTranslations('shared');
                        }],
                    dep: ['trans','$ocLazyLoad',
                        function(trans,$ocLazyLoad){
                            return $ocLazyLoad.load(['select2','ContactServiceModule','ui-select-filter']).then(
                                function(){
                                    return $ocLazyLoad.load(['app/modules/contact/controllers/ContactCtrl.js']);
                                }
                            );
                        }]
                }
            })
          
    }
);