"use strict";

var app = angular.module('ng-laravel', ['ui.select']);
app.controller('ContactCtrl', function($scope, ContactService, $http, $rootScope, $translatePartialLoader, Notification, trans, $state, $timeout){
			
    $scope.contact = {'servicetype':'integration'};
	$scope.typeList = [{id:'storesetup',value:'Shopify store setup service'},{id:'themecustomization',value:'Shopify theme customization'},{id:'integration',value:'Import / Export to other marketing channels like Jet, eBay, Rakuten etc.'},{id:'other',value:'Other'}];

    $scope.sendRequest = function(contact) {
        $scope.isDisabled = true;
		$scope.tmp = angular.isObject(contact) ? angular.toJson(contact) : contact;
        ContactService.sendRequest($scope.tmp);
    };  

    /********************************************************
     * Event Listeners
     * Task event listener related to ContactCtrl
     ********************************************************/
    // Send contact request event listener
    $scope.$on('contact.sendrequest', function() {
		Notification({message: 'contact.form.sendRequestSuccess' ,templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
		$scope.contact = {'servicetype':'integration'};
		$scope.isDisabled = false;
    });

    //Validation error in send contact request event listener
    $scope.$on('contact.validationError', function(event,errorData) {
        Notification({message: errorData ,templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'},'warning');
        $scope.isDisabled = false;
    });

});