"use strict";

var app = angular.module('ng-laravel', ['ui.bootstrap']);
app.controller('EBCategoryMappingListCtrl', function($scope, resolvedItems, EBCategoryMappingService, EBCategoryService, $translatePartialLoader, trans, Notification){

	$scope.query ='';
	$scope.mappings = resolvedItems;
    $scope.pagination = $scope.mappings.metadata;
    $scope.maxSize = 2;
	$scope.mappingObj = {};

	$scope.categorylist1 = [];
	$scope.categorylist2 = [];
	$scope.categorylist3 = [];
	$scope.categorylist4 = [];
	$scope.categorylist5 = [];
	$scope.categorylist6 = [];

	EBCategoryMappingService.list().then(function(data){
        $scope.mappings = data;
        $scope.pagination = $scope.mappings.metadata;
        $scope.maxSize = 2;
    });

	$scope.units = [
        {'id': 10, 'label': '10'},
		{'id': 20, 'label': '20'},
        {'id': 50, 'label': '50'},
        {'id': 100, 'label': '100'},
    ]

	$scope.perPage = $scope.units[1];
	if($scope.perPage.id < $scope.pagination.total) {
		$scope.start = 1;
		$scope.end = $scope.perPage.id;
	} else {
		$scope.start = 1;
		$scope.end = $scope.pagination.total;
	}
	
	$scope.popupMapping = function (obj) {
		$scope.mappingObj.id = obj.id;
		$scope.mappingObj.product_type = obj.product_type;
		$scope.mappingObj.eb_category_id = obj.eb_category_id;
		$scope.mappingObj.eb_category_name = obj.eb_category_name;
		$scope.mappingObj.new_eb_category_id = "";
		$scope.isDisabled1 = true;
		$scope.loader = true;
		EBCategoryService.list().then(function(data){
			$scope.categorylist1 = data;			
			$scope.categorylist2 = [];
			$scope.categorylist3 = [];
			$scope.categorylist4 = [];
			$scope.categorylist5 = [];
			$scope.categorylist6 = [];
			$scope.mappingObj.category1 = "";
			$scope.mappingObj.category2 = "";
			$scope.mappingObj.category3 = "";
			$scope.mappingObj.category4 = "";
			$scope.mappingObj.category5 = "";
			$scope.mappingObj.category6 = "";
			$scope.loader = false;
		});		
	};

	$scope.updateMapping = function (mappingObj) {
		$scope.loader = true;
		$scope.isDisabled = true;
		if($scope.mappingObj.new_eb_category_id == ""){
			$scope.loader = false;			
			Notification({message: [["Please choose a valid category."]], templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			$scope.isDisabled = false;
		} else {
			EBCategoryMappingService.updateMapping(mappingObj);
		}
	};
	
	$scope.categoryDropDownChanged = function(type, eb_category_id){
		$scope.isDisabled1 = true;
		$scope.loader = true;
		$scope.mappingObj.new_eb_category_id = "";
		if(type == 1){
			EBCategoryService.subCategory(eb_category_id).then(function(data){
				$scope.categorylist2 = data;
				if(!$scope.categorylist2.length){
					$scope.isDisabled1 = false;
					$scope.mappingObj.new_eb_category_id = eb_category_id;
				}
				$scope.categorylist3 = [];
				$scope.categorylist4 = [];
				$scope.categorylist5 = [];
				$scope.categorylist6 = [];
				$scope.mappingObj.category2 = "";
				$scope.mappingObj.category3 = "";
				$scope.mappingObj.category4 = "";
				$scope.mappingObj.category5 = "";
				$scope.mappingObj.category6 = "";
				$scope.loader = false;
			});
		} else if(type == 2){
			EBCategoryService.subCategory(eb_category_id).then(function(data){
				$scope.categorylist3 = data;
				if(!$scope.categorylist3.length){
					$scope.isDisabled1 = false;
					$scope.mappingObj.new_eb_category_id = eb_category_id;
				}
				$scope.categorylist4 = [];
				$scope.categorylist5 = [];
				$scope.categorylist6 = [];
				$scope.mappingObj.category3 = "";
				$scope.mappingObj.category4 = "";
				$scope.mappingObj.category5 = "";
				$scope.mappingObj.category6 = "";
				$scope.loader = false;
			});
		} else if(type == 3){
			EBCategoryService.subCategory(eb_category_id).then(function(data){
				$scope.categorylist4 = data;
				if(!$scope.categorylist4.length){
					$scope.isDisabled1 = false;
					$scope.mappingObj.new_eb_category_id = eb_category_id;
				}
				$scope.categorylist5 = [];
				$scope.categorylist6 = [];
				$scope.mappingObj.category4 = "";
				$scope.mappingObj.category5 = "";
				$scope.mappingObj.category6 = "";
				$scope.loader = false;
			});
		} else if(type == 4){
			EBCategoryService.subCategory(eb_category_id).then(function(data){
				$scope.categorylist5 = data;
				if(!$scope.categorylist5.length){
					$scope.isDisabled1 = false;
					$scope.mappingObj.new_eb_category_id = eb_category_id;
				}
				$scope.categorylist6 = [];
				$scope.mappingObj.category5 = "";
				$scope.mappingObj.category6 = "";
				$scope.loader = false;
			});
		} else if(type == 5){
			EBCategoryService.subCategory(eb_category_id).then(function(data){
				$scope.categorylist6 = data;
				if(!$scope.categorylist6.length){
					$scope.isDisabled1 = false;
					$scope.mappingObj.new_eb_category_id = eb_category_id;
				}
				$scope.mappingObj.category6 = "";
				$scope.loader = false;
			});
		} else if(type == 6){
			$scope.isDisabled1 = false;
			$scope.loader = false;
			$scope.mappingObj.new_eb_category_id = eb_category_id;
		}
	};

	$scope.pageChanged = function (per_page) {
		$scope.loader = true;
		if($scope.query == '') {
			EBCategoryMappingService.pageChange($scope.pagination.current_page, per_page.id, $scope.end, $scope.pagination.total).then(function (data) {
	            $scope.loader = false;
				$scope.mappings = data;
				$scope.pagination = $scope.mappings.metadata;
				$scope.maxSize = 2;
				if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.current_page * per_page.id;			
				} else {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.total;	
				}
			});
		} else { 
			EBCategoryMappingService.search($scope.query, per_page.id, $scope.pagination.current_page, $scope.end, $scope.pagination.total).then(function (data) {
				$scope.loader = false;
				$scope.mappings = data;
				$scope.pagination = $scope.mappings.metadata;
				$scope.maxSize = 2;
				if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.current_page * per_page.id;			
				} else {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.total;	
				}
			});
		} 
	};

	$scope.search = function (per_page) {
		$scope.loader = true;
		EBCategoryMappingService.search($scope.query, per_page.id).then(function (data) {	
			$scope.loader = false;
			$scope.mappings = data;
			alert(JSON.stringify(data));
			$scope.pagination = $scope.mappings.metadata;			
            $scope.maxSize = 2;
			if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.current_page * per_page.id;			
			} else {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.total;	
			}
		});
	};
	
	$scope.refresh = function(){
		$scope.loader = true;
		$scope.query = '';
		EBCategoryMappingService.list().then(function (data) {
			$scope.loader = false;
			$scope.mappings = data;
			$scope.pagination = $scope.mappings.metadata;
			$scope.maxSize = 2;
			$scope.perPage = $scope.units[1];
			var per_page = $scope.perPage;
			if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.current_page * per_page.id;			
			} else {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.total;	
			}				
		});
	}

    /**********************************************************
     * Event Listener
     **********************************************************/
    // Get list of selected sample to do actions
    $scope.selection = [];
	$scope.selectedAll = false;
	$scope.checkAll = function () {		
		if ($scope.selectedAll) {
			$scope.selectedAll = true;				
        } else {
			$scope.selectedAll = false;
        }

		angular.forEach($scope.mappings, function (mapping) {
			 mapping.Selected = $scope.selectedAll;
			 $scope.toggleSelection(mapping.id);
        });
    };

	$scope.toggleSelection = function toggleSelection(mappingId) {
		// toggle selection for a given mapping by Id
		var idx = $scope.selection.indexOf(mappingId);
		// is currently selected
		if (idx > -1) {
			$scope.selection.splice(idx, 1);
        } else {
			$scope.selection.push(mappingId);
        }
    };

	$scope.removeSelection = function removeSelection(mappingId) {
		// toggle selection for a given mapping by Id
		var idx = $scope.selection.indexOf(mappingId);
		// is currently selected
		if (idx > -1) {
			$scope.selection.splice(idx, 1);
        }
    };
	
	$scope.$on('mapping.update', function (event, data, resp) {
		$scope.loader = false;
		$scope.isDisabled = false;
		Notification({message: 'mapping.form.mappingUpdateSuccess', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');		
		for(var i = 0; i < $scope.mappings.length; i++) {
			if($scope.mappings[i].product_type == data.product_type) {
				$scope.mappings[i].eb_category_id = data.eb_category_id;
				$scope.mappings[i].eb_category_name = resp.eb_category_name;
				break;
			}
		}
		$('#updateMappingModal').modal('hide');
    });

    $scope.$on('mapping.validationError', function(event, errorData) {
		$scope.loader = false;		
		Notification({message: errorData, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
		$scope.isDisabled = false;
	});
});