<?php

namespace App\Http\Controllers;

use App\AmzKey;
use App\AmzRequest;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Collection;

use App\Http\Requests;
use App\Http\Requests\AmzConfigRequest;
use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Peron\AmazonMws\AmazonReportRequest;

class AmzConfigController extends Controller
{
    public function __construct()
    {
        // Apply the jwt.auth middleware to all methods in this controller
        // except for the authenticate method. We don't want to prevent
        // the user from retrieving their token if they don't already have it
        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }


    public function index()
    {
		$currUser = Auth::User();
		$amzKey = $currUser->amzKey()->first();//->where("mws_token", "!=", "")->where("valid", "=", "1")
		if(!$amzKey){
			return response()->json([], 201);
		} else {
			return Auth::User()->amzKey()->first();
		}
    }

    public function store(AmzConfigRequest $request)
    {
		$currUser = Auth::User();
		$amzKey = $currUser->amzKey()->first();
		if($amzKey){
		   // if($amzKey->mws_token != ""){
		     //   return response()->json(['error' => ["msg"=>['Amazon account is already configured.']]], 406);	
		   // } else {
		        $merchant_id = $request->input('merchant_id');
			    $marketplace_id = $request->input('marketplace_id');
			    $mws_token = $request->input('mws_token');		
			    $isValid = $this->checkValidity($merchant_id, $marketplace_id, $mws_token);
			    if($isValid){
			        $amzKey->merchant_id = $merchant_id;
			        $amzKey->marketplace_id = $marketplace_id;
			        $amzKey->mws_token = $mws_token;
			        $amzKey->valid = 1;
			        $amzKey->secret_access_key = "";
			        $amzKey->access_key_id = "";
			    	Auth::User()->amzKey()->save($amzKey);
			    	$Request = AmzRequest::create(array("requestid" => '', "reporttype" => "_GET_MERCHANT_LISTINGS_DATA_", "status" => "pending"));
				    Auth::User()->amzRequests()->save($Request);
				    return response()->json(['success'], 200);		
			    } else {
			    	return response()->json(['error' => ["msg"=>['Invalid keys.']]], 406);
			    }   
		    //}
		} else {
			$merchant_id = $request->input('merchant_id');
			$marketplace_id = $request->input('marketplace_id');
			$mws_token = $request->input('mws_token');		
			$isValid = $this->checkValidity($merchant_id, $marketplace_id, $mws_token);
			if($isValid){
				$Request = AmzKey::create($request->all());		
				Auth::User()->amzKey()->save($Request);
				$Request = AmzRequest::create(array("requestid" => '', "reporttype" => "_GET_MERCHANT_LISTINGS_DATA_", "status" => "pending"));
				Auth::User()->amzRequests()->save($Request);
				return response()->json(['success'], 200);		
			} else {
				return response()->json(['error' => ["msg"=>['Invalid keys.']]], 406);
			}
		}			
    }
	
	private function checkValidity($merchant_id, $marketplace_id, $mws_token){
		$post = [
			'authkey' => 'WEREWC342343dfgddfds23dfs',
			'merchant_id' => $merchant_id,
			'marketplace_id' => $marketplace_id,
			'auth_token' => $mws_token
		];
		$ch = curl_init('https://shopify.infoshore.biz/xpert/validatekeysAPI.php');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post);		
		$response = curl_exec($ch);
		curl_close($ch);
		if($response){
			$resJson = json_decode($response, true);
			if(isset($resJson['status']) && $resJson['status'] == "success"){
				return true;
			}
		}
		return false;
	}
	
	private function getMWSServiceURL($marketplace_id){
		$mwsServiceUrlArr = array("A2EUQ1WTGCTBG2" => "https://mws.amazonservices.com", "A1AM78C64UM0Y8" => "https://mws.amazonservices.com", "ATVPDKIKX0DER" => "https://mws.amazonservices.com", "A1PA6795UKMFR9" => "https://mws-eu.amazonservices.com", "A1RKKUPIHCS9HS" => "https://mws-eu.amazonservices.com", "A13V1IB3VIYZZH" => "https://mws-eu.amazonservices.com", "APJ6JRA9NG5V4" => "https://mws-eu.amazonservices.com", "A1F83G8C2ARO7P" => "https://mws-eu.amazonservices.com", "A21TJRUUN4KGV" => "https://mws.amazonservices.in", "AAHKV2X7AFYLW" => "https://mws.amazonservices.com.cn", "A1VC38T7YXB528" => "https://mws.amazonservices.jp", "A39IBJ37TRP1C6" => "https://mws.amazonservices.com.au","A2VIGQ35RCS4UG" => "https://mws.amazonservices.com.ae");
		if(array_key_exists($marketplace_id, $mwsServiceUrlArr)){
			return $mwsServiceUrlArr[$marketplace_id];
		} else {
			return "https://mws.amazonservices.com";
		}
	}
	
	public function fetch(Request $request)
    {
		$currUser = Auth::User();
		$amzKey = $currUser->amzKey()->first();
		if(!$amzKey){
			return response()->json(['error' => ["msg"=>['Amazon account is not configured.']]], 406);			
		} 
		$existingRequests = $currUser->amzRequests()->where('reporttype', '=', '_GET_MERCHANT_LISTINGS_DATA_')->where('status', '!=', 'readyforshopify')->first();
		if($existingRequests){
			return response()->json(['error' => ["msg"=>['A request to fetch amazon products is already in progress.']]], 406);			
		}
		/*$merchant_id = $amzKey->merchant_id;
		$marketplace_id = $amzKey->marketplace_id;
		$access_key_id = $amzKey->access_key_id;
		$secret_access_key = $amzKey->secret_access_key;
		$serviceUrl = $this->getMWSServiceURL($marketplace_id);
		if(!$serviceUrl){
			return response()->json(['error' => ["msg"=>['The request could not be completed due to an internal error. Please contact support.']]], 406);
		}
		\Config::set('amazon-mws.store.'.$merchant_id, array(
				'merchantId'    => $merchant_id,
				'marketplaceId' => $marketplace_id,
				'keyId'  => $access_key_id,
				'secretKey'  => $secret_access_key,
				'amazonServiceUrl'  => $serviceUrl
		));
			
		$amz = new AmazonReportRequest($merchant_id);
		$amz->setReportType("_GET_MERCHANT_LISTINGS_DATA_");
		//$amz->setShowSalesChannel(true);
		$amz->setMarketplaces($marketplace_id);
		$amz->requestReport();
		$response = $amz->getResponse();
		if(!$response){
			return response()->json(['error' => ["msg"=>['The request could not be completed due to an internal error. Please contact support.']]], 406);
		} else {			*/
			$reportRequestID = '';//$amz->getReportRequestId();
			$Request = AmzRequest::create(array("requestid" => $reportRequestID, "reporttype" => "_GET_MERCHANT_LISTINGS_DATA_", "status" => "pending"));
			Auth::User()->amzRequests()->save($Request);
			return response()->json(['success'], 200);
	//	}			
    }
	
	public function resync(Request $request)
    {
		$currUser = Auth::User();
		$amzKey = $currUser->amzKey()->first();
		if(!$amzKey){
			return response()->json(['error' => ["msg"=>['Amazon account is not configured.']]], 406);			
		} 
		$existingRequests = $currUser->amzRequests()->where('reporttype', '=', '_GET_MERCHANT_LISTINGS_DATA_')->where('status', '!=', 'readyforshopify')->first();
		if($existingRequests){
			return response()->json(['error' => ["msg"=>['A request to fetch amazon products is already in progress.']]], 406);			
		}
		$merchant_id = $amzKey->merchant_id;
		$marketplace_id = $amzKey->marketplace_id;
		$access_key_id = $amzKey->access_key_id;
		$secret_access_key = $amzKey->secret_access_key;
		$serviceUrl = $this->getMWSServiceURL($marketplace_id);
		if(!$serviceUrl){
			return response()->json(['error' => ["msg"=>['The request could not be completed due to an internal error. Please contact support.']]], 406);
		}
		\Config::set('amazon-mws.store.'.$merchant_id, array(
				'merchantId'    => $merchant_id,
				'marketplaceId' => $marketplace_id,
				'keyId'  => $access_key_id,
				'secretKey'  => $secret_access_key,
				'amazonServiceUrl'  => $serviceUrl
		));
			
		$amz = new AmazonReportRequest($merchant_id);
		$amz->setReportType("_GET_MERCHANT_LISTINGS_DATA_");
		//$amz->setShowSalesChannel(true);
		$amz->setMarketplaces($marketplace_id);
		$amz->requestReport();
		$response = $amz->getResponse();
		if(!$response){
			return response()->json(['error' => ["msg"=>['The request could not be completed due to an internal error. Please contact support.']]], 406);
		} else {			
			$reportRequestID = $amz->getReportRequestId();
			$Request = AmzRequest::create(array("requestid" => $reportRequestID, "reporttype" => "_GET_MERCHANT_LISTINGS_DATA_", "status" => "requested", "resync" => "1"));
			Auth::User()->amzRequests()->save($Request);
			return response()->json(['success'], 200);
		}			
    }

	public function status(Request $request)
    {
		$currUser = Auth::User();
		$amzKey = $currUser->amzKey()->first();
		if(!$amzKey){
			return response()->json(['status' => "AMZ_KEY_NOT_EXIST"], 200);		
		} 
		$existingRequests = $currUser->amzRequests()->where('status', '!=', 'readyforshopify')->first();
		if($existingRequests){
			return response()->json(['status' => "REQUEST_IN_PROGRESS"], 200);						
		}		
		return response()->json(['status' => "NO_PRODUCT"], 200);
    }
}