<?php

namespace App\Http\Controllers;

use App\role_user;
use Illuminate\Http\Request;
use App\Role;
use App\User;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Tymon\JWTAuth\Facades\JWTAuth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class AuthenticateController extends Controller
{

    public function authenticate(Request $request)
    {
	    $permissions = array();
		if(!$request->has("key")){
			return response()->json(['error' => 'Invalid Credentials'], 401);
		}
		$tempcode = $request->input("key");
		$user = User::where('tempcode', $tempcode)->first(["id", "avatar_url", "shopurl", "status", "tempcode", "membershiptype", "plan", "sync", "skulimit", "skuconsumed", "review", "created_at", "paid_at", "usermsg","ebtoken"]);		
		if(!$user){
			return response()->json(['error' => 'Invalid Credentials'], 401);
		}
		$user->lastlogin = DB::raw('now()');
        $user->save();
		$paid_at = $user->paid_at;
		$created_at = $user->created_at;
		$review = $user->review;
		$fromtime = new Carbon($paid_at);
		//Log::info("difference == ".strtotime($paid_at));
		if(strtotime($paid_at) < 1){
			$fromtime = new Carbon($created_at);
		}		
		$now = Carbon::now();
		$difference = $fromtime->diffInDays($now);
		Log::info("difference == ".$difference);
		if($difference > 30 && $user->sync == 0 && $user->review == 0) {
			$user->expired = 1;
		} else if($difference > 60 && $user->sync == 0 && $user->review == 1) {
			$user->expired = 1;
		} else {
			$user->expired = 0;
		}
		$amzKey = $user->amzKey()->first();
		Log::info($amzKey);
		if(!$amzKey){
			$user->amzkey = 1;
		} else {
			if($amzKey->valid == 1){
				$user->amzkey = 1;
			} else {
				$user->amzkey = 0;
			}
		}
		try {
            // verify the credentials and create a token for the user
            if (! $token = JWTAuth::fromUser($user)) {
                return response()->json(['error' => 'Invalid Credentials'], 401);
            }
        } catch (JWTException $e) {
            // something went wrong
            return response()->json(['error' => 'could_not_create_token'], 500);
        }
       /* $role = DB::table('role_user')->where('user_id',Auth::user()->id)->first();
        $role = Role::find($role->role_id);
        $user=Auth::user();
        $temp=$role->perms()->get()->lists('name');
        foreach($temp as $value){
            $permissions[]=$value;
         }
        $user->permissions=$permissions;*/
        return response()->json(compact('token','user')); 
    }
}