<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use Illuminate\Http\JsonResponse;

class AmzConfigRequest extends Request
{


	public function response(array $errors){
        return new JsonResponse(['error' => $errors], 406);
    }
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {		
		$rules = ['merchant_id' => 'required',
				'marketplace_id' => 'required',
				'mws_token' => 'required'
              ];				
        return $rules;
    }
	
	public function messages() {
		$messages = [];
		$messages['merchant_id.required'] = 'Please enter Merchant ID.';	
		$messages['marketplace_id.required'] = 'Please choose a Marketplace.';
		$messages['access_key_id.required'] = 'Please enter MWS Auth Token.';
		return $messages;
	}	
}