<?php

Route::group(['prefix' => 'v1'], function()
{
	// authentication
    Route::resource('authenticate', 'AuthenticateController', ['only' => ['index']]);
    Route::post('authenticate', 'AuthenticateController@authenticate');
    
	Route::resource('product', 'ProductController', ['only' => ['index']]);
    Route::get('product/search','ProductController@search');    
	Route::post('product/block/{id}', 'ProductController@block'); 
	Route::post('product/unblock/{id}', 'ProductController@unblock'); 
	Route::post('product/push/{id}', 'ProductController@push');
	Route::post('product/pusheb/{id}', 'ProductController@pushEB');
	Route::post('product/pushwm/{id}', 'ProductController@pushWM');
	Route::post('product/pushdupamz/{id}', 'ProductController@pushDupAmz');
	Route::post('product/pushall', 'ProductController@pushall');
	Route::post('product/updateupc', 'ProductController@updateUPC');
	Route::post('product/resync', 'ProductController@resync');
	Route::post('product/remove/{id}', 'ProductController@remove');
	Route::get('product/suggestedplan', 'ProductController@suggestedPlan');
	Route::get('product/export/file', 'ProductController@exportFile');
	Route::get('product/export/file1', 'ProductController@exportFile1');
	Route::post('product/requestImgRefresh/{id}', 'ProductController@requestImgRefresh'); 

    Route::get('amzconfig','AmzConfigController@index');
	Route::post('amzconfig','AmzConfigController@store');
	Route::post('amzconfig/fetch','AmzConfigController@fetch');
	Route::post('amzconfig/resync','AmzConfigController@resync');
	Route::get('amzconfig/status','AmzConfigController@status');
	
	Route::get('settings','SettingsController@index');
	Route::post('settings','SettingsController@store');

	Route::post('contact/requestquote','ContactController@requestquote');
	Route::post('contact/addsubscriber','ContactController@addSubscriber');
	
	// Handle categories
	Route::get('ebcategory','EbCategoryController@index');
	Route::get('ebcategory/{id}/subcategory','EbCategoryController@getSubCategories');

	// Handle category mappings
	Route::get('ebcategorymapping', 'EbCategoryMappingController@index');
	Route::get('ebcategorymapping/{id}', 'EbCategoryMappingController@show');
	Route::post('ebcategorymapping', 'EbCategoryMappingController@store');
	Route::get('ebcategorymapping/search', 'EbCategoryMappingController@search');

	// Handle eBay products
	Route::resource('ebproduct', 'EbProductController', ['only' => ['index']]);
    Route::get('ebproduct/search','EbProductController@search');    
	Route::post('ebproduct/block/{id}', 'EbProductController@block'); 
	Route::post('ebproduct/unblock/{id}', 'EbProductController@unblock'); 
	Route::post('ebproduct/push/{id}', 'EbProductController@push');
	Route::post('ebproduct/pushall', 'EbProductController@pushall');	
});