<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Requests;
use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Artisan;
use Carbon\Carbon;
use PHPShopify;
use Mail;
use Illuminate\Support\Facades\Storage;
use App\User;
use App\ShopifyStore;
use App\StoreCronJob;
use App\Helpers\AppHelper;
use App\EbayAccount;
use App\Profile;
// use \DTS\eBaySDK\OAuth\Services;
// use \DTS\eBaySDK\OAuth\Types;
use App\Helpers\EbayHelper;
use \DTS\eBaySDK\Trading\Services;
use \DTS\eBaySDK\Trading\Types;
use \DTS\eBaySDK\Trading\Enums;
use Illuminate\Support\Facades\Log;

class EbayAccountController extends Controller{
	
	public function __construct(Request $request){
	}

	public function index(Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			if($request->has("fetch_first") && $request->input("fetch_first") == 1){
				$ebayAccount = $shopifyStore->ebayAccounts()->first();

				$locations = array();
				try{
					// PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
					// $shopifyClient = new PHPShopify\ShopifySDK;

					$config = array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version'));
					$shopifyClient = new PHPShopify\ShopifySDK($config);

					$locations = $shopifyClient->Location()->get();
				}
				catch(\Exception $e){
					report($e);
				}
			//	$ebayAccount->locations = $locations;
			if (isset($locations)) {
    $ebayAccount->locations = $locations;
} else {
    // If $locations is not defined, assign an empty string
    $ebayAccount->locations = "";
}	
				return response()->json($ebayAccount,200);
			}
			else{
				$ebayAccounts = $shopifyStore->ebayAccounts()->get();
				return response()->json($ebayAccounts,200);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	/*
	public function save(Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$validationRules = [
				'name' => 'required',
				'siteid' => 'required'
			];
			
			$validator = Validator::make($request->all(),$validationRules);
			if($validator->fails()){
				return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
			}

			$siteid = $request->input('siteid');

			$environment = config('ebay.environment');

			$install_link = ($environment == "sandbox") ? "https://auth.sandbox.ebay.com/oauth2/authorize" : "https://auth.ebay.com/oauth2/authorize";

			$params = [];
			$params['client_id'] = config('ebay.'.$environment.'appid');
			$params['redirect_uri'] = config('ebay.'.$environment.'RuName');
			$params['response_type'] = "code";
			$params['scope'] = implode(" ",config('ebay.scope'));
			$params['prompt'] = "login";

			$ebayAccount = $shopifyStore->ebayAccounts()->where("siteid",$siteid)->first();
			if($ebayAccount && $ebayAccount->is_valid == 1 && strlen($ebayAccount->token) > 0 && strlen($ebayAccount->sellerid) > 0){
				return response()->json(['status' => 'error','msg' => "ebay account already exists"],406);
			}
			else if($ebayAccount){
				$params['state'] = $ebayAccount->id.":".$shopifyStore->id;

				$install_link .= "?".http_build_query($params);

				//file_put_contents("install_link.txt",$install_link);

				return response()->json(['status' => 'success','install_link' => $install_link],200);
			}

			$accountData = $request->all();
			$accountData["siteid"] = $siteid;
			$accountData["store_id"] = $shopifyStore->id;
			$accountData["user_id"] = $shopifyStore->user->id;
			$accountData["is_valid"] = 0;
			if($request->input("import_products")) $accountData["import_products"] = 1;

			$ebayAccount = $shopifyStore->ebayAccounts()->create($accountData);
			if($ebayAccount){
				$params['state'] = $ebayAccount->id.":".$shopifyStore->id;
				
				$install_link .= "?".http_build_query($params);

				return response()->json(['status' => 'success','install_link' => $install_link],200);
			}
			else{
				return response()->json(['status' => 'error','msg' => 'account not added, please try again'],406);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}
	*/

	
	public function save(Request $request){
	     Log::info("Entered in save method of ebayaccount controller");
	  	$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
		     Log::info("shpoify store found in save method of ebayaccount controller");
			$validationRules = [
				'name' => 'required',
				'siteid' => 'required'
			];
			
			$validator = Validator::make($request->all(),$validationRules);
			if($validator->fails()){
				return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
			}

			$siteid = $request->input('siteid');
            Log::info("site id found in save method of ebayaccount controller");
			$environment = config('ebay.environment');
			if($shopifyStore->user_id == 2) $environment = "sandbox";

			$params = array(
				'store_id' => $shopifyStore->id,
				'siteid' => $siteid,
				"sbkey" => $shopifyStore->id,
				"issrc" => "infoshore"
			);
			
			$query = array('RuName' => config('ebay.'.$environment.'RuName'));
			$query['sid'] = $params['SecretID'] = md5(uniqid());

			$ebayAccount = $shopifyStore->ebayAccounts()->where("siteid",$siteid)->first();
			if($ebayAccount && strlen($ebayAccount->token) > 0 && strlen($ebayAccount->sellerid) > 0){
				return response()->json(['status' => 'error','msg' => "ebay account already exists"],406);
			}
			else if($ebayAccount){
				$params['account_id'] = $ebayAccount->id;
				$query['ruparams'] = http_build_query($params);

				$install_link = config('ebay.'.$environment.'signin').http_build_query($query);
              Log::info("site id found in save method of ebayaccount controller");
				return response()->json(['status' => 'success','install_link' => $install_link],200);
			}

			$accountData = $request->all();
			$accountData["siteid"] = $siteid;
			$accountData["store_id"] = $shopifyStore->id;
			$accountData["user_id"] = $shopifyStore->user->id;
			$accountData["is_valid"] = 0;
         Log::info("all data found in save method of ebayaccount controller");
			if($request->input("import_products")) $accountData["import_products"] = 1;

			$ebayAccount = $shopifyStore->ebayAccounts()->create($accountData);
			
			if($ebayAccount){
			     Log::info("ebay account found in save method of ebayaccount controller");
				$params['account_id'] = $ebayAccount->id;
				$query['ruparams'] = http_build_query($params);
                Log::info("insatallation link in save method of ebayaccount controller");
				$install_link = config('ebay.'.$environment.'signin').http_build_query($query);
                Log::info("insatallation found in save method of ebayaccount controller".$install_link);
				return response()->json(['status' => 'success','install_link' => $install_link],200);
			}
			else{
			    Log::info("error occuered found in save method of ebayaccount controller");
				return response()->json(['status' => 'error','msg' => 'account not added, please try again'],406);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}
	
    public function Ebayaccountset(Request $request){
      
	$shopifyStore = AppHelper::getShopifyStore($request);
	if($shopifyStore){
	
			$ebayAccount = $shopifyStore->ebayAccounts()->first();
			
         if($ebayAccount){
			$locations = array();
			try{
				
				// PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
				// $shopifyClient = new PHPShopify\ShopifySDK;

				$config = array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version'));
				$shopifyClient = new PHPShopify\ShopifySDK($config);

				$locations = $shopifyClient->Location()->get();
			}
			catch(\Exception $e){
				report($e);
			}
			$ebayAccount->locations = $locations;
			
			return response()->json($ebayAccount,200);

		 }
			
		
		// else{
		// 	$ebayAccounts = $shopifyStore->ebayAccounts()->get();
		// 	return response()->json($ebayAccounts,200);
		// }
	}

	return response()->json("Empty",200);
   

}
	public function show($id,Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$ebayAccount = $shopifyStore->ebayAccounts()->find($id);
			if($ebayAccount){
				return response()->json($ebayAccount,200);
			}
			else{
				return response()->json(['status' => 'error','msg' => 'account not found'],404);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function update($id,Request $request){
	    Log::info("Entered in update method of 4th step of confguration");	
	    //Log::info('reuest of inventory sync is here'.$request);
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$ebayAccount = $shopifyStore->ebayAccounts()->find($id);
			if($ebayAccount){
				$update_install_step = false;
				if($request->has("update_install_step")) $update_install_step = (bool) $request->input("update_install_step");

				$accountData = $request->all();
				
				$ebayAccount->update($accountData);
				$ebayAccount = $shopifyStore->ebayAccounts()->find($id);

				if($update_install_step && $shopifyStore->install_step == 4){
					$shopifyStore->install_step = "done";
					$shopifyStore->save();
				}

				if(!$request->input("automatic_sku_creation")) $shopifyStore->automatic_sku_creation = NULL;
				else $shopifyStore->automatic_sku_creation = 1;

				if(!$request->input("fix_duplicate_sku")) $shopifyStore->fix_duplicate_sku = NULL;
				else $shopifyStore->fix_duplicate_sku = 1;

				if($request->has("locations")){
					$locations = $request->input("locations");
					$shopifyStore->locations = ($locations) ? implode(",",$locations) : null;
				}

				$shopifyStore->save();
                 $siteid = 0;
                 
				if($request->has("reconfigure_ebay_account")){
					$reconfigure_ebay_account = (int) $request->input("reconfigure_ebay_account");
					if($reconfigure_ebay_account){

						$siteid = $ebayAccount->siteid;
                       Log::info("siteid found".$siteid);
						$environment = config('ebay.environment');
						
						$params = array(
							'store_id' => $shopifyStore->id,
							'siteid' => $siteid,
							"sbkey" => $shopifyStore->id,
							"issrc" => "infoshore"
						);
						
						$query = array('RuName' => config('ebay.'.$environment.'RuName'));
						$query['sid'] = $params['SecretID'] = md5(uniqid());

						$params['account_id'] = $ebayAccount->id;
						$query['ruparams'] = http_build_query($params);

						$install_link = config('ebay.'.$environment.'signin').http_build_query($query);
						
				
						return response()->json(['status' => 'success','install_link' => $install_link],200);
					}
				}
				
					$siteid = $ebayAccount->siteid;
				 Log::info("siteid found".$siteid);
				 
				 
					Log::info("finding user_id and token for setup IPN for id".$id);			
				$user_id = $shopifyStore->ebayAccounts()->where("id",$id)->value("user_id");	
				Log::info("user_id is this".$user_id);
				$token = $shopifyStore->ebayAccounts()->where("id",$id)->value("access_token");
					Log::info("token is this-".$token);
				$errmsg = "";
				
				

				return response()->json(['status' => 'success','msg' => 'App Configuration updated successfully','ebayAccount' => $ebayAccount->toArray()],200);
			}
			else{
				return response()->json(['status' => 'error','msg' => 'account not found'],404);
			}
		}
		
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

   
public function getnotification(){
    
    //$userResult =EbayAccount::where('is_valid',1)->where('user_id',770)->get();
      $userResults =EbayAccount::where('is_valid',1)->get();
    //print_r(json_encode($userResult,true));
    foreach($userResults as $userResult){
         $token = $userResult->access_token;
         $siteid = $userResult->siteid;
         print_r($token);
           print_r($siteid);
       	$environment = config('eb.environment');
    
    					$ebayCredentials = array(
    						'credentials' => [
    							'devId' => config('ebay.'.$environment.'devid'),
    							'appId' => config('ebay.'.$environment.'appid'),
    							'certId' => config('ebay.'.$environment.'certid'),
    							'authToken' => '',
    						],
    						'authToken' => '',
    						'oauthUserToken' => '',
    						'ruName' => config('ebay.'.$environment.'RuName')
    					);
    	$service = new Services\TradingService([
					'credentials' =>  $ebayCredentials['credentials'],
					'sandbox'     => false,
					'siteId'      => $siteid
				]);
				$request = new Types\GetNotificationPreferencesRequestType(); 
$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
$request->RequesterCredentials->eBayAuthToken = $token;
$request->PreferenceLevel = 'Application';
$response = $service->getNotificationPreferences($request);
print_r($response);

//addlog("new ipn data select sucess ".json_encode($response), "INFO");		
if ($response->Ack === 'Success') {
    // Handle the response and process the notification preferences
    print_r('hhhhh');
    //$notificationPreferences = $response->UserNotificationPreferences;
    
    // Iterate through $notificationPreferences to access each preference
    // foreach ($notificationPreferences as $preference) {
    //     // Access and process each notification preference as needed
    //     $notificationName = $preference->EventName;
    //     $notificationEnabled = $preference->UserDeliveryPreferenceArray->NotificationEnable;
    // }
} else {
    // Handle the case where the request was not successful
    // Check $response->Errors for error details
}
    }
   
    // $token = $userResult[0]->access_token;
    // $siteid = $userResult[0]->siteid;
    
}
	/*
	public function requestReport(Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$validationRules = [
				'name' => 'required',
				'merchant_id' => 'required',
				'marketplace_id' => 'required',
				'merchant_token' => 'required'
			];
			
			$validator = Validator::make($request->all(),$validationRules);
			if($validator->fails()){
				return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
			}
			
			$merchant_id = $request->input("merchant_id");
			$marketplace_id = $request->input("marketplace_id");
			$merchant_token = $request->input("merchant_token");
			$amazon_website = AppHelper::getAmazonCountryFromMarketPlace($marketplace_id);
			
			$update_install_step = false;
			if($request->has("update_install_step")) $update_install_step = (bool) $request->input("update_install_step");

			$amazonAccounts = $shopifyStore->amazonAccounts()->where("merchant_id",$merchant_id)->where("marketplace_id",$marketplace_id)->get();
			if($amazonAccounts->count() > 0){
				return response()->json(['status' => 'error','msg' => "amazon account already exists"],406);
			}

			$awsAccessKeyID = config('amazon.access_key_id');
			$awsSecretAccessKey = config('amazon.secret_access_key');
			if($amazon_website != "US" && $amazon_website != "CA"){
				$awsAccessKeyID = config('amazon.access_key_id2');
				$awsSecretAccessKey = config('amazon.secret_access_key2');
			}

			$amazonClient = new MCS\MWSClient([
				'Marketplace_Id' => $marketplace_id,
				'Seller_Id' => $merchant_id,
				'Access_Key_ID' => $awsAccessKeyID,
				'Secret_Access_Key' => $awsSecretAccessKey,
				'MWSAuthToken' => $merchant_token
			]);

			if(!$amazonClient->validateCredentials()){
				return response()->json(['status' => 'error','msg' => "amazon keys are not valid"],406);
			}

			try{
				sleep(2);
				$getReportListRespone = $amazonClient->GetReportList();
				//return response()->json(['status' => 'error','msg' => json_encode($getReportListRespone)],406);
			}
			catch(\Exception $e){
				return response()->json(['status' => 'error','msg' => $e->getMessage()],406);
			}

			$accountData = $request->all();
			$accountData["amazon_website"] = $amazon_website;
			$accountData["store_id"] = $shopifyStore->id;
			$accountData["user_id"] = $shopifyStore->user->id;

			//if($request->input("import_products")) $accountData["import_products"] = 1;

			$accountData["is_valid"] = 1;

			$amazonAccount = $shopifyStore->amazonAccounts()->create($accountData);
			if($amazonAccount){

				if($request->input("import_products")){
					try{
						$reportId = $amazonClient->RequestReport('_GET_MERCHANT_LISTINGS_DATA_');
						$reportData = array();
						$reportData["report_type"] = "_GET_MERCHANT_LISTINGS_DATA_";
						$reportData["request_id"] = $reportId;
						$reportData["report_id"] = $reportId;
						$reportData["status"] = "_SUBMITTED_";
						$reportData["account_id"] = $amazonAccount->id;
						$reportData["store_id"] = $shopifyStore->id;
						$reportData["user_id"] = $shopifyStore->user->id;
						$amazonReport = $amazonAccount->reports()->create($reportData);
					}
					catch(\Exception $e){
						report($e);
					}
				}
				
				if($update_install_step && $shopifyStore->install_step == 2){
					$shopifyStore->install_step = 3;
					$shopifyStore->save();
				}
				return response()->json(['status' => 'success','msg' => 'account added successfully','amazonAccount' => $amazonAccount->toArray()],200);
			}
			else{
				return response()->json(['status' => 'error','msg' => 'account not added, please try again'],406);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}
	*/

	public function checkEbayKeys(Request $request){
		$refresh_token = 'Atzr|IwEBIGjtlbDOCYnZq9L1ze0LkKRtteidQGEKkJLZgbrRJlqu9TXGUH-k01niJwZi_PSVdr6hs9JrCtCiuIWRB-XyIZeUGtw_We0XiYbPsUkOobgBpFbdr9W9BbVUZaNC5HQP14IrYQdehd17dZl02rO5Zoj8Dyry0cTusni7GB70sNmahGEOa6Lew6wn9-I5AmT4cX4jtDsNe1a5r7_-8KZjDxEfcs1Rja7puOhxrHfo-VOh9waa33bNEjpDHCwve1QHB9_owZ0-sCUs3PtEPyMRPymkjRxNZNhte356CnKT6xfgZAZIeLxldaIFr__2QgFE3nQ';
		$amz_site = 'US';

		$region = \ClouSale\AmazonSellingPartnerAPI\SellingPartnerRegion::$NORTH_AMERICA;
		$endpoint = \ClouSale\AmazonSellingPartnerAPI\SellingPartnerEndpoint::$NORTH_AMERICA;

		if($amz_site == 'US' || $amz_site == 'CA' || $amz_site == 'MX' || $amz_site == 'BR'){
		}
		else if($amz_site == 'SG' || $amz_site == 'AU' || $amz_site == 'JP'){
			$region = \ClouSale\AmazonSellingPartnerAPI\SellingPartnerRegion::$FAR_EAST;
			$endpoint = \ClouSale\AmazonSellingPartnerAPI\SellingPartnerEndpoint::$FAR_EAST;
		}
		else{
			$region = \ClouSale\AmazonSellingPartnerAPI\SellingPartnerRegion::$EUROPE;
			$endpoint = \ClouSale\AmazonSellingPartnerAPI\SellingPartnerEndpoint::$EUROPE;
		}
		
		if(config('amazon.sandbox') === true) $endpoint = str_replace("https://","https://sandbox.",$endpoint);

		$options = [
			'refresh_token' => $refresh_token,
			'client_id' => config('amazon.client_id'),
			'client_secret' => config('amazon.client_secret'),
			'region' => $region,
			'access_key' => config('amazon.access_key_id'),
			'secret_key' =>config('amazon.secret_access_key'),
			'endpoint' => $endpoint,
			'role_arn' => config('amazon.role_arn'),
		];

		
		$accessToken = \ClouSale\AmazonSellingPartnerAPI\SellingPartnerOAuth::getAccessTokenFromRefreshToken(
			$options['refresh_token'],
			$options['client_id'],
			$options['client_secret']
		);
		$assumedRole = \ClouSale\AmazonSellingPartnerAPI\AssumeRole::assume(
			$options['region'],
			$options['access_key'],
			$options['secret_key'],
			$options['role_arn']
		);

		$config = \ClouSale\AmazonSellingPartnerAPI\Configuration::getDefaultConfiguration();
		$config->setHost($options['endpoint']);
		$config->setAccessToken($accessToken);
		$config->setAccessKey($assumedRole->getAccessKeyId());
		$config->setSecretKey($assumedRole->getSecretAccessKey());
		$config->setRegion($options['region']);
		$config->setSecurityToken($assumedRole->getSessionToken());


		$marketplace_ids = ['ATVPDKIKX0DER'];
		$apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\OrdersApi($config);

		
		echo '<pre>';

		$created_after = "2020-04-04T08:07:32.000Z";
		$next_token = "";
		$max_results_per_page = 100;
		try{
			$result = $apiInstance->getOrders(
				$marketplace_ids,
				$created_after,
				null,
				null,
				null,
				["Pending","Unshipped","PartiallyShipped"],
				null,
				["Other"],
				null,
				null,
				$max_results_per_page,
				null,
				$next_token
			);
			$payload = $result->getPayload();
			print_r($payload);
		}
		catch(\Exception $e){
			$error = $e->getMessage();
			echo $error;
		}

		die();



		$merchant_id = "A2HDH9PWY7LP2W";
		$marketplace_id = "ATVPDKIKX0DER";
		$merchant_token = "amzn.mws.04b34410-dc70-d7fa-4b7a-5193cc001d31";
		$amazon_website = AppHelper::getAmazonCountryFromMarketPlace($marketplace_id);

		$awsAccessKeyID = config('amazon.access_key_id');
		$awsSecretAccessKey = config('amazon.secret_access_key');
		if($amazon_website != "US" && $amazon_website != "CA"){
			$awsAccessKeyID = config('amazon.access_key_id2');
			$awsSecretAccessKey = config('amazon.secret_access_key2');
		}

		$amazonClient = new MCS\MWSClient([
			'Marketplace_Id' => $marketplace_id,
			'Seller_Id' => $merchant_id,
			'Access_Key_ID' => $awsAccessKeyID,
			'Secret_Access_Key' => $awsSecretAccessKey,
			'MWSAuthToken' => $merchant_token
		]);
		echo '<pre>';

		try{
			$fromDate = new \DateTime("2016-01-01");
			$apiRes = $amazonClient->ListOrders($fromDate,true,["Pending","Unshipped","PartiallyShipped","Shipped"]);

			//$apiRes = $amazonClient->ListOrderItems("validate");
			print_r($apiRes);
		}
		catch(\Exception $e){
			echo $e->getMessage();
		}

		
		if(!$amazonClient->validateCredentials()){
			echo "invalid";
		}
		
		
		
		try{
			$getReportListRespone = $amazonClient->GetReportList();
			print_r($getReportListRespone);
		}
		catch(\Exception $e){
			echo $e->getMessage();
		}
	}


	/*
	public function ebayAppInstall(Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore && $request->input('amazon_callback_uri') && $request->input('amazon_state')){
			$amazon_callback_uri = $request->input('amazon_callback_uri');
        	$amazon_state = $request->input('amazon_state');
			$merchant_id = $request->input('merchant_id');
			$version = ($request->has('version')) ? $request->input('version') : null;
			$redirect_url = route('amazonAuth');
			$redirect_url = "https://apps.infoshore.biz/shopify-apps/amazon-shopify/service/amazonauth";
			$app_url = $amazon_callback_uri."?redirect_uri=".urldecode($redirect_url)."&amazon_state=".urldecode($amazon_state);
			if($version) $app_url .= "&version=beta";

			$amazonAccount = $shopifyStore->amazonAccounts()->latest('created_at')->first();
			if($amazonAccount && $merchant_id){
				$amazonAccount->merchant_id = $merchant_id;
				$amazonAccount->save();
			}
			else{
				return response()->json(['status' => 'error','msg' => "invalid request"],403);
			}
			return response()->json(['status' => 'success','auth_link' => $app_url],200);
			//return \Redirect::to($app_url);
		}
		else if($shopifyStore){
			$install_link = 'https://sellercentral.amazon.com/apps/authorize/consent?application_id='.config('amazon.application_id');
			//$install_link .='&shopify_url='.$shopifyStore->shopify_url;
			if(config('amazon.sandbox') === true) $install_link .='&version=beta';

			return response()->json(['install_link' => $install_link],200);
		}
		
	}
	*/

	public function ebayAccountClose(Request $request){
		if(isset($_GET["challenge_code"])){
			$challenge_code = $_GET["challenge_code"];
			$verificationToken = "FB534ED7ACE2DD24A2EA3D4531481V6H7J1";

			$endpoint = "https://app1.ecomshore.com/service/ebayaccountclose";

			$hash = hash_init('sha256');
			hash_update($hash, $challenge_code);
			hash_update($hash, $verificationToken);
			hash_update($hash, $endpoint);

			$responseHash = hash_final($hash);

			header('Content-Type: application/json; charset=utf-8');

			echo json_encode(["challengeResponse" => $responseHash]);

			//echo $responseHash;
		}
		else{
			//$stdin = $GLOBALS['HTTP_RAW_POST_DATA'];
			//$stdinjson = (is_array($stdin)) ? json_encode($stdin) : $stdin;
			//file_put_contents("stdin.txt",$stdinjson);
			file_put_contents("not_header.txt",json_encode($_SERVER));
			file_put_contents("not_post.txt",json_encode($_POST));
			file_put_contents("not_get.txt",json_encode($_GET));
			//echo '<pre>';
			//print_r($_GET);

			return response()->json([],200);
		}
	}
	
	public function ebayAuth(Request $request){
		$account_id = $request->input('account_id');
		$store_id = $request->input('store_id');
		$sellerid = $request->input('username');
		
		$ebayAccount = ($account_id) ? EbayAccount::where('store_id',$store_id)->with('store')->find($account_id) : array();
		if($ebayAccount && $ebayAccount->store){
			$shopifyStore = $ebayAccount->store;
			if($shopifyStore && $shopifyStore->status == "active"){
				try{
					$environment = config('ebay.environment');

					if($shopifyStore->user_id == 2) $environment = "sandbox";
					
					$EBAY = array(
						'trade'  => config('ebay.'.$environment.'trade'),
						'signin' => config('ebay.'.$environment.'signin'),
						'devid'  => config('ebay.'.$environment.'devid'),
						'appid'  => config('ebay.'.$environment.'appid'),
						'certid' => config('ebay.'.$environment.'certid'),
						'RuName' => config('ebay.'.$environment.'RuName')
					);
					
					$token = '';
					$token_exp = '';

					$body = '';
					while(isset($_GET['ebaytkn'])){
						if(strlen($_GET['ebaytkn'])) $token = $_GET['ebaytkn'];
						else{
							if(isset($_GET['SessionID'])) $body ="<SessionID>{$_GET['SessionID']}</SessionID>";
							else if(isset($_GET['SecretID'])){
								if(!isset($_GET['username'])){
									$rmsg = 'Cannot retrieve token without username!';
									break;
								}
								$body ="<SecretID>{$_GET['SecretID']}</SecretID>"."<RequesterCredentials><Username>{$_GET['username']}</Username></RequesterCredentials>";
							}
							else{
								break;
							}
							$token = EbayHelper::ebayTradeAPI('FetchToken',$body,'eBayAuthToken',$EBAY);
							if($token) $token_exp = EbayHelper::ebayTradeAPI('FetchToken',$body,'HardExpirationTime',$EBAY);
						}
						break;
					}

					if($token && $token_exp){
						$ebayAccount->access_token = $token;
						$ebayAccount->expires_in = $token_exp;
						$ebayAccount->token_type = "eBayAuthToken";
						$ebayAccount->is_valid = 1;
						$ebayAccount->sellerid = $sellerid;
						$ebayAccount->save();
						
						if($shopifyStore->install_step == 2){
							$shopifyStore->install_step = 3;
							$shopifyStore->save();
						}

						$frontend_url = config('config.frontend_url').'?shop='.$shopifyStore->shopify_url;
						return \Redirect::to($frontend_url);
					}
					else{
						return view('error');
					}

					/*
					$ebayCredentials = array(
						'credentials' => [
							'devId' => config('ebay.'.$environment.'devid'),
							'appId' => config('ebay.'.$environment.'appid'),
							'certId' => config('ebay.'.$environment.'certid'),
							'authToken' => '',
						],
						'authToken' => '',
						'oauthUserToken' => '',
						'ruName' => config('ebay.'.$environment.'RuName')
					);

					$service = new Services\OAuthService([
						'credentials' => $ebayCredentials['credentials'],
						'ruName' => $ebayCredentials['ruName'],
						'sandbox' => ($environment == "sandbox") ? true : false
					]);
					
					$response = $service->getAppToken();
					
					if($response->getStatusCode() === 200){
						
						$ebayAccount->access_token = $response->access_token;
						$ebayAccount->expires_in = $response->expires_in;
						$ebayAccount->refresh_token = $response->refresh_token;
						$ebayAccount->token_type = $response->token_type;
						$ebayAccount->is_valid = 1;
						$ebayAccount->sellerid = $sellerid;
						$ebayAccount->save();
						
						if($shopifyStore->install_step == 2){
							$shopifyStore->install_step = 3;
							$shopifyStore->save();
						}

						$frontend_url = config('config.frontend_url').'?shop='.$shopifyStore->shopify_url;
						return \Redirect::to($frontend_url);

					}
					else{
						//echo $response->error_description;
						return view('error');
					}
					*/
				}
				catch(\Exception $e){
					//echo $e->getMessage();
					return view('error');
				}
			}
			else{
				return view('error');
			}
		}
		else{
			return view('error');
		}
	}

	/*
	public function ebayAuth(Request $request){
		$state = ($request->input('state')) ? explode(":",$request->input('state')) : null;
		$account_id = null;
		$store_id = null;

		if($state && count($state) == 2){
			$account_id = $state[0];
			$store_id = $state[1];
		}
		
		$oauth_code = $request->input('code');

		//$oauth_code = urldecode(urldecode($oauth_code));

		$ebayAccount = ($account_id) ? EbayAccount::where('store_id',$store_id)->with('store')->find($account_id) : array();
		if($ebayAccount && $ebayAccount->store && $oauth_code){
			$shopifyStore = $ebayAccount->store;
			if($shopifyStore && $shopifyStore->status == "active"){
				try{
					$environment = config('eb.environment');

					$ebayCredentials = array(
						'credentials' => [
							'devId' => config('ebay.'.$environment.'devid'),
							'appId' => config('ebay.'.$environment.'appid'),
							'certId' => config('ebay.'.$environment.'certid'),
							'authToken' => '',
						],
						'authToken' => '',
						'oauthUserToken' => '',
						'ruName' => config('ebay.'.$environment.'RuName')
					);

					$service = new OServices\OAuthService([
						'credentials' => $ebayCredentials['credentials'],
						'ruName' => $ebayCredentials['ruName'],
						'sandbox' => ($environment == "sandbox") ? true : false
					]);

					$request = new OTypes\GetUserTokenRestRequest();
					$request->code = $oauth_code;

					$response = $service->getUserToken($request);
					if($response->getStatusCode() === 200){

						$ebayAccount->access_token = $response->access_token;
						$ebayAccount->expires_in = $response->expires_in;
						$ebayAccount->refresh_token = $response->refresh_token;
						$ebayAccount->token_type = $response->token_type;
						$ebayAccount->is_valid = 1;

						try{
							$service = new Services\TradingService([
								'credentials' => $ebayCredentials['credentials'],
								'siteId' => $ebayAccount->siteid,
								'sandbox' => ($environment == "sandbox") ? true : false
							]);

							$request = new Types\GetUserRequestType();
							$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
							$request->RequesterCredentials->eBayAuthToken = $response->access_token;
							$userResponse = $service->getUser($request);
							$userResponse = ($userResponse) ? $userResponse->toArray() : [];
							if($userResponse && isset($userResponse["User"]) && $userResponse["User"]){
								$ebayAccount->sellerid = $userResponse["User"]["UserID"];
							}
						}
						catch(\Exception $e){
							report($e);
						}

						$ebayAccount->save();
						
						if($shopifyStore->install_step == 2){
							$shopifyStore->install_step = 3;
							$shopifyStore->save();
						}

						$frontend_url = config('config.frontend_url').'?shop='.$shopifyStore->shopify_url;
						return \Redirect::to($frontend_url);

					}
					else{
						echo $response->error_description;
						return view('error');
					}
				}
				catch(\Exception $e){
					return view('error');
				}
			}
			else{
				return view('error');
			}
		}
		else{
			return view('error');
		}
	}
	*/

}