<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Requests;
use Validator;
use App\Http\Controllers\Controller;
use App\Http\Controllers\EbayDataController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Artisan;
use Carbon\Carbon;
use PHPShopify;
use Mail;
use Illuminate\Support\Facades\Storage;
use App\Profile;
use App\User;
use App\ShopifyStore;
use App\StoreCronJob;
use App\Helpers\AppHelper;
use App\EbayAccount;
use App\EbaySellerProfile;
use App\EbayCategory;
use \DTS\eBaySDK\Constants;
use \DTS\eBaySDK\BusinessPoliciesManagement\Services;
use \DTS\eBaySDK\BusinessPoliciesManagement\Types;
use \DTS\eBaySDK\BusinessPoliciesManagement\Types\Amount;
use Illuminate\Support\Facades\Log;
use \DTS\eBaySDK\Trading\Enums;
use DTS\eBaySDK\BusinessPoliciesManagement\Types\InternationalReturnPolicyInfo;

class PolicyController extends Controller{

	public $shopifyStore = null;	
	
	public function __construct(Request $request){
	    
	}

	public function index(Request $request){
		Log::channel('PolicyControllerLog')->info("policy controller starts index ");
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$ebayAccount = EbayAccount::where('is_valid',1)->where('store_id',$shopifyStore->id)->orderBy('created_at','DESC')->first();
			$profiles = $ebayAccount->ebaySellerProfiles()->paginate(20);
			return response()->json($profiles,200);
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function getGlobalId($site_id){
		$globalId = Constants\GlobalIds::US;
		if($site_id == 2) $globalId = Constants\GlobalIds::ENCA;
		else if($site_id == 3) $globalId = Constants\GlobalIds::GB;
		else if($site_id == 15) $globalId = Constants\GlobalIds::AU;
		else if($site_id == 23) $globalId = Constants\GlobalIds::FRBE;
		else if($site_id == 71) $globalId = Constants\GlobalIds::FR;
		else if($site_id == 77) $globalId = Constants\GlobalIds::DE;
		else if($site_id == 203) $globalId = Constants\GlobalIds::IN;
		else if($site_id == 210) $globalId = Constants\GlobalIds::FRCA;
		else if($site_id == 216) $globalId = Constants\GlobalIds::SG;
		else if($site_id == 207) $globalId = Constants\GlobalIds::MY;
		else if($site_id == 205) $globalId = Constants\GlobalIds::IE;
		else if($site_id == 186) $globalId = Constants\GlobalIds::ES;
		else if($site_id == 101) $globalId = Constants\GlobalIds::IT;
		return $globalId;
	}

	public function addUpdatePaymentProfile($request, $shopifyStore){
	    
	     Log::channel('PolicyControllerLog')->info("addUpdatePaymentProfile starts ".json_encode($request->all()));
		//$request["paypal_email"] = "infoshorejpr@gmail.com";
		$validationRules = [
			'name' => 'required',
			'payment_methods' => 'required',
			'immediate_payment' => 'in:0,1',
			'paypal_email' => 'email'
		];
		    
		$validator = Validator::make($request->all(),$validationRules);
		Log::channel('PolicyControllerLog')->info("addUpdatePaymentProfile starts 11111555555");
	//	if($validator->fails()) return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
		
		$ebayAccount = EbayAccount::where('is_valid',1)->where('store_id',$shopifyStore->id)->orderBy('created_at','DESC')->first();
		
		if(!$ebayAccount) return response()->json(['status' => 'error', 'msg' => 'invalid request'],403);
            Log::channel('PolicyControllerLog')->info("eb.environmen");
		$environment = config('eb.environment');
		$_EBAY = array(
			'trade'  => config('ebay.'.$environment.'trade'),
			'signin' => config('ebay.'.$environment.'signin'),
			'devid'  => config('ebay.'.$environment.'devid'),
			'appid'  => config('ebay.'.$environment.'appid'),
			'certid' => config('ebay.'.$environment.'certid'),
			'RuName' => config('ebay.'.$environment.'RuName'),
			'compatabilityLevel' => 859,
			'siteID' => 0
		);
		
		$ebayCredentials = array(
			'credentials' => [
				'devId' => config('ebay.'.$environment.'devid'),
				'appId' => config('ebay.'.$environment.'appid'),
				'certId' => config('ebay.'.$environment.'certid'),
				'authToken' => '',
			],
			'authToken' => '',
			'oauthUserToken' => '',
			'ruName' => config('ebay.'.$environment.'RuName')
		);
		
	     Log::channel('PolicyControllerLog')->info("addUpdatePaymentProfile starts 2222222222");
		try{
			$payment_method = $request->input("payment_methods");
		
			$payment_methods = str_replace('"', '', $payment_method[0]);
				$payment_methods = 'PayPal';
				Log::channel('PolicyControllerLog')->info("payment  methoddddd  ".json_encode($payment_methods,true));
		
			  //Log::channel('PolicyControllerLog')->info("payment  method");
		//	if(!is_array($payment_methodsyment_methods = explode(",",$payment_methods);

			$payment_instructions = $request->input("payment_instructions");
			$paypal_email = $request->input("paypal_email");
			$profile_name = $request->input("name");
			$profile_type = $request->input("profile_type");
			$immediate_payment = $request->input("immediate_payment");

			$site_id = (isset($ebayAccount->siteid)) ? $ebayAccount->siteid : 0;
			$_EBAY["siteID"] = $site_id;
			
        //  Log::channel('PolicyControllerLog')->info("payment_methods ".str_replace('"', '', $payment_methods[0]));
           Log::channel('PolicyControllerLog')->info("payment_instructions ".$request->input("payment_instructions"));
           Log::channel('PolicyControllerLog')->info("paypal_email ".$request->input("paypal_email")); 
           Log::channel('PolicyControllerLog')->info("name ".$request->input("name"));
           Log::channel('PolicyControllerLog')->info("profile_type ".$request->input("profile_type"));
           Log::channel('PolicyControllerLog')->info("immediate_payment ".$request->input("immediate_payment"));  
           Log::channel('PolicyControllerLog')->info("site_id ".$site_id);
           
                    
			$ebay_token = $ebayAccount->access_token;
               Log::channel('PolicyControllerLog')->info("ebay_token ".$ebay_token);
			$globalId = $this->getGlobalId($site_id);
             Log::channel('PolicyControllerLog')->info("globalid  $globalId");
			$ebayService = new Services\BusinessPoliciesManagementService([
				'credentials' => $ebayCredentials['credentials'],
				'authToken'   => $ebay_token,
				'globalId'    => $globalId
			]);
			//	Log::channel('PolicyControllerLog')->info("ebayService".json_encode($ebayService,true));
			$ebayRequest = new Types\AddSellerProfileRequest();
			$paymentProfile = new Types\PaymentProfile();

			$paymentInfo = new Types\PaymentInfo(); 
			$paymentInfo->acceptedPaymentMethod =   [Enums\BuyerPaymentMethodCodeType::C_PAY_PAL]; 
             // $paymentInfo->PaymentOption = Enums\BuyerPaymentMethodCodeType::C_PAY_PAL;

			
		//	 Log::channel('PolicyControllerLog')->info("ebay_paymentInfo ".json_encode($paymentInfo,true));
		
			if($payment_instructions) $paymentInfo->paymentInstructions = $payment_instructions;
			if($paypal_email) $paymentInfo->paypalEmailAddress = $paypal_email;
			if($immediate_payment == "1") $paymentInfo->immediatePay = true;
			else $paymentInfo->immediatePay = false;

			$paymentProfile->paymentInfo = $paymentInfo;
			$paymentProfile->profileName = $profile_name;
			$paymentProfile->profileType = $profile_type;

			$ebayRequest->paymentProfile = $paymentProfile;

			//file_put_contents("profilereq.json",json_encode($ebayRequest->toArray()));
             
              Log::channel('PolicyControllerLog')->info("ebay Requestttttttttttt".json_encode($ebayRequest->toArray(),true));
              
			$ebayResponse = $ebayService->addSellerProfile($ebayRequest);
			
			    Log::channel('PolicyControllerLog')->info("ebay Response".json_encode($ebayResponse->toArray(),true));
			    
			$ebayResponse = $ebayResponse->toArray();
             
		//	file_put_contents("profileres.json",json_encode($ebayResponse));

			if($ebayResponse && isset($ebayResponse->Ack) && $ebayResponse->Ack !== 'Failure'){
			     Log::channel('PolicyControllerLog')->info("success");
			     Log::channel('PolicyControllerLog')->info("addUpdatePaymentProfile success");
				return response()->json(['status' => 'success','msg' => 'payment profile added successfully'],200);
			}
		}
		catch(\Exception $e){
			report($e);
			Log::channel('PolicyControllerLog')->info("addUpdatePaymentProfile error");
			return response()->json(['status' => 'error','msg' => $e->getMessage()],406);
		}
	}

	public function addUpdateReturnProfile123($request, $shopifyStore){
	/*	$validationRules = [
			'name' => 'required',
			'payment_methods' => 'required',
			'immediate_payment' => 'in:0,1',
			'paypal_email' => 'email'
		];
		$validator = Validator::make($request->all(),$validationRules);
		
		if($validator->fails()) return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
	*/
	$ebayAccount = EbayAccount::where('is_valid',1)->where('store_id',$shopifyStore->id)->orderBy('created_at','DESC')->first();
		if(!$ebayAccount) return response()->json(['status' => 'error', 'msg' => 'invalid request'],403);

		$environment = config('eb.environment');
		$_EBAY = array(
			'trade'  => config('ebay.'.$environment.'trade'),
			'signin' => config('ebay.'.$environment.'signin'),
			'devid'  => config('ebay.'.$environment.'devid'),
			'appid'  => config('ebay.'.$environment.'appid'),
			'certid' => config('ebay.'.$environment.'certid'),
			'RuName' => config('ebay.'.$environment.'RuName'),
			'compatabilityLevel' => 859,
			'siteID' => 0
		);
		$ebayCredentials = array(
			'credentials' => [
				'devId' => config('ebay.'.$environment.'devid'),
				'appId' => config('ebay.'.$environment.'appid'),
				'certId' => config('ebay.'.$environment.'certid'),
				'authToken' => '',
			],
			'authToken' => '',
			'oauthUserToken' => '',
			'ruName' => config('ebay.'.$environment.'RuName')
		);
		try{
			$payment_methods = $request->input("payment_methods");
			if(!is_array($payment_methods)) $payment_methods = explode(",",$payment_methods);

			$payment_instructions = $request->input("payment_instructions");
			$paypal_email = $request->input("paypal_email");
			$profile_name = $request->input("name");
			$profile_type = $request->input("profile_type");
			$immediate_payment = $request->input("immediate_payment");

			$site_id = (isset($ebayAccount->siteid)) ? $ebayAccount->siteid : 0;
			$_EBAY["siteID"] = $site_id;

			$ebay_token = $ebayAccount->access_token;

			$globalId = $this->getGlobalId($site_id);

			$ebayService = new Services\BusinessPoliciesManagementService([
				'credentials' => $ebayCredentials['credentials'],
				'authToken'   => $ebay_token,
				'globalId'    => $globalId
			]);
			$ebayRequest = new Types\AddSellerProfileRequest();
			$paymentProfile = new Types\PaymentProfile();

			$paymentInfo = new Types\PaymentInfo();
			$paymentInfo->acceptedPaymentMethod = $payment_methods;
			if($payment_instructions) $paymentInfo->paymentInstructions = $payment_instructions;
			if($paypal_email) $paymentInfo->paypalEmailAddress = $paypal_email;
			if($immediate_payment == "1") $paymentInfo->immediatePay = true;
			else $paymentInfo->immediatePay = false;

			$paymentProfile->paymentInfo = $paymentInfo;
			$paymentProfile->profileName = $profile_name;
			$paymentProfile->profileType = $profile_type;

			$ebayRequest->paymentProfile = $paymentProfile;

			//file_put_contents("profilereq.json",json_encode($ebayRequest->toArray()));

			$ebayResponse = $ebayService->addSellerProfile($ebayRequest);
			$ebayResponse = $ebayResponse->toArray();

			//file_put_contents("profileres.json",json_encode($ebayResponse));

			if($ebayResponse && isset($ebayResponse->Ack) && $ebayResponse->Ack !== 'Failure'){
				return response()->json(['status' => 'success','msg' => 'payment profile added successfully'],200);
			}
		}
		catch(\Exception $e){
			report($e);
			return response()->json(['status' => 'error','msg' => $e->getMessage()],406);
		}
	}

	public function addUpdateReturnProfile($request, $shopifyStore){
	    	Log::channel('PolicyControllerLog')->info("addUpdateReturnProfile starts");
		$validationRules = [
			'name' => 'required',
			'domestic_returns_accepted' => 'required',
			'international_returns_accepted' => 'required'
		];
		$validator = Validator::make($request->all(),$validationRules);
		if($validator->fails()) return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
		$ebayAccount = EbayAccount::where('is_valid',1)->where('store_id',$shopifyStore->id)->orderBy('created_at','DESC')->first();
		if(!$ebayAccount) return response()->json(['status' => 'error', 'msg' => 'invalid request'],403);

		$environment = config('eb.environment');
		$_EBAY = array(
			'trade'  => config('ebay.'.$environment.'trade'),
			'signin' => config('ebay.'.$environment.'signin'),
			'devid'  => config('ebay.'.$environment.'devid'),
			'appid'  => config('ebay.'.$environment.'appid'),
			'certid' => config('ebay.'.$environment.'certid'),
			'RuName' => config('ebay.'.$environment.'RuName'),
			'compatabilityLevel' => 859,
			'siteID' => 0
		);
		$ebayCredentials = array(
			'credentials' => [
				'devId' => config('ebay.'.$environment.'devid'),
				'appId' => config('ebay.'.$environment.'appid'),
				'certId' => config('ebay.'.$environment.'certid'),
				'authToken' => '',
			],
			'authToken' => '',
			'oauthUserToken' => '',
			'ruName' => config('ebay.'.$environment.'RuName')
		);
		try{
		   Log::channel('PolicyControllerLog')->info("addUpdateReturnProfile try starts");
		   
			$profile_name = $request->input("name");
			$profile_type = $request->input("profile_type");

			$domestic_returns_accepted = $request->input("domestic_returns_accepted");
			$domestic_returned_within = $request->input("domestic_returned_within");
			$domestic_returns_paid_by = $request->input("domestic_returns_paid_by");
			$domestic_refund_given_as = $request->input("domestic_refund_given_as");
            Log::channel('PolicyControllerLog')->info("addUpdateReturnProfile try starts111111111");
			$international_returns_accepted = $request->input("international_returns_accepted");
			$international_returned_within = $request->input("international_returned_within");
			$international_returns_paid_by = $request->input("international_returns_paid_by");
			$international_refund_given_as = $request->input("international_refund_given_as");

			$return_policy_details = $request->input("return_policy_details");
            Log::channel('PolicyControllerLog')->info("addUpdateReturnProfile try starts2222222222222222");
			$site_id = (isset($ebayAccount->siteid)) ? $ebayAccount->siteid : 0;
			$_EBAY["siteID"] = $site_id;

			$ebay_token = $ebayAccount->access_token;

			$globalId = $this->getGlobalId($site_id);

			$ebayService = new Services\BusinessPoliciesManagementService([
				'credentials' => $ebayCredentials['credentials'],
				'authToken'   => $ebay_token,
				'globalId'    => $globalId
			]);
			Log::channel('PolicyControllerLog')->info("addUpdateReturnProfile try starts3333333333333");
			$ebayRequest = new Types\AddSellerProfileRequest();

			$returnPolicyProfile = new Types\ReturnPolicyProfile();

			$returnPolicyInfo = new Types\ReturnPolicyInfo();
			$returnPolicyInfo->returnsAcceptedOption = $domestic_returns_accepted;
			if($domestic_returns_accepted == "ReturnsAccepted"){
				$returnPolicyInfo->refundOption = $domestic_refund_given_as;
				$returnPolicyInfo->shippingCostPaidByOption = $domestic_returns_paid_by;
				$returnPolicyInfo->returnsWithinOption = $domestic_returned_within;
				if($return_policy_details) $returnPolicyInfo->description = $return_policy_details;
			}
			$returnPolicyProfile->returnPolicyInfo = $returnPolicyInfo;

            Log::channel('PolicyControllerLog')->info("addUpdateReturnProfile try starts444444444444");
			$internationalReturnPolicyInfo = new Types\InternationalReturnPolicyInfo();
			$internationalReturnPolicyInfo->returnsAcceptedOption = $international_returns_accepted;
			if($international_returns_accepted == "ReturnsAccepted"){
				$internationalReturnPolicyInfo->refundOption = $international_refund_given_as;
				$internationalReturnPolicyInfo->shippingCostPaidByOption = $international_returns_paid_by;
				$internationalReturnPolicyInfo->returnsWithinOption = $international_returned_within;
			}
			$returnPolicyProfile->internationalReturnPolicyInfo = $internationalReturnPolicyInfo;

            Log::channel('PolicyControllerLog')->info("addUpdateReturnProfile try 55555555555555");
			$returnPolicyProfile->profileName = $profile_name;
			$returnPolicyProfile->profileType = $profile_type;

			$ebayRequest->returnPolicyProfile = $returnPolicyProfile;

			//file_put_contents("profilereq.json",json_encode($ebayRequest->toArray()));

			$ebayResponse = $ebayService->addSellerProfile($ebayRequest);
			$ebayResponse = $ebayResponse->toArray();
             
 			//file_put_contents("profileres.json",json_encode($ebayResponse));
            Log::channel('PolicyControllerLog')->info("addUpdateReturnProfile try 666666666666".json_encode($ebayResponse));
			if($ebayResponse && isset($ebayResponse->Ack) && $ebayResponse->Ack !== 'Failure'){
			    Log::channel('PolicyControllerLog')->info('ReturnPolicyInfo success'); 
				return response()->json(['status' => 'success','msg' => 'return profile added successfully'],200);
			}
		}
		catch(\Exception $e){
			report($e);
			Log::channel('PolicyControllerLog')->info($e);
			return response()->json(['status' => 'error','msg' => $e->getMessage()],406);
		}
	}

    public function addUpdateShippingProfile($request, $shopifyStore){
        
        $user = Auth::user();

        $userId = $user->id;

        $profiles = Profile::select('domestic_returns_accepted','international_returns_accepted','international_refund_given_as','international_returns_paid_by','international_returned_within','postal_code','ship_global_locations','domestic_refund_given_as','domestic_returns_paid_by','domestic_returned_within','return_policy_details')->first();
        $domesticReturnsAccepted = $profiles->domestic_returns_accepted;
        $internationalReturnsAccepted = $profiles->international_returns_accepted;
        $international_refund_given_as = $profiles->international_refund_given_as;
        $international_returns_paid_by = $profiles->international_returns_paid_by;
        $international_returned_within = $profiles->international_returned_within;
        $ship_global_locations = $profiles->ship_global_locations;
        $postal_code = $profiles->postal_code;
        $domestic_refund_given_as = $profiles->domestic_refund_given_as;
        $domestic_returns_paid_by = $profiles->domestic_returns_paid_by;
        $domestic_returned_within = $profiles->domestic_returned_within;
        $return_policy_details = $profiles->return_policy_details;
		$ShopifyStore_User_ID = ShopifyStore::where('user_id', $userId)->get();
		// JSON string ko decode karein
		$data = json_decode($ShopifyStore_User_ID, true);

		// country ki value ko access karein
		$jsonData = $data[0]['shop_data'];

		$data2 = json_decode($jsonData, true);

		// currency ki value ko access karein
		$currency = $data2['currency'];

		
	


	    Log::channel('PolicyControllerLog')->info('addUpdateShippingProfile starts here');
		$validationRules = [
			'name' => 'required',
			'domestic_shipping' => 'required',
			'intl_shipping' => 'required'
		];
		$validator = Validator::make($request->all(),$validationRules);

        Log::channel('PolicyControllerLog')->info('addUpdateShippingProfile 2');

		if($validator->fails()) return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);

        Log::channel('PolicyControllerLog')->info('addUpdateShippingProfile 3');

		$ebayAccount = EbayAccount::where('is_valid',1)->where('store_id',$shopifyStore->id)->orderBy('created_at','DESC')->first();

        Log::channel('PolicyControllerLog')->info('addUpdateShippingProfile 4');

		if(!$ebayAccount) return response()->json(['status' => 'error', 'msg' => 'invalid request'],403);

        Log::channel('PolicyControllerLog')->info('addUpdateShippingProfile 5');

		$environment = config('eb.environment');
		$_EBAY = array(
			'trade'  => config('ebay.'.$environment.'trade'),
			'signin' => config('ebay.'.$environment.'signin'),
			'devid'  => config('ebay.'.$environment.'devid'),
			'appid'  => config('ebay.'.$environment.'appid'),
			'certid' => config('ebay.'.$environment.'certid'),
			'RuName' => config('ebay.'.$environment.'RuName'),
			'compatabilityLevel' => 859,
			'siteID' => 0
		);
		$ebayCredentials = array(
			'credentials' => [
				'devId' => config('ebay.'.$environment.'devid'),
				'appId' => config('ebay.'.$environment.'appid'),
				'certId' => config('ebay.'.$environment.'certid'),
				'authToken' => '',
			],
			'authToken' => '',
			'oauthUserToken' => '',
			'ruName' => config('ebay.'.$environment.'RuName')
		);
		
		try{
		    
		    Log::channel('PolicyControllerLog')->info('addUpdateShippingProfile try starts here');
		    
			$profile_name = $request->input("name");
			$profile_type = $request->input("profile_type");
			$domestic_shipping = $request->input("domestic_shipping");
			$domestic_ships_within_handling_days = $request->input("domestic_ships_within_handling_days");
			$domestic_free_shipping = $request->input("domestic_free_shipping");
			$domestic_fast_shipping = $request->input("domestic_fast_shipping");
			$domestic_ship_service1 = $request->input("domestic_ship_service1");			
			$ship_fee1 = (double) $request->input("ship_fee1");
			$x_ship_fee1 = (double) $request->input("x_ship_fee1");
			$domestic_local_pickup = 0;
			$domestic_pkg_handling_fee = $request->input("domestic_pkg_handling_fee");
			$intl_shipping = $request->input("intl_shipping");
			//$intl_ship_options1 = $request->input("intl_ship_options1")."<br>";
			$intl_locations1 =  "Asia";
			$intl_ship_service1 = $request->input("intl_ship_service1");
			$intl_ship_fee1 = $request->input("intl_ship_fee1");
			$intl_x_ship_fee1 = $request->input("intl_x_ship_fee1");
			$intl_pkg_handling_fee = $request->input("intl_pkg_handling_fee");
			$ship_options = $request->input("ship_options");
			$ship_global_locations = $ship_global_locations;
			$postal_code = $postal_code;
			$additional_services = $request->input("domestic_ship_additional_services");

            if (is_array($additional_services)) {
                $additional_services_string = implode(", ", $additional_services);
            } else {
                $additional_services;
            }

            $intl_additional_services = $request->input("intl_ship_additional_services");
            
            if (is_array($intl_additional_services)) {
                $intl_additional_services_string = implode(", ", $intl_additional_services);
            } else {
                $intl_additional_services;
            }
            
            $domestic_returns_accepted = $domesticReturnsAccepted;
            $international_returns_accepted = $internationalReturnsAccepted;

			
			Log::channel('PolicyControllerLog')->info('addUpdateShippingProfile try starts here 1');

			$site_id = (isset($ebayAccount->siteid)) ? $ebayAccount->siteid : 0;
			
			$_EBAY["siteID"] = $site_id;

			$ebay_token = $ebayAccount->access_token;
			
			Log::channel('PolicyControllerLog')->info("addUpdateShippingProfile try starts here 11 $profile_type");

			$globalId = $this->getGlobalId($site_id);

			
			$ebayService = new Services\BusinessPoliciesManagementService([
				'credentials' => $ebayCredentials['credentials'],
				'authToken'   => $ebay_token,
				'globalId'    => $globalId
			]);
			
			$test = new Types\AdditionalServiceShippingOption();

			print_r($test);
			dd(1);

			$ebayRequest = new Types\AddSellerProfileRequest();
			$shippingPolicyProfile = new Types\ShippingPolicyProfile();
			$shippingPolicyInfo = new Types\ShippingPolicyInfo();

			// Shipping Policy Info container
			$shippingPolicyInfo->domesticShippingType = 'Calculated';
			$shippingPolicyInfo->dispatchTimeMax = (int) $domestic_ships_within_handling_days;
			$shippingPolicyInfo->shippingOption = $ship_options;
			$shippingPolicyInfo->shippingPolicyCurrency = $currency;
			
			 // Domestic Shipping

			$shippingPolicyInfo->domesticShippingPolicyInfoService->buyerResponsibleForPickup = true;
			$shippingPolicyInfo->domesticShippingPolicyInfoService->buyerResponsibleForShipping = false;
			$shippingPolicyInfo->domesticShippingPolicyInfoService->fastShipping = true;
			$shippingPolicyInfo->domesticShippingPolicyInfoService->freeShipping = true;
			$shippingPolicyInfo->domesticShippingPolicyInfoService->shippingService = "USPSPriority";
			$shippingPolicyInfo->domesticShippingPolicyInfoService->sortOrderIdSpecified = true;
			$shippingPolicyInfo->domesticShippingPolicyInfoService->sortOrderId = 1;
			$shippingPolicyInfo->domesticShippingPolicyInfoService->shippingServiceAdditionalCost = new Types\Amount(array('value' => $x_ship_fee1, 'currencyId' => $currency));
			$shippingPolicyInfo->domesticShippingPolicyInfoService->shippingServiceCost = new Types\Amount(array('value' => $ship_fee1, 'currencyId' => $currency));

			// $domesticShippingPolicyInfoService = new Types\ShippingPolicyInfoService();
			// $domesticShippingPolicyInfoService->buyerResponsibleForPickup = ($domestic_local_pickup == 1) ? true : false;
			// $domesticShippingPolicyInfoService->buyerResponsibleForShipping = false;
			// $domesticShippingPolicyInfoService->fastShipping = ($domestic_fast_shipping == 1) ? true : false;
			// $domesticShippingPolicyInfoService->freeShipping = ($domestic_free_shipping == 1) ? true : false;
			// echo $domesticShippingPolicyInfoService->shippingService = $domestic_ship_service1;
            // $domesticShippingPolicyInfoService->shippingServiceAdditionalCost = new Types\Amount(array('value' => $x_ship_fee1, 'currencyId' => $currency));
            // $domesticShippingPolicyInfoService->shippingServiceCost = new Types\Amount(array('value' => $ship_fee1, 'currencyId' => $currency));
			
			// International Shipping
			$shippingPolicyInfo->intlShippingPolicyInfoService->shippingService = $intl_shipping;

            $returnPolicyInfo = new Types\ReturnPolicyInfo();
			print_r($returnPolicyInfo);
			
			if($domestic_returns_accepted == "ReturnsAccepted"){
				$returnPolicyInfo->refundOption = $domestic_refund_given_as;
				$returnPolicyInfo->shippingCostPaidByOption = $domestic_returns_paid_by;
				$returnPolicyInfo->returnsWithinOption = $domestic_returned_within;
				if($return_policy_details) $returnPolicyInfo->description = $return_policy_details;
			}

			$shippingPolicyProfile->shippingPolicyInfo = $shippingPolicyInfo;

			$internationalReturnPolicyInfo = new Types\InternationalReturnPolicyInfo();
			print_r($internationalReturnPolicyInfo);

			$internationalReturnPolicyInfo->returnsAcceptedOption = $international_returns_accepted;			
			
			if($international_returns_accepted == "ReturnsAccepted"){
				$internationalReturnPolicyInfo->refundOption = $international_refund_given_as;
				$internationalReturnPolicyInfo->shippingCostPaidByOption = $international_returns_paid_by;
				$internationalReturnPolicyInfo->returnsWithinOption = $international_returned_within;
			}
			
		// 			$shippingPolicyProfile->internationalReturnPolicyInfo = $internationalReturnPolicyInfo; /*error 17-04-2024 */

			$shippingPolicyProfile->profileName = $profile_name;
			$shippingPolicyProfile->profileType = $profile_type;



			$ebayRequest->shippingPolicyProfile = $shippingPolicyProfile;


			// echo "<pre>";
			// print_r($ebayRequest); 
			// echo "</pre>";
			// dd(1); 			

            
			// file_put_contents("profilereq.json",json_encode($ebayRequest->toArray()));	
			
			$ebayResponse = $ebayService->addSellerProfile($ebayRequest);
			
			// echo "<pre>";
			// print_r($ebayResponse); 
			// echo "</pre>";
			// dd(2); 	
			
			

			$ebayResponse = $ebayResponse->toArray();
			
			
			echo "<pre>";
			print_r($ebayResponse); 
			echo "</pre>";
// 			dd(3); 	
			
			
			// file_put_contents("profileres.json",json_encode($ebayResponse));
            
			if($ebayResponse && isset($ebayResponse->Ack) && $ebayResponse->Ack !== 'Failure'){
			     Log::channel('PolicyControllerLog')->info('addUpdateShippingProfile success');
				return response()->json(['status' => 'success','msg' => 'return profile added successfully'],200);
			}
		}
		catch(\Exception $e){
			report($e);
			Log::channel('PolicyControllerLog')->info($e);
			return response()->json(['status' => 'error','msg' => $e->getMessage()],406);
		}
	}

	public function save(Request $request){	    
	   
	    Log::channel('PolicyControllerLog')->info("policy save");
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$validationRules = [
				'name' => 'required',
				'profile_type' => 'required|in:PAYMENT,RETURN_POLICY,SHIPPING'
			];
			$validator = Validator::make($request->all(),$validationRules);
			if($validator->fails()) return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);

			//$ebayAccount = EbayAccount::where('is_valid',1)->where('store_id',$shopifyStore->id)->orderBy('created_at','DESC')->first();

			$profile_type = $request->input("profile_type");
			Log::channel('PolicyControllerLog')->info("policy profile type $profile_type");
			if($profile_type == "PAYMENT"){
			    Log::channel('PolicyControllerLog')->info("policy profile type payment");
				return $this->addUpdatePaymentProfile($request,$shopifyStore);
			}
			else if($profile_type == "RETURN_POLICY"){
				return $this->addUpdateReturnProfile($request,$shopifyStore);
			}
			else if($profile_type == "SHIPPING"){
				return $this->addUpdateShippingProfile($request,$shopifyStore);
			}

			/*
			$item_specifics = ($request->has("item_specifics")) ? $request->input("item_specifics") : [];
			$item_specifics2 = ($request->has("item_specifics2")) ? $request->input("item_specifics2") : [];

			$ebayDataController = new EbayDataController();

			$ebayCategory1 = EbayCategory::select('id','category_tree_name','category_attributes','ebay_category_id')->find($request->input("ebay_category_1"));
			if($ebayCategory1){
				$category_attributes = json_decode($ebayCategory1->category_attributes,true);
				if(!$category_attributes){
					$category_attributes = $ebayDataController->getEbayCategorySpecifics($ebayCategory1->ebay_category_id,$ebayCategory1->ebay_site);
				}
				if($category_attributes){
					$requiredFields = [];
					foreach($category_attributes as $category_attribute){
						$cfield = $category_attribute["name"];
						if($category_attribute["min_values"] > 0){
							if(!$item_specifics || !isset($item_specifics[$cfield]) || !$item_specifics[$cfield]){
								$requiredFields[] = $cfield;
							}
						}
					}
					if($requiredFields){
						$cerrors = implode(",",$requiredFields);
						return response()->json(['status' => 'error','msg' => 'please fill required category fields : '.$cerrors],406);
					}
				}
			}



			$is_default_profile = (int) $request->input("is_default_profile");
			if($is_default_profile){
				$dprofile = $shopifyStore->profiles()->where("is_default_profile","1")->first();
				if($dprofile){
					$dprofile->is_default_profile = 0;
					$dprofile->save();
				}
			}

			$profileData = $request->all();
			$profileData["trim_title"] = ($request->input("trim_title")) ? 1 : 0;
			$profileData["is_default_profile"] = $is_default_profile;
			$profileData["store_id"] = $shopifyStore->id;
			$profileData["user_id"] = $shopifyStore->user->id;

			

			if($request->has("item_specifics")) $profileData["item_specifics"] = json_encode($request->input("item_specifics"));
			if($request->has("item_specifics2")) $profileData["item_specifics2"] = json_encode($request->input("item_specifics2"));
			
			if($request->has("domestic_ship_additional_services")) $profileData["domestic_ship_additional_services"] = json_encode($request->input("domestic_ship_additional_services"));
			if($request->has("intl_ship_additional_services")) $profileData["intl_ship_additional_services"] = json_encode($request->input("intl_ship_additional_services"));
			//if($request->has("ship_global_locations")) $profileData["ship_global_locations"] = json_encode($request->input("ship_global_locations"));
			if($request->has("payment_methods")) $profileData["payment_methods"] = json_encode($request->input("payment_methods"));
			if($request->has("intl_locations1")) $profileData["intl_locations1"] = json_encode($request->input("intl_locations1"));
			

			$profile = $shopifyStore->profiles()->create($profileData);
			if($profile){
				if($update_install_step && $shopifyStore->install_step == 3){
					$shopifyStore->install_step = 4;
					$shopifyStore->save();
				}
				return response()->json(['status' => 'success','msg' => 'profile added successfully','profile' => $profile->toArray()],200);
			}
			else{
				return response()->json(['status' => 'error','msg' => 'profile not added, please try again'],406);
			}
			*/
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function show($id,Request $request){
	    	Log::channel('PolicyControllerLog')->info("show starts");
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$profile = $shopifyStore->profiles()->find($id);
			if($profile){
				$ebayAccount = $shopifyStore->ebayAccounts()->where("is_valid","1")->first();

				$profile->payment_methods = ($profile->payment_methods) ? json_decode($profile->payment_methods,true) : array();
				$profile->intl_locations1 = ($profile->intl_locations1) ? json_decode($profile->intl_locations1,true) : array();

				$profile->item_specifics = ($profile->item_specifics) ? json_decode($profile->item_specifics,true) : array();
				$profile->item_specifics2 = ($profile->item_specifics2) ? json_decode($profile->item_specifics2,true) : array();

				$profile->domestic_ship_additional_services = ($profile->domestic_ship_additional_services) ? json_decode($profile->domestic_ship_additional_services,true) : array();
				$profile->intl_ship_additional_services = ($profile->intl_ship_additional_services) ? json_decode($profile->intl_ship_additional_services,true) : array();

				$ebayDataController = new EbayDataController();

				if($profile->ebay_category_1 > 0){
					$ebay_category_1 = EbayCategory::select('id','category_tree_name','category_attributes','ebay_category_id')->find($profile->ebay_category_1);
					if($ebay_category_1){
						$profile->ebay_category_1 = $ebay_category_1;
						$category_attributes = json_decode($profile->ebay_category_1->category_attributes,true);
						if(!$category_attributes || !isset($category_attributes[0]["min_values"])){
							$category_attributes = $ebayDataController->getEbayCategorySpecifics($profile->ebay_category_1->ebay_category_id,$ebayAccount->siteid);
							$profile->ebay_category_1->category_attributes = $category_attributes;
						}
						else $profile->ebay_category_1->category_attributes = $category_attributes;
					}
				}

				if($profile->ebay_category_2 > 0){
					$ebay_category_2 = EbayCategory::select('id','category_tree_name','category_attributes','ebay_category_id')->find($profile->ebay_category_2);
					if($ebay_category_2){
						$profile->ebay_category_2 = $ebay_category_2;
						$category_attributes = json_decode($profile->ebay_category_2->category_attributes,true);

						if(!$category_attributes || !isset($category_attributes[0]["min_values"])){
							$category_attributes = $ebayDataController->getEbayCategorySpecifics($profile->ebay_category_2->ebay_category_id,$ebayAccount->siteid);
							$profile->ebay_category_2->category_attributes = $category_attributes;
						}
						else $profile->ebay_category_2->category_attributes = $category_attributes;
					}
				}

				if($profile->store_category > 0){
					//$profile->store_category = $ebayAccount->ebayStoreCategories()->find($profile->store_category);
				}


				return response()->json($profile,200);
			}
			else{
				return response()->json(['status' => 'error','msg' => "not found"],404);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function attributeMapping($id,Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$profile = $shopifyStore->profiles()->with('attributeMapping')->find($id);
			if($profile){
				
				$profile->category_fields_data = ($profile->category_fields_data) ? json_decode($profile->category_fields_data,true) : array();
				$profile->product_type_fields_data = ($profile->product_type_fields_data) ? json_decode($profile->product_type_fields_data,true) : array();

				return response()->json($profile,200);
			}
			else{
				return response()->json(['status' => 'error','msg' => "not found"],404);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function update($id,Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$update_install_step = false;
			if($request->has("update_install_step")) $update_install_step = (bool) $request->input("update_install_step");
			$profile = $shopifyStore->profiles()->find($id);
			if($profile){
				$validationRules = [
					'profile_id' => 'required',
					'name' => 'required|unique:tenants.profiles,name,'.$profile->id,
					'ebay_category_1' => 'required'
				];
				$validator = Validator::make($request->all(),$validationRules);
				if($validator->fails()){
					return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
				}


				$item_specifics = ($request->has("item_specifics")) ? $request->input("item_specifics") : [];
				$item_specifics2 = ($request->has("item_specifics2")) ? $request->input("item_specifics2") : [];

				$ebayDataController = new EbayDataController();

				$ebayCategory1 = EbayCategory::select('id','category_tree_name','category_attributes','ebay_category_id')->find($request->input("ebay_category_1"));
				if($ebayCategory1){
					$category_attributes = json_decode($ebayCategory1->category_attributes,true);
					if(!$category_attributes){
						$category_attributes = $ebayDataController->getEbayCategorySpecifics($ebayCategory1->ebay_category_id,$ebayCategory1->ebay_site);
					}
					if($category_attributes){
						$requiredFields = [];
						foreach($category_attributes as $category_attribute){
							$cfield = $category_attribute["name"];
							if($category_attribute["min_values"] > 0){
								if(!$item_specifics || !isset($item_specifics[$cfield]) || !$item_specifics[$cfield]){
									$requiredFields[] = $cfield;
								}
							}
						}
						if($requiredFields){
							$cerrors = implode(",",$requiredFields);
							return response()->json(['status' => 'error','msg' => 'please fill required category fields : '.$cerrors],406);
						}
					}
				}
	
				$is_default_profile = (int) $request->input("is_default_profile");
				if($is_default_profile){
					$dprofile = $shopifyStore->profiles()->where("is_default_profile","1")->where("id","!=",$id)->first();
					if($dprofile){
						$dprofile->is_default_profile = 0;
						$dprofile->save();
					}
				}
	
				$profileData = $request->all();
				if($request->has("trim_title")) $profileData["trim_title"] = ($request->input("trim_title")) ? 1 : 0;

				if(!$is_default_profile){
					unset($profileData["is_default_profile"]);
				}
				else{
					$profileData["is_default_profile"] = $is_default_profile;
				}

				if($request->has("item_specifics")) $profileData["item_specifics"] = json_encode($request->input("item_specifics"));
				if($request->has("item_specifics2")) $profileData["item_specifics2"] = json_encode($request->input("item_specifics2"));
				
				if($request->has("domestic_ship_additional_services")) $profileData["domestic_ship_additional_services"] = json_encode($request->input("domestic_ship_additional_services"));
				if($request->has("intl_ship_additional_services")) $profileData["intl_ship_additional_services"] = json_encode($request->input("intl_ship_additional_services"));
				//if($request->has("ship_global_locations")) $profileData["ship_global_locations"] = json_encode($request->input("ship_global_locations"));
				if($request->has("payment_methods")) $profileData["payment_methods"] = json_encode($request->input("payment_methods"));
				if($request->has("intl_locations1")) $profileData["intl_locations1"] = json_encode($request->input("intl_locations1"));
			
				$ups = $profile->update($profileData);
				if($ups){
					return response()->json(['status' => 'success','msg' => 'profile updated successfully','profile' => $profile->toArray()],200);
				}
				else{
					return response()->json(['status' => 'error','msg' => 'profile not updated, please try again'],406);
				}
			}
			else{
				return response()->json(['status' => 'error','msg' => "profile not found"],404);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function updateAttributeMapping($id,Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			$profile = $shopifyStore->profiles()->find($id);
			if($profile){
				$validationRules = [
					'mapping_data' => 'required',
				];
				$validator = Validator::make($request->all(),$validationRules);
				if($validator->fails()){
					return response()->json(['status' => 'error', 'msg' => '', 'errors' => $validator->errors()],406);
				}
				$mapping_data = $request->input("mapping_data");
				foreach($mapping_data as $attribute => $option){
					$attributeMapping = $profile->attributeMapping()->where("attribute_name",$attribute)->first();
					if($attributeMapping){
						if($option){
							$attributeMapping->option_name = $option;
							$attributeMapping->save();
						}
						else{
							$attributeMapping->delete();
						}
					}
					else{
						if(!$option) continue;
						$attrData = [];
						$attrData["attribute_name"] = $attribute;
						$attrData["option_name"] = $option;
						$attrData["store_id"] = $shopifyStore->id;
						$attrData["user_id"] = $shopifyStore->user->id;
						$attributeMapping = $profile->attributeMapping()->create($attrData);
					}
				}
				return response()->json(['status' => 'success','msg' => 'attribute mapping updated successfully','profile' => $profile->toArray()],200);
			}
			else{
				return response()->json(['status' => 'error','msg' => "profile not found"],404);
			}
		}
		
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}

	public function destroy($id,Request $request){
		$shopifyStore = AppHelper::getShopifyStore($request);
		if($shopifyStore){
			//$profile = $shopifyStore->profiles()->find($id);
		 $ebayAccount = EbayAccount::where('is_valid',1)->where('store_id',$shopifyStore->id)->first();
 			$profile = $ebayAccount->ebaySellerProfiles()->find($id);
			if($profile){
				if($profile->is_default_profile) return response()->json(['status' => 'error','msg' => "can not delete default profile"],401);
				$profile->delete();
				return response()->json(['status' => 'success','msg' => "profile deleted successfully"],200);
			}
			else{
				return response()->json(['status' => 'error','msg' => "not found"],404);
			}
		}
		return response()->json(['status' => 'error','msg' => "invalid request"],403);
	}
}